/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds1e1;

import cerent.cms.idl.Ds123Media.eLineType;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.INodeModel;
import cerent.cms.ui.ds123.Ds123LineMaintTableModel;
import cerent.util.SDebug;
import java.util.ArrayList;

public class Ds1E1MaintenanceTableModel
extends Ds123LineMaintTableModel {
    protected static final int INHIBITLBK_INDEX = 7;
    protected static final int INHIBITBACKPLANELBK_INDEX = 8;
    protected Boolean[] inhibitLoopback = null;
    protected Boolean[] inhibitBackplaneLoopback = null;
    private static final SDebug db = new SDebug("Ds1E1MaintenanceTableModel");

    public Ds1E1MaintenanceTableModel(INodeModel iNodeModel, Ds123LineModel[] ds123LineModelArray) {
        super(iNodeModel, ds123LineModelArray);
        if (ds123LineModelArray == null || ds123LineModelArray.length == 0) {
            if (db.on()) {
                db.println("Model is null");
            }
            this.numLines = 0;
        } else {
            this.numLines = ds123LineModelArray.length;
        }
        this.inhibitLoopback = new Boolean[this.numLines];
        this.inhibitBackplaneLoopback = new Boolean[this.numLines];
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 7: 
            case 8: {
                return Boolean.class;
            }
        }
        return super.getColumnClass(n);
    }

    protected void setColumnNames() {
        db.fine("Ds1E1MaintenanceTableModel.setColumnNames");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.columnNames.length; ++i) {
            arrayList.add(this.columnNames[i]);
        }
        arrayList.add("Inhibit FE Lbk");
        arrayList.add("Inhibit FE Backplane Lbk");
        this.columnNames = arrayList.toArray(new String[0]);
    }

    protected Attribute getAttributeFor(String string, int n) {
        return this.getAttributeMap().getAttributeForVal("DS1_E1_56_LINE_CARD." + string, n);
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 7) {
            try {
                return this.getInhibitLoopback(n);
            }
            catch (Exception exception) {
                db.println("Caught exception in getValueAt");
                SDebug.printStackTrace((Throwable)exception);
                return null;
            }
        }
        if (n2 == 8) {
            try {
                return this.getInhibitBackplaneLoopback(n);
            }
            catch (Exception exception) {
                db.println("Caught exception in getValueAt");
                SDebug.printStackTrace((Throwable)exception);
                return null;
            }
        }
        return super.getValueAt(n, n2);
    }

    protected boolean canEditSendCode(int n) {
        try {
            if (AdminState.admitsSendCode(this.getAdminState(n).getAdminStateEnum()) && (this.model[n].getConfig().lineType == eLineType.ESF || this.model[n].getConfig().lineType == eLineType.D4)) {
                return true;
            }
        }
        catch (Exception exception) {
            db.println("Caught exception in canEditSendCode");
            SDebug.printStackTrace((Throwable)exception);
        }
        return false;
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 7: {
                this.inhibitLoopback[n] = (Boolean)object;
                break;
            }
            case 8: {
                this.inhibitBackplaneLoopback[n] = (Boolean)object;
                break;
            }
            default: {
                super.setValueAt(object, n, n2);
                return;
            }
        }
        this.isDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
    }

    public Boolean getInhibitLoopback(int n) {
        if (this.inhibitLoopback[n] == null) {
            this.inhibitLoopback[n] = new Boolean(this.model[n].getInhibitLoopback());
        }
        return this.inhibitLoopback[n];
    }

    public Boolean getInhibitBackplaneLoopback(int n) {
        if (this.inhibitBackplaneLoopback[n] == null) {
            this.inhibitBackplaneLoopback[n] = new Boolean(this.model[n].getInhibitBackplaneLoopback());
        }
        return this.inhibitBackplaneLoopback[n];
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.inhibitLoopback[i] = null;
            this.inhibitBackplaneLoopback[i] = null;
        }
        super.refreshFromModel();
    }

    public void refreshMyLines(Ds123LineModel[] ds123LineModelArray) {
        this.model = ds123LineModelArray;
        Boolean[] booleanArray = new Boolean[ds123LineModelArray.length];
        Boolean[] booleanArray2 = new Boolean[ds123LineModelArray.length];
        for (int i = 0; i < booleanArray.length; ++i) {
            if (i < this.inhibitLoopback.length) {
                booleanArray[i] = this.inhibitLoopback[i];
                booleanArray2[i] = this.inhibitBackplaneLoopback[i];
                continue;
            }
            booleanArray[i] = null;
            booleanArray2[i] = null;
        }
        this.inhibitLoopback = booleanArray;
        this.inhibitBackplaneLoopback = booleanArray2;
        this.init();
        this.fireTableDataChanged();
    }

    public void refreshLineFromModel(int n) {
        this.inhibitLoopback[n] = null;
        this.inhibitBackplaneLoopback[n] = null;
        super.refreshLineFromModel(n);
    }
}

