/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds3xm;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.If.eLoopback;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.ds3xm.Ds3xmMaintenanceTableModel;
import cerent.util.SDebug;
import java.util.ArrayList;

public class Ds3xmDs1MaintenanceTableModel
extends Ds3xmMaintenanceTableModel {
    private static final SDebug db = new SDebug("Ds3xmDs1MaintenanceTableModel");

    public Ds3xmDs1MaintenanceTableModel(INodeModel iNodeModel, Ds123LineModel[] ds123LineModelArray) {
        super(iNodeModel, ds123LineModelArray);
        db.info("<init>");
    }

    protected void setColumnNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        db.fine("Ds3xmDs1MaintenanceTableModel.setColumnNames()");
        for (int i = 0; i < this.columnNames.length; ++i) {
            if (i == 1) {
                arrayList.add("Derived State");
                continue;
            }
            arrayList.add(this.columnNames[i]);
        }
        this.columnNames = arrayList.toArray(new String[0]);
    }

    protected boolean canEditAdminState(int n) {
        return false;
    }

    private boolean slipOOSNoCircuitsThroughCrack(Ds123LineModel ds123LineModel) {
        boolean bl = false;
        try {
            bl = ds123LineModel.getAdminStateEnum() == eAdminState.ADMIN_OOS_DSBLD && !ds123LineModel.hasCircuitInterfaces();
        }
        catch (Exception exception) {
            db.severe("slipOOSNoCircuitsThroughCrack " + exception.toString());
        }
        return bl;
    }

    protected boolean canEditLoopback(int n) {
        boolean bl = false;
        try {
            if (AdminState.admitsLoopback(this.model[n].getAdminStateEnum())) {
                bl = true;
            } else if (this.slipOOSNoCircuitsThroughCrack(this.model[n])) {
                bl = true;
            }
        }
        catch (Exception exception) {
            db.severe("Exception in Ds3xmDs1MaintenanceTableModel.canEditSendCode " + exception);
        }
        return bl;
    }

    protected boolean canEditSendCode(int n) {
        boolean bl = false;
        try {
            if (AdminState.admitsSendCode(this.model[n].getAdminStateEnum())) {
                bl = true;
            }
        }
        catch (Exception exception) {
            db.severe("Exception in Ds3xmDs1MaintenanceTableModel.canEditSendCode " + exception);
        }
        return bl;
    }

    protected String getLineNumber(int n) throws AbstractCmsNoSuchEntityException {
        int n2 = n % 28 + 1;
        int n3 = n / 28 + 1;
        return "Port " + this.getPortDescriptionFor(n) + ", DS1 " + n2;
    }

    protected Attribute getLoopback(int n) throws NoSuchInterface, WrongInterfaceType {
        db.info("getLoopback() line " + n);
        if (AdminState.admitsLoopback(this.getAdminStateFor(n)) || this.slipOOSNoCircuitsThroughCrack(this.model[n])) {
            if (this.loopbackVal[n] == null) {
                eLoopback eLoopback2 = this.model[n].getLoopback();
                this.loopbackVal[n] = this.getAttributeFor(eLoopback.class.getName(), eLoopback2.value());
            }
        } else {
            this.loopbackVal[n] = this.getAttributeFor(eLoopback.class.getName(), 0);
        }
        return this.loopbackVal[n];
    }
}

