/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds3xm;

import cerent.cms.idl.Ds123Media.eThresholdType;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.GeneralPmThresholdsPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.PmThresholdButtonPanel;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ds123.Ds123PathThresholdsPane;
import cerent.cms.ui.ds3.Ds3CPBitThresholdsPane;
import cerent.cms.ui.ds3xm.Ds3xmCardTabbedView;
import cerent.cms.ui.ds3xm.Ds3xmDs1ThresholdProvPane;
import cerent.cms.ui.ds3xm.Ds3xmPbitThresholdsPane;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;

public class Ds3xmPathThresholdProvPane
extends AbstractPane {
    protected Ds123LineModel[] models;
    protected Ds3xmThresholdButtonPanel buttonPanel = null;
    protected JPanel tablePanel = null;
    protected Ds123LineModel[] ds1Models = null;
    protected GeneralPmThresholdsPane[] panes = null;
    protected Pane currentPane = null;
    protected CardLayout cl = null;
    protected static final String FE_DS1_1DAY_PANEL = "FE_DS1_1DAY";
    protected static final String FE_DS1_15MIN_PANEL = "FE_DS1_15MIN";
    protected static final String FE_DS3_CPBIT_1DAY_PANEL = "FE_DS3_CPBIT_1DAY";
    protected static final String FE_DS3_CPBIT_15MIN_PANEL = "FE_DS3_CPBIT_15MIN";
    protected static final String FE_DS3_PBIT_1DAY_PANEL = "FE_DS3_PBIT_1DAY";
    protected static final String FE_DS3_PBIT_15MIN_PANEL = "FE_DS3_PBIT_15MIN";
    protected static final String NE_DS1_1DAY_PANEL = "NE_DS1_1DAY";
    protected static final String NE_DS1_15MIN_PANEL = "NE_DS1_15MIN";
    protected static final String NE_DS3_CPBIT_1DAY_PANEL = "NE_DS3_CPBIT_1DAY";
    protected static final String NE_DS3_CPBIT_15MIN_PANEL = "NE_DS3_CPBIT_15MIN";
    protected static final String NE_DS3_PBIT_1DAY_PANEL = "NE_DS3_PBIT_1DAY";
    protected static final String NE_DS3_PBIT_15MIN_PANEL = "NE_DS3_PBIT_15MIN";
    protected static final int FE_DS1_1DAY = 11;
    protected static final int FE_DS1_15MIN = 10;
    protected static final int NE_DS1_1DAY = 9;
    protected static final int NE_DS1_15MIN = 8;
    protected static final int FE_DS3_CPBIT_1DAY = 7;
    protected static final int FE_DS3_CPBIT_15MIN = 6;
    protected static final int FE_DS3_PBIT_1DAY = 5;
    protected static final int FE_DS3_PBIT_15MIN = 4;
    protected static final int NE_DS3_CPBIT_1DAY = 3;
    protected static final int NE_DS3_CPBIT_15MIN = 2;
    protected static final int NE_DS3_PBIT_1DAY = 1;
    protected static final int NE_DS3_PBIT_15MIN = 0;
    private CSHelpID helpID = null;
    private static final SDebug db = new SDebug("Pane.Ds3xmPathThresholdProvPane");

    public Ds3xmPathThresholdProvPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray, CSHelpID cSHelpID) {
        super(string, tabbedView);
        this.models = ds123LineModelArray;
        this.helpID = cSHelpID;
        this.panes = new GeneralPmThresholdsPane[12];
        this.initializeLayout();
        TablePropertyMgr.getColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + this.currentPane.getName());
    }

    protected void initializeLayout() {
        this.setLayout(new BorderLayout());
        this.add(this.getButtonPanel(), "North");
        this.add(this.getTablePanel(), "Center");
    }

    protected Ds3xmThresholdButtonPanel getButtonPanel() {
        this.buttonPanel = new Ds3xmThresholdButtonPanel();
        return this.buttonPanel;
    }

    protected JPanel getTablePanel() {
        this.tablePanel = new JPanel();
        this.cl = new CardLayout();
        this.tablePanel.setLayout(this.cl);
        this.tablePanel.setPreferredSize(TabbedView.TABBED_VIEW_DIM);
        this.ds1Models = this.getDs1();
        this.panes[11] = this.getDs1ThresholdsPane(FE_DS1_1DAY_PANEL, eThresholdType.THRESHOLD_1_DAY, false, this.helpID);
        this.tablePanel.add((Component)((Object)this.panes[11]), FE_DS1_1DAY_PANEL);
        this.panes[10] = this.getDs1ThresholdsPane(FE_DS1_15MIN_PANEL, eThresholdType.THRESHOLD_15_MIN, false, this.helpID);
        this.tablePanel.add((Component)((Object)this.panes[10]), FE_DS1_15MIN_PANEL);
        this.panes[6] = this.getDs3CPBitThresholdsPane(FE_DS3_CPBIT_15MIN_PANEL, eThresholdType.THRESHOLD_15_MIN, false, this.helpID);
        this.tablePanel.add((Component)((Object)this.panes[6]), FE_DS3_CPBIT_15MIN_PANEL);
        this.panes[7] = this.getDs3CPBitThresholdsPane(FE_DS3_CPBIT_1DAY_PANEL, eThresholdType.THRESHOLD_1_DAY, false, this.helpID);
        this.tablePanel.add((Component)((Object)this.panes[7]), FE_DS3_CPBIT_1DAY_PANEL);
        this.panes[4] = this.getDs3PBitThresholdsPane(FE_DS3_PBIT_15MIN_PANEL, eThresholdType.THRESHOLD_15_MIN, false, this.helpID);
        this.tablePanel.add((Component)((Object)this.panes[4]), FE_DS3_PBIT_15MIN_PANEL);
        this.panes[5] = this.getDs3PBitThresholdsPane(FE_DS3_PBIT_1DAY_PANEL, eThresholdType.THRESHOLD_1_DAY, false, this.helpID);
        this.tablePanel.add((Component)((Object)this.panes[5]), FE_DS3_PBIT_1DAY_PANEL);
        this.panes[9] = this.getDs1ThresholdsPane(NE_DS1_1DAY_PANEL, eThresholdType.THRESHOLD_1_DAY, true, this.helpID);
        this.tablePanel.add((Component)((Object)this.panes[9]), NE_DS1_1DAY_PANEL);
        this.panes[8] = this.getDs1ThresholdsPane(NE_DS1_15MIN_PANEL, eThresholdType.THRESHOLD_15_MIN, true, this.helpID);
        this.tablePanel.add((Component)((Object)this.panes[8]), NE_DS1_15MIN_PANEL);
        this.panes[2] = this.getDs3CPBitThresholdsPane(NE_DS3_CPBIT_15MIN_PANEL, eThresholdType.THRESHOLD_15_MIN, true, this.helpID);
        this.tablePanel.add((Component)((Object)this.panes[2]), NE_DS3_CPBIT_15MIN_PANEL);
        this.panes[3] = this.getDs3CPBitThresholdsPane(NE_DS3_CPBIT_1DAY_PANEL, eThresholdType.THRESHOLD_1_DAY, true, this.helpID);
        this.tablePanel.add((Component)((Object)this.panes[3]), NE_DS3_CPBIT_1DAY_PANEL);
        this.panes[0] = this.getDs3PBitThresholdsPane(NE_DS3_PBIT_15MIN_PANEL, eThresholdType.THRESHOLD_15_MIN, true, this.helpID);
        this.tablePanel.add((Component)((Object)this.panes[0]), NE_DS3_PBIT_15MIN_PANEL);
        this.panes[1] = this.getDs3PBitThresholdsPane(NE_DS3_PBIT_1DAY_PANEL, eThresholdType.THRESHOLD_1_DAY, true, this.helpID);
        this.tablePanel.add((Component)((Object)this.panes[1]), NE_DS3_PBIT_1DAY_PANEL);
        this.cl.show(this.tablePanel, NE_DS3_PBIT_15MIN_PANEL);
        this.currentPane = this.panes[0];
        return this.tablePanel;
    }

    protected Ds123PathThresholdsPane getDs3PBitThresholdsPane(String string, eThresholdType eThresholdType2, boolean bl, CSHelpID cSHelpID) {
        return new Ds3xmPbitThresholdsPane(string, this.getParentView(), this.models, eThresholdType2, bl, cSHelpID);
    }

    protected Ds123PathThresholdsPane getDs3CPBitThresholdsPane(String string, eThresholdType eThresholdType2, boolean bl, CSHelpID cSHelpID) {
        return new Ds3CPBitThresholdsPane(string, this.getParentView(), this.models, eThresholdType2, bl, cSHelpID);
    }

    protected Ds123PathThresholdsPane getDs1ThresholdsPane(String string, eThresholdType eThresholdType2, boolean bl, CSHelpID cSHelpID) {
        return new Ds3xmDs1ThresholdProvPane(string, this.getParentView(), this.ds1Models, eThresholdType2, bl, cSHelpID);
    }

    protected Ds123LineModel[] getDs1() {
        return ((Ds3xmCardTabbedView)this.getParentView()).getDs1Lines();
    }

    protected void showPanel(Pane pane) {
        block5: {
            block4: {
                try {
                    TablePropertyMgr.setColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + this.currentPane.getName());
                    this.currentPane.leavingPage();
                }
                catch (Exception exception) {
                    if (!db.on()) break block4;
                    db.println("Error in leaving page " + exception.toString());
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            try {
                pane.enteringPage();
                TablePropertyMgr.getColumnPrefs(pane.getTable(), ((Object)((Object)this)).getClass().getName() + pane.getName());
            }
            catch (Exception exception) {
                if (!db.on()) break block5;
                db.println("Error in entering page " + exception.toString());
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.cl.show(this.tablePanel, pane.getName());
        this.currentPane = pane;
    }

    public JTable getTable() {
        JTable jTable = null;
        if (this.currentPane != null) {
            jTable = this.currentPane.getTable();
        }
        return jTable;
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + this.currentPane.getName());
        if (this.currentPane != null) {
            this.currentPane.leavingPage();
        }
    }

    public void enteringPage() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.enteringPage();
        }
        TablePropertyMgr.getColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + this.currentPane.getName());
    }

    public void refresh() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.refresh();
        }
    }

    public void destroy() {
        for (int i = 0; i < this.panes.length; ++i) {
            TablePropertyMgr.setColumnPrefs(this.panes[i].getTable(), ((Object)((Object)this)).getClass().getName() + this.panes[i].getName());
            this.panes[i].destroy();
            this.panes[i] = null;
        }
        this.panes = null;
        super.destroy();
    }

    public CSHelpID getHelpID() {
        if (this.currentPane != null && this.currentPane instanceof AbstractPane) {
            ((AbstractPane)this.currentPane).getHelpID();
        }
        return null;
    }

    protected class Ds3xmThresholdButtonPanel
    extends PmThresholdButtonPanel {
        public JRadioButton button15Min;
        public JRadioButton button1Day;
        public JRadioButton buttonNE;
        public JRadioButton buttonFE;
        public JRadioButton buttonDs1;
        public JRadioButton buttonDs3PBit;
        public JRadioButton buttonDs3CPBit;
        public ButtonGroup periodButtonGroup;
        public ButtonGroup endButtonGroup;
        public ButtonGroup secDs3ButtonGroup;
        public int FE_MASK = 4;
        public int CPBIT_MASK = 2;
        public int ONE_DAY_MASK = 1;
        public int DS1_MASK = 8;
        public int DS1_FE_MASK = 2;

        public Ds3xmThresholdButtonPanel() {
            this.initialize();
        }

        protected void initialize() {
            this.button15Min = new JRadioButton("15 Min", true);
            this.button1Day = new JRadioButton("1 Day");
            this.buttonNE = new JRadioButton("Near End", true);
            this.buttonFE = new JRadioButton("Far End");
            this.buttonDs1 = new JRadioButton("DS1");
            this.buttonDs3PBit = new JRadioButton("DS3 PBit", true);
            this.buttonDs3CPBit = new JRadioButton("DS3 CPBit");
            this.secDs3ButtonGroup = new ButtonGroup();
            this.secDs3ButtonGroup.add(this.buttonDs1);
            this.secDs3ButtonGroup.add(this.buttonDs3PBit);
            this.secDs3ButtonGroup.add(this.buttonDs3CPBit);
            this.periodButtonGroup = new ButtonGroup();
            this.periodButtonGroup.add(this.button15Min);
            this.periodButtonGroup.add(this.button1Day);
            this.endButtonGroup = new ButtonGroup();
            this.endButtonGroup.add(this.buttonNE);
            this.endButtonGroup.add(this.buttonFE);
            this.buttonNE.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (((JRadioButton)itemEvent.getSource()).isSelected()) {
                        Ds3xmThresholdButtonPanel.this.buttonDs3PBit.setEnabled(true);
                        Ds3xmThresholdButtonPanel.this.buttonDs1.setEnabled(true);
                    } else {
                        if (Ds3xmThresholdButtonPanel.this.buttonDs3PBit.isSelected() || Ds3xmThresholdButtonPanel.this.buttonDs1.isSelected()) {
                            Ds3xmThresholdButtonPanel.this.buttonDs1.setSelected(false);
                            Ds3xmThresholdButtonPanel.this.buttonDs3PBit.setSelected(false);
                            Ds3xmThresholdButtonPanel.this.buttonDs3CPBit.setSelected(true);
                        }
                        Ds3xmThresholdButtonPanel.this.buttonDs3PBit.setEnabled(false);
                        Ds3xmThresholdButtonPanel.this.buttonDs1.setEnabled(false);
                    }
                }
            });
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.buttonNE, "North");
            jPanel.add((Component)this.buttonFE, "South");
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)this.button15Min, "North");
            jPanel2.add((Component)this.button1Day, "South");
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.add((Component)this.buttonDs3PBit, "North");
            jPanel3.add((Component)this.buttonDs3CPBit, "South");
            JPanel jPanel4 = new JPanel(new BorderLayout());
            jPanel4.add((Component)this.buttonDs1, "North");
            this.setLayout(new FlowLayout(0));
            this.add(jPanel);
            this.add(jPanel2);
            this.add(jPanel3);
            this.add(jPanel4);
            this.addShowButton();
            this.addResetToDefaultButton();
            this.setPreferredSize(new Dimension(800, 50));
        }

        protected int getUserRadioButtonChoiceMask() {
            int n = 0;
            if (this.periodButtonGroup.getSelection() == this.button1Day.getModel()) {
                n |= this.ONE_DAY_MASK;
            }
            if (this.secDs3ButtonGroup.getSelection() == this.buttonDs1.getModel()) {
                n |= this.DS1_MASK;
                if (this.endButtonGroup.getSelection() == this.buttonFE.getModel()) {
                    n |= this.DS1_FE_MASK;
                }
            } else {
                if (this.secDs3ButtonGroup.getSelection() == this.buttonDs3CPBit.getModel()) {
                    n |= this.CPBIT_MASK;
                }
                if (this.endButtonGroup.getSelection() == this.buttonFE.getModel()) {
                    n |= this.FE_MASK;
                }
            }
            return n;
        }

        protected GeneralPmThresholdsPane getPanel(int n) {
            return Ds3xmPathThresholdProvPane.this.panes[n];
        }

        protected void displayPanel(int n) {
            Ds3xmPathThresholdProvPane.this.showPanel(Ds3xmPathThresholdProvPane.this.panes[n]);
        }
    }
}

