/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.DwdmCliLineModel;
import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.GfpLineModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IModel;
import cerent.cms.model.IPortContainer;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IRmonModel;
import cerent.cms.model.ISupportsRMON;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InterlinkPortModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.MrSlot;
import cerent.cms.model.PpmModel;
import cerent.cms.model.RmonLineUpdate;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.CardInventoryPane;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.Pane;
import cerent.cms.ui.PluggableCardTabbedView;
import cerent.cms.ui.SoakMaintenancePane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.dwdm.DwdmInfoMaintenancePane;
import cerent.cms.ui.dwdm.DwdmLineMaintenancePane;
import cerent.cms.ui.dwdm.DwdmPerfPane;
import cerent.cms.ui.dwdm.DwdmProvPane;
import cerent.cms.ui.dwdm.NxpAlsPane;
import cerent.cms.ui.event.IEventPanelController;
import cerent.util.SDebug;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeMap;

public class DwdmCardTabbedView
extends PluggableCardTabbedView
implements ITabName {
    private Map _payloadToClientModels;
    private Map _payloadToTrunkModels;
    private List _rmonModels;
    private List _gfpModels;
    private List _trunkModels;

    public DwdmCardTabbedView(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        super(moduleModel, iEventPanelController, iUiToolkit);
        moduleModel.addObserver(this);
    }

    protected void init() {
        DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.getUiModel();
        this._payloadToClientModels = Collections.synchronizedMap(new TreeMap());
        this._payloadToTrunkModels = Collections.synchronizedMap(new TreeMap());
        this._interfaceContainers = Collections.synchronizedMap(new TreeMap());
        this._trunkModels = Collections.synchronizedList(new ArrayList());
        this.initPayloadMap(dwdmModuleModel.getDwdmCliLineModels(), this._payloadToClientModels);
        this.initPayloadMap(dwdmModuleModel.getAllDwdmTrkLineModels(), this._payloadToTrunkModels);
        GfpLineModel[] gfpLineModelArray = dwdmModuleModel.getGfpLineModels();
        this._gfpModels = new ArrayList<GfpLineModel>(Arrays.asList(gfpLineModelArray));
        this.getOM().addObservable((Observable[])gfpLineModelArray);
        this._rmonModels = new ArrayList<IRmonModel>(Arrays.asList(dwdmModuleModel.getRmonModels()));
        this.getOM().addObservable((Observable)((Object)dwdmModuleModel.getMrSlot()));
        if (db.on()) {
            db.println("<init> found clientModels = " + dwdmModuleModel.getDwdmCliLineModels().length + " <init> found trunkModels = " + dwdmModuleModel.getAllDwdmTrkLineModels().length);
        }
        super.init();
    }

    private void initPayloadMap(AbstractDwdmLineModel[] abstractDwdmLineModelArray, Map map) {
        int n = abstractDwdmLineModelArray == null ? 0 : abstractDwdmLineModelArray.length;
        for (int i = 0; i < n; ++i) {
            InterfaceModel interfaceModel = abstractDwdmLineModelArray[i].getPayloadModel();
            if (interfaceModel != null) {
                if (db.on()) {
                    db.println("Add (Cli/Trk) 1 ---- Adding payload: " + interfaceModel + ", to OM");
                }
                this.getOM().addObservable((Observable)((Object)interfaceModel));
                if (db.on()) {
                    db.println("Add (Cli/Trk) 2 ---- Adding IfModel: " + interfaceModel + ", line model: " + abstractDwdmLineModelArray[i] + ", to map payload <-> line");
                }
                map.put(interfaceModel, abstractDwdmLineModelArray[i]);
                if (db.on()) {
                    db.println("Add (Cli/Trk) 3 ---- Adding IfModel: " + interfaceModel);
                }
                this.addContainerMap(interfaceModel);
                if (!(abstractDwdmLineModelArray[i] instanceof DwdmTrkLineModel) || ((DwdmModuleModel)this.getUiModel()).hasPluggableTrunk()) continue;
                if (db.on()) {
                    db.println("Add (Trk)     4 ---- Adding trunk port with payload: " + abstractDwdmLineModelArray[i] + ", to OM");
                }
                this.getOM().addObservable((Observable)((Object)abstractDwdmLineModelArray[i]));
                continue;
            }
            if (abstractDwdmLineModelArray[i] instanceof DwdmTrkLineModel) {
                DwdmTrkLineModel dwdmTrkLineModel = (DwdmTrkLineModel)abstractDwdmLineModelArray[i];
                this.manageTrkPayload(dwdmTrkLineModel, map);
                continue;
            }
            db.println("Payload cannot be determined for line: " + abstractDwdmLineModelArray[i]);
            if (!db.on()) continue;
            SDebug.printStackTrace((Throwable)new Exception());
        }
    }

    private InterfaceModel[] getPayloadLinesArray() {
        ArrayList arrayList = new ArrayList(this._payloadToClientModels.keySet());
        arrayList.addAll(this._payloadToTrunkModels.keySet());
        return arrayList.toArray(new InterfaceModel[arrayList.size()]);
    }

    private DwdmCliLineModel[] getCliLinesArray() {
        return this._payloadToClientModels.values().toArray(new DwdmCliLineModel[this._payloadToClientModels.size()]);
    }

    private DwdmTrkLineModel[] getTrkLinesArray() {
        DwdmTrkLineModel[] dwdmTrkLineModelArray = null;
        if (this._trunkModels.size() == 0) {
            dwdmTrkLineModelArray = this._payloadToTrunkModels.values().toArray(new DwdmTrkLineModel[this._payloadToTrunkModels.size()]);
        } else {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this._payloadToTrunkModels.values());
            arrayList.addAll(this._trunkModels);
            dwdmTrkLineModelArray = arrayList.toArray(new DwdmTrkLineModel[this._payloadToTrunkModels.size() + this._trunkModels.size()]);
        }
        return dwdmTrkLineModelArray;
    }

    private GfpLineModel[] getGfpLinesArray() {
        return this._gfpModels.toArray(new GfpLineModel[this._gfpModels.size()]);
    }

    private IRmonModel[] getRmonModelsArray() {
        return this._rmonModels.toArray(new IRmonModel[this._rmonModels.size()]);
    }

    private IPortContainer manageTrkPayload(DwdmTrkLineModel dwdmTrkLineModel, Map map) {
        IPortContainer iPortContainer;
        block17: {
            iPortContainer = null;
            if (dwdmTrkLineModel.isInterlink()) {
                InterlinkPortModel interlinkPortModel = null;
                try {
                    interlinkPortModel = (InterlinkPortModel)dwdmTrkLineModel.getPortModel();
                    if (interlinkPortModel != null) {
                        iPortContainer = (IPortContainer)interlinkPortModel.getParent();
                        if (db.on()) {
                            db.println("Add (Ilk) 1 ---- Adding payload interface: " + interlinkPortModel.getInterfaceModel() + ", to OM");
                        }
                        this.getOM().addObservable((Observable)((Object)((InterfaceModel)interlinkPortModel.getInterfaceModel())));
                        if (db.on()) {
                            db.println("Add (Ilk) 2 ---- Adding IfModel: " + dwdmTrkLineModel + ", to map payload <-> line");
                        }
                        map.put(dwdmTrkLineModel, dwdmTrkLineModel);
                        if (!this._interfaceContainers.containsValue(interlinkPortModel.getParent())) {
                            if (db.on()) {
                                db.println("Add (Ilk) 3 ---- Adding IfModel: " + dwdmTrkLineModel + ", container: " + interlinkPortModel.getParent() + ", to _interfaceContainers");
                            }
                            this._interfaceContainers.put(dwdmTrkLineModel, interlinkPortModel.getParent());
                            this.addContainerMap(dwdmTrkLineModel, (IPortContainer)interlinkPortModel.getParent());
                        } else if (db.on()) {
                            db.println("Add (Ilk) ---- Interlink IfModel " + dwdmTrkLineModel + " container " + interlinkPortModel.getParent() + " already present!!!!!");
                        }
                    } else if (db.on()) {
                        db.println("Got null Interlink payload.");
                    }
                    break block17;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    db.println("Cannot determine Interlink port.");
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                    break block17;
                }
            }
            if (!this._trunkModels.contains(dwdmTrkLineModel)) {
                if (db.on()) {
                    db.println("Add (Trk w/o payload, not Interlink) 1 ---- Adding line: " + dwdmTrkLineModel + ", to OM");
                }
                this.getOM().addObservable((Observable)((Object)dwdmTrkLineModel));
                if (db.on()) {
                    db.println("Add (Trk w/o payload, not Interlink) 2 ---- Adding IfModel: " + dwdmTrkLineModel + ", to Trk w/o payload, not Interlink)");
                }
                this._trunkModels.add(dwdmTrkLineModel);
                if (db.on()) {
                    db.println("Add (Trk w/o payload, not Interlink) 3 ---- Nothing to add to interface container");
                }
            }
        }
        return iPortContainer;
    }

    private IPortContainer updatePayloadMap(AbstractDwdmLineModel[] abstractDwdmLineModelArray, Map map) {
        int n;
        IPortContainer iPortContainer = null;
        int n2 = n = abstractDwdmLineModelArray == null ? 0 : abstractDwdmLineModelArray.length;
        if (n > map.size()) {
            AbstractDwdmLineModel abstractDwdmLineModel = null;
            InterfaceModel interfaceModel = null;
            for (int i = 0; i < n; ++i) {
                if (!map.containsValue(abstractDwdmLineModelArray[i])) {
                    Object object;
                    abstractDwdmLineModel = abstractDwdmLineModelArray[i];
                    if (db.on()) {
                        db.println("Found new line = " + abstractDwdmLineModel);
                    }
                    if ((interfaceModel = abstractDwdmLineModel.getPayloadModel()) != null) {
                        if (db.on()) {
                            db.println("Found payload = " + interfaceModel);
                        }
                        try {
                            object = interfaceModel.getPortModel();
                            IEntityModel iEntityModel = object.getParent();
                            if (iEntityModel instanceof IPortContainer) {
                                iPortContainer = (IPortContainer)iEntityModel;
                                if (db.on()) {
                                    db.println("Add (Cli/Trk) 1 ---- Adding IfModel: " + interfaceModel + ", container: " + iPortContainer + ", to containers map");
                                }
                                this.addContainerMap(interfaceModel, iPortContainer);
                            } else if (db.on()) {
                                db.println("PortModel is " + object);
                                db.println("EntityModel is not a PortContainer! Found " + iEntityModel);
                            }
                            if (db.on()) {
                                db.println("Found pc = " + iPortContainer);
                                db.println("Add (Cli/Trk) 2 ---- Adding payload: " + interfaceModel + ", to OM");
                            }
                            this.getOM().addObservable((Observable)((Object)interfaceModel));
                            if (db.on()) {
                                db.println("Add (Cli/Trk) 3 ---- Adding IfModel: " + interfaceModel + ", line model: " + abstractDwdmLineModel + ", to map payload <-> line");
                            }
                            if (abstractDwdmLineModel instanceof DwdmTrkLineModel) {
                                this._payloadToTrunkModels.put(interfaceModel, abstractDwdmLineModel);
                                continue;
                            }
                            map.put(interfaceModel, abstractDwdmLineModel);
                        }
                        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                            db.println("Caught NoSuchEntity in updatePayloadMap!");
                            if (!db.on()) continue;
                            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                        }
                        continue;
                    }
                    if (abstractDwdmLineModel instanceof DwdmTrkLineModel) {
                        object = (DwdmTrkLineModel)abstractDwdmLineModelArray[i];
                        iPortContainer = this.manageTrkPayload((DwdmTrkLineModel)object, map);
                        continue;
                    }
                    if (!db.on()) continue;
                    db.println("Payload not found");
                    continue;
                }
                if (!db.on()) continue;
                db.println("Found known line<->payload mapping");
            }
        }
        return iPortContainer;
    }

    protected List addModel(Observable observable) {
        IRmonModel[] iRmonModelArray;
        GfpLineModel[] gfpLineModelArray;
        DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.getUiModel();
        List list = super.addModel(observable);
        IModel[] iModelArray = null;
        InterfaceModel interfaceModel = null;
        boolean bl = false;
        int n = 0;
        if (observable instanceof DwdmModuleModel) {
            gfpLineModelArray = this.updatePayloadMap(dwdmModuleModel.getDwdmCliLineModels(), this._payloadToClientModels);
            iRmonModelArray = this.updatePayloadMap(dwdmModuleModel.getAllDwdmTrkLineModels(), this._payloadToTrunkModels);
            if (db.on()) {
                db.println("DwdmModuleModel update in addModel - cliPc: " + gfpLineModelArray + " trkPc: " + iRmonModelArray);
            }
            boolean bl2 = bl = gfpLineModelArray != null || iRmonModelArray != null;
            iModelArray = gfpLineModelArray != null ? gfpLineModelArray : iRmonModelArray;
        } else if (observable instanceof PpmModel || observable instanceof MrSlot) {
            iModelArray = (GfpLineModel[])observable;
            if (db.on()) {
                db.println("PpmModel or MrSlot update in addModel");
                db.println("Found pc = " + iModelArray);
            }
            gfpLineModelArray = iModelArray.getContainedPorts().iterator();
            while (gfpLineModelArray.hasNext()) {
                iRmonModelArray = (IPortModel)gfpLineModelArray.next();
                Map map = null;
                interfaceModel = (InterfaceModel)iRmonModelArray.getInterfaceModel();
                if (interfaceModel != null && !this._payloadToClientModels.containsKey(interfaceModel) && !this._payloadToTrunkModels.containsKey(interfaceModel)) {
                    if (db.on()) {
                        db.println("Found new payload = " + interfaceModel);
                    }
                    if (iRmonModelArray instanceof InterlinkPortModel) {
                        bl = true;
                        map = this._payloadToTrunkModels;
                        map.put(interfaceModel, interfaceModel);
                        this.getOM().addObservable((Observable)((Object)interfaceModel));
                        this.addContainerMap(interfaceModel, (IPortContainer)iModelArray);
                        continue;
                    }
                    InterfaceModel interfaceModel2 = interfaceModel.getFirstLowerLayerModels();
                    if (interfaceModel2 != null) {
                        if (interfaceModel2 instanceof DwdmCliLineModel) {
                            if (db.on()) {
                                db.println("Update Client <-> payload map for line: " + interfaceModel2);
                            }
                            map = this._payloadToClientModels;
                        } else if (interfaceModel2 instanceof DwdmTrkLineModel) {
                            if (db.on()) {
                                db.println("Update Trunk <-> payload for line: " + interfaceModel2);
                            }
                            map = this._payloadToTrunkModels;
                        } else {
                            db.println("Invalid lower layer found for: " + interfaceModel);
                            continue;
                        }
                        if (db.on()) {
                            db.println("Add (Cli/Trk) 1 ---- Adding payload: " + interfaceModel + ", to OM");
                        }
                        this.getOM().addObservable((Observable)((Object)interfaceModel));
                        if (db.on()) {
                            db.println("Add (Cli/Trk) 2 ---- Adding IfModel: " + interfaceModel + ", line model: " + interfaceModel2 + ", to map payload <-> line");
                        }
                        map.put(interfaceModel, interfaceModel2);
                        if (db.on()) {
                            db.println("Add (Cli/Trk) 3 ---- Adding IfModel: " + interfaceModel + ", container: " + iModelArray + ", to containers map");
                        }
                        this.addContainerMap(interfaceModel, (IPortContainer)iModelArray);
                        bl = true;
                        continue;
                    }
                    if (!db.on()) continue;
                    db.println("No lower layer yet, for payload: " + interfaceModel);
                    continue;
                }
                if (!db.on()) continue;
                db.println("Found known (or null) payload");
            }
        } else if (observable instanceof DwdmTrkLineModel) {
            if (db.on()) {
                db.println("DwdmTrkLineModel update in addModel");
            }
            if ((interfaceModel = ((DwdmTrkLineModel)((Object)observable)).getPayloadModel()) != null) {
                bl = true;
                if (db.on()) {
                    db.println("Add (Trk) 1 ---- Adding payload: " + interfaceModel + ", to OM");
                }
                this.getOM().addObservable((Observable)((Object)interfaceModel));
                if (db.on()) {
                    db.println("Add (Trk) 2 ---- Adding IfModel: " + interfaceModel + ", line model: " + observable + ", to _payloadToTrunkModels");
                }
                this._payloadToTrunkModels.put(interfaceModel, (DwdmTrkLineModel)((Object)observable));
                if (db.on()) {
                    db.println("Found trunk payload for " + observable);
                }
            } else if (db.on()) {
                db.println("Found known (or null) Trunk payload.");
            }
        }
        if (bl) {
            if (db.on()) {
                db.println("Sending DwdmLineUpdate...");
                db.println("PortContainer: " + iModelArray);
                db.println("Cli lines: " + this.getCliLinesArray().length);
                db.println("Trk lines: " + this.getTrkLinesArray().length);
                db.println("Payloads:  " + this.getPayloadLinesArray().length);
            }
            list.add(new DwdmLineUpdate(this.getCliLinesArray(), this.getPayloadLinesArray(), this.getTrkLinesArray(), (IPortContainer)iModelArray));
        }
        int n2 = n = (gfpLineModelArray = dwdmModuleModel.getGfpLineModels()) == null ? 0 : gfpLineModelArray.length;
        if (n > this._gfpModels.size()) {
            this._gfpModels = new ArrayList<GfpLineModel>(Arrays.asList(gfpLineModelArray));
            this.getOM().addObservable((Observable[])gfpLineModelArray);
            if (DwdmCardTabbedView.db.on) {
                db.println("gfpModel.size = " + this._gfpModels.size());
            }
        }
        int n3 = n = (iRmonModelArray = dwdmModuleModel.getRmonModels()) == null ? 0 : iRmonModelArray.length;
        if (n > this._rmonModels.size()) {
            this._rmonModels = new ArrayList<IRmonModel>(Arrays.asList(iRmonModelArray));
            if (DwdmCardTabbedView.db.on) {
                db.println("rmonModels.size = " + this._rmonModels.size());
                db.println("Sending RmonLineUpdate...");
            }
            list.add(new RmonLineUpdate(iRmonModelArray));
        }
        return list;
    }

    protected List removeModel(Observable observable) {
        List list = super.removeModel(observable);
        IPortContainer iPortContainer = null;
        if (db.on() && (observable instanceof InterfaceModel || observable instanceof InterlinkPortModel)) {
            db.println("Remove (Cli/Trk/Ilk) 1 ---- removing: " + observable + ", from OM");
        }
        this.getOM().removeObservable(observable);
        if (observable instanceof InterfaceModel) {
            if (db.on()) {
                db.println("Remove (Cli/Trk) 2 ---- removing: " + observable + ", from containers map");
            }
            iPortContainer = (IPortContainer)this.removeContainerMap((IInterfaceModel)observable);
            this._gfpModels.remove(observable);
        }
        if (iPortContainer != null) {
            if (db.on()) {
                db.println("Remove (Cli/Trk) 3 ---- removing: " + observable + ", from payload <-> Line map");
            }
            this._payloadToClientModels.remove(observable);
            this._payloadToTrunkModels.remove(observable);
            if (db.on()) {
                db.println("Sending DwdmLineUpdate in removeModel");
                db.println("PortContainer: " + iPortContainer);
                db.println("Cli lines: " + this.getCliLinesArray().length);
                db.println("Trk lines: " + this.getTrkLinesArray().length);
                db.println("Payloads:  " + this.getPayloadLinesArray().length);
            }
            list.add(new DwdmLineUpdate(this.getCliLinesArray(), this.getPayloadLinesArray(), this.getTrkLinesArray(), iPortContainer));
        } else if (this._payloadToTrunkModels.containsKey(observable)) {
            if (db.on()) {
                db.println("Remove (Trk)     3 ---- removing: " + observable + ", from payload <-> Line map");
            }
            this._payloadToTrunkModels.remove(observable);
        }
        if (observable instanceof ISupportsRMON) {
            this._rmonModels.remove(((ISupportsRMON)((Object)observable)).getRmonModel());
            list.add(new RmonLineUpdate(this.getRmonModelsArray()));
        }
        return list;
    }

    public void showTabs() {
        this.addTab("Alarms", (Component)this.getAlarmTab());
        this.addTab("Conditions", (Component)this.getConditionsTab());
        this.addTab("History", (Component)this.getEventTab());
        this.addTab("Circuits", (Component)this.getCircuitTab());
        this.addTab("Provisioning", (Component)this.getProvTab());
        this.addTab("Maintenance", (Component)this.getMaintenanceTab());
        this.addTab("Performance", (Component)this.getPerformanceTab());
    }

    public Pane getMaintenanceTab() {
        return new AbstractSubTabbedPane("Maintenance", (TabbedView)this){

            public void createSubTabs() {
                DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.getUiModel();
                DwdmCliLineModel[] dwdmCliLineModelArray = DwdmCardTabbedView.this.getCliLinesArray();
                DwdmTrkLineModel[] dwdmTrkLineModelArray = DwdmCardTabbedView.this.getTrkLinesArray();
                int n = dwdmCliLineModelArray.length;
                int n2 = dwdmTrkLineModelArray.length;
                InterfaceModel[] interfaceModelArray = new AbstractDwdmLineModel[n + n2];
                System.arraycopy(dwdmCliLineModelArray, 0, interfaceModelArray, 0, n);
                System.arraycopy(dwdmTrkLineModelArray, 0, interfaceModelArray, n, n2);
                NxpAlsPane nxpAlsPane = new NxpAlsPane("ALS", this.subTabs, interfaceModelArray);
                interfaceModelArray = dwdmModuleModel.removeIlkTrkLineModels((AbstractDwdmLineModel[])interfaceModelArray);
                this.subTabs.addTab("Loopback", (Component)((Object)new DwdmLineMaintenancePane("Loopback", this.subTabs, (AbstractDwdmLineModel[])interfaceModelArray)));
                this.subTabs.addTab("ALS", (Component)((Object)nxpAlsPane));
                this.subTabs.addTab("Info", (Component)((Object)new DwdmInfoMaintenancePane("Info", this.subTabs)));
                AbstractDwdmLineModel[] abstractDwdmLineModelArray = dwdmModuleModel.removeNonAINSLineModels((AbstractDwdmLineModel[])interfaceModelArray);
                this.subTabs.addTab("AINS Soak", (Component)this.getSoakPane(abstractDwdmLineModelArray, !dwdmModuleModel.isMxpMr25G()));
                this.subTabs.addTab("Protection", (Component)CardTabbedView.getProtectionPane(this.subTabs));
                if (dwdmModuleModel.isADMCard()) {
                    this.subTabs.addTab("Path Trace", (Component)CardTabbedView.getPathTracePane(interfaceModelArray, this.subTabs));
                }
            }

            private Pane getSoakPane(AbstractDwdmLineModel[] abstractDwdmLineModelArray, boolean bl) {
                return new SoakMaintenancePane("AINS Soak", this.subTabs, abstractDwdmLineModelArray, bl){

                    protected void refreshMyLines(Object object) {
                        DwdmModuleModel dwdmModuleModel;
                        AbstractDwdmLineModel[] abstractDwdmLineModelArray;
                        if (object instanceof DwdmLineUpdate && (abstractDwdmLineModelArray = (dwdmModuleModel = (DwdmModuleModel)this.getUiModel()).removeIlkTrkLineModels(((DwdmLineUpdate)object).getDwdmLineModels())) != null && (abstractDwdmLineModelArray = dwdmModuleModel.removeNonAINSLineModels(abstractDwdmLineModelArray)) != null) {
                            this.models = abstractDwdmLineModelArray;
                            this.dataModel.refreshMyLines(this.models);
                        }
                    }
                };
            }
        };
    }

    public Pane getPerformanceTab() {
        return new DwdmPerfPane("Performance", this);
    }

    public Pane getProvTab() {
        return new DwdmProvPane("Provisioning", this);
    }

    public Pane getInventoryTab() {
        return new CardInventoryPane("Inventory", this);
    }

    public void destroy() {
        this._payloadToClientModels.clear();
        this._payloadToTrunkModels.clear();
        this._gfpModels.clear();
        this._rmonModels.clear();
        this.getOM().removeObservable((Observable[])this._trunkModels.toArray(new DwdmTrkLineModel[this._trunkModels.size()]));
        this._trunkModels.clear();
        this.getUiModel().deleteObserver((Observer)this);
        super.destroy();
    }
}

