/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.eReach;
import cerent.cms.idl.Common.eWavelength;
import cerent.cms.idl.Common.sEtherMacAddr;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.Dwdm.eAisSquelchMode;
import cerent.cms.idl.Dwdm.eDataRate;
import cerent.cms.idl.EtherMedia.eEtherSpeed;
import cerent.cms.idl.EtherMedia.sL1Info;
import cerent.cms.idl.If.eALSMode;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DetailedConfigError;
import cerent.cms.model.DwdmCliLineModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.HdGeLineModel;
import cerent.cms.model.IOpticsProvExtModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NotSupportedOnEquipment;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.IAdminTableAccess;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.dwdm.DwdmTableModel;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.MacAddrFormat;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.WID;
import cerent.util.gui.SoakTimePropertyEditor;
import java.awt.Component;

public class DwdmLineProvTableModel
extends DwdmTableModel
implements IAdminTableAccess {
    private IOpticsProvExtModel[] opticModels;
    private long[] macAddr;
    private Attribute[] frameSize;
    protected AdminState[] adminState;
    protected IServiceState[] serviceState;
    protected Attribute[] alsMode;
    protected int[] soakTime;
    protected Attribute[] reach;
    protected Attribute[] wavelength;
    protected Attribute[] squelch;
    protected Attribute[] negotiationMode;
    public static final int LINENUMBER_INDEX = 0;
    public static final int PORTNAME_INDEX = 1;
    public static final int ADMIN_STATE_INDEX = 2;
    public static final int SERVICE_STATE_INDEX = 3;
    public static final int ALS_MODE_INDEX = 4;
    public static final int FRAME_SIZE_INDEX = 5;
    public static final int MAC_ADDR_INDEX = 6;
    public static final int AINS_SOAK_INDEX = 7;
    public static final int REACH_INDEX = 8;
    public static final int WAVELENGTH_INDEX = 9;
    public static final int AIS_SQUELCH_INDEX = 10;
    public static final int NEGOTIATION_MODE_INDEX = 11;
    public static final int NEXT_COLUMN_INDEX = 12;
    protected String[] columnNames = new String[]{"Port", "Port Name", "Admin State", "Service State", "ALS Mode", "MTU", "Incoming MAC Address", "AINS Soak", "Reach", "Wavelength", "Squelch", "Mode"};
    protected boolean[][] isDirty;
    private boolean FlgDlgAlreadyShowed = false;
    private static final SDebug db = new SDebug("DwdmLineProvTableModel");

    public DwdmLineProvTableModel(AbstractDwdmLineModel[] abstractDwdmLineModelArray, IOpticsProvExtModel[] iOpticsProvExtModelArray) {
        super(db, abstractDwdmLineModelArray);
        this.refreshMyLines(abstractDwdmLineModelArray, iOpticsProvExtModelArray);
    }

    public void refreshMyLines(AbstractDwdmLineModel[] abstractDwdmLineModelArray, IOpticsProvExtModel[] iOpticsProvExtModelArray) {
        int n;
        super.refreshMyLines(abstractDwdmLineModelArray);
        this.opticModels = iOpticsProvExtModelArray;
        this.adminState = new AdminState[this.numLines];
        this.serviceState = new IServiceState[this.numLines];
        this.alsMode = new Attribute[this.numLines];
        this.frameSize = new Attribute[this.numLines];
        this.macAddr = new long[this.numLines];
        this.soakTime = new int[this.numLines];
        this.reach = new Attribute[this.numLines];
        this.wavelength = new Attribute[this.numLines];
        this.squelch = new Attribute[this.numLines];
        this.negotiationMode = new Attribute[this.numLines];
        for (n = 0; n < this.numLines; ++n) {
            this.macAddr[n] = -1L;
        }
        for (n = 0; n < this.numLines; ++n) {
            this.soakTime[n] = -1;
        }
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public Class getColumnClass(int n) {
        return Object.class;
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.model != null && this.numLines > 0 && n2 != 3) {
            if (n2 == 8 || n2 == 9) {
                if (this.model[n] instanceof DwdmTrkLineModel) {
                    DwdmTrkLineModel dwdmTrkLineModel = (DwdmTrkLineModel)this.model[n];
                    return dwdmTrkLineModel.isPluggableTrk();
                }
                if (this.model[n] instanceof DwdmCliLineModel && n2 == 8) {
                    try {
                        if (this.model[n].getEqTypeFromDataRate().value() == 322 || this.model[n].getEqTypeFromDataRate().value() == 323 || this.model[n].getEqTypeFromDataRate().value() == 173) {
                            return false;
                        }
                    }
                    catch (NoSuchInterface noSuchInterface) {
                        noSuchInterface.printStackTrace();
                    }
                    catch (WrongInterfaceType wrongInterfaceType) {
                        wrongInterfaceType.printStackTrace();
                    }
                }
            }
            if (n2 == 7) {
                boolean bl = true;
                if (this.model[n] instanceof DwdmTrkLineModel) {
                    DwdmTrkLineModel dwdmTrkLineModel = (DwdmTrkLineModel)this.model[n];
                    bl = !dwdmTrkLineModel.isInterlink();
                    bl = bl && dwdmTrkLineModel.supportsAINS();
                } else if (this.model[n] instanceof DwdmCliLineModel) {
                    DwdmCliLineModel dwdmCliLineModel = (DwdmCliLineModel)this.model[n];
                    bl = dwdmCliLineModel.supportsAINS();
                }
                return bl;
            }
            if (AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING) && (!this.isProtectedTrunkPort(n) || n2 != 4)) {
                if (n2 == 10) {
                    return this.isSquelchSettable(n);
                }
                return n2 == 4 ? this.isAlsSettable(n, n2) : n2 > 0;
            }
        }
        return false;
    }

    private boolean isAlsSettable(int n, int n2) {
        if (n2 != 4 || this.model[n] == null) {
            return true;
        }
        return this.model[n].isAlsSettable();
    }

    protected boolean isProtectedTrunkPort(int n) {
        if (this.model[n].isCatinaccioTrunk()) {
            return false;
        }
        return super.isProtectedTrunkPort(n);
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    public boolean isAdminStateDirty(int n) {
        return this.isDirty(n, 2);
    }

    public boolean isRowDirty(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.isDirty(n, i)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isRowDirty(i)) continue;
            return true;
        }
        return false;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortDescriptionFor(n);
                }
                case 1: {
                    return this.getPortName(n);
                }
                case 4: {
                    return this.getAlsMode(n);
                }
                case 2: {
                    return this.getAdminState(n).toString(this.getTerms());
                }
                case 3: {
                    return this.getServiceState(n).toString(this.getTerms());
                }
                case 5: {
                    return this.getMaxFrameSize(n);
                }
                case 6: {
                    return this.getMacAddress(n);
                }
                case 7: {
                    return this.getSoakTimeAsHHMM(n);
                }
                case 8: {
                    return this.getReach(n);
                }
                case 9: {
                    return this.getWavelength(n);
                }
                case 10: {
                    return this.getAisSquelchMode(n);
                }
                case 11: {
                    return this.getNegotiationMode(n);
                }
            }
            return "";
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("DwdmLineProvTableModel: error in getValueAt" + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    private Attribute getReach(int n) {
        if (this.reach[n] == null) {
            eReach eReach2 = null;
            Attribute attribute = null;
            try {
                eReach2 = this.opticModels[n].getLineReach();
                this.reach[n] = attribute = this.getAttributeMap().getAttributeForVal("declDwdmReach", eReach2.value());
            }
            catch (UnsupportedOperation unsupportedOperation) {
                this.reach[n] = attribute = this.getAttributeMap().getAttributeForVal("declDwdmReach", 0);
            }
            catch (Exception exception) {
                if (db.on()) {
                    db.println("DwdmLineProvTableModel: " + exception);
                }
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return this.reach[n];
    }

    public eReach getSelectedReach(int n) {
        eReach eReach2 = eReach.REACH_AUTOPROV;
        if (this.reach[n] != null) {
            eReach2 = eReach.from_int(this.reach[n].getValue());
        }
        return eReach2;
    }

    private Attribute getWavelength(int n) {
        if (this.wavelength[n] == null) {
            eWavelength eWavelength2 = eWavelength.WV_UNKNOWN;
            try {
                eWavelength2 = this.opticModels[n].getLineWavelength();
            }
            catch (UnsupportedOperation unsupportedOperation) {
                if (db.on()) {
                    db.println("DwdmLineProvTableModel: " + (Object)((Object)unsupportedOperation));
                }
            }
            catch (Exception exception) {
                if (db.on()) {
                    db.println("DwdmLineProvTableModel: " + exception);
                }
                SDebug.printStackTrace((Throwable)exception);
            }
            this.wavelength[n] = Wavelength.getWlAttribute(eWavelength2.value());
        }
        return this.wavelength[n];
    }

    public AdminState getAdminState(int n) throws Exception {
        if (this.adminState[n] == null) {
            eAdminState eAdminState2 = this.model[n].getAdminStateEnum();
            this.adminState[n] = AdminState.enumToAdminState(eAdminState2);
        }
        return this.adminState[n];
    }

    private IServiceState getServiceState(int n) throws NoSuchInterface {
        if (this.serviceState[n] == null) {
            sServiceState sServiceState2 = this.model[n].getServiceState();
            this.serviceState[n] = ServiceStateFactory.getServiceState(sServiceState2);
        }
        return this.serviceState[n];
    }

    private TDMTerminology getTerms() {
        return this.eqpmtModel.getNodeModel().getTDMTerminology();
    }

    public void setValueAt(Object object, int n, int n2) {
        if (db.on()) {
            db.println("Change in value row=" + n + " col=" + n2 + " newVal=" + object);
        }
        try {
            switch (n2) {
                case 1: {
                    this.portNames[n] = (String)object;
                    break;
                }
                case 4: {
                    Attribute attribute = (Attribute)object;
                    if (!this.model[n].supportsAutoALS() && eALSMode.from_int(attribute.getIntValue()) == eALSMode.AUTO) {
                        ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_AUTO_RESTART_NOT_SUPPORTED);
                        return;
                    }
                    if (attribute == this.alsMode[n]) {
                        return;
                    }
                    this.alsMode[n] = attribute;
                    break;
                }
                case 2: {
                    AdminState adminState = (AdminState)object;
                    if (adminState.equals(this.adminState[n])) {
                        return;
                    }
                    this.adminState[n] = adminState;
                    break;
                }
                case 5: {
                    Attribute attribute = (Attribute)object;
                    if (attribute == this.frameSize[n]) {
                        return;
                    }
                    this.frameSize[n] = attribute;
                    break;
                }
                case 6: {
                    long l = MacAddrFormat.parseMacAddr((String)object);
                    if (this.macAddr[n] == l) {
                        return;
                    }
                    this.macAddr[n] = l;
                    break;
                }
                case 7: {
                    int n3 = this.soakTime[n];
                    try {
                        n3 = SoakTimePropertyEditor.toIntValue((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                        db.fine("Number Format Exception on " + (String)object);
                    }
                    if (this.soakTime[n] == n3) {
                        return;
                    }
                    this.soakTime[n] = n3;
                    break;
                }
                case 8: {
                    this.reach[n] = (Attribute)object;
                    break;
                }
                case 9: {
                    this.wavelength[n] = (Attribute)object;
                    break;
                }
                case 10: {
                    this.squelch[n] = (Attribute)object;
                    break;
                }
                case 11: {
                    this.negotiationMode[n] = (Attribute)object;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return;
        }
        this.isDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
    }

    private void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.refreshLineFromModel(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void refreshLineFromModel(int n) {
        if (n > this.numLines || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.resetLineCache(n);
        this.FlgDlgAlreadyShowed = false;
        this.fireTableRowsUpdated(n, n);
    }

    protected void resetLineCache(int n) {
        this.portNames[n] = null;
        this.adminState[n] = null;
        this.serviceState[n] = null;
        this.alsMode[n] = null;
        this.macAddr[n] = -1L;
        this.frameSize[n] = null;
        this.soakTime[n] = -1;
        this.reach[n] = null;
        this.wavelength[n] = null;
        this.squelch[n] = null;
        this.negotiationMode[n] = null;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    protected eAdminState getAdminStateFor(int n) throws Exception {
        return this.getAdminState(n).getAdminStateEnum();
    }

    public void applyToModel() throws Exception {
        int n = 0;
        try {
            for (n = 0; n < this.numLines; ++n) {
                Object object;
                if (this.isDirty(n, 1)) {
                    this.model[n].setAlias(this.getPortName(n));
                    this.isDirty[n][1] = false;
                }
                if (this.isDirty(n, 4)) {
                    if (this.model[n].isSplitterProtectedLine() && !this.model[n].isCatinaccioTrunk() && this.alsMode[n].getIntValue() != 0) {
                        if (!this.FlgDlgAlreadyShowed) {
                            ErrorMsg.displayWarning(null, (WID)EMC.WID_ALS_WONT_ENGAGE);
                        }
                        this.FlgDlgAlreadyShowed = true;
                    }
                    this.model[n].setALSMode(this.getAlsMode(n).getIntValue());
                    this.isDirty[n][4] = false;
                }
                if (this.isDirty(n, 2)) {
                    if (db.on()) {
                        db.fine("setting line to admin state " + this.getAdminState(n).toString());
                    }
                    this.model[n].setAdminStateNoLpbk(this.getAdminStateFor(n));
                    this.isDirty[n][2] = false;
                }
                if (this.isDirty(n, 5)) {
                    if (this.eqpmtModel.isADMCard()) {
                        this.setAdmEthL1Info(n);
                        this.isDirty[n][11] = false;
                    } else {
                        this.model[n].setMaxFrame(this.getMaxFrameSize(n).getIntValue());
                    }
                    this.isDirty[n][5] = false;
                }
                if (this.isDirty[n][6]) {
                    this.model[n].setMacAddress(new sEtherMacAddr(MacAddrFormat.toBytes(this.macAddr[n])));
                    this.isDirty[n][6] = false;
                }
                if (this.isDirty(n, 7)) {
                    if (db.on()) {
                        db.println("setting line soakTime " + this.getSoakTime(n));
                    }
                    this.model[n].setSoakTime(this.getSoakTime(n));
                }
                if (this.isDirty(n, 8)) {
                    boolean bl = true;
                    if (this.model[n] instanceof DwdmTrkLineModel) {
                        object = (DwdmTrkLineModel)this.model[n];
                        bl = ((DwdmTrkLineModel)object).isPluggableTrk();
                    }
                    if (bl) {
                        eReach eReach2;
                        object = this.getReach(n);
                        if (db.on()) {
                            db.println("setting reach " + object);
                            db.println("Model is " + this.model[n]);
                        }
                        if ((eReach2 = eReach.from_int(((Attribute)object).getValue())).value() != 0) {
                            this.opticModels[n].setLineReach(eReach2);
                        }
                    }
                }
                if (this.isDirty(n, 9)) {
                    Attribute attribute = this.getWavelength(n);
                    if (db.on()) {
                        db.println("setting wave " + attribute);
                    }
                    if (((eWavelength)(object = eWavelength.from_int(attribute.getValue()))).value() != 174) {
                        this.opticModels[n].setLineWavelength((eWavelength)object);
                    }
                }
                if (this.isDirty(n, 10)) {
                    eAisSquelchMode eAisSquelchMode2 = eAisSquelchMode.from_int(this.getAisSquelchMode(n).getIntValue());
                    this.model[n].setAisSquelchMode(eAisSquelchMode2);
                    this.isDirty[n][10] = false;
                }
                if (!this.isDirty(n, 11)) continue;
                this.setAdmEthL1Info(n);
                this.isDirty[n][11] = false;
                this.isDirty[n][5] = false;
            }
        }
        catch (DetailedConfigError detailedConfigError) {
            throw new ConfigError(detailedConfigError.getMessage());
        }
        catch (UnsupportedOperation unsupportedOperation) {
            throw new AnnotatedException("An error occurred while applying changes to row " + (n + 1), (Exception)((Object)unsupportedOperation));
        }
        catch (Exception exception) {
            throw new AnnotatedException("An error occurred while applying changes to row " + (n + 1) + ".", exception);
        }
    }

    private void setAdmEthL1Info(int n) throws NoSuchInterface, WrongInterfaceType, NotSupportedOnEquipment, EMCProvisionError, ConfigError {
        HdGeLineModel hdGeLineModel = (HdGeLineModel)this.model[n].getPayloadModel();
        sL1Info sL1Info2 = null;
        sL1Info2 = hdGeLineModel.getEtherL1Info();
        sL1Info2.mtu = this.getMaxFrameSize(n).getIntValue();
        sL1Info2.speed = eEtherSpeed.from_int(this.getNegotiationMode(n).getIntValue());
        hdGeLineModel.setEtherL1Info(sL1Info2);
    }

    private Attribute getAlsMode(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.alsMode[n] == null) {
            this.alsMode[n] = this.getAttributeFor("AlsMode", this.model[n].getALSMode());
        }
        return this.alsMode[n];
    }

    private Attribute getMaxFrameSize(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.frameSize[n] == null) {
            int n2 = 1548;
            String string = null;
            if (this.eqpmtModel.isADMCard()) {
                sL1Info sL1Info2 = this.getAdmL1Info(n);
                if (sL1Info2 != null) {
                    n2 = sL1Info2.mtu;
                    string = "Adm10GEthMaxSize";
                }
            } else {
                n2 = this.model[n].getMaxFrame();
                string = "G1000 Port Max Size";
            }
            this.frameSize[n] = this.getAttributeFor(string, n2);
        }
        return this.frameSize[n];
    }

    private Attribute getNegotiationMode(int n) {
        if (this.negotiationMode[n] == null && this.eqpmtModel.isADMCard()) {
            int n2 = 3;
            sL1Info sL1Info2 = this.getAdmL1Info(n);
            if (sL1Info2 != null) {
                n2 = sL1Info2.speed.value();
            }
            this.negotiationMode[n] = this.getAttributeFor("EtherGeSpeed", n2);
        }
        return this.negotiationMode[n];
    }

    private String getMacAddress(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.macAddr[n] == -1L) {
            this.macAddr[n] = MacAddrFormat.toLong(this.model[n].getMacAddress().addr);
        }
        return MacAddrFormat.formatMacAddr(this.macAddr[n]);
    }

    private sL1Info getAdmL1Info(int n) {
        sL1Info sL1Info2;
        block6: {
            sL1Info2 = null;
            HdGeLineModel hdGeLineModel = (HdGeLineModel)this.model[n].getPayloadModel();
            try {
                sL1Info2 = hdGeLineModel.getEtherL1Info();
            }
            catch (NoSuchInterface noSuchInterface) {
                db.println("Exception in getMaxFrameSize, Invalid frame size");
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                db.println("Exception in getMaxFrameSize, Invalid frame size");
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
            catch (NotSupportedOnEquipment notSupportedOnEquipment) {
                db.println("Exception in getMaxFrameSize, Invalid frame size");
                if (!db.on()) break block6;
                SDebug.printStackTrace((Throwable)notSupportedOnEquipment);
            }
        }
        return sL1Info2;
    }

    private Attribute getAisSquelchMode(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.squelch[n] == null) {
            this.squelch[n] = this.getAttributeFor("disableAisSquelch", this.model[n].getAisSquelchMode().value());
        }
        return this.squelch[n];
    }

    protected int getSoakTime(int n) throws NoSuchInterface {
        if (this.soakTime[n] == -1) {
            this.soakTime[n] = this.model[n].getSoakTime();
        }
        return this.soakTime[n];
    }

    private String getSoakTimeAsHHMM(int n) throws NoSuchInterface {
        return SoakTimePropertyEditor.toStringHHMM(this.getSoakTime(n));
    }

    protected AttributeMaps getAttributeMap() {
        return ElementDefaults.getAttributeMap(this.eqpmtModel.getNodeModel().getTdmProtocolType(), this.getTerms());
    }

    private boolean isSquelchSettable(int n) {
        try {
            int n2 = this.eqpmtModel.getEqType();
            return (n2 == 243 || n2 == 282) && this.model[n].getDataRateEnum() != eDataRate.ISC;
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return false;
        }
    }
}

