/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.FcmrLineModel;
import cerent.cms.model.IGenericTraceLine;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TraceMode;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.dwdm.DwdmLinePane;
import cerent.cms.ui.dwdm.DwdmSonetLineProvPane;
import cerent.cms.ui.dwdm.DwdmTrkMlsePane;
import cerent.cms.ui.dwdm.DwdmTrkWlPane;
import cerent.cms.ui.dwdm.NAProtectPane;
import cerent.cms.ui.fcmr.FcmrPortDistExtensionPane;
import cerent.cms.ui.fcmr.FcmrPortEnhancedFCFiconPane;
import cerent.cms.ui.trace.GenericTraceProvPane;
import cerent.util.SDebug;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;

public class DwdmPayloadLinePane
extends AbstractSubTabbedPane
implements ITabName {
    private boolean isSDH = false;
    private boolean isMonvisoMxp = false;
    private boolean isPolluce = false;
    private boolean isPolluceMXP = false;
    private AbstractPane dwdmLinePane;
    private AbstractPane fcDistExtPane;
    private AbstractPane fcPortEnhPane;
    private AbstractPane sonetLinePane;
    private AbstractPane monvisoTrkPane;
    private AbstractPane comboPane;
    private AbstractPane pluggablePortsPane;
    private GenericTraceProvPane sonetTracePane;
    private AbstractPane currentPane;
    private AbstractPane trkPane;
    private AbstractPane mlsePane;

    public DwdmPayloadLinePane(String string, TabbedView tabbedView, DwdmModuleModel dwdmModuleModel) {
        super(string, tabbedView);
        this.registerWithModel();
        this.isSDH = dwdmModuleModel.getNodeModel().getTdmProtocolTypeObj().isSdh();
        this.isMonvisoMxp = dwdmModuleModel.getEqType() == 182 || dwdmModuleModel.getEqType() == 276;
        this.isPolluce = dwdmModuleModel.getEqType() == 301 || dwdmModuleModel.getEqType() == 300;
        this.isPolluceMXP = dwdmModuleModel.getEqType() == 301;
    }

    public void destroy() {
        int n = this.subTabs.getComponentCount();
        AbstractPane[] abstractPaneArray = new AbstractPane[]{this.dwdmLinePane, this.fcDistExtPane, this.fcPortEnhPane, this.sonetLinePane, this.sonetTracePane, this.monvisoTrkPane, this.comboPane, this.trkPane, this.pluggablePortsPane};
        ArrayList<AbstractPane> arrayList = new ArrayList<AbstractPane>(Arrays.asList(abstractPaneArray));
        for (int i = 0; i < n; ++i) {
            Component object = this.subTabs.getComponentAt(i);
            if (!arrayList.contains(object)) continue;
            arrayList.remove(object);
        }
        for (AbstractPane abstractPane : arrayList) {
            if (abstractPane == null) continue;
            abstractPane.destroy();
        }
        super.destroy();
    }

    protected void createSubTabs() {
        int n;
        DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.getUiModel();
        AbstractDwdmLineModel[] abstractDwdmLineModelArray = dwdmModuleModel.getDwdmCliLineModels();
        AbstractDwdmLineModel[] abstractDwdmLineModelArray2 = dwdmModuleModel.getDwdmTrkLineModels();
        AbstractDwdmLineModel[] abstractDwdmLineModelArray3 = dwdmModuleModel.getAllDwdmLineModels();
        FcmrLineModel[] fcmrLineModelArray = FcmrLineModel.filterUndefinedMedia(DwdmModuleModel.getFcmrLineModels(abstractDwdmLineModelArray));
        ArrayList<TdmLineModel> arrayList = new ArrayList<TdmLineModel>();
        ArrayList<AbstractDwdmLineModel> arrayList2 = new ArrayList<AbstractDwdmLineModel>();
        if (dwdmModuleModel.getEqType() == 293 || this.isPolluce) {
            for (n = 0; n < abstractDwdmLineModelArray3.length; ++n) {
                try {
                    if (!abstractDwdmLineModelArray3[n].isSonetSdhPayload()) continue;
                    if (!this.isPolluceMXP || abstractDwdmLineModelArray3[n].isClient()) {
                        arrayList.add(abstractDwdmLineModelArray3[n].getTdmLineModel());
                    }
                    arrayList2.add(abstractDwdmLineModelArray3[n]);
                    continue;
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                    continue;
                }
                catch (NoSuchInterface noSuchInterface) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
        } else {
            for (n = 0; n < abstractDwdmLineModelArray.length; ++n) {
                try {
                    if (!abstractDwdmLineModelArray[n].isSonetSdhPayload()) continue;
                    arrayList.add(abstractDwdmLineModelArray[n].getTdmLineModel());
                    arrayList2.add(abstractDwdmLineModelArray[n]);
                    continue;
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
            for (n = 0; n < abstractDwdmLineModelArray2.length; ++n) {
                try {
                    if (!abstractDwdmLineModelArray2[n].isSonetSdhPayload()) continue;
                    arrayList.add(abstractDwdmLineModelArray2[n].getTdmLineModel());
                    arrayList2.add(abstractDwdmLineModelArray2[n]);
                    continue;
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    if (!db.on()) continue;
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
        }
        AbstractDwdmLineModel[] abstractDwdmLineModelArray4 = arrayList2.toArray(new AbstractDwdmLineModel[0]);
        IGenericTraceLine[] iGenericTraceLineArray = arrayList.toArray(new TdmLineModel[0]);
        if (dwdmModuleModel.isADMCard()) {
            this.dwdmLinePane = new DwdmLinePane("Unframed", this.subTabs, dwdmModuleModel.get1GEthLines(null), DwdmLinePane.PaneType.ADM_ETH);
        } else if (dwdmModuleModel.getEqType() == 293) {
            this.dwdmLinePane = new DwdmLinePane("Unframed", this.subTabs, dwdmModuleModel.get10GELines(null), DwdmLinePane.PaneType.ADM_ETH);
        } else if (this.isPolluce) {
            this.dwdmLinePane = new DwdmLinePane("Unframed", this.subTabs, dwdmModuleModel.getEthGELines(null), DwdmLinePane.PaneType.PLUGGABLES);
        } else {
            this.dwdmLinePane = new DwdmLinePane("Unframed", this.subTabs, abstractDwdmLineModelArray3, DwdmLinePane.PaneType.DEFAULT);
            if (abstractDwdmLineModelArray2.length > 0 && !this.isPolluce) {
                this.trkPane = new DwdmTrkWlPane("Wavelength Trunk Settings", this.subTabs, (DwdmTrkLineModel[])abstractDwdmLineModelArray2);
                if (dwdmModuleModel.supportsMLSEModule()) {
                    this.mlsePane = new DwdmTrkMlsePane("Error Decorrelator Settings", this.subTabs, (DwdmTrkLineModel[])abstractDwdmLineModelArray2);
                }
            }
        }
        this.fcDistExtPane = new FcmrPortDistExtensionPane("Distance Extension", this.subTabs, fcmrLineModelArray, !dwdmModuleModel.supportsDEParams());
        this.fcPortEnhPane = new FcmrPortEnhancedFCFiconPane("Enhanced FC/FICON ISL", this.subTabs, fcmrLineModelArray, true);
        this.sonetLinePane = new DwdmSonetLineProvPane(this.isSDH ? "SDH" : "SONET", this.subTabs, (TdmLineModel[])iGenericTraceLineArray, abstractDwdmLineModelArray4);
        int n2 = 6;
        if (dwdmModuleModel.isADMCard()) {
            n2 |= 1;
        }
        this.sonetTracePane = new GenericTraceProvPane("Section Trace", this.subTabs, TraceMode.SECTION, iGenericTraceLineArray, n2);
        this.monvisoTrkPane = new DwdmLinePane("Trunk", this.subTabs, abstractDwdmLineModelArray2, DwdmLinePane.PaneType.TRUNK);
        AbstractDwdmLineModel[] abstractDwdmLineModelArray5 = ((EntityModel)this.getUiModel()).getDescendantsOfEqType(279).isEmpty() ? abstractDwdmLineModelArray : abstractDwdmLineModelArray3;
        this.comboPane = new DwdmLinePane("Client", this.subTabs, abstractDwdmLineModelArray5, DwdmLinePane.PaneType.COMBO);
        this.pluggablePortsPane = new DwdmLinePane("Ports", this.subTabs, abstractDwdmLineModelArray3, DwdmLinePane.PaneType.PLUGGABLES);
        if (dwdmModuleModel.getEqType() == 293) {
            if (abstractDwdmLineModelArray3.length > 0) {
                this.setupTabs(dwdmModuleModel.getDwdmLineModels(), (DwdmTrkLineModel[])abstractDwdmLineModelArray2, abstractDwdmLineModelArray4, (TdmLineModel[])iGenericTraceLineArray, fcmrLineModelArray);
            } else {
                NAProtectPane nAProtectPane = NAProtectPane.createPane(this.getParentView(), true);
                nAProtectPane.setText("", "");
                this.subTabs.add((Component)((Object)nAProtectPane));
            }
        } else {
            this.setupTabs(dwdmModuleModel.getDwdmLineModels(), (DwdmTrkLineModel[])abstractDwdmLineModelArray2, abstractDwdmLineModelArray4, (TdmLineModel[])iGenericTraceLineArray, fcmrLineModelArray);
        }
    }

    protected void refreshMyLines(Object object) {
        if (!(object instanceof DwdmLineUpdate)) {
            return;
        }
        DwdmLineUpdate dwdmLineUpdate = (DwdmLineUpdate)object;
        this.currentPane = (AbstractPane)((Object)this.subTabs.getSelectedComponent());
        this.setupTabs(dwdmLineUpdate.getDwdmLineModels(), dwdmLineUpdate.getDwdmTrkLineModels(), dwdmLineUpdate.getTdmDwdmLineModels(), dwdmLineUpdate.getTdmLineModels(), FcmrLineModel.filterUndefinedMedia(dwdmLineUpdate.getFcmrLineModels()));
        if (this.showing && this.currentPane != null) {
            try {
                this.subTabs.setSelectedComponent((Component)((Object)this.currentPane));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.subTabs.setSelectedIndex(0);
            }
            try {
                this.currentPane.setShowing(true);
                this.repaint();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
            if (this.currentPane.getTable() != null) {
                TablePropertyMgr.getColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
            }
        }
    }

    private void setupTabs(AbstractDwdmLineModel[] abstractDwdmLineModelArray, DwdmTrkLineModel[] dwdmTrkLineModelArray, AbstractDwdmLineModel[] abstractDwdmLineModelArray2, TdmLineModel[] tdmLineModelArray, FcmrLineModel[] fcmrLineModelArray) {
        block25: {
            try {
                this.subTabs.removeAll();
                boolean bl = true;
                DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.getUiModel();
                if (dwdmModuleModel.isADMCard()) {
                    this.subTabs.addTab("Ports", (Component)((Object)this.pluggablePortsPane));
                    if (dwdmModuleModel.get1GEthLines(abstractDwdmLineModelArray).length > 0) {
                        this.subTabs.addTab("Ethernet", (Component)((Object)this.dwdmLinePane));
                    }
                } else if (dwdmModuleModel.getEqType() == 293 || this.isPolluce) {
                    this.subTabs.addTab("Ports", (Component)((Object)this.pluggablePortsPane));
                    if (this.isPolluce && dwdmModuleModel.getEthGELines(abstractDwdmLineModelArray).length > 0) {
                        this.subTabs.addTab("Ethernet", (Component)((Object)this.dwdmLinePane));
                    } else if (dwdmModuleModel.get10GELines(abstractDwdmLineModelArray).length > 0) {
                        this.subTabs.addTab("Ethernet", (Component)((Object)this.dwdmLinePane));
                    }
                } else {
                    int n;
                    int n2 = abstractDwdmLineModelArray[0].getFramingType();
                    if (n2 != (n = dwdmTrkLineModelArray[0].getFramingType()) && n2 != 4) {
                        this.subTabs.addTab("Client", (Component)((Object)this.comboPane));
                        if (fcmrLineModelArray != null && fcmrLineModelArray.length > 0) {
                            this.subTabs.addTab("Distance Extension", (Component)((Object)this.fcDistExtPane));
                            if (dwdmModuleModel.supportsDEParams()) {
                                this.subTabs.addTab("Enhanced FC/FICON ISL", (Component)((Object)this.fcPortEnhPane));
                            }
                        }
                    } else {
                        EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
                        String string = EntityCellRenderer.getPayloadTypeStr(abstractDwdmLineModelArray[0]);
                        bl = false;
                        switch (n2) {
                            case 0: 
                            case 1: {
                                bl = true;
                                if (!this.isMonvisoMxp) break;
                                this.subTabs.addTab("Trunk", (Component)((Object)this.monvisoTrkPane));
                                break;
                            }
                            case 2: 
                            case 6: {
                                this.subTabs.addTab("Ethernet", (Component)((Object)this.dwdmLinePane));
                                break;
                            }
                            case 3: 
                            case 5: {
                                this.subTabs.addTab(string, (Component)((Object)this.dwdmLinePane));
                                break;
                            }
                            case 4: {
                                this.subTabs.addTab(string, (Component)((Object)this.comboPane));
                                break;
                            }
                            default: {
                                db.println("Unknown payload type " + n2);
                            }
                        }
                    }
                }
                if (bl && tdmLineModelArray != null && tdmLineModelArray.length > 0) {
                    this.subTabs.addTab(this.isSDH ? "SDH" : "SONET", (Component)((Object)this.sonetLinePane));
                    this.sonetTracePane.refreshMyLines(tdmLineModelArray);
                    this.sonetTracePane.refreshFromModel();
                    this.subTabs.addTab("Section Trace", (Component)((Object)this.sonetTracePane));
                }
                if (!dwdmModuleModel.isADMCard()) {
                    this.subTabs.addTab("Wavelength Trunk Settings", (Component)((Object)this.trkPane));
                    if (dwdmModuleModel.supportsMLSEModule()) {
                        this.subTabs.addTab("Error Decorrelator Settings", (Component)((Object)this.mlsePane));
                    }
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                db.println("Exception in setupTabs");
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                db.println("Exception in setupTabs");
                if (!db.on()) break block25;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
    }
}

