/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.dwdm.DwdmSonetLineTableModel;
import cerent.cms.ui.sonet.TdmLineProvPane;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.Observable;

public class DwdmSonetLineProvPane
extends TdmLineProvPane {
    private static final SDebug db = new SDebug("DwdmSonetLineProvPane");
    private AbstractDwdmLineModel[] dwdmLineModels;

    public DwdmSonetLineProvPane(String string, TabbedView tabbedView, TdmLineModel[] tdmLineModelArray, AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        super(string, tabbedView, tdmLineModelArray, new DwdmSonetLineTableModel((NodeModelDelegate)tabbedView.getUiModel().getNodeModel(), tdmLineModelArray, abstractDwdmLineModelArray));
        this.dwdmLineModels = abstractDwdmLineModelArray;
        this.getObsMgr().addObservable((Observable[])abstractDwdmLineModelArray);
    }

    protected void prepareColumns() {
        super.prepareColumns();
        this.removeColumn(14);
        this.removeColumn(2);
        this.removeColumn(12);
        DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.getUiModel();
        if (!dwdmModuleModel.supportTiming()) {
            this.removeColumn(9);
            this.removeColumn(10);
            this.removeColumn(13);
        }
        if (dwdmModuleModel.isADMCard() || dwdmModuleModel.getEqType() == 293 || dwdmModuleModel.getEqType() == 300 || dwdmModuleModel.getEqType() == 301) {
            this.removeColumn(1);
            this.removeColumn(3);
            this.removeColumn(4);
            this.removeColumn(17);
            this.removeColumn(20);
            if (dwdmModuleModel.getEqType() == 293) {
                this.removeColumn(11);
            }
        } else {
            this.removeColumn(11);
        }
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.DwdmSonetPayloadLineProvPane;
    }

    protected String getSplitterString() {
        String string = "";
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < this.dwdmLineModels.length; ++i) {
            if (!(this.dwdmLineModels[i] instanceof DwdmTrkLineModel)) continue;
            DwdmTrkLineModel dwdmTrkLineModel = (DwdmTrkLineModel)this.dwdmLineModels[i];
            if (dwdmTrkLineModel.isSplitterProtectedLine()) {
                bl2 = true;
            }
            if (!this.dataModel.isAdminStateDirty(i)) continue;
            bl = true;
        }
        if (bl && bl2) {
            string = "\nSafety Warning: The laser will not be turned off.\nPlease shutter the port.\n";
        }
        return string;
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof DwdmLineUpdate) {
            if (db.on()) {
                db.println("in refreshMyLines, processing " + object);
            }
            DwdmLineUpdate dwdmLineUpdate = (DwdmLineUpdate)object;
            this.getObsMgr().removeObservable((Observable[])this.dwdmLineModels);
            this.dwdmLineModels = dwdmLineUpdate.getTdmDwdmLineModels();
            ((DwdmSonetLineTableModel)this.dataModel).setLineModels(this.dwdmLineModels);
            this.setLineModels(dwdmLineUpdate.getTdmLineModels());
            this.getObsMgr().addObservable((Observable[])this.dwdmLineModels);
        }
    }

    protected boolean isReachAndWave() {
        boolean bl = true;
        switch (this.getEqpmtModel().getEqType()) {
            case 183: 
            case 184: 
            case 243: 
            case 282: {
                bl = false;
                break;
            }
            case 118: {
                bl = false;
                break;
            }
            case 273: {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    protected void refreshLine(Observable object) {
        int n = Arrays.asList(this.dwdmLineModels).indexOf(object);
        if (n != -1 && n < this.lineModels.length) {
            object = this.lineModels[n];
        }
        super.refreshLine((Observable)object);
    }
}

