/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.nedefaults.DefaultsManager;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractValidatingTableModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.Frame;

public abstract class DwdmTableModel
extends AbstractValidatingTableModel {
    protected AbstractDwdmLineModel[] model;
    protected int numLines;
    protected EntityCellRenderer myPortRenderer;
    protected String[] portNames;
    protected DwdmModuleModel eqpmtModel;
    private DefaultsManager validationManager;
    private final SDebug db;

    protected DwdmTableModel(SDebug sDebug, AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        super(abstractDwdmLineModelArray.length > 0 ? abstractDwdmLineModelArray[0].getNodeModelDelegate() : null, sDebug);
        this.db = sDebug;
        this.model = abstractDwdmLineModelArray;
        this.numLines = abstractDwdmLineModelArray.length;
        if (abstractDwdmLineModelArray.length > 0) {
            try {
                this.eqpmtModel = (DwdmModuleModel)abstractDwdmLineModelArray[0].getModuleModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                // empty catch block
            }
        }
        this.myPortRenderer = new EntityCellRenderer(false);
        this.portNames = new String[this.numLines];
        this.validationManager = null;
    }

    public void refreshMyLines(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        this.model = abstractDwdmLineModelArray;
        this.numLines = this.model.length;
        this.portNames = new String[this.numLines];
        if (this.eqpmtModel == null && abstractDwdmLineModelArray.length > 0) {
            try {
                this.eqpmtModel = (DwdmModuleModel)this.model[0].getModuleModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                // empty catch block
            }
        }
    }

    public int getNumberOfLines() {
        return this.model.length;
    }

    public boolean resetToDefaultByLine() {
        return false;
    }

    protected Frame getFrame() {
        return this.eqpmtModel.getNodeModel().getUiToolkit().getApplicationFrame();
    }

    protected String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException {
        if (n >= 0 && n < this.model.length) {
            IPortModel iPortModel = this.model[n].getPortModel();
            InterfaceModel interfaceModel = this.model[n].getPayloadModel();
            if (interfaceModel != null) {
                InterfaceModel interfaceModel2 = interfaceModel.getFirstLowerLayerModels();
                if (interfaceModel2 instanceof DwdmTrkLineModel) {
                    DwdmTrkLineModel dwdmTrkLineModel = (DwdmTrkLineModel)interfaceModel2;
                    iPortModel = dwdmTrkLineModel.getPortModel();
                } else {
                    iPortModel = interfaceModel.getPortModel();
                }
                if (this.eqpmtModel.getEqType() == 293 || this.eqpmtModel.getEqType() == 300 || this.eqpmtModel.getEqType() == 301) {
                    iPortModel = interfaceModel.getPortModel();
                }
            }
            return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
        }
        return "!ERROR!";
    }

    protected Attribute getAttributeFor(String string, int n) {
        return ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeForVal(string, n);
    }

    protected String getPortName(int n) {
        if (n >= 0 && n < this.portNames.length) {
            if (this.portNames[n] == null) {
                try {
                    this.portNames[n] = this.model[n].getAlias();
                }
                catch (NoSuchInterface noSuchInterface) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
            return this.portNames[n];
        }
        return "!ERROR!";
    }

    public boolean isCellEditable(int n, int n2) {
        boolean bl;
        if (n < this.numLines && this.model != null && this.numLines > 0 && (bl = AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.MAINTENANCE))) {
            return n2 > 0;
        }
        return false;
    }

    public void validate(String string, String string2) throws ProvisionError {
        if (this.validationManager == null) {
            NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.eqpmtModel.getNodeModel();
            this.validationManager = DefaultsManager.getInstance(nodeModelDelegate);
        }
        this.validationManager.validate(this.eqpmtModel.getEqTypeEnum(), string, string2);
    }

    protected void presentProvisionError(String string, ProvisionError provisionError) {
        ErrorMsg.displayDetailed((Component)this.getFrame(), EMC.EID_INVALID_COLUMN_NAME_PARAM_1, string, provisionError.getMessage());
    }

    public static boolean isProtectedTrunkPort(AbstractDwdmLineModel abstractDwdmLineModel) {
        return abstractDwdmLineModel instanceof DwdmTrkLineModel && abstractDwdmLineModel.isProtectLine();
    }

    protected boolean isProtectedTrunkPort(int n) {
        DwdmTrkLineModel dwdmTrkLineModel;
        return this.model[n] != null && this.model[n] instanceof DwdmTrkLineModel && (dwdmTrkLineModel = (DwdmTrkLineModel)this.model[n]).isProtectLine();
    }
}

