/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.dwdm.DwdmTableModel;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import java.awt.Component;

public class DwdmTrkMlseTableModel
extends DwdmTableModel {
    private static final SDebug db = new SDebug("DwdmTrkMlseTableModel");
    private Attribute[] mlseValues;
    public static final int FIRST_ROW_INDEX = 0;
    private static final int MIN_NUM_LINES = 0;
    private static final int MIN_NUM_COL = 0;
    public static final int LINENUMBER_INDEX = 0;
    public static final int MLSE_MODULE_INDEX = 1;
    public static final int NEXT_COLUMN_INDEX = 2;
    protected String[] columnNames = new String[]{"Port", "Error Decorrelator"};
    protected boolean[][] isDirty;

    public DwdmTrkMlseTableModel(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        super(db, abstractDwdmLineModelArray);
        this.mlseValues = new Attribute[this.numLines];
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.refreshMyLines(abstractDwdmLineModelArray);
    }

    public void refreshMyLines(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        super.refreshMyLines(abstractDwdmLineModelArray);
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public Class getColumnClass(int n) {
        return Object.class;
    }

    public boolean isCellEditable(int n, int n2) {
        return this.model != null && this.numLines > 0 && AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING) && !this.isProtectedTrunkPort(n) && n2 == 1;
    }

    private boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    public boolean isRowDirty(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.isDirty(n, i)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isRowDirty(i)) continue;
            return true;
        }
        return false;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortDescriptionFor(n);
                }
                case 1: {
                    return this.getMlseValue(n);
                }
            }
            return "";
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("DwdmTrkMlseTableModel: error in getValueAt" + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        if (db.on()) {
            db.println("Change in value row=" + n + " col=" + n2 + " newVal=" + object);
        }
        try {
            switch (n2) {
                case 1: {
                    Attribute attribute;
                    this.mlseValues[n] = attribute = (Attribute)object;
                    this.isDirty[n][n2] = true;
                    this.fireTableCellUpdated(n, n2);
                }
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return;
        }
    }

    private Attribute getMlseValue(int n) {
        if (this.mlseValues[n] == null) {
            DwdmTrkLineModel dwdmTrkLineModel = (DwdmTrkLineModel)this.model[n];
            try {
                this.mlseValues[n] = this.getAttributeFor("G%7%0%9OTN", dwdmTrkLineModel.isMlseEnabled() ? 1 : 0);
            }
            catch (NoSuchInterface noSuchInterface) {
                db.println("Caught NoSuchInterface in getWL");
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                db.println("Caught WrongInterfaceType in getWL");
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
            catch (EMCProvisionError eMCProvisionError) {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)eMCProvisionError.getEID());
            }
        }
        return this.mlseValues[n];
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.refreshLineFromModel(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void refreshLineFromModel(int n) {
        block4: {
            if (n > this.numLines || n < 0) {
                if (db.on()) {
                    db.println("Invalid lineNo for refresh " + n);
                }
                return;
            }
            this.resetLineCache(n);
            try {
                this.mlseValues[n] = this.getMlseValue(n);
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                db.println("DwdmTrkMlseTableModel: error in refreshLineFromModel, line: " + n + "\n" + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.fireTableRowsUpdated(n, n);
    }

    protected void resetLineCache(int n) {
        this.mlseValues[n] = null;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    public void applyToModel() throws Exception {
        int n = 0;
        for (n = 0; n < this.numLines; ++n) {
            if (!this.isDirty(n, 1)) continue;
            boolean bl = this.getMlseValue(n).getIntValue() != 0;
            try {
                ((DwdmTrkLineModel)this.model[n]).enableMlse(bl);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (db.on()) {
                    db.println("WrongInterfaceType Exception " + n);
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                if (db.on()) {
                    db.println("NoSuchInterface Exception " + n);
                }
            }
            catch (EMCProvisionError eMCProvisionError) {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)eMCProvisionError.getEID());
            }
            this.isDirty[n][1] = false;
        }
    }
}

