/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.IGenericTraceLine;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OTU2XpModuleModel;
import cerent.cms.model.TdmHoModel;
import cerent.cms.model.TraceMode;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.dwdm.NAProtectPane;
import cerent.cms.ui.dwdm.OTU2HoSonetTableModel;
import cerent.cms.ui.dwdm.OTU2xpPathPane;
import cerent.cms.ui.trace.GenericTraceProvPane;
import cerent.util.SDebug;
import java.awt.Component;

public class OTU2xpPathProvPane
extends AbstractSubTabbedPane
implements ITabName {
    boolean isSDH;
    OTU2XpModuleModel otu2xpModel;
    NAProtectPane notApplTab;
    OTU2xpPathPane otu2xpPathPane;
    GenericTraceProvPane j1ProvPane;
    TabbedView parent;
    SDebug db = new SDebug("OTU2xpPathProvPane");

    public OTU2xpPathProvPane(String string, TabbedView tabbedView, DwdmModuleModel dwdmModuleModel) {
        super(string, tabbedView);
        this.otu2xpModel = (OTU2XpModuleModel)dwdmModuleModel;
        this.isSDH = dwdmModuleModel.getNodeModel().getTdmProtocolTypeObj().isSdh();
        this.notApplTab = NAProtectPane.createPane(this.getParentView(), true);
        this.notApplTab.setText("", "");
        this.parent = tabbedView;
    }

    protected void createSubTabs() {
        int n;
        block6: {
            n = 0;
            try {
                n = this.otu2xpModel.getCardMode();
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!this.db.on()) break block6;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        if (n == 4 || n == 6) {
            IGenericTraceLine[] iGenericTraceLineArray = this.otu2xpModel.getHO();
            this.otu2xpPathPane = new OTU2xpPathPane(this.isSDH ? "SDH" : "SONET", this.subTabs, (TdmHoModel[])iGenericTraceLineArray, new OTU2HoSonetTableModel(this.otu2xpModel.getNodeModel(), (TdmHoModel[])iGenericTraceLineArray));
            this.subTabs.add((Component)((Object)this.otu2xpPathPane));
            this.j1ProvPane = new GenericTraceProvPane("J1 Path Trace", this.getParentView(), TraceMode.PATH, iGenericTraceLineArray, 2);
            this.subTabs.add((Component)((Object)this.j1ProvPane));
        } else {
            this.subTabs.add((Component)((Object)this.notApplTab));
        }
    }

    public void refresh() {
        int n;
        block10: {
            n = 0;
            try {
                n = this.otu2xpModel.getCardMode();
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!this.db.on()) break block10;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        if (n == 4 || n == 6) {
            this.subTabs.remove((Component)((Object)this.notApplTab));
            this.subTabs.remove((Component)((Object)this.otu2xpPathPane));
            this.subTabs.remove((Component)((Object)this.j1ProvPane));
            IGenericTraceLine[] iGenericTraceLineArray = this.otu2xpModel.getHO();
            if (this.otu2xpPathPane != null) {
                this.otu2xpPathPane.refreshFromModel();
            } else {
                this.otu2xpPathPane = new OTU2xpPathPane(this.isSDH ? "SDH" : "SONET", this.subTabs, (TdmHoModel[])iGenericTraceLineArray, new OTU2HoSonetTableModel(this.otu2xpModel.getNodeModel(), (TdmHoModel[])iGenericTraceLineArray));
            }
            if (this.j1ProvPane != null) {
                this.j1ProvPane.refreshFromModel();
            } else {
                this.j1ProvPane = new GenericTraceProvPane("J1 Path Trace", this.getParentView(), TraceMode.PATH, iGenericTraceLineArray, 2);
            }
            this.subTabs.add((Component)((Object)this.otu2xpPathPane));
            this.subTabs.add((Component)((Object)this.j1ProvPane));
        } else {
            this.subTabs.remove((Component)((Object)this.otu2xpPathPane));
            this.subTabs.remove((Component)((Object)this.j1ProvPane));
            this.subTabs.add((Component)((Object)this.notApplTab));
        }
    }

    public void enteringPage() throws Exception {
        this.refresh();
    }
}

