/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Dwdm.eDwdmLineType;
import cerent.cms.idl.Dwdm.sLaserThresholds;
import cerent.cms.idl.Dwdm.sValThresholds;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DwdmCliLineModel;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmPayloadLineModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.IOpticsProvExtModel;
import cerent.cms.model.ISupportsOpticsProvExtModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.nedefaults.NeDefaultsModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.ResettablePmThresholdsTableModel;
import cerent.cms.ui.dwdm.DwdmTableModel;
import cerent.util.KDebug;
import cerent.util.SDebug;

public class OpticalThresholdTableModel
extends DwdmTableModel
implements ResettablePmThresholdsTableModel {
    private static final int POWER_OFFSET = 400;
    public static final String UNAVAILABLE = "N/A";
    public static final float[] scaleFactor = new float[]{1.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f};
    private static final int[] LOWER_BOUND = new int[]{0, 0, 0, 0, 0, 0};
    private static final int[] UPPER_BOUND = new int[]{0, 1000, 700, 700, 700, 700};
    public static final String[] columnNames = new String[]{"Port", "Laser Bias High (%)", "RX Power High (dBm)", "RX Power Low (dBm)", "TX Power High (dBm)", "TX Power Low (dBm)"};
    public static final int LINENUMBER_INDEX = 0;
    public static final int LBIAS_HIGH_INDEX = 1;
    public static final int RXP_HIGH_INDEX = 2;
    public static final int RXP_LOW_INDEX = 3;
    public static final int TXP_HIGH_INDEX = 4;
    public static final int TXP_LOW_INDEX = 5;
    protected int thresholdLayer;
    protected sLaserThresholds[] thresholdsVal;
    protected boolean[] rowDirty = null;
    private static final SDebug db = new SDebug("OpticalThresholdTableModel");

    public OpticalThresholdTableModel(AbstractDwdmLineModel[] abstractDwdmLineModelArray, int n) {
        super(db, abstractDwdmLineModelArray);
        this.thresholdLayer = n;
        this.refreshMyLines(abstractDwdmLineModelArray);
    }

    public void markRowDirty(int n) {
        this.rowDirty[n] = true;
    }

    public boolean resetToDefaultByLine() {
        return true;
    }

    public Object getThresholdNeDefault(NeDefaultsModel neDefaultsModel, int n) throws Exception {
        sLaserThresholds sLaserThresholds2 = null;
        AbstractDwdmLineModel abstractDwdmLineModel = this.model[n];
        eDwdmLineType eDwdmLineType2 = abstractDwdmLineModel.getLineType();
        eIntervalType eIntervalType2 = null;
        switch (this.thresholdLayer) {
            case 0: {
                eIntervalType2 = eIntervalType.INTERVAL_15_MIN;
                break;
            }
            case 1: {
                eIntervalType2 = eIntervalType.INTERVAL_DAY;
                break;
            }
            case 2: {
                eIntervalType2 = eIntervalType.INTERVAL_VARIABLE;
                break;
            }
            default: {
                throw new Exception("OpticalThresholdTableModel.getThresholdNeDefault: Bad thresholdLayer = " + this.thresholdLayer);
            }
        }
        sLaserThresholds2 = abstractDwdmLineModel.getDefaultOpticsThresholds(eIntervalType2, neDefaultsModel);
        if (db.isInfoEnabled() && sLaserThresholds2 != null) {
            db.info("getThresholdNeDefault: Retrieved Thresholds:");
            sLaserThresholds sLaserThresholds3 = sLaserThresholds2;
            db.info("\n\t laserBias.high = " + sLaserThresholds3.laserBias.high + "\n\t txPower.high = " + sLaserThresholds3.txPower.high + "\n\t txPower.low = " + sLaserThresholds3.txPower.low + "\n\t rxPower.high = " + sLaserThresholds3.rxPower.high + "\n\t rxPower.low = " + sLaserThresholds3.rxPower.low);
        }
        return sLaserThresholds2;
    }

    public void setThresholdValue(int n, Object object) {
        if (object instanceof sLaserThresholds) {
            this.thresholdsVal[n] = (sLaserThresholds)object;
        }
    }

    public void refreshMyLines(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        super.refreshMyLines(abstractDwdmLineModelArray);
        this.rowDirty = new boolean[this.numLines];
        this.thresholdsVal = new sLaserThresholds[this.numLines];
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return Float.class;
            }
        }
        return Object.class;
    }

    public boolean supportLaserBias(int n, int n2) {
        if (n2 == 1) {
            return this.model[n].supportsLaserBias();
        }
        return true;
    }

    public boolean supportTxPower(int n, int n2) {
        if (n2 == 4 || n2 == 5) {
            return this.model[n].supportsTxPower();
        }
        return true;
    }

    public boolean supportOpticsMon(int n, int n2) {
        return this.model[n].supportOpticsMon();
    }

    protected String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException {
        String string = "";
        AbstractDwdmLineModel abstractDwdmLineModel = this.model[n];
        if (abstractDwdmLineModel instanceof DwdmCliLineModel) {
            InterfaceModel interfaceModel = ((DwdmCliLineModel)abstractDwdmLineModel).getPayloadModel();
            if (interfaceModel instanceof ISupportsOpticsProvExtModel) {
                IOpticsProvExtModel iOpticsProvExtModel = ((ISupportsOpticsProvExtModel)((Object)interfaceModel)).getOpticsProvExtModel();
                try {
                    string = string + " " + this.getAttributeFor("declDwdmReach", iOpticsProvExtModel.getLineReach().value()) + " Reach";
                }
                catch (Exception exception) {
                    db.severe(exception.toString());
                }
            }
        } else if (abstractDwdmLineModel instanceof DwdmTrkLineModel) {
            if (((DwdmModuleModel)abstractDwdmLineModel.getModuleModel()).supportsOTN() && !this.has2RDwdmCliLineModels()) {
                try {
                    string = string + " " + this.getAttributeFor("EFec", ((DwdmTrkLineModel)abstractDwdmLineModel).getFECMode().value()) + " FEC";
                }
                catch (Exception exception) {
                    db.severe(exception.toString());
                }
            } else {
                string = string + " G.709 OTN not supported";
            }
        }
        return super.getPortDescriptionFor(n) + string;
    }

    private boolean has2RDwdmCliLineModels() {
        boolean bl = false;
        for (int i = 0; i < this.model.length; ++i) {
            if (!(this.model[i] instanceof DwdmCliLineModel) || !(((DwdmCliLineModel)this.model[i]).getPayloadModel() instanceof DwdmPayloadLineModel)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.model != null && this.numLines > 0) {
            try {
                if (AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING) && !this.model[0].getModuleModel().isProtectModule() && this.supportLaserBias(n, n2) && this.supportTxPower(n, n2) && this.supportOpticsMon(n, n2)) {
                    Object object = this.getValueAt(n, n2);
                    if (object != null && object instanceof String && ((String)object).equals(UNAVAILABLE)) {
                        return false;
                    }
                    return n2 > 0;
                }
                return false;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (db.on()) {
                    db.println("no such entity in isCellEditable");
                }
                KDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                return false;
            }
        }
        return false;
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.rowDirty[i]) continue;
            return true;
        }
        return false;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        if (n2 >= 1 && n2 <= 5 && !this.isThresholdSupported(n)) {
            return UNAVAILABLE;
        }
        try {
            int n3 = 0;
            switch (n2) {
                case 0: {
                    return this.getPortDescriptionFor(n);
                }
                case 1: {
                    n3 = this.getThreshold((int)n).laserBias.high;
                    break;
                }
                case 2: {
                    n3 = this.getThreshold((int)n).rxPower.high - 400;
                    if (n3 != -401) break;
                    return UNAVAILABLE;
                }
                case 3: {
                    n3 = this.getThreshold((int)n).rxPower.low - 400;
                    if (n3 != -401) break;
                    return UNAVAILABLE;
                }
                case 4: {
                    n3 = this.getThreshold((int)n).txPower.high - 400;
                    break;
                }
                case 5: {
                    n3 = this.getThreshold((int)n).txPower.low - 400;
                    break;
                }
                default: {
                    return null;
                }
            }
            return new Float((float)n3 / scaleFactor[n2]);
        }
        catch (UnsupportedOperation unsupportedOperation) {
            return UNAVAILABLE;
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("OpticalThresholdTableModel: error in getValueAt" + exception);
                KDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        db.info("Change in value " + n + " " + n2);
        boolean bl = true;
        sValThresholds sValThresholds2 = null;
        int n3 = 0;
        try {
            switch (n2) {
                case 1: {
                    bl = false;
                    sValThresholds2 = this.getThreshold((int)n).laserBias;
                    break;
                }
                case 2: {
                    bl = false;
                }
                case 3: {
                    n3 = 400;
                    sValThresholds2 = this.getThreshold((int)n).rxPower;
                    break;
                }
                case 4: {
                    bl = false;
                }
                case 5: {
                    n3 = 400;
                    sValThresholds2 = this.getThreshold((int)n).txPower;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            if (db.on()) {
                db.println("Fail to getThreshold" + (Object)((Object)noSuchInterface));
                KDebug.printStackTrace((Throwable)noSuchInterface);
            }
            return;
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            if (db.on()) {
                db.println("Fail to getThreshold" + (Object)((Object)wrongInterfaceType));
                KDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
            return;
        }
        catch (UnsupportedOperation unsupportedOperation) {
            if (db.on()) {
                db.println("Fail to getThreshold" + (Object)((Object)unsupportedOperation));
                KDebug.printStackTrace((Throwable)unsupportedOperation);
            }
            return;
        }
        int n4 = sValThresholds2.low;
        int n5 = sValThresholds2.high;
        if (bl) {
            n4 = LOWER_BOUND[n2];
        } else {
            n5 = UPPER_BOUND[n2];
        }
        ProvisionError provisionError = new ProvisionError("value " + object + " out of range [" + (float)(n4 - n3) / scaleFactor[n2] + ".." + (float)(n5 - n3) / scaleFactor[n2] + "]");
        try {
            if (!(object instanceof Float)) {
                db.info("Value is not type of Float");
                return;
            }
            Float f = (Float)object;
            int n6 = Math.round(f.floatValue() * scaleFactor[n2]) + n3;
            if (n6 < n4 || n6 > n5) {
                throw provisionError;
            }
            if (bl) {
                if (sValThresholds2.low == n6) {
                    return;
                }
                sValThresholds2.low = n6;
            } else {
                if (sValThresholds2.high == n6) {
                    return;
                }
                sValThresholds2.high = n6;
            }
            this.rowDirty[n] = true;
            this.fireTableCellUpdated(n, n2);
        }
        catch (ProvisionError provisionError2) {
            this.presentProvisionError(this.getColumnName(n2), provisionError2);
        }
        catch (NumberFormatException numberFormatException) {
            this.presentProvisionError(this.getColumnName(n2), provisionError);
        }
    }

    public void refreshFromModel() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            this.portNames[i] = null;
            this.thresholdsVal[i] = null;
            this.rowDirty[i] = false;
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void refreshLineFromModel(int n) throws Exception {
        this.portNames[n] = null;
        this.thresholdsVal[n] = null;
        this.rowDirty[n] = false;
        this.fireTableRowsUpdated(n, n);
    }

    public void applyToModel() throws NoSuchInterface, WrongInterfaceType, ConfigError, UnsupportedOperation {
        if (db.on()) {
            db.println("applyToModel");
        }
        for (int i = 0; i < this.numLines; ++i) {
            try {
                if (!this.rowDirty[i]) continue;
                switch (this.thresholdLayer) {
                    case 0: {
                        this.model[i].setOpticsTCAThresholds(this.getThreshold(i), eIntervalType.INTERVAL_15_MIN);
                        break;
                    }
                    case 1: {
                        this.model[i].setOpticsTCAThresholds(this.getThreshold(i), eIntervalType.INTERVAL_DAY);
                        break;
                    }
                    case 2: {
                        this.model[i].setOpticsAlmThresholds(this.getThreshold(i));
                    }
                }
                this.rowDirty[i] = false;
                continue;
            }
            catch (Exception exception) {
                this.rowDirty[i] = false;
                this.thresholdsVal[i] = null;
                this.fireTableRowsUpdated(i, i);
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public sLaserThresholds getThreshold(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        if (this.thresholdsVal[n] == null) {
            switch (this.thresholdLayer) {
                case 0: {
                    this.thresholdsVal[n] = this.model[n].getOpticsTCAThresholds(eIntervalType.INTERVAL_15_MIN);
                    break;
                }
                case 1: {
                    this.thresholdsVal[n] = this.model[n].getOpticsTCAThresholds(eIntervalType.INTERVAL_DAY);
                    break;
                }
                case 2: {
                    this.thresholdsVal[n] = this.model[n].getOpticsAlmThresholds();
                }
            }
        }
        return this.thresholdsVal[n];
    }

    private boolean isThresholdSupported(int n) {
        try {
            ModuleModel moduleModel = this.model[n].getModuleModel();
            return moduleModel.getEqType() != 121 && moduleModel.getEqType() != 120 || this.model[n].getDataRate() != 12 && this.model[n].getDataRate() != 20 || this.model[n].getLineType() != eDwdmLineType.DWDM_CLIENT;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

