/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.idl.Dwdm.sOpticsCurrentValues;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IOpticsPmModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.PmRendererOpticStat;
import cerent.cms.ui.dwdm.OpticsPmTableModel;
import cerent.util.SDebug;
import cerent.util.gui.IFixedColumnsTableModel;

public class OpticsPmStatTableModel
extends OpticsPmTableModel
implements IFixedColumnsTableModel {
    private static final int FIXED_COLUMNS = 1;
    private static final int PARM_INDEX = 0;
    private static final String[] PARM_NAMES = new String[]{"Laser Bias (%)", "RX Optical Pwr (dBm)", "TX Optical Pwr (dBm)"};
    private static final int LASER_BIAS_INDEX = 0;
    private static final int RX_POWER_INDEX = 1;
    private static final int TX_POWER_INDEX = 2;
    private static final int TX_POWER_START = 2;
    protected IOpticsPmModel[] opticsModels;
    protected sOpticsCurrentValues[] lineStats;
    protected int numLines;
    private static final int NOT_SUPPORTED = -1;
    protected static final SDebug db = new SDebug("OpticsPmStatTableModel");

    public OpticsPmStatTableModel(IOpticsPmModel[] iOpticsPmModelArray, NodeModelDelegate nodeModelDelegate) {
        this.opticsModels = iOpticsPmModelArray;
        this.numLines = iOpticsPmModelArray.length;
        this.lineStats = new sOpticsCurrentValues[this.numLines];
    }

    public void refreshMyLines(IOpticsPmModel[] iOpticsPmModelArray) {
        this.opticsModels = iOpticsPmModelArray;
        this.numLines = iOpticsPmModelArray.length;
        this.lineStats = new sOpticsCurrentValues[this.numLines];
        this.refreshData();
        this.fireTableStructureChanged();
    }

    public Class getColumnClass(int n) {
        return String.class;
    }

    public int getColumnCount() {
        return this.numLines + 1;
    }

    public String getColumnName(int n) {
        if (n < 1) {
            return "Param";
        }
        String string = "Port " + n;
        try {
            PortModel portModel = (PortModel)this.opticsModels[n - 1].getInterfaceModel().getPortModel();
            EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
            string = "Port " + entityCellRenderer.getPortString(portModel, false);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return string;
    }

    public int getRowCount() {
        return PARM_NAMES.length;
    }

    public Object getValueAt(int n, int n2) {
        db.fine("getValueAt( " + n + ", " + n2 + " )");
        if (n2 == 0) {
            return PARM_NAMES[n];
        }
        if (--n2 < this.opticsModels.length && (!this.opticsModels[n2].supportsTxPower() && n >= 2 || !this.opticsModels[n2].supportsLaserBias() && n == 0)) {
            return "N/A";
        }
        return this.getStats(n2, n);
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void setValueAt(Object object, int n, int n2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshData() {
        if (db.on()) {
            db.println("refreshData");
        }
        try {
            for (int i = 0; i < this.numLines; ++i) {
                try {
                    this.lineStats[i] = this.opticsModels[i].getOpticsCurrentValues();
                    continue;
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    this.clearData(i);
                    if (!db.on()) continue;
                    db.println("Caught WrongInterfaceType in refreshData!");
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                    continue;
                }
                catch (InternalCommError internalCommError) {
                    this.clearData(i);
                    if (!db.on()) continue;
                    db.println("Caught InternalCommError in refreshData!");
                    SDebug.printStackTrace((Throwable)internalCommError);
                    continue;
                }
                catch (NoSuchInterface noSuchInterface) {
                    this.clearData(i);
                    if (!db.on()) continue;
                    db.println("Caught NoSuchInterface in refreshData!");
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                    continue;
                }
                catch (UnsupportedOperation unsupportedOperation) {
                    this.DataNotSupported(i);
                    if (!db.on()) continue;
                    db.println("Caught UnsupportedOperation in refreshData!");
                    SDebug.printStackTrace((Throwable)unsupportedOperation);
                }
            }
        }
        catch (Exception exception) {
            this.clearAllData();
            if (db.on()) {
                db.println("Caught " + exception + " in refreshData!");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        finally {
            this.fireTableDataChanged();
        }
    }

    public int getFixedColumnCount() {
        return 1;
    }

    private Object getStats(int n, int n2) {
        if (n < this.lineStats.length && this.lineStats[n] != null) {
            switch (n2) {
                case 0: {
                    if (this.lineStats[n].laserBias == -1) {
                        return "N/A";
                    }
                    return new PmRendererOpticStat(1, this.lineStats[n].laserBias, true);
                }
                case 1: {
                    if (this.lineStats[n].rxPower == -1) {
                        return "N/A";
                    }
                    return new PmRendererOpticStat(0, this.lineStats[n].rxPower, true);
                }
                case 2: {
                    if (this.lineStats[n].txPower == -1) {
                        return "N/A";
                    }
                    return new PmRendererOpticStat(0, this.lineStats[n].txPower, true);
                }
            }
            db.println("WARNING: PmLayerDwdmOptics.getPmValue needs updating, unknown value " + n2);
        }
        return null;
    }

    private void clearAllData() {
        for (int i = 0; i < this.numLines; ++i) {
            this.clearData(i);
        }
    }

    private void clearData(int n) {
        this.lineStats[n] = this.isPreProvisioned(n) ? null : new sOpticsCurrentValues(0, 0, 0);
    }

    private void DataNotSupported(int n) {
        this.lineStats[n] = this.isPreProvisioned(n) ? null : new sOpticsCurrentValues(-1, -1, -1);
    }

    private boolean isPreProvisioned(int n) {
        try {
            return this.opticsModels[n].getInterfaceModel().getModuleModel().getState() == eEqState.NOT_PRESENT;
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            return true;
        }
    }
}

