/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.e1;

import cerent.cms.idl.Ds123Media.eSaBit;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Attribute;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds1LineModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.e1.E142LineTableModel;
import cerent.cms.ui.e1.E1LineTableModel;
import cerent.cms.ui.e13.E13LineProvPane;
import cerent.cms.ui.e13.E13LineTableModel;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.util.NoSuchElementException;
import javax.swing.DefaultCellEditor;
import javax.swing.table.TableColumn;

public class E1LineProvPane
extends E13LineProvPane {
    public static final String ENABLE_RETIMING_WARNING = "Enabling retiming on ports that have associated circuits may affect traffic.\nIs it OK to continue?";
    protected TableColumn saBitColumn = null;
    private TableColumn adminSsmColumn = null;
    private static final SDebug db = new SDebug("E1LineProvPane");

    public E1LineProvPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray) {
        super(string, tabbedView, ds123LineModelArray);
        TableColumn tableColumn = this.table.getColumn(E13LineTableModel.columnNames[11]);
        this.table.removeColumn(tableColumn);
        int n = ((ModuleModel)this.getUiModel()).getEqType();
        this.saBitColumn = this.table.getColumn(E1LineTableModel.e1ColumnNames[17]);
        this.adminSsmColumn = this.table.getColumn(E1LineTableModel.e1ColumnNames[18]);
        Object var6_6 = null;
        TableColumn tableColumn2 = null;
        if (n != 233) {
            tableColumn2 = this.table.getColumn(E1LineTableModel.e1ColumnNames[13]);
            this.table.removeColumn(tableColumn2);
        }
        if (!this.isLineTimingSupported(n)) {
            tableColumn2 = this.table.getColumn(E1LineTableModel.e1ColumnNames[14]);
            this.table.removeColumn(tableColumn2);
            tableColumn2 = this.table.getColumn(E1LineTableModel.e1ColumnNames[15]);
            this.table.removeColumn(tableColumn2);
            tableColumn2 = this.table.getColumn(E1LineTableModel.e1ColumnNames[16]);
            this.table.removeColumn(tableColumn2);
            tableColumn2 = this.table.getColumn(E1LineTableModel.e1ColumnNames[17]);
            this.table.removeColumn(tableColumn2);
            tableColumn2 = this.table.getColumn(E1LineTableModel.e1ColumnNames[18]);
            this.table.removeColumn(tableColumn2);
        }
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        Attribute[] attributeArray = null;
        try {
            attributeArray = this.getSelectableSaBitAttributes();
            this.saBitColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
        }
        catch (NoSuchElementException noSuchElementException) {
            attributeArray = null;
            this.table.removeColumn(this.saBitColumn);
        }
        try {
            attributeArray = this.getSelectableSSMAttributes();
            this.adminSsmColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
        }
        catch (NoSuchElementException noSuchElementException) {
            this.table.removeColumn(this.adminSsmColumn);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            this.table.removeColumn(this.adminSsmColumn);
        }
    }

    protected Attribute[] getSelectableSaBitAttributes() {
        return this.getAttributeMap().getAttributeArray("fullSetTimingBitsSabit");
    }

    protected Attribute[] getSelectableSSMAttributes() throws AbstractCmsNoSuchEntityException {
        return this.getAttributeMap().getAttributeArray("timingSdhSsmQuality");
    }

    protected E13LineTableModel getDataModel(Ds123LineModel[] ds123LineModelArray) {
        if (this.isHdE1(ds123LineModelArray)) {
            return new E142LineTableModel(this.node, ds123LineModelArray);
        }
        return new E1LineTableModel(this.node, ds123LineModelArray);
    }

    protected boolean isHdE1(Ds123LineModel[] ds123LineModelArray) {
        int n;
        try {
            n = ds123LineModelArray[0].getModuleModel().getEqType();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            return false;
        }
        return n == 108 || n == 109;
    }

    protected boolean isLineTimingSupported(int n) {
        return n == 233 || n == 234;
    }

    protected Attribute[] getAttributeArray(Class clazz) {
        return ElementDefaults.getAttributeMap((IModel)this.node).getAttributeArray("E1N_LINE_CARD." + clazz.getName());
    }

    protected Attribute[] getAttributeArray(String string) {
        return ElementDefaults.getAttributeMap((IModel)this.node).getAttributeArray("E1N_LINE_CARD." + string);
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.E1LineProvPane;
    }

    protected void applyToLine(int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = this.dataModel.isDirty(n, 15) && !((E1LineTableModel)this.dataModel).getSyncConfig((int)n).syncMessageIn;
        if (bl) {
            this.handleSyncConfig(n);
            super.applyToLine(n);
        } else {
            super.applyToLine(n);
            this.handleSyncConfig(n);
        }
        if (this.dataModel.isDirty(n, 13)) {
            boolean bl3 = ((E1LineTableModel)this.dataModel).getRetimingEnabled(n);
            int n2 = ((Ds1LineModel)this.lineModels[n]).getConnectionsList().size();
            if (bl3 && n2 > 0) {
                if (CerentDialog.yesNoDialog((Component)((Object)this), (String)ENABLE_RETIMING_WARNING, (String)"Confirm Enable Retiming")) {
                    ((Ds1LineModel)this.lineModels[n]).setDs1RetimingEnabled(((E1LineTableModel)this.dataModel).getRetimingEnabled(n));
                }
            } else {
                ((Ds1LineModel)this.lineModels[n]).setDs1RetimingEnabled(((E1LineTableModel)this.dataModel).getRetimingEnabled(n));
            }
        }
        if (this.dataModel.isDirty(n, 17)) {
            ((Ds1LineModel)this.lineModels[n]).setE1SaBit(eSaBit.from_int(((E1LineTableModel)this.dataModel).getE1SaBit(n).getValue()));
        }
    }

    private void handleSyncConfig(int n) throws Exception {
        if (this.dataModel.isDirty(n, 15) || this.dataModel.isDirty(n, 16) || this.dataModel.isDirty(n, 18)) {
            ((Ds1LineModel)this.lineModels[n]).setSyncConfig(((E1LineTableModel)this.dataModel).getSyncConfig(n));
        }
    }

    protected boolean needToRemoveAutoProvision() {
        return !this.pci.supportsE1AutoProvision();
    }
}

