/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.e1;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.ProtCardDualPane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.e1.E1LinePmThresholdsPane;
import cerent.cms.ui.e1.E1LineProvPane;
import cerent.cms.ui.e1.E1PathPmThresholdsPane;
import cerent.cms.ui.e1.E1SdhPmThresholdsPane;
import cerent.util.SDebug;
import java.awt.Component;

public class E1ProvPane
extends NodeProvPane {
    private Ds123LineModel[] lineModels = null;
    boolean needsAlarmingPane;

    public E1ProvPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray) {
        this(string, tabbedView, ds123LineModelArray, true);
    }

    public E1ProvPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray, boolean bl) {
        super(string, tabbedView);
        this.lineModels = ds123LineModelArray;
        this.needsAlarmingPane = bl;
        this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
        this.subTabs.addTab("Line", (Component)this.getLineProvTab("Line"));
        this.subTabs.addTab("Line Thresholds", (Component)this.getLineThreshold("Line Thresholds"));
        this.subTabs.addTab("Elect Path Thresholds", (Component)this.getPathThreshold("Elect Path Thresholds"));
        this.subTabs.addTab("SDH Thresholds", (Component)this.getSonetThreshold("SDH Thresholds"));
        if (bl) {
            this.subTabs.addTab("Alarm Profiles", (Component)CardTabbedView.getCardProvAlarmsPane(this.subTabs, true));
        }
        this.add((Component)this.subTabs);
    }

    private Pane getLineThreshold(String string) {
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new E1LinePmThresholdsPane(string, this.getParentView(), this.lineModels));
    }

    private Pane getPathThreshold(String string) {
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new E1PathPmThresholdsPane(string, this.getParentView(), this.lineModels));
    }

    private Pane getLineProvTab(String string) {
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new E1LineProvPane(string, this.getParentView(), this.lineModels));
    }

    private Pane getSonetThreshold(String string) {
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new E1SdhPmThresholdsPane(string, this.getParentView(), this.lineModels));
    }

    protected boolean isHdE1(Ds123LineModel[] ds123LineModelArray) {
        int n;
        try {
            n = ds123LineModelArray[0].getModuleModel().getEqType();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            return false;
        }
        return n == 108 || n == 109;
    }

    public boolean hasSubTabs() {
        return true;
    }
}

