/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ether;

import cerent.cms.idl.Circuits.sCircuitId;
import cerent.cms.idl.Common.sEtherMacAddr;
import cerent.cms.idl.Epos.sLearnedAddress;
import cerent.cms.model.IChassisModel;
import cerent.cms.ui.ether.MacAddrDataSource;
import cerent.cms.ui.ether.MacAddrSourceInfo;
import cerent.util.ComparisonUtil;
import cerent.util.IHoNum;
import cerent.util.MacAddrFormat;
import cerent.util.TDMTerminology;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JTable;

public class MacAddrColumnRenderer
extends AbstractColumnRenderer {
    private static final int COLUMN_COUNT = 4;
    private static final int MAC_ADDRESS = 0;
    private static final int VLAN = 1;
    private static final int SLOT_PORT = 2;
    private static final int CIRCUIT_NAME = 3;
    private JLabel label;
    private MacAddrDataSource dataSource;

    public MacAddrColumnRenderer(MacAddrDataSource macAddrDataSource, String string, int n, boolean bl, int n2) {
        super(string, n, bl, n2);
        this.dataSource = macAddrDataSource;
        this.label = new JLabel();
        this.label.setHorizontalAlignment(n2);
        this.label.setVerticalAlignment(1);
        this.label.setOpaque(true);
        this.label.setForeground(Color.black);
        this.label.setFont(this.label.getFont().deriveFont(0));
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        String string = "";
        JLabel jLabel = this.label;
        Color color = bl ? jTable.getSelectionForeground() : jTable.getForeground();
        Color color2 = bl ? jTable.getSelectionBackground() : jTable.getBackground();
        MacAddrSourceInfo macAddrSourceInfo = (MacAddrSourceInfo)object;
        sLearnedAddress sLearnedAddress2 = macAddrSourceInfo.getLearnedAddress();
        switch (n2) {
            case 0: {
                string = this.getMacAddress(sLearnedAddress2.macAddr);
                break;
            }
            case 1: {
                HashMap hashMap = this.dataSource.getVlanMap();
                string = this.getVlanString(hashMap, sLearnedAddress2.vlanId);
                break;
            }
            case 2: {
                string = macAddrSourceInfo.getSlotPortHo();
                break;
            }
            case 3: {
                string = this.getCircuitName(macAddrSourceInfo);
            }
        }
        if (!bl) {
            color = Color.black;
            color2 = Color.white;
        }
        this.label.setText(string);
        ((Component)jLabel).setForeground(color);
        ((Component)jLabel).setBackground(color2);
        return jLabel;
    }

    private String getMacAddress(sEtherMacAddr sEtherMacAddr2) {
        return MacAddrFormat.format(sEtherMacAddr2.addr);
    }

    private String getCircuitName(MacAddrSourceInfo macAddrSourceInfo) {
        sCircuitId sCircuitId2 = macAddrSourceInfo.getCircuitId();
        String string = null;
        if (sCircuitId2 == null) {
            string = "Ethernet Port";
        } else {
            string = this.dataSource.getCircuitName(sCircuitId2);
            if (string == null) {
                string = "unknown";
            }
        }
        return string;
    }

    private String getVlanString(HashMap hashMap, short s) {
        if (hashMap == null) {
            return "unknown";
        }
        String string = (String)hashMap.get(new Short(s));
        if (string == null) {
            return "unknown";
        }
        return string + " (" + s + ")";
    }

    public int compareColumn(Object object, Object object2, int n) {
        int n2 = 0;
        MacAddrSourceInfo macAddrSourceInfo = (MacAddrSourceInfo)object;
        MacAddrSourceInfo macAddrSourceInfo2 = (MacAddrSourceInfo)object2;
        sLearnedAddress sLearnedAddress2 = macAddrSourceInfo.getLearnedAddress();
        sLearnedAddress sLearnedAddress3 = macAddrSourceInfo2.getLearnedAddress();
        switch (n) {
            case 0: {
                n2 = this.getMacAddress(sLearnedAddress2.macAddr).compareTo(this.getMacAddress(sLearnedAddress3.macAddr));
                break;
            }
            case 1: {
                HashMap hashMap = this.dataSource.getVlanMap();
                n2 = this.getVlanString(hashMap, sLearnedAddress2.vlanId).compareTo(this.getVlanString(hashMap, sLearnedAddress3.vlanId));
                break;
            }
            case 2: {
                return MacAddrColumnRenderer.compareSlotPortHo(macAddrSourceInfo, macAddrSourceInfo2);
            }
            case 3: {
                n2 = this.getCircuitName(macAddrSourceInfo).compareTo(this.getCircuitName(macAddrSourceInfo2));
            }
        }
        return n2;
    }

    public static int compareSlotPortHo(MacAddrSourceInfo macAddrSourceInfo, MacAddrSourceInfo macAddrSourceInfo2) {
        int[] nArray;
        int n;
        int n2 = 0;
        int n3 = macAddrSourceInfo.getSlot();
        n2 = ComparisonUtil.compare((int)n3, (int)(n = macAddrSourceInfo2.getSlot()));
        if (n2 != 0) {
            return n2;
        }
        int[] nArray2 = macAddrSourceInfo.getPortNum();
        n2 = ComparisonUtil.compare((int[])nArray2, (int[])(nArray = macAddrSourceInfo2.getPortNum()));
        if (n2 != 0) {
            return n2;
        }
        IHoNum iHoNum = macAddrSourceInfo.getHo();
        IHoNum iHoNum2 = macAddrSourceInfo2.getHo();
        return MacAddrColumnRenderer.compareHoNum(iHoNum, iHoNum2);
    }

    protected static int compareHoNum(IHoNum iHoNum, IHoNum iHoNum2) {
        if (iHoNum == null) {
            if (iHoNum2 == null) {
                return 0;
            }
            return -1;
        }
        if (iHoNum2 == null) {
            return 1;
        }
        return iHoNum.compareTo((Object)iHoNum2);
    }

    static ColumnRenderer[] createTableRenderers(MacAddrDataSource macAddrDataSource, IChassisModel iChassisModel) {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[4];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = MacAddrColumnRenderer.createColumnRenderer(macAddrDataSource, iChassisModel, i);
        }
        return columnRendererArray;
    }

    public static ColumnRenderer createColumnRenderer(MacAddrDataSource macAddrDataSource, IChassisModel iChassisModel, int n) {
        int n2;
        boolean bl;
        int n3;
        String string;
        switch (n) {
            case 0: {
                string = "MAC Address";
                n3 = 100;
                bl = true;
                n2 = 2;
                break;
            }
            case 1: {
                string = "VLAN";
                n3 = 35;
                bl = true;
                n2 = 2;
                break;
            }
            case 2: {
                TDMTerminology tDMTerminology = iChassisModel.getTDMTerminology();
                String string2 = tDMTerminology.getGeneralTerms(0);
                string = "Slot/Port/" + string2;
                n3 = 35;
                bl = true;
                n2 = 2;
                break;
            }
            case 3: {
                string = "Circuit Name";
                n3 = 35;
                bl = true;
                n2 = 2;
                break;
            }
            default: {
                string = "???";
                n3 = 20;
                bl = false;
                n2 = 2;
            }
        }
        return new MacAddrColumnRenderer(macAddrDataSource, string, n3, bl, n2);
    }
}

