/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.event;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.ILoConnectionModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.IModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOchTrailAditModel;
import cerent.cms.model.IOchccConnectionModel;
import cerent.cms.model.IOchncConnectionModel;
import cerent.cms.model.IPluggableSlotModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IPpmModel;
import cerent.cms.model.event.AbstractAlarmStore;
import cerent.cms.model.event.EventInfo;
import cerent.cms.ui.AbstractLeavePageException;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractTabbedView;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.IPreselectCircuits;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.event.EventPanel;
import cerent.cms.ui.event.IEventPanelController;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.ILoNum;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public abstract class AlarmPane
extends AbstractPane
implements ActionListener,
PropertyChangeListener {
    private static final String TT_SYNC = "<html>Synchronize table from the node(s)<P>All Transient events will be cleared</html>";
    private static final String TT_FILTER = "<html>Show Alarm Filter<P>Allows filtering of alarms</html>";
    private static final String TT_DELETE_CLEARED_ALARM = "<html>Delete Cleared Alarms<P>All Cleared alarms will be removed from table</html>";
    protected EventPanel alrPanel;
    protected AbstractAlarmStore alarmStore;
    private JCheckBox autoDeleteCB;
    private JButton deleteButton;
    private JButton synchAlrButton;
    private JButton filterButton;
    private JToggleButton filterIndicator;
    private final ImageIcon FILTER_ENABLE_IMG = new ImageIcon(this.getClass().getResource("/images/icons/Toolbar-Filter.gif"));
    private final ImageIcon FILTER_DISABLE_IMG = new ImageIcon(this.getClass().getResource("/images/icons/Toolbar-Filter-Gray.gif"));
    private Preferences preferences = Preferences.instance();
    private static final String[] DEF_HIDECOL = new String[]{"Num", "Ref"};
    private JPopupMenu contextMenu;
    private JMenuItem showCircuitsMenuItem;
    private EventInfo contextMenuEventInfo = null;
    private MouseAdapter selectCircuitsMouseAdapter = new MouseAdapter(){

        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                Component component = mouseEvent.getComponent();
                if (null != component) {
                    if (component instanceof JTable) {
                        JTable jTable = (JTable)component;
                        int n = jTable.rowAtPoint(mouseEvent.getPoint());
                        AlarmPane.this.contextMenuEventInfo = (EventInfo)jTable.getValueAt(n, 0);
                    }
                    AlarmPane.this.contextMenu.show(component, mouseEvent.getX(), mouseEvent.getY());
                } else {
                    db.println("AlarmPane got a null when seeking the component for the context menu");
                }
            }
        }
    };
    protected static final SDebug db = new SDebug("AlarmPane");

    public AlarmPane(String string, IModel iModel, TabbedView tabbedView, AbstractAlarmStore abstractAlarmStore, IEventPanelController iEventPanelController) {
        super(string, iModel, tabbedView);
        this.alarmStore = abstractAlarmStore;
        this.setLayout(new BorderLayout());
        this.alrPanel = this.createEventPanel(iEventPanelController);
        this.add(this.alrPanel, "Center");
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.filterIndicator = new JToggleButton(this.FILTER_DISABLE_IMG);
        this.filterIndicator.setSelectedIcon(this.FILTER_ENABLE_IMG);
        this.filterIndicator.setFocusPainted(false);
        this.filterIndicator.setPreferredSize(new Dimension(27, 25));
        this.filterButton = new JButton("Filter...");
        this.autoDeleteCB = new JCheckBox("AutoDelete Cleared Alarms");
        this.deleteButton = new JButton("Delete Cleared Alarms");
        this.synchAlrButton = new JButton("Synchronize");
        this.autoDeleteCB.setEnabled(true);
        this.filterIndicator.addActionListener(this);
        this.filterButton.addActionListener(this);
        this.autoDeleteCB.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.synchAlrButton.addActionListener(this);
        jPanel.add(this.synchAlrButton);
        jPanel.add(this.filterButton);
        jPanel.add(this.deleteButton);
        jPanel.add(this.autoDeleteCB);
        this.synchAlrButton.setToolTipText(TT_SYNC);
        this.filterButton.setToolTipText(TT_FILTER);
        this.deleteButton.setToolTipText(TT_DELETE_CLEARED_ALARM);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.filterIndicator);
        CSHelpID cSHelpID = this.getHelpID();
        if (cSHelpID != null) {
            jPanel2.add(new CSHelpButton(cSHelpID));
        }
        JPanel jPanel3 = new JPanel(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, "Center");
        jPanel3.add((Component)jPanel2, "East");
        this.add(jPanel3, "South");
        this.table = this.alrPanel.getTable();
        this.contextMenu = new JPopupMenu();
        this.showCircuitsMenuItem = new JMenuItem("Select Affected Circuits");
        this.showCircuitsMenuItem.setActionCommand("showCircuitsMenuItem");
        this.showCircuitsMenuItem.addActionListener(this);
        this.contextMenu.add(this.showCircuitsMenuItem);
        this.table.addMouseListener(this.selectCircuitsMouseAdapter);
        int[] nArray = this.createDefaultSorting();
        boolean[] blArray = new boolean[nArray.length];
        if (this.alrPanel.getModel() instanceof SortableRowTableModel) {
            ((SortableRowTableModel)((Object)this.alrPanel.getModel())).setDefaultColSetting(nArray, blArray, DEF_HIDECOL);
        }
        this.alarmStore.getEventFilter().setType(1);
        this.alarmStore.getEventFilter().addObserver((Observer)((Object)this));
        this.preferences.addPropertyChangeListener((PropertyChangeListener)this);
    }

    protected int[] createDefaultSorting() {
        int n = this.table.getColumn("Sev").getModelIndex();
        int n2 = this.table.getColumn("Date").getModelIndex();
        int[] nArray = new int[]{n, n2};
        return nArray;
    }

    protected abstract EventPanel createEventPanel(IEventPanelController var1);

    protected abstract void removeClearedAlarms();

    protected abstract void syncAlarms();

    protected abstract void showFilterDialog();

    protected abstract INodeModel getAffectedNodeModel(EventInfo var1);

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (this.isShowing() && (string.equals("useNeTimeZone") || string.equals("dateFormat"))) {
            this.repaint();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.autoDeleteCB) {
            this.alarmStore.setAutoDeleteCleared(this.autoDeleteCB.isSelected());
        } else if (object == this.deleteButton) {
            this.removeClearedAlarms();
        } else if (object == this.synchAlrButton) {
            this.syncAlarms();
        } else if (object == this.filterButton) {
            this.showFilterDialog();
        } else if (object == this.filterIndicator) {
            this.setFilterActive(this.filterIndicator.isSelected());
        } else {
            String string = actionEvent.getActionCommand();
            if (null != string && string.equals("showCircuitsMenuItem")) {
                List list = this.getAffectedCircuitIds();
                this.selectAffectedCircuits(list);
            }
        }
    }

    public void enteringPage() throws Exception {
        if (this.alarmStore == null) {
            if (AlarmPane.db.on) {
                db.println("Alarm store is null in enteringPage");
            }
            return;
        }
        this.autoDeleteCB.setSelected(this.alarmStore.isAutoDeleteCleared());
        this.alarmStore.getEventFilter().refreshCriteria();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
    }

    public void refresh() {
    }

    private void setFilterTooltipText() {
        String string = this.filterIndicator.isSelected() ? "Turn off alarm filter" : "Turn on alarm filter";
        this.filterIndicator.setToolTipText(string);
    }

    private void setFilterActive(boolean bl) {
        if (this.alarmStore.getEventFilter().isEnabled()) {
            this.alarmStore.getEventFilter().setActive(bl);
            this.alarmStore.setFilterActive(bl);
        }
        this.setFilterTooltipText();
    }

    public void update(Observable observable, Object object) {
        if (this.filterIndicator != null && object instanceof Boolean) {
            this.filterIndicator.setSelected((Boolean)object);
            this.setFilterTooltipText();
        }
        super.update(observable, object);
    }

    public void destroy() {
        if (null != this.table) {
            TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        }
        if (null != this.autoDeleteCB) {
            this.autoDeleteCB.removeActionListener(this);
            this.autoDeleteCB = null;
        }
        if (null != this.deleteButton) {
            this.deleteButton.removeActionListener(this);
            this.deleteButton = null;
        }
        if (null != this.synchAlrButton) {
            this.synchAlrButton.removeActionListener(this);
            this.synchAlrButton = null;
        }
        if (null != this.showCircuitsMenuItem) {
            this.showCircuitsMenuItem.removeActionListener(this);
            this.showCircuitsMenuItem = null;
        }
        if (null != this.table) {
            this.table.removeMouseListener(this.selectCircuitsMouseAdapter);
        }
        if (null != this.alrPanel) {
            this.alrPanel.dispose();
            this.alrPanel = null;
        }
        if (null != this.filterButton) {
            this.filterButton.removeActionListener(this);
            this.filterButton = null;
        }
        if (null != this.filterIndicator) {
            this.filterIndicator.removeActionListener(this);
            this.filterIndicator = null;
            this.alarmStore.getEventFilter().deleteObserver((Observer)((Object)this));
        }
        this.alarmStore = null;
        this.contextMenu = null;
        this.selectCircuitsMouseAdapter = null;
        this.contextMenuEventInfo = null;
        this.preferences.removePropertyChangeListener((PropertyChangeListener)this);
        super.destroy();
    }

    protected List getAffectedCircuitIds() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (null != this.contextMenuEventInfo) {
            INodeModel iNodeModel = this.getAffectedNodeModel(this.contextMenuEventInfo);
            if (this.contextMenuEventInfo.getSlot() > 0 && this.contextMenuEventInfo.getPort() > 0) {
                IModuleModel iModuleModel;
                if (AlarmPane.db.on) {
                    db.println("We have a slot(" + this.contextMenuEventInfo.getSlot() + "), " + "a port(" + this.contextMenuEventInfo.getPort() + "), " + "a pathWidth(" + this.contextMenuEventInfo.getPathWidth() + "), " + "a starting STS(" + this.contextMenuEventInfo.getStsNum() + "), " + "and a VT(" + this.contextMenuEventInfo.getVtNum() + ") to work with.");
                }
                if (null != (iModuleModel = this.getModuleFromEventInfo(this.contextMenuEventInfo))) {
                    IPortModel iPortModel = AlarmPane.getPortModel(iModuleModel, this.contextMenuEventInfo);
                    Set set = null;
                    int n = this.contextMenuEventInfo.getPathWidth();
                    int n2 = this.contextMenuEventInfo.getStsNum();
                    int n3 = this.contextMenuEventInfo.getVtNum();
                    int n4 = this.contextMenuEventInfo.getWavelength();
                    set = n4 != -1 ? AlarmPane.getCircuitIdsFromPort(iPortModel, n4) : (n2 == -1 && n3 == -1 ? AlarmPane.getCircuitIdsFromPort(iPortModel) : AlarmPane.getCircuitIdsFromPort(iPortModel, (short)n2, (short)n3, (short)n));
                    arrayList.add(iPortModel);
                    arrayList.addAll(set);
                }
            } else if (this.contextMenuEventInfo.getSlot() > 0 && this.contextMenuEventInfo.getStsNum() > 0 && AlarmPane.isDS1(this.contextMenuEventInfo.getEqType())) {
                db.info("We have a slot(" + this.contextMenuEventInfo.getSlot() + "), " + "a pathWidth(" + this.contextMenuEventInfo.getPathWidth() + "), " + "a starting STS(" + this.contextMenuEventInfo.getStsNum() + "), " + "and a VT(" + this.contextMenuEventInfo.getVtNum() + ") to work with.");
                arrayList.addAll(AlarmPane.getCircuitIdsFromSts(iNodeModel, this.contextMenuEventInfo));
            } else if (null != iNodeModel) {
                arrayList.add(iNodeModel);
                if (this.contextMenuEventInfo.getSlot() > 0) {
                    if (AlarmPane.db.on) {
                        db.println("only have a nodeModel and Slot model to work with");
                    }
                    IEntityModel iEntityModel = null;
                    try {
                        iEntityModel = iNodeModel.getEntityTable().getEntityModelByIndex(this.contextMenuEventInfo.getIndex());
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                    if (iEntityModel != null) {
                        if (iEntityModel instanceof IModuleModel) {
                            IModuleModel iModuleModel = (IModuleModel)iEntityModel;
                            List list = iModuleModel.getChildren();
                            for (IEntityModel iEntityModel2 : list) {
                                IConnectionModel iConnectionModel2;
                                List list2;
                                if (iEntityModel2 instanceof IPortModel) {
                                    list2 = iNodeModel.getConnectionModels().getOchConnectionModels(iEntityModel2.getIndex());
                                    list2.addAll(iEntityModel2.getConnectionsList());
                                    for (IConnectionModel iConnectionModel2 : list2) {
                                        arrayList.add(iConnectionModel2.getCircuitId());
                                    }
                                    continue;
                                }
                                if (!(iEntityModel2 instanceof IPluggableSlotModel) || iEntityModel2.getChildren().size() <= 0) continue;
                                list2 = (IPpmModel)((ArrayList)iEntityModel2.getChildren()).get(0);
                                List list3 = list2.getChildren();
                                iConnectionModel2 = list3.iterator();
                                while (iConnectionModel2.hasNext()) {
                                    IEntityModel iEntityModel3 = (IEntityModel)iConnectionModel2.next();
                                    if (!(iEntityModel3 instanceof IPortModel)) continue;
                                    List list4 = iNodeModel.getConnectionModels().getOchConnectionModels(iEntityModel3.getIndex());
                                    list4.addAll(iEntityModel3.getConnectionsList());
                                    for (IConnectionModel iConnectionModel3 : list4) {
                                        arrayList.add(iConnectionModel3.getCircuitId());
                                    }
                                }
                            }
                        } else if (iEntityModel instanceof IPpmModel) {
                            List list = ((IPpmModel)iEntityModel).getChildren();
                            for (IEntityModel iEntityModel4 : list) {
                                if (!(iEntityModel4 instanceof IPortModel)) continue;
                                List list5 = iNodeModel.getConnectionModels().getOchConnectionModels(iEntityModel4.getIndex());
                                list5.addAll(iEntityModel4.getConnectionsList());
                                for (IConnectionModel iConnectionModel : list5) {
                                    arrayList.add(iConnectionModel.getCircuitId());
                                }
                            }
                        }
                    }
                } else {
                    if (AlarmPane.db.on) {
                        db.println("only have a nodeModel to work with");
                    }
                    this.electricalAffectedCircuit(iNodeModel, arrayList);
                    this.opticalAffectedCircuit(iNodeModel, arrayList);
                }
            }
        }
        return arrayList;
    }

    private static int getEqType(EventInfo eventInfo) {
        int n = eventInfo.getPortType();
        return n == 0 ? eventInfo.getEqType() : n;
    }

    protected static IPortModel getPortModel(IModuleModel iModuleModel, EventInfo eventInfo) {
        IPortModel iPortModel = null;
        String string = PortHelper.getConcatenatedString((int[])eventInfo.getEntityHierarchyNum());
        int n = AlarmPane.getEqType(eventInfo);
        List list = iModuleModel.getDescendantsOfClassType(7);
        db.info("Need port = " + string + ", eqType = " + n + ", Searching " + list.size() + " Ports");
        for (IPortModel iPortModel2 : list) {
            String string2 = PortHelper.getPortNumString((IPortModel)iPortModel2);
            if (!string2.equals(string) || !AlarmPane.isPortNumUnique(iPortModel2, iModuleModel) && iPortModel2.getEqType() != n) continue;
            iPortModel = iPortModel2;
            db.info("found portModel = " + iPortModel);
            break;
        }
        return iPortModel;
    }

    private static IModuleModel getCard(INodeModel iNodeModel, EventInfo eventInfo) {
        IModuleModel iModuleModel = null;
        try {
            IEntityModel iEntityModel = iNodeModel.getEntityTable().getEntityModelByIndex(eventInfo.getIndex());
            List list = iEntityModel.getChildren();
            for (int i = 0; i < list.size(); ++i) {
                if (!(list.get(i) instanceof IModuleModel)) continue;
                iModuleModel = (IModuleModel)list.get(i);
                break;
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        return iModuleModel;
    }

    private static boolean isPortNumUnique(IPortModel iPortModel, IModuleModel iModuleModel) {
        return Feature.provides((INodeModel)iPortModel.getNodeModel(), (Feature)Feature.EXP_PORT_NUM) ? iPortModel.isPortNumUnique() : iModuleModel.getEqType() != 47;
    }

    public static Set getCircuitIdsFromPort(IPortModel iPortModel) {
        return AlarmPane.getCircuitIdsFromPort(iPortModel, (short)-1, (short)-1, (short)-1, -1);
    }

    public static Set getCircuitIdsFromPort(IPortModel iPortModel, int n) {
        return AlarmPane.getCircuitIdsFromPort(iPortModel, (short)-1, (short)-1, (short)-1, n);
    }

    public static Set getCircuitIdsFromPort(IPortModel iPortModel, short s, short s2, short s3) {
        return AlarmPane.getCircuitIdsFromPort(iPortModel, s, s2, s3, -1);
    }

    private static Set getCircuitIdsFromPort(IPortModel iPortModel, short s, short s2, short s3, int n) {
        HashSet<ICircuitId> hashSet = new HashSet<ICircuitId>();
        if (iPortModel != null) {
            List list = iPortModel.getConnectionsList();
            db.info("Get cktIds for " + iPortModel + "\nNeed Sts = " + s + ", VT = " + s2 + ", width = " + s3 + "Found conns: " + list.size());
            for (int i = 0; i < list.size(); ++i) {
                short s4;
                ILoNum iLoNum;
                ILoDefModel iLoDefModel;
                int n2;
                boolean bl;
                ILoDefModel[] iLoDefModelArray;
                ILoConnectionModel iLoConnectionModel;
                if (list.get(i) instanceof ILoConnectionModel) {
                    iLoConnectionModel = (ILoConnectionModel)list.get(i);
                    if (iLoConnectionModel == null) continue;
                    if (s == -1 && s2 == -1) {
                        hashSet.add(iLoConnectionModel.getCircuitId());
                        continue;
                    }
                    iLoDefModelArray = iLoConnectionModel.getPaths();
                    if (null == iLoDefModelArray) continue;
                    bl = false;
                    for (n2 = 0; !bl && n2 < iLoDefModelArray.length; ++n2) {
                        iLoDefModel = iLoDefModelArray[n2];
                        iLoNum = iLoDefModel.getLoNum();
                        s4 = iLoDefModel.getLoAdit().getHo().getStartingHo().getHoNum();
                        short s5 = iLoNum.getIdlFlatNum();
                        db.info("LO Path has Sts = " + s4 + ", VtNum = " + s5);
                        if (s != s4 || s2 != -1 && s2 != s5) continue;
                        hashSet.add(iLoConnectionModel.getCircuitId());
                        bl = true;
                    }
                    continue;
                }
                if (list.get(i) instanceof IHoConnectionModel) {
                    iLoConnectionModel = (IHoConnectionModel)list.get(i);
                    if (iLoConnectionModel == null) continue;
                    if (s > 0) {
                        iLoDefModelArray = iLoConnectionModel.getPaths();
                        db.println("pathDefs len = " + iLoDefModelArray.length);
                        if (null == iLoDefModelArray) continue;
                        bl = false;
                        for (n2 = 0; !bl && n2 < iLoDefModelArray.length; ++n2) {
                            iLoDefModel = iLoDefModelArray[n2];
                            iLoNum = iLoDefModel.getStartingHo();
                            s4 = iLoDefModel.getPathWidth();
                            db.info("HoPath hoNum= " + iLoNum.getHoNum() + "width = " + s4);
                            if (!AlarmPane.isPathOnPort(iPortModel, (IHoPathDefModel)iLoDefModel) || s != iLoNum.getHoNum() || s3 != s4) continue;
                            hashSet.add(iLoConnectionModel.getCircuitId());
                            bl = true;
                        }
                        continue;
                    }
                    hashSet.add(iLoConnectionModel.getCircuitId());
                    continue;
                }
                if (list.get(i) instanceof IOchncConnectionModel) {
                    iLoConnectionModel = (IOchncConnectionModel)list.get(i);
                    if (iLoConnectionModel == null || n != -1 && n != iLoConnectionModel.getOptChannel()) continue;
                    hashSet.add(iLoConnectionModel.getCircuitId());
                    continue;
                }
                if (list.get(i) instanceof IOchccConnectionModel) {
                    iLoConnectionModel = (IOchccConnectionModel)list.get(i);
                    if (iLoConnectionModel == null) continue;
                    hashSet.add(iLoConnectionModel.getCircuitId());
                    continue;
                }
                if (!(list.get(i) instanceof IOchTrailAditModel) || (iLoConnectionModel = (IOchTrailAditModel)list.get(i)) == null || n != -1 && n != iLoConnectionModel.getOptChannel()) continue;
                hashSet.add(iLoConnectionModel.getCircuitId());
            }
        }
        db.info("getCircuitIdsFromPort returns " + hashSet.size() + "ckts");
        return hashSet;
    }

    public static Set getCircuitIdsFromSts(INodeModel iNodeModel, EventInfo eventInfo) {
        HashSet<ICircuitId> hashSet = new HashSet<ICircuitId>();
        IModuleModel iModuleModel = AlarmPane.getCard(iNodeModel, eventInfo);
        if (iModuleModel == null) {
            return hashSet;
        }
        List list = iModuleModel.getDescendantsOfEqType(34);
        list.add(iModuleModel);
        IEntityTableModel iEntityTableModel = iModuleModel.getNodeModel().getEntityTable();
        List list2 = iModuleModel.getConnectionsList();
        Iterator iterator = list2.iterator();
        db.info("Get cktIds for " + iModuleModel + "\nNeed Sts = " + eventInfo.getStsNum() + ", width = " + eventInfo.getPathWidth() + "\nds1PoolEntities size = " + list.size() + ", Found conns: " + list2.size());
        block4: while (iterator.hasNext()) {
            IEntityModel iEntityModel;
            ILoConnectionModel iLoConnectionModel;
            IConnectionModel iConnectionModel = (IConnectionModel)iterator.next();
            if (iConnectionModel instanceof ILoConnectionModel) {
                iLoConnectionModel = (ILoConnectionModel)iConnectionModel;
                for (ILoDefModel iLoDefModel : Arrays.asList(iLoConnectionModel.getPaths())) {
                    try {
                        iEntityModel = iEntityTableModel.getEntityModelByIndex(iLoDefModel.getPortIndex());
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        db.println("Caught AbstractCmsNoSuchEntityException. Can't find EntityModel of LO Path");
                        continue block4;
                    }
                    db.fine("LoPath PoolEntity = " + iEntityModel);
                    if (!list.contains(iEntityModel)) continue;
                    hashSet.add(iLoConnectionModel.getCircuitId());
                    db.info("Adding LO circuit");
                    continue block4;
                }
                continue;
            }
            if (!(iConnectionModel instanceof IHoConnectionModel)) continue;
            iLoConnectionModel = (IHoConnectionModel)iConnectionModel;
            for (IHoPathDefModel iHoPathDefModel : Arrays.asList(iLoConnectionModel.getPaths())) {
                try {
                    iEntityModel = iHoPathDefModel.getPool().getEntityModel();
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    db.println("Caught AbstractCmsNoSuchEntityException. Can't find EntityModel of HO Path");
                    continue block4;
                }
                db.fine("HoPath PoolEntity = " + iEntityModel);
                if (!list.contains(iEntityModel)) continue;
                hashSet.add(iLoConnectionModel.getCircuitId());
                db.info("Adding HO circuit");
                continue block4;
            }
        }
        db.info("getCircuitIdsFromSts returns " + hashSet.size() + "ckts");
        return hashSet;
    }

    public static boolean isDS1(int n) {
        return n == 34 || n == 4 || n == 5;
    }

    private static boolean isPathOnPort(IPortModel iPortModel, IHoPathDefModel iHoPathDefModel) {
        IEntityModel iEntityModel = null;
        boolean bl = false;
        try {
            iEntityModel = iHoPathDefModel.getPool().getEntityModel();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            db.println("Caught AbstractCmsNoSuchEntityException in isPathOnPort");
        }
        if (iEntityModel instanceof IPortModel) {
            bl = iPortModel.equals((IPortModel)iEntityModel);
        } else if (iEntityModel instanceof IModuleModel) {
            bl = iPortModel.getModuleModel().equals((IModuleModel)iEntityModel);
        }
        if (db.on()) {
            db.println("HoPath of HoConnection matches Port " + iPortModel);
        }
        return bl;
    }

    private void selectAffectedCircuits(List list) {
        TabbedView tabbedView = this.getParentView();
        if (tabbedView instanceof AbstractTabbedView) {
            AbstractTabbedView abstractTabbedView = (AbstractTabbedView)tabbedView;
            try {
                abstractTabbedView.changeTab(3);
            }
            catch (AbstractLeavePageException abstractLeavePageException) {
                db.println("AbstractLeavePageException caught trying to change to circuits tab int NodeAlarmPane");
                SDebug.printStackTrace((Throwable)abstractLeavePageException);
            }
            Pane pane = tabbedView.getCurrentPane();
            if (pane instanceof IPreselectCircuits) {
                if (AlarmPane.db.on) {
                    db.println("Setting the Preselected Circuit IDs now...");
                }
                ((IPreselectCircuits)pane).setPreselectedCircuitIds(list);
            }
        }
    }

    protected IModuleModel getModuleFromEventInfo(EventInfo eventInfo) {
        IModuleModel iModuleModel;
        block4: {
            iModuleModel = null;
            INodeModel iNodeModel = null;
            try {
                iNodeModel = this.getAffectedNodeModel(eventInfo);
                IEntityModel iEntityModel = iNodeModel.getEntityTable().getEntityModelByIndex(eventInfo.getIndex());
                iModuleModel = iEntityModel.getModuleModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                try {
                    IEntityModel iEntityModel = iNodeModel.getEntityTable().getEntityModelBySlot(eventInfo.getShelfId(), eventInfo.getSlot());
                    List list = iEntityModel.getDescendantsOfClassType(6);
                    iModuleModel = (IModuleModel)list.get(0);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException2) {
                    db.println("Caught " + (Object)((Object)abstractCmsNoSuchEntityException));
                    if (!db.on()) break block4;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        return iModuleModel;
    }

    public CSHelpID getHelpID() {
        return null;
    }

    public void setContextMenuEventInfo(EventInfo eventInfo) {
        this.contextMenuEventInfo = eventInfo;
    }

    protected void electricalAffectedCircuit(INodeModel iNodeModel, List list) {
        IHoConnectionModel iHoConnectionModel;
        int n;
        IHoConnectionModel[] iHoConnectionModelArray = iNodeModel.getConnectionModels().getHoConnectionModels();
        ILoConnectionModel[] iLoConnectionModelArray = iNodeModel.getConnectionModels().getLoConnectionModels();
        for (n = 0; n < iHoConnectionModelArray.length; ++n) {
            iHoConnectionModel = iHoConnectionModelArray[n];
            list.add(iHoConnectionModel.getCircuitId());
        }
        for (n = 0; n < iLoConnectionModelArray.length; ++n) {
            iHoConnectionModel = iLoConnectionModelArray[n];
            list.add(iHoConnectionModel.getCircuitId());
        }
    }

    protected void opticalAffectedCircuit(INodeModel iNodeModel, List list) {
        IOchncConnectionModel iOchncConnectionModel;
        int n;
        IOchncConnectionModel[] iOchncConnectionModelArray = iNodeModel.getConnectionModels().getOchncConnectionModels();
        IOchccConnectionModel[] iOchccConnectionModelArray = iNodeModel.getConnectionModels().getOchccConnectionModels();
        IOchTrailAditModel[] iOchTrailAditModelArray = iNodeModel.getConnectionModels().getOchTrailAditModels();
        for (n = 0; n < iOchncConnectionModelArray.length; ++n) {
            iOchncConnectionModel = iOchncConnectionModelArray[n];
            list.add(iOchncConnectionModel.getCircuitId());
        }
        for (n = 0; n < iOchccConnectionModelArray.length; ++n) {
            iOchncConnectionModel = iOchccConnectionModelArray[n];
            list.add(iOchncConnectionModel.getCircuitId());
        }
        for (n = 0; n < iOchTrailAditModelArray.length; ++n) {
            iOchncConnectionModel = iOchTrailAditModelArray[n];
            list.add(iOchncConnectionModel.getCircuitId());
        }
    }
}

