/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.event;

import cerent.cms.model.AuditTrail;
import cerent.cms.model.CtcTimeZone;
import cerent.cms.model.Feature;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.StringTag;
import cerent.util.ComparisonUtil;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;

public class AuditColumnRenderer
extends AbstractColumnRenderer {
    public static final int DATE = 0;
    public static final int SEQ_NUM = 1;
    public static final int USER = 2;
    public static final int SUCCESS = 3;
    public static final int LEVEL = 4;
    public static final int PARAMETERS = 5;
    private JLabel label;
    private int mode;
    private static EmptyBorder emptyBorder = new EmptyBorder(0, 2, 0, 2);
    private Date date;
    private SimpleDateFormat formatter_us;
    private SimpleDateFormat formatter_euro;
    private static final SDebug db = new SDebug("AuditColumnRenderer", false);

    public AuditColumnRenderer(int n, String string, int n2, boolean bl, int n3) {
        super(string, n2, bl, n3);
        this.mode = n;
        this.label = new JLabel();
        this.label.setHorizontalAlignment(this.alignment);
        this.label.setOpaque(true);
        this.label.setForeground(Color.black);
        this.label.setFont(this.label.getFont().deriveFont(0));
        this.label.setBorder(emptyBorder);
        this.date = new Date();
        this.formatter_us = new SimpleDateFormat("MM/dd/yy HH:mm:ss");
        this.formatter_euro = new SimpleDateFormat("dd/MM/yy HH:mm:ss");
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        String string;
        JLabel jLabel = this.label;
        AuditTrail auditTrail = (AuditTrail)object;
        switch (this.mode) {
            case 0: {
                this.date.setTime((long)auditTrail.getTimeStamp() * 1000L);
                NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)auditTrail.getNodeModel();
                CtcTimeZone ctcTimeZone = nodeModelDelegate.getCtcTimeZone();
                if (Preferences.instance().getProperty("ctc", "dateFormat", "MM/DD/YY").equals("MM/DD/YY")) {
                    this.formatter_us.setTimeZone(ctcTimeZone);
                    string = this.formatter_us.format(this.date).toString();
                    break;
                }
                this.formatter_euro.setTimeZone(ctcTimeZone);
                string = this.formatter_euro.format(this.date).toString();
                break;
            }
            case 1: {
                string = String.valueOf(auditTrail.getSequenceNumber());
                break;
            }
            case 2: {
                string = auditTrail.getUserId();
                break;
            }
            case 3: {
                if (auditTrail.getSucceeded() == 'P') {
                    string = "P";
                    break;
                }
                if (auditTrail.getSucceeded() == 'F') {
                    string = "F";
                    break;
                }
                if (auditTrail.getSucceeded() == 'X') {
                    string = "X";
                    break;
                }
                if (auditTrail.getSucceeded() == '\u0000') {
                    string = "f";
                    break;
                }
                if (auditTrail.getSucceeded() == '\u0001') {
                    string = "p";
                    break;
                }
                string = "?";
                break;
            }
            case 4: {
                string = String.valueOf(auditTrail.getLevel());
                break;
            }
            case 5: {
                if (auditTrail.getOperationId() < 0) {
                    auditTrail.setOperationId((short)0);
                }
                string = "     " + this.getAuditString((NodeModelDelegate)auditTrail.getNodeModel(), auditTrail.getOperationId()) + auditTrail.getArguments();
                break;
            }
            default: {
                string = "???";
            }
        }
        if (string != null) {
            this.label.setText(string);
        }
        ((Component)jLabel).setBackground(Color.white);
        ((Component)jLabel).setForeground(Color.black);
        return jLabel;
    }

    public String getAuditString(NodeModelDelegate nodeModelDelegate, short s) {
        try {
            if (nodeModelDelegate.provides(Feature.IDL_220)) {
                Integer n = new Integer(s);
                StringTag stringTag = (StringTag)nodeModelDelegate.getAuditOpList().get(n);
                if (stringTag == null) {
                    if (db.on()) {
                        db.println("Null tag returned for operation ID: " + s);
                    }
                    return "Unknown Operation";
                }
                return stringTag.getFirst() + "::" + stringTag.getSecond();
            }
            if (db.on()) {
                db.println("Pre 2.2 node");
            }
            return "Unknown Operation";
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Exception in getting Audit String");
                SDebug.printStackTrace((Throwable)exception);
            }
            return "Error in getting Operation";
        }
    }

    public static ColumnRenderer createAuditColumnRenderer(int n) {
        String string;
        int n2 = 20;
        boolean bl = true;
        int n3 = 0;
        switch (n) {
            case 0: {
                string = "Date";
                n2 = 120;
                break;
            }
            case 1: {
                string = "Num";
                n2 = 34;
                break;
            }
            case 2: {
                string = "User";
                n2 = 40;
                break;
            }
            case 3: {
                string = "P/F/X";
                n2 = 34;
                break;
            }
            case 4: {
                string = "Lvl";
                n2 = 34;
                break;
            }
            case 5: {
                string = "Operation";
                n3 = 2;
                n2 = 800;
                break;
            }
            default: {
                string = "???";
            }
        }
        return new AuditColumnRenderer(n, string, n2, bl, n3);
    }

    public int compareColumn(Object object, Object object2, int n) {
        int n2 = 0;
        AuditTrail auditTrail = (AuditTrail)object;
        AuditTrail auditTrail2 = (AuditTrail)object2;
        switch (this.mode) {
            case 0: {
                n2 = ComparisonUtil.compare((int)auditTrail.getTimeStamp(), (int)auditTrail2.getTimeStamp());
                break;
            }
            case 1: {
                n2 = ComparisonUtil.compare((int)auditTrail.getSequenceNumber(), (int)auditTrail2.getSequenceNumber());
                break;
            }
            case 2: {
                n2 = auditTrail.getUserId().compareTo(auditTrail2.getUserId());
                break;
            }
            case 3: {
                n2 = ComparisonUtil.compare((int)auditTrail.getSucceeded(), (int)auditTrail2.getSucceeded());
                break;
            }
            case 4: {
                n2 = ComparisonUtil.compare((int)auditTrail.getLevel(), (int)auditTrail2.getLevel());
                break;
            }
            case 5: {
                n2 = ComparisonUtil.compare((int)auditTrail.getOperationId(), (int)auditTrail2.getOperationId());
                break;
            }
        }
        return n2;
    }
}

