/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.event;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IDwdmModuleModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.ILoConnectionModel;
import cerent.cms.model.IModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOchTrailAditModel;
import cerent.cms.model.IOchccConnectionModel;
import cerent.cms.model.IOchncConnectionModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IPpmModel;
import cerent.cms.model.ITdmModuleModel;
import cerent.cms.model.event.EventFilter;
import cerent.cms.model.event.EventInfo;
import cerent.cms.ui.AbstractLeavePageException;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractTabbedView;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.IPreselectCircuits;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.event.ARowSource;
import cerent.cms.ui.event.AlarmPane;
import cerent.cms.ui.event.ConditionsComparator;
import cerent.cms.ui.event.EventPanel;
import cerent.cms.ui.event.IEventPanelController;
import cerent.util.DetailedLog;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.WindowHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public abstract class ConditionsPane
extends AbstractPane
implements ActionListener,
PropertyChangeListener,
Runnable,
Comparator {
    private static final String TT_RETRIEVE = "<html>Retrieve all current conditions from node(s)</html>";
    private static final String TT_FILTER = "<html>Show Alarm Filter<P>Allows filtering of conditions</html>";
    private static final Comparator comp = ConditionsComparator.instance();
    protected EventPanel conditionPanel;
    protected JButton watchButton;
    protected JLabel watchLabel;
    protected ArrayList arrayList = new ArrayList();
    protected JCheckBox suppressedCB;
    protected boolean excludeSuppressed = false;
    protected Date lastUpdate;
    private JPopupMenu contextMenu;
    private JMenuItem showCircuitsMenuItem;
    private SDebug db;
    private static final Preferences preferences = Preferences.instance();
    private static final String PREF_KEY = "excludeSuppressed";
    private static final String PREF_PATH = "ctc";
    private static final String SUPPRESSED_CB_LABEL = "Exclude Same Root Cause";
    protected ArrayList filteredArrayList = new ArrayList();
    protected EventFilter eventFilter;
    protected JButton filterButton;
    protected JToggleButton filterIndicator;
    private final ImageIcon FILTER_ENABLE_IMG = new ImageIcon(this.getClass().getResource("/images/icons/Toolbar-Filter.gif"));
    private final ImageIcon FILTER_DISABLE_IMG = new ImageIcon(this.getClass().getResource("/images/icons/Toolbar-Filter-Gray.gif"));
    private EventInfo contextMenuEventInfo = null;
    private MouseAdapter selectCircuitsMouseAdapter = new MouseAdapter(){

        public void mouseClicked(MouseEvent mouseEvent) {
            Component component;
            if (SwingUtilities.isRightMouseButton(mouseEvent) && null != (component = mouseEvent.getComponent())) {
                if (component instanceof JTable) {
                    JTable jTable = (JTable)component;
                    int n = jTable.rowAtPoint(mouseEvent.getPoint());
                    ConditionsPane.this.contextMenuEventInfo = (EventInfo)jTable.getValueAt(n, 0);
                }
                ConditionsPane.this.contextMenu.show(component, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    };
    private boolean disposed = false;
    private static final String[] DEF_HIDECOL = new String[]{"Num", "Ref", "New"};
    protected ARowSource rowSource;

    protected ConditionsPane(String string, IModel iModel, TabbedView tabbedView, IEventPanelController iEventPanelController, SDebug sDebug) {
        super(string, iModel, tabbedView);
        this.db = sDebug;
        this.setLayout(new BorderLayout());
        this.createButtonPanel();
        this.eventFilter = new EventFilter("ConditionPane", null, 2);
        this.rowSource = new ARowSource(this.arrayList, this.filteredArrayList, this.eventFilter);
        this.conditionPanel = this.createEventPanel(iEventPanelController);
        this.add(this.conditionPanel, "Center");
        this.table = this.conditionPanel.getTable();
        this.eventFilter.addObserver((Observer)((Object)this));
        this.contextMenu = new JPopupMenu();
        this.showCircuitsMenuItem = new JMenuItem("Select Affected Circuits");
        this.showCircuitsMenuItem.setActionCommand("showCircuitsMenuItem");
        this.showCircuitsMenuItem.addActionListener(this);
        this.contextMenu.add(this.showCircuitsMenuItem);
        this.table.addMouseListener(this.selectCircuitsMouseAdapter);
        this.eventFilter.setType(2);
        preferences.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public int compare(Object object, Object object2) {
        return comp.compare(object, object2);
    }

    protected void registerNewConditions(ArrayList arrayList) {
        if (!this.disposed) {
            Collections.sort(arrayList, this);
            this.arrayList.addAll(arrayList);
            if (this.eventFilter.isEnabled()) {
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    this.filterEvent((EventInfo)arrayList.get(i));
                }
            }
            this.rowSource.dataSourceChanged();
        }
    }

    protected void createButtonPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        this.watchButton = new JButton("Retrieve");
        this.watchButton.addActionListener(this);
        this.filterButton = new JButton("Filter...");
        this.filterButton.addActionListener(this);
        this.suppressedCB = new JCheckBox(SUPPRESSED_CB_LABEL);
        this.suppressedCB.addActionListener(this);
        this.watchLabel = new JLabel(" ");
        this.filterIndicator = new JToggleButton(this.FILTER_DISABLE_IMG);
        this.filterIndicator.setSelectedIcon(this.FILTER_ENABLE_IMG);
        this.filterIndicator.setFocusPainted(false);
        this.filterIndicator.setPreferredSize(new Dimension(27, 25));
        this.filterIndicator.addActionListener(this);
        this.watchButton.setToolTipText(TT_RETRIEVE);
        this.filterButton.setToolTipText(TT_FILTER);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(this.watchButton);
        jPanel2.add(this.filterButton);
        jPanel2.add(this.suppressedCB);
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        jPanel3.add(this.watchLabel);
        jPanel3.add(this.filterIndicator);
        CSHelpID cSHelpID = this.getHelpID();
        if (cSHelpID != null) {
            jPanel3.add(new CSHelpButton(cSHelpID));
        }
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "East");
        this.add(jPanel, "South");
    }

    public void updateWatchLabel(Date date) {
        this.lastUpdate = date;
        WindowHelper.setLabelText((JLabel)this.watchLabel, (String)("Retrieved: " + ConditionsPane.getFormattedDateTime(this.lastUpdate)));
        this.conditionPanel.getTable().setName(this.watchLabel.getText());
    }

    private void updateConditions() {
        this.watchButton.setEnabled(false);
        this.arrayList.clear();
        this.filteredArrayList.clear();
        WindowHelper.setLabelText((JLabel)this.watchLabel, (String)"Retrieving conditions...");
        new Thread((Runnable)this, "Conditions Retriever Thread").start();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (this.isShowing() && (string.equals("useNeTimeZone") || string.equals("dateFormat"))) {
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        try {
            if (object == this.watchButton) {
                this.uiToolkit.setCursor(3);
                this.updateConditions();
            } else if (object == this.suppressedCB) {
                this.excludeSuppressed = this.suppressedCB.isSelected();
                if (this.db.on()) {
                    this.db.println("excludeSuppressed: " + this.excludeSuppressed);
                }
            } else if (object == this.filterButton) {
                this.showFilterDialog();
            } else if (object == this.filterIndicator) {
                this.setFilterActive(this.filterIndicator.isSelected());
            } else if (null != string && string.equals("showCircuitsMenuItem")) {
                List list = this.getAffectedCircuitIds();
                this.selectAffectedCircuits(list);
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        finally {
            this.uiToolkit.setCursor(0);
        }
        this.rowSource.dataSourceChanged();
    }

    protected abstract String getErrorMsg();

    protected abstract EventPanel createEventPanel(IEventPanelController var1);

    protected abstract List getNodeModelList();

    protected ArrayList filterConditions(ArrayList arrayList) {
        return arrayList;
    }

    protected abstract void showFilterDialog();

    public void enteringPage() throws Exception {
        this.excludeSuppressed = preferences.getBoolean(PREF_PATH, this.getExcludeKey(), this.getExcludeDefault());
        this.suppressedCB.setSelected(this.excludeSuppressed);
        this.eventFilter.refreshCriteria();
        TablePropertyMgr.getColumnPrefs(this.conditionPanel.getTable(), this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        preferences.setBoolean(PREF_PATH, this.getExcludeKey(), this.excludeSuppressed);
        TablePropertyMgr.setColumnPrefs(this.conditionPanel.getTable(), this.getClass().getName());
    }

    public void refresh() {
    }

    private void filterEvent(EventInfo eventInfo) {
        if (this.eventFilter.isEnabled() && this.eventFilter.doesMatch(eventInfo)) {
            this.filteredArrayList.add(eventInfo);
        }
    }

    private void setFilterTooltipText() {
        String string = this.filterIndicator.isSelected() ? "Turn off alarm filter" : "Turn on alarm filter";
        this.filterIndicator.setToolTipText(string);
    }

    public void update(Observable observable, Object object) {
        if (this.filterIndicator != null && object instanceof Boolean) {
            this.filterIndicator.setSelected((Boolean)object);
            this.setFilterTooltipText();
        }
        this.flushFilteredData();
        this.rowSource.dataSourceChanged();
        super.update(observable, object);
    }

    private void flushFilteredData() {
        this.filteredArrayList.clear();
        int n = this.arrayList.size();
        for (int i = 0; i < n; ++i) {
            this.filterEvent((EventInfo)this.arrayList.get(i));
        }
    }

    private void setFilterActive(boolean bl) {
        if (this.eventFilter.isEnabled()) {
            this.eventFilter.setActive(bl);
            this.flushFilteredData();
            this.setFilterTooltipText();
        }
    }

    public void destroy() {
        this.disposed = true;
        if (null != this.conditionPanel) {
            TablePropertyMgr.setColumnPrefs(this.conditionPanel.getTable(), this.getClass().getName());
        }
        if (null != this.watchButton) {
            this.watchButton.removeActionListener(this);
        }
        this.conditionPanel = null;
        this.arrayList.clear();
        this.filteredArrayList.clear();
        if (this.filterButton != null) {
            this.filterButton.removeActionListener(this);
        }
        if (this.filterIndicator != null) {
            this.filterIndicator.removeActionListener(this);
        }
        this.filterButton = null;
        this.filterIndicator = null;
        if (this.eventFilter != null) {
            this.eventFilter.deleteObserver((Observer)((Object)this));
            this.eventFilter.dispose();
        }
        this.eventFilter = null;
        this.suppressedCB = null;
        this.table.removeMouseListener(this.selectCircuitsMouseAdapter);
        this.contextMenu = null;
        this.selectCircuitsMouseAdapter = null;
        this.contextMenuEventInfo = null;
        preferences.removePropertyChangeListener((PropertyChangeListener)this);
        super.destroy();
    }

    protected List getAffectedCircuitIds() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (null != this.contextMenuEventInfo) {
            INodeModel iNodeModel = this.getAffectedNodeModel(this.contextMenuEventInfo);
            if (this.contextMenuEventInfo.getSlot() > 0 && this.contextMenuEventInfo.getPort() > 0) {
                IModuleModel iModuleModel;
                if (this.db.on) {
                    this.db.println("We have a slot(" + this.contextMenuEventInfo.getSlot() + "), " + "a port(" + this.contextMenuEventInfo.getPort() + "), " + "a pathWidth(" + this.contextMenuEventInfo.getPathWidth() + "), " + "a starting STS(" + this.contextMenuEventInfo.getStsNum() + "), " + "and a VT(" + this.contextMenuEventInfo.getVtNum() + ") to work with.");
                }
                if (null != (iModuleModel = this.getModuleFromEventInfo(this.contextMenuEventInfo))) {
                    IPortModel iPortModel = AlarmPane.getPortModel(iModuleModel, this.contextMenuEventInfo);
                    Set set = null;
                    int n = this.contextMenuEventInfo.getPathWidth();
                    int n2 = this.contextMenuEventInfo.getStsNum();
                    int n3 = this.contextMenuEventInfo.getVtNum();
                    int n4 = this.contextMenuEventInfo.getWavelength();
                    set = n4 != -1 ? AlarmPane.getCircuitIdsFromPort(iPortModel, n4) : (n2 == -1 && n3 == -1 ? AlarmPane.getCircuitIdsFromPort(iPortModel) : AlarmPane.getCircuitIdsFromPort(iPortModel, (short)n2, (short)n3, (short)n));
                    arrayList.add(iPortModel);
                    arrayList.addAll(set);
                }
            } else if (this.contextMenuEventInfo.getSlot() > 0 && this.contextMenuEventInfo.getStsNum() > 0 && AlarmPane.isDS1(this.contextMenuEventInfo.getEqType())) {
                this.db.info("We have a slot(" + this.contextMenuEventInfo.getSlot() + "), " + "a pathWidth(" + this.contextMenuEventInfo.getPathWidth() + "), " + "a starting STS(" + this.contextMenuEventInfo.getStsNum() + "), " + "and a VT(" + this.contextMenuEventInfo.getVtNum() + ") to work with.");
                arrayList.addAll(AlarmPane.getCircuitIdsFromSts(iNodeModel, this.contextMenuEventInfo));
            } else {
                if (this.db.on) {
                    this.db.println("only have a nodeModel to work with");
                }
                if (null != iNodeModel) {
                    int n;
                    Object object;
                    IOchccConnectionModel[] iOchccConnectionModelArray;
                    arrayList.add(iNodeModel);
                    IHoConnectionModel[] iHoConnectionModelArray = iNodeModel.getConnectionModels().getHoConnectionModels();
                    for (int i = 0; i < iHoConnectionModelArray.length; ++i) {
                        IHoConnectionModel iHoConnectionModel = iHoConnectionModelArray[i];
                        arrayList.add(iHoConnectionModel.getCircuitId());
                    }
                    ILoConnectionModel[] iLoConnectionModelArray = iNodeModel.getConnectionModels().getLoConnectionModels();
                    for (int i = 0; i < iLoConnectionModelArray.length; ++i) {
                        iOchccConnectionModelArray = iLoConnectionModelArray[i];
                        arrayList.add(iOchccConnectionModelArray.getCircuitId());
                    }
                    IOchncConnectionModel[] iOchncConnectionModelArray = new IOchncConnectionModel[]{};
                    iOchccConnectionModelArray = new IOchccConnectionModel[]{};
                    IOchTrailAditModel[] iOchTrailAditModelArray = new IOchTrailAditModel[]{};
                    if (this.contextMenuEventInfo.getSlot() > 0) {
                        IEntityModel iEntityModel = null;
                        try {
                            iEntityModel = iNodeModel.getEntityTable().getEntityModelByIndex(this.contextMenuEventInfo.getIndex());
                        }
                        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                        }
                        if (iEntityModel != null) {
                            IConnectionModel iConnectionModel;
                            Object object2;
                            Object object3;
                            IEntityModel iEntityModel2;
                            Object object4;
                            if (iEntityModel instanceof IModuleModel && ((IModuleModel)iEntityModel).isOpticsCard() || iEntityModel instanceof IDwdmModuleModel || iEntityModel instanceof ITdmModuleModel) {
                                object = (IModuleModel)iEntityModel;
                                object4 = object.getChildren();
                                iEntityModel2 = object4.iterator();
                                while (iEntityModel2.hasNext()) {
                                    object3 = (IEntityModel)iEntityModel2.next();
                                    if (!(object3 instanceof IPortModel)) continue;
                                    object2 = iNodeModel.getConnectionModels().getOchConnectionModels(object3.getIndex());
                                    iConnectionModel = object2.iterator();
                                    while (iConnectionModel.hasNext()) {
                                        IConnectionModel iConnectionModel2 = (IConnectionModel)iConnectionModel.next();
                                        arrayList.add(iConnectionModel2.getCircuitId());
                                    }
                                }
                            } else if (iEntityModel instanceof IPpmModel) {
                                object = ((IPpmModel)iEntityModel).getChildren();
                                object4 = object.iterator();
                                while (object4.hasNext()) {
                                    iEntityModel2 = (IEntityModel)object4.next();
                                    if (!(iEntityModel2 instanceof IPortModel)) continue;
                                    object3 = iNodeModel.getConnectionModels().getOchConnectionModels(iEntityModel2.getIndex());
                                    object2 = object3.iterator();
                                    while (object2.hasNext()) {
                                        iConnectionModel = (IConnectionModel)object2.next();
                                        arrayList.add(iConnectionModel.getCircuitId());
                                    }
                                }
                            }
                        }
                    } else {
                        iOchncConnectionModelArray = iNodeModel.getConnectionModels().getOchncConnectionModels();
                        iOchccConnectionModelArray = iNodeModel.getConnectionModels().getOchccConnectionModels();
                        iOchTrailAditModelArray = iNodeModel.getConnectionModels().getOchTrailAditModels();
                    }
                    for (n = 0; n < iOchncConnectionModelArray.length; ++n) {
                        object = iOchncConnectionModelArray[n];
                        arrayList.add(object.getCircuitId());
                    }
                    for (n = 0; n < iOchccConnectionModelArray.length; ++n) {
                        object = iOchccConnectionModelArray[n];
                        arrayList.add(object.getCircuitId());
                    }
                    for (n = 0; n < iOchTrailAditModelArray.length; ++n) {
                        object = iOchTrailAditModelArray[n];
                        arrayList.add(object.getCircuitId());
                    }
                }
            }
        }
        return arrayList;
    }

    private void selectAffectedCircuits(List list) {
        TabbedView tabbedView = this.getParentView();
        if (tabbedView instanceof AbstractTabbedView) {
            AbstractTabbedView abstractTabbedView = (AbstractTabbedView)tabbedView;
            try {
                abstractTabbedView.changeTab(3);
            }
            catch (AbstractLeavePageException abstractLeavePageException) {
                this.db.println("AbstractLeavePageException caught trying to change to circuits tab int NodeAlarmPane");
            }
            Pane pane = tabbedView.getCurrentPane();
            if (pane instanceof IPreselectCircuits) {
                ((IPreselectCircuits)pane).setPreselectedCircuitIds(list);
            }
        }
    }

    private final String getExcludeKey() {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(".") + 1);
        return string + "." + PREF_KEY;
    }

    protected boolean getExcludeDefault() {
        return false;
    }

    protected INodeModel getAffectedNodeModel(EventInfo eventInfo) {
        INodeModel iNodeModel = this.getUiModel().getNodeModel();
        INodeModel iNodeModel2 = null;
        if (iNodeModel instanceof INodeModel) {
            iNodeModel2 = iNodeModel;
        }
        return iNodeModel2;
    }

    public CSHelpID getHelpID() {
        return null;
    }

    public void run() {
        DetailedLog detailedLog = new DetailedLog(3, this.getErrorMsg());
        List list = this.getNodeModelList();
        int n = list.size();
        int n2 = 1;
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && !this.disposed) {
            ArrayList arrayList;
            INodeModel iNodeModel = (INodeModel)iterator.next();
            WindowHelper.setLabelText((JLabel)this.watchLabel, (String)("Retrieving conditions from the node " + iNodeModel.getName() + " (" + n2 + "/" + n + ")..."));
            if (iNodeModel.isInited()) {
                try {
                    arrayList = this.filterConditions(iNodeModel.getNodeConditionList(this.excludeSuppressed));
                    this.registerNewConditions(arrayList);
                }
                catch (Exception exception) {
                    DetailedLog detailedLog2 = new DetailedLog(3, "An error occurred while retrieving conditions from the node " + iNodeModel.getName() + ".");
                    SDebug.printStackTrace((Throwable)exception);
                    detailedLog.addChild(detailedLog2);
                    detailedLog.updateTime();
                    WindowHelper.postAlert((DetailedLog)detailedLog);
                }
            } else {
                arrayList = new DetailedLog(3, "The node " + iNodeModel.getName() + " is not reachable.");
                detailedLog.addChild((DetailedLog)arrayList);
                detailedLog.updateTime();
                WindowHelper.postAlert((DetailedLog)detailedLog);
            }
            ++n2;
        }
        if (!this.disposed) {
            this.updateWatchLabel(new Date());
            WindowHelper.setEnabled((JComponent)this.watchButton, (boolean)true);
        }
    }

    private IModuleModel getModuleFromEventInfo(EventInfo eventInfo) {
        IModuleModel iModuleModel;
        block4: {
            iModuleModel = null;
            INodeModel iNodeModel = null;
            try {
                iNodeModel = this.getAffectedNodeModel(eventInfo);
                IEntityModel iEntityModel = iNodeModel.getEntityTable().getEntityModelByIndex(eventInfo.getIndex());
                iModuleModel = iEntityModel.getModuleModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                try {
                    IEntityModel iEntityModel = iNodeModel.getEntityTable().getEntityModelBySlot(eventInfo.getShelfId(), eventInfo.getSlot());
                    List list = iEntityModel.getDescendantsOfClassType(6);
                    iModuleModel = (IModuleModel)list.get(0);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException2) {
                    this.db.println("Caught " + (Object)((Object)abstractCmsNoSuchEntityException));
                    if (!this.db.on()) break block4;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        return iModuleModel;
    }
}

