/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.event;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.event.EventInfo;
import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.CardTabbedViewFactory;
import cerent.cms.ui.IViewController;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ViewName;
import cerent.cms.ui.ViewNameFactory;
import cerent.cms.ui.event.IEventPanelController;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class ShelfEventPanelController
implements IEventPanelController {
    protected AbstractViewController avc = null;

    public ShelfEventPanelController(AbstractViewController abstractViewController) {
        this.avc = abstractViewController;
    }

    public void mouseClicked(MouseEvent mouseEvent, JTable jTable, AbstractTableModel abstractTableModel) {
        NodeModelDelegate nodeModelDelegate;
        EventInfo eventInfo;
        int n;
        if (mouseEvent.getClickCount() == 2 && (n = jTable.rowAtPoint(mouseEvent.getPoint())) != -1 && (eventInfo = (EventInfo)abstractTableModel.getValueAt(n, 0)) != null && (nodeModelDelegate = this.getNode()).getConnectionState()) {
            try {
                if (!this.jumpToCardView(eventInfo, nodeModelDelegate) && !this.jumpToShelfView(eventInfo, nodeModelDelegate)) {
                    this.jumpToNodeView(eventInfo, nodeModelDelegate);
                }
            }
            catch (RuntimeException runtimeException) {
                this.avc.tryJumpView(ViewName.ROOT_VIEW);
            }
        }
    }

    protected NodeModelDelegate getNode() {
        TabbedView tabbedView = this.getParentVC().getCurrentTabbedView();
        IModel iModel = tabbedView.getUiModel();
        return (NodeModelDelegate)iModel.getNodeModel();
    }

    protected IViewController getParentVC() {
        AbstractViewController abstractViewController = this.avc;
        while (abstractViewController.getParentVC() != null) {
            abstractViewController = abstractViewController.getParentVC();
        }
        return abstractViewController;
    }

    protected boolean jumpToCardView(EventInfo eventInfo, NodeModelDelegate nodeModelDelegate) {
        if (eventInfo.getSlot() > 0) {
            try {
                IModuleModel iModuleModel;
                IEntityModel iEntityModel = nodeModelDelegate.getEntityTableModel().getEntityModelBySlot(eventInfo.getShelfId(), eventInfo.getSlot());
                if (iEntityModel != null && iEntityModel.getChildren().size() > 0 && CardTabbedViewFactory.isCardViewAvailable(iModuleModel = (IModuleModel)iEntityModel.getChildren().get(0))) {
                    ViewNameFactory viewNameFactory = new ViewNameFactory();
                    ViewName viewName = viewNameFactory.getViewName(eventInfo, nodeModelDelegate.getNodeId());
                    this.avc.tryJumpView(viewName);
                    return true;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                // empty catch block
            }
        }
        return false;
    }

    protected boolean jumpToShelfView(EventInfo eventInfo, NodeModelDelegate nodeModelDelegate) {
        int n = this.getShelf(eventInfo);
        if (n > 0) {
            ViewName viewName = new ViewName(new int[]{nodeModelDelegate.getNodeId(), eventInfo.getShelfId()});
            this.avc.tryJumpView(viewName);
            return true;
        }
        return false;
    }

    protected void jumpToNodeView(EventInfo eventInfo, NodeModelDelegate nodeModelDelegate) {
        this.avc.tryJumpView(new ViewName(nodeModelDelegate.getNodeId()));
    }

    private int getShelf(EventInfo eventInfo) {
        return eventInfo.isOnMultishelf() ? (eventInfo.isMultishelfViewCondition() ? 0 : eventInfo.getShelfId()) : 0;
    }

    public AbstractViewController getAvc() {
        return this.avc;
    }
}

