/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.fcmr;

import cerent.cms.idl.Equipment.eCardOperMode;
import cerent.cms.idl.FCMedia.eFCMediaType;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElAttributeMaps;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.FcmrLineModel;
import cerent.cms.model.FcmrModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.UnsupportedCardOperMode;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FcmrCardProvPane
extends NodeProvPane
implements ActionListener {
    private static final String warnMsg = "Changing the card mode will cause a loss of traffic while the card resets.\n\nIs it OK to continue?";
    private static final String warnTitle = "Change Mode";
    private FcmrModuleModel model;
    private JComboBox modeCB;
    private static final SDebug db = new SDebug("FcmrCardProvPane");

    public FcmrCardProvPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.registerWithModel();
        this.model = (FcmrModuleModel)this.getParentView().getUiModel();
        this.modeCB = new JComboBox<Attribute>(this.getModeChoices());
        this.modeCB.addActionListener(this);
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 3));
        jPanel.add(new JLabel("Mode: "));
        jPanel.add(this.modeCB);
        this.add((Component)new UScrollPane((Component)jPanel));
        this.enableComponent(this.modeCB);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        Attribute attribute = (Attribute)this.modeCB.getSelectedItem();
        Attribute attribute2 = ElementDefaults.getAttributeForCardOperMode(this.model, "FcmrCardMode");
        int n = attribute2.getIntValue();
        int n2 = attribute.getIntValue();
        if (object == this.modeCB) {
            if (n2 == 4 && n2 != n) {
                if (!this.isLineRateModeValid()) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FCMR_INVALID_CARD_MODE_FOR_PORT);
                    this.modeCB.setSelectedItem(attribute2);
                } else {
                    this.setDirty();
                }
            } else if (n2 == 5 && n2 != n) {
                this.setDirty();
            } else {
                this.resetDirty();
            }
        }
    }

    public void applyChangesToModel() throws Exception {
        if (db.on()) {
            db.println("applying changes to model");
        }
        Attribute attribute = ElementDefaults.getAttributeForCardOperMode(this.model, "FcmrCardMode");
        int n = attribute.getIntValue();
        String string = ErrorMsg.getString((EID)EMC.WID_CARD_MODE_CHANGE_WARNING) + "\n\nIs it OK to continue?";
        if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)string, (String)"Change Card Mode")) {
            this.modeCB.setSelectedItem(attribute);
            return;
        }
        try {
            Object object = this.modeCB.getSelectedItem();
            eCardOperMode eCardOperMode2 = eCardOperMode.from_int(((Attribute)object).getIntValue());
            this.model.setCardOperMode(eCardOperMode2);
        }
        catch (ProvisionError provisionError) {
            throw new Exception("A provisioning error occurred.");
        }
        catch (UnsupportedCardOperMode unsupportedCardOperMode) {
            throw new Exception("This mode is not supported.");
        }
        catch (ResourceInUse resourceInUse) {
            throw new Exception("Please delete circuits on the card.");
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }

    public void refreshFromModel() throws Exception {
        Attribute attribute = ElementDefaults.getAttributeForCardOperMode(this.model, "FcmrCardMode");
        this.modeCB.setSelectedItem(attribute);
    }

    private boolean isLineRateModeValid() {
        FcmrLineModel[] fcmrLineModelArray = (FcmrLineModel[])this.model.getLineModels();
        eFCMediaType eFCMediaType2 = null;
        for (int i = 0; i < fcmrLineModelArray.length; ++i) {
            block5: {
                try {
                    eFCMediaType2 = fcmrLineModelArray[i].getPortMediaTypeEnum();
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (db.on()) {
                        db.println("No such interface");
                    }
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    if (!db.on()) break block5;
                    db.println("Wrong interface");
                }
            }
            if (eFCMediaType2 == null || eFCMediaType2 != eFCMediaType.FCMR_FICON_1GIG && eFCMediaType2 != eFCMediaType.FCMR_FICON_2GIG) continue;
            return false;
        }
        return true;
    }

    public Attribute[] getModeChoices() {
        ElAttributeMaps elAttributeMaps = ElementDefaults.getAttributeMap(this.model);
        return elAttributeMaps.getAttributeArray("FcmrCardMode");
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.FcmrCardProvPane;
    }
}

