/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.functional;

import cerent.cms.fv.IFvCardModel;
import cerent.cms.fv.IFvNodeModel;
import cerent.cms.fv.IFvOpticsCardModel;
import cerent.cms.fv.IFvOpticsPortModel;
import cerent.cms.fv.IFvPortModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.WrongPortType;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.functional.FunctPortGraphic;
import cerent.cms.ui.functional.helper.MPOHelper;
import cerent.cms.ui.functional.helper.SvgFactoryDirector;
import cerent.util.gui.ActionOrganizer;
import cerent.util.gui.UPopupMenu;
import cerent.util.view.fv.GrapherViewCommand;
import cerent.util.view.fv.IFvOpenActions;
import cerent.util.view.fv.ISvgParams;
import cerent.util.view.fv.IViewGraph;
import cerent.util.view.fv.IViewSvg;
import cerent.util.view.fv.IViewSvgParamInfo;
import cerent.util.view.fv.MouseViewCommand;
import cerent.util.view.fv.ViewAttribute;
import cerent.util.view.fv.ViewGeneralCompositeGraphic;
import cerent.util.view.fv.ViewGraphLabel;
import cerent.util.view.fv.ViewGraphicSet;
import cerent.util.view.fv.ViewLabel;
import cerent.util.view.fv.ViewManager;
import cerent.util.view.fv.ViewPortGraphic;
import cerent.util.view.fv.ViewShapeInfo;
import cerent.util.view.fv.ViewSvgDecoderHelper;
import cerent.util.view.fv.helper.FunctDebug;
import cerent.util.view.fv.helper.SvgParams;
import cerent.util.view.fv.helper.SvgParamsHelper;
import ilog.views.graphic.IlvGraphicSet;
import ilog.views.graphic.IlvZoomableLabel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctBandCardGrapher
extends ViewGeneralCompositeGraphic
implements ActionListener {
    private IFvCardModel[] cardModels = new IFvCardModel[2];
    private Integer bandid = 0;
    private IViewGraph loPort;
    private IViewGraph hiPort = null;
    private ArrayList<IViewGraph> allPort;
    private ActionOrganizer actOrg = null;
    private int even;

    public FunctBandCardGrapher(SvgParams svgParams, ViewGraphicSet viewGraphicSet) {
        super((ISvgParams)svgParams, viewGraphicSet);
        this.cardModels[0] = svgParams.getCardModel();
        assert (this.cardModels[0] != null) : "null Model";
        this.cardModels[1] = svgParams.getSecondModel();
        assert (this.cardModels[1] != null) : "null Model";
        this.bandid = svgParams.getIndex();
        this.allPort = new ArrayList();
        this.initViewGraphic((IlvGraphicSet)viewGraphicSet);
        this.setName("FunctBandCardGrapher" + this.bandid);
        this.adjustLabel(viewGraphicSet);
        IFvOpticsCardModel iFvOpticsCardModel = null;
        IFvCardModel iFvCardModel = null;
        if (this.cardModels[0].isPassiveModule()) {
            iFvCardModel = this.cardModels[0];
        } else if (this.cardModels[1].isPassiveModule()) {
            iFvCardModel = this.cardModels[1];
        }
        if (iFvCardModel != null) {
            switch (iFvCardModel.getEqType()) {
                case 308: {
                    this.even = 0;
                    break;
                }
                case 309: {
                    this.even = 16;
                    break;
                }
            }
        }
        if (this.cardModels[0] instanceof IFvOpticsCardModel) {
            iFvOpticsCardModel = (IFvOpticsCardModel)this.cardModels[0];
        } else if (this.cardModels[1] instanceof IFvOpticsCardModel) {
            iFvOpticsCardModel = (IFvOpticsCardModel)this.cardModels[1];
        }
        if (iFvOpticsCardModel != null) {
            this.even = iFvOpticsCardModel.isEvenWavelengthCard() ? 16 : 0;
        }
    }

    protected boolean addPort(IViewGraph iViewGraph, IViewSvgParamInfo iViewSvgParamInfo) {
        if (iViewGraph != null && iViewGraph instanceof ViewPortGraphic) {
            this.addGraphNode((IViewGraph)((ViewPortGraphic)iViewGraph), true, IViewGraph.Layers.Port);
            return true;
        }
        return false;
    }

    public int getMinWaveLength() {
        return this.getMinWave(this.loPort);
    }

    public int getEven() {
        return this.even;
    }

    public int getMaxWaveLength() {
        return this.getMinWave(this.hiPort);
    }

    private int getMinWave(IViewGraph iViewGraph) {
        if (iViewGraph instanceof FunctPortGraphic) {
            FunctPortGraphic functPortGraphic = (FunctPortGraphic)iViewGraph;
            try {
                return functPortGraphic.getPortModel().getIFvInterfaceModel().getExpectedWaveLength();
            }
            catch (NoSuchInterface noSuchInterface) {
                FunctDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                FunctDebug.printStackTrace((Throwable)wrongInterfaceType);
                FunctDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
        return 174;
    }

    protected IViewSvg.IViewSvgEnum getGeneralType() {
        return IViewSvg.SvgGenericShape.BAND_CARD_X;
    }

    protected IViewGraph createCardPort(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
        IViewGraph iViewGraph = null;
        ViewSvgDecoderHelper.SvgTypeDirEnum svgTypeDirEnum = ((IViewSvgParamInfo)viewAttribute.getKey()).getSvgDir();
        int n = 0;
        switch (((IViewSvgParamInfo)viewAttribute.getKey()).getSvgPortTyp()) {
            case CHAN_PORT: {
                if (svgTypeDirEnum == ViewSvgDecoderHelper.SvgTypeDirEnum.RX) {
                    n = 0;
                } else if (svgTypeDirEnum == ViewSvgDecoderHelper.SvgTypeDirEnum.TX) {
                    n = 1;
                }
                switch (svgTypeDirEnum) {
                    case TX: {
                        viewAttribute.setBag(MPOHelper.getChanPortModels(this.bandid, true, this.cardModels[n], true));
                        iViewGraph = SvgFactoryDirector.getViewElem(SvgParamsHelper.getSvgChanPortParams((IViewGraph)this, (ViewManager)this.getViewManager(), viewAttribute, (IFvPortModel)SvgParamsHelper.getSvgPortModel(viewAttribute)));
                        if (iViewGraph != null && ((IViewSvgParamInfo)viewAttribute.getKey()).getSvgNumId() == 1) {
                            this.loPort = iViewGraph;
                            break;
                        }
                        if (iViewGraph == null || ((IViewSvgParamInfo)viewAttribute.getKey()).getSvgNumId() != 8) break;
                        this.hiPort = iViewGraph;
                        break;
                    }
                    case RX: {
                        viewAttribute.setBag(MPOHelper.getChanPortModels(this.bandid, false, this.cardModels[n], true));
                        iViewGraph = SvgFactoryDirector.getViewElem(SvgParamsHelper.getSvgChanPortParams((IViewGraph)this, (ViewManager)this.getViewManager(), viewAttribute, (IFvPortModel)SvgParamsHelper.getSvgPortModel(viewAttribute)));
                    }
                }
                break;
            }
            case BAND_PORT: {
                iViewGraph = SvgFactoryDirector.getViewElem(SvgParamsHelper.getSvgBandPortParams((IViewGraph)this, (ViewManager)this.getViewManager(), viewAttribute, (IFvPortModel)SvgParamsHelper.getSvgPortModel(viewAttribute)));
            }
        }
        if (iViewGraph != null) {
            this.allPort.add(iViewGraph);
        }
        return iViewGraph;
    }

    protected HashMap<Integer, IFvPortModel> getModels() {
        return MPOHelper.getChanPortModels(this.bandid, false, this.cardModels[0], true);
    }

    protected HashMap<Integer, IFvPortModel> getPortModels() {
        HashMap<Integer, IFvPortModel> hashMap = new HashMap<Integer, IFvPortModel>();
        List list = this.cardModels[0].getListOfPorts();
        for (IFvPortModel iFvPortModel : list) {
            hashMap.put(iFvPortModel.getPositionInParent(), iFvPortModel);
        }
        return hashMap;
    }

    protected void updateCardBckgInfo(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
        this.info = new ViewShapeInfo(this.cardModels[0].getIndex());
    }

    protected ViewLabel createCardLabel(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
        return (ViewGraphLabel)SvgFactoryDirector.getViewElem(SvgParamsHelper.getSvgLabelParams((IFvNodeModel)this.getViewManager().getNode(), (IViewGraph)this, viewAttribute));
    }

    public void doMouseDrag(MouseViewCommand mouseViewCommand) {
        this.info.setX(this.boundingBox().getX());
        this.info.setY(this.boundingBox().getY());
    }

    private HashMap<Integer, IFvPortModel> getChanPortModels(int n, ViewSvgDecoderHelper.SvgTypeDirEnum svgTypeDirEnum) {
        HashMap<Integer, IFvPortModel> hashMap = new HashMap<Integer, IFvPortModel>();
        int n2 = 0;
        if (svgTypeDirEnum == ViewSvgDecoderHelper.SvgTypeDirEnum.RX) {
            n2 = 1;
        } else if (svgTypeDirEnum == ViewSvgDecoderHelper.SvgTypeDirEnum.TX) {
            n2 = 0;
        }
        List list = this.cardModels[n2].getListOfPorts();
        for (IFvPortModel iFvPortModel : list) {
            if (!(iFvPortModel instanceof IFvOpticsPortModel) || !((IFvOpticsPortModel)iFvPortModel).isOchType()) continue;
            if (iFvPortModel.getPositionInParent() / 8 == n - 1) {
                int n3 = iFvPortModel.getPositionInParent() % 8;
                hashMap.put(n3, iFvPortModel);
                continue;
            }
            if (iFvPortModel.getPositionInParent() / 8 != n || iFvPortModel.getPositionInParent() % 8 != 0) continue;
            hashMap.put(8, iFvPortModel);
        }
        return hashMap;
    }

    public String getGraphKey() {
        return this.getName();
    }

    public void doAdd(GrapherViewCommand grapherViewCommand) {
    }

    public void doDelete(GrapherViewCommand grapherViewCommand) {
    }

    public void doChange(GrapherViewCommand grapherViewCommand) {
    }

    public void onInitPopupMenu(UPopupMenu uPopupMenu) {
        this.actOrg = new ActionOrganizer(this);
        this.initPopupMenu(uPopupMenu);
        this.actOrg = null;
    }

    public void doMousePopup(MouseViewCommand mouseViewCommand) {
        UPopupMenu uPopupMenu = new UPopupMenu();
        this.onInitPopupMenu(uPopupMenu);
        uPopupMenu.show((Component)mouseViewCommand.getViewManager().getViewTk(), mouseViewCommand.getEvent().getX(), mouseViewCommand.getEvent().getY());
    }

    protected void initPopupMenu(UPopupMenu uPopupMenu) {
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Open Card", 79);
    }

    public void doMouseDoubleClick(MouseViewCommand mouseViewCommand) {
        IFvOpenActions iFvOpenActions = this.getViewManager().getFVActions();
        if (iFvOpenActions != null) {
            iFvOpenActions.openCard(new int[]{this.getNodeId(), this.getShelfId(), this.getSlotId()});
        }
    }

    private void adjustLabel(ViewGraphicSet viewGraphicSet) {
        HashMap<Integer, IFvPortModel> hashMap = this.getModels();
        String string = "Unknown";
        String string2 = "N/A";
        String string3 = "N/A";
        if (hashMap.size() > 0) {
            for (int i = 1; i <= 8; ++i) {
                IFvPortModel iFvPortModel = hashMap.get(i);
                if (((IFvOpticsPortModel)iFvPortModel).isWavelengthSupported()) {
                    try {
                        int n = ((IFvOpticsPortModel)iFvPortModel).getWaveLength();
                        string = Wavelength.getWavelengthStringFromWavelength(n);
                    }
                    catch (WrongPortType wrongPortType) {
                        wrongPortType.printStackTrace();
                    }
                }
                string = string.replace("_", ".");
                if (i == 1) {
                    string2 = string;
                }
                if (i == 8) {
                    string3 = string;
                }
                ((IlvZoomableLabel)this.getObject("PORT_LABEL-" + i)).setLabel(string);
            }
        }
        viewGraphicSet.setToolTipText("MPO from " + string2 + " to " + string3);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        IFvOpenActions iFvOpenActions;
        String string = actionEvent.getActionCommand();
        if (string == "Open Card" && (iFvOpenActions = this.getViewManager().getFVActions()) != null) {
            iFvOpenActions.openCard(new int[]{this.getNodeId(), this.getShelfId(), this.getSlotId()});
        }
    }

    public int getNodeId() {
        return this.cardModels[0].getIFVNodeModel().getNodeId();
    }

    public int getShelfId() {
        if (this.cardModels[0].getIFVNodeModel().isMultishelf()) {
            return this.cardModels[0].getShelfId();
        }
        return 0;
    }

    public int getSlotId() {
        return this.cardModels[0].getSlot();
    }

    public Integer getBandid() {
        return this.bandid;
    }
}

