/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.functional;

import cerent.cms.fv.IFvCardModel;
import cerent.cms.fv.IFvNodeModel;
import cerent.cms.fv.IFvOpticsPortModel;
import cerent.cms.fv.IFvPortModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.functional.FunctBandDomainGrapher;
import cerent.cms.ui.functional.FunctDomainGrapher;
import cerent.cms.ui.functional.FunctMpoOpg;
import cerent.cms.ui.functional.FunctViewLinkHelper;
import cerent.cms.ui.functional.FunctViewPureGraphicalLink;
import cerent.cms.ui.functional.helper.MPOHelper;
import cerent.cms.ui.functional.helper.SvgFactoryDirector;
import cerent.util.gui.ActionOrganizer;
import cerent.util.gui.UPopupMenu;
import cerent.util.view.fv.ISvgParams;
import cerent.util.view.fv.IViewGraph;
import cerent.util.view.fv.IViewLink;
import cerent.util.view.fv.IViewSvg;
import cerent.util.view.fv.IViewSvgParamInfo;
import cerent.util.view.fv.MouseViewCommand;
import cerent.util.view.fv.ViewCompositeGraphic;
import cerent.util.view.fv.ViewDomainGrapher;
import cerent.util.view.fv.ViewInternalLink;
import cerent.util.view.fv.ViewPortGraphic;
import cerent.util.view.fv.ViewSvgDecoderHelper;
import cerent.util.view.fv.helper.FunctDebug;
import cerent.util.view.fv.helper.FunctDialog;
import cerent.util.view.fv.helper.FunctException;
import cerent.util.view.fv.helper.SvgParams;
import ilog.views.IlvApplyObject;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.graphlayout.IlvGraphLayoutException;
import ilog.views.graphlayout.hierarchical.IlvHierarchicalConstraint;
import ilog.views.graphlayout.hierarchical.IlvRelativePositionConstraint;
import ilog.views.graphlayout.hierarchical.IlvSameLevelConstraint;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctBandPortGraphic
extends ViewPortGraphic
implements ActionListener {
    private ActionOrganizer actOrg = null;
    private String key = "FunctBandPortGraphic" + this.getPortId();
    private int even = 0;

    public FunctBandPortGraphic(ISvgParams iSvgParams) {
        super(iSvgParams);
        this.init();
        this.initToolTip();
        if (iSvgParams.getOwner().getGraphParent() instanceof FunctDomainGrapher) {
            FunctDomainGrapher functDomainGrapher = (FunctDomainGrapher)iSvgParams.getOwner().getGraphParent();
            functDomainGrapher.addPortGraph(this);
        }
    }

    private void init() {
        if (this.getPortModel() != null) {
            boolean bl = !((IFvOpticsPortModel)this.getPortModel()).isOptPortTypeRX();
            this.opg = new FunctMpoOpg(this, this.getPortModels(bl));
        } else {
            this.opg = new FunctMpoOpg(this, this.getPortModels());
        }
    }

    public Collection<IFvPortModel> getPortModels(boolean bl) {
        boolean bl2 = true;
        try {
            HashMap<Integer, IFvPortModel> hashMap = MPOHelper.getChanPortModels(FunctBandPortGraphic.getBandfromPos(this.getPortModel().getPositionInParent(), this.getPortModel().getCardModel().isPassiveModule()), bl, this.getPortModel().getCardModel(), bl2);
            return hashMap.values();
        }
        catch (Exception exception) {
            return new HashMap().values();
        }
    }

    public Collection<IFvPortModel> getPortModels() {
        boolean bl = false;
        boolean bl2 = false;
        try {
            HashMap<Integer, IFvPortModel> hashMap = MPOHelper.getChanPortModels(FunctBandPortGraphic.getBandfromPos(this.getPortModel().getPositionInParent(), bl2), false, this.getPortModel().getCardModel(), bl);
            return hashMap.values();
        }
        catch (Exception exception) {
            return new HashMap().values();
        }
    }

    public void dispose() {
        this.key = null;
        super.dispose();
    }

    private void initToolTip() {
        super.setToolTipText(this.getPortId());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Create MPO") {
            try {
                this.doBandExpand();
            }
            catch (FunctException functException) {
                FunctDebug.printStackTrace((Throwable)functException);
            }
        }
    }

    public void onInitPopupMenu(UPopupMenu uPopupMenu) {
        this.actOrg = new ActionOrganizer(this);
        this.initPopupMenu(uPopupMenu);
        this.actOrg = null;
    }

    protected void initPopupMenu(UPopupMenu uPopupMenu) {
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Create MPO", 69);
    }

    public void doMousePopup(MouseViewCommand mouseViewCommand) {
        UPopupMenu uPopupMenu = new UPopupMenu();
        this.onInitPopupMenu(uPopupMenu);
        uPopupMenu.show((Component)mouseViewCommand.getViewManager().getViewTk(), mouseViewCommand.getEvent().getX(), mouseViewCommand.getEvent().getY());
    }

    public void doMouseDoubleClick(MouseViewCommand mouseViewCommand) {
        try {
            this.doBandExpand();
        }
        catch (FunctException functException) {
            FunctDebug.printStackTrace((Throwable)functException);
        }
        int n = FunctDialog.instance().questionFvDialog(null, "create Mpo for the other dir?", "mpo creation");
        if (n == 0) {
            // empty if block
        }
    }

    private void doBandExpand() throws FunctException {
        this.createMPODomainGrapher((ArrayList<ViewInternalLink>)null, (ArrayList<ViewInternalLink>)null, this.even);
    }

    public static int getBandfromPos(int n, boolean bl) {
        if (bl) {
            return n / 16 + (n % 16 == 0 ? 0 : 1);
        }
        return n / 8 + (n % 8 == 0 ? 0 : 1);
    }

    private void getTxpList(ArrayList<ViewInternalLink> arrayList, ArrayList<ViewInternalLink> arrayList2, int n) throws FunctException {
        Iterator<ViewInternalLink> iterator = arrayList.iterator();
        IFvPortModel iFvPortModel = null;
        int n2 = 0;
        while (iterator.hasNext()) {
            int n3;
            ViewInternalLink viewInternalLink = iterator.next();
            iFvPortModel = viewInternalLink.getOptPort();
            if (iFvPortModel == null || (n3 = FunctBandPortGraphic.getBandfromPos(iFvPortModel.getPositionInParent(), iFvPortModel.getCardModel().isPassiveModule())) < 1) continue;
            if (viewInternalLink.isPassiveLnk()) {
                IFvCardModel iFvCardModel = null;
                iFvCardModel = iFvPortModel.getCardModel();
                switch (iFvCardModel.getEqType()) {
                    case 308: {
                        n2 = 0;
                        break;
                    }
                    case 309: {
                        n2 = 16;
                        break;
                    }
                    default: {
                        throw new FunctException("Passive link without chianti card");
                    }
                }
            } else {
                try {
                    int n4 = iFvPortModel.getIFvInterfaceModel().getExpectedWaveLength();
                    n2 = Wavelength.isEvenLambda(new Attribute("", n4)) ? 16 : 0;
                }
                catch (NoSuchInterface noSuchInterface) {
                    noSuchInterface.printStackTrace();
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    wrongInterfaceType.printStackTrace();
                }
            }
            if (n != n2) continue;
            arrayList2.add(viewInternalLink);
        }
    }

    public FunctBandDomainGrapher createMPODomainGrapher(ArrayList<ViewInternalLink> arrayList, ArrayList<ViewInternalLink> arrayList2, int n) throws FunctException {
        ArrayList<ViewInternalLink> arrayList3 = new ArrayList<ViewInternalLink>();
        ArrayList<ViewInternalLink> arrayList4 = new ArrayList<ViewInternalLink>();
        this.getTxpList(arrayList, arrayList3, n);
        this.getTxpList(arrayList2, arrayList4, n);
        FunctBandDomainGrapher functBandDomainGrapher = null;
        if (arrayList3.size() != 0 && arrayList4.size() != 0) {
            functBandDomainGrapher = this.createMPODomainGrapher(arrayList3.get(0).getOptPort().getCardModel(), arrayList4.get(0).getOptPort().getCardModel(), n);
            functBandDomainGrapher.updateBandCards(arrayList4, arrayList3);
            try {
                functBandDomainGrapher.getLayout().performLayout(true, true, true);
            }
            catch (IlvGraphLayoutException ilvGraphLayoutException) {
                FunctDebug.printStackTrace((Throwable)ilvGraphLayoutException);
            }
        }
        return functBandDomainGrapher;
    }

    public FunctBandDomainGrapher createMPODomainGrapher(IFvCardModel iFvCardModel, IFvCardModel iFvCardModel2, int n) {
        FunctBandDomainGrapher functBandDomainGrapher = null;
        SvgParams svgParams = null;
        try {
            svgParams = this.getBandParams(iFvCardModel);
            svgParams.secondModel = iFvCardModel2;
            functBandDomainGrapher = SvgFactoryDirector.createBandDomanin(svgParams, n);
            IlvGraphicBag ilvGraphicBag = functBandDomainGrapher.getGraphicBag();
            if (ilvGraphicBag == null) {
                functBandDomainGrapher.setCollapsed(true);
            } else {
                ilvGraphicBag.applyToObject((IlvGraphic)functBandDomainGrapher, new IlvApplyObject(){

                    public void apply(IlvGraphic ilvGraphic, Object object) {
                        ((IlvGrapher)object).setCollapsed(true);
                    }
                }, (Object)functBandDomainGrapher, false);
            }
            this.even = n;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return functBandDomainGrapher;
    }

    private SvgParams getBandParams(IFvCardModel iFvCardModel) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        SvgParams svgParams = new SvgParams();
        svgParams.nm = this.getNm();
        svgParams.vm = this.getManager();
        svgParams.svgType = IViewSvg.SvgGenericShape.BAND_SIDE.ordinal();
        svgParams.cardModel = iFvCardModel;
        svgParams.owner = this.getGraphParent().getGraphParent();
        svgParams.parent = this.getGraphParent().getGraphParent();
        svgParams.paramBag = ((IFvOpticsPortModel)this.getPortModel()).getSide();
        svgParams.layer = IViewGraph.Layers.Mpo;
        return svgParams;
    }

    public FunctViewPureGraphicalLink createPortMpoLink(FunctBandDomainGrapher functBandDomainGrapher, ArrayList<ViewInternalLink> arrayList) {
        FunctViewPureGraphicalLink functViewPureGraphicalLink;
        IViewGraph iViewGraph;
        FunctBandPortGraphic functBandPortGraphic;
        ViewCompositeGraphic viewCompositeGraphic;
        FunctBandPortGraphic functBandPortGraphic2;
        ViewCompositeGraphic viewCompositeGraphic2;
        IFvPortModel iFvPortModel = this.getPortModel();
        int n = MPOHelper.mpoNumberFromPort(iFvPortModel.getPositionInParent(), iFvPortModel.getCardModel()) + 1;
        if (this.key.indexOf("RX") >= 0) {
            viewCompositeGraphic2 = (ViewCompositeGraphic)functBandDomainGrapher.getGraphChildren().get("FunctBandCardGrapher" + n);
            functBandPortGraphic2 = (ViewPortGraphic)viewCompositeGraphic2.getGraphChildren().get("FunctBandPortGraphicCARD_PORT-BAND-1-TX");
            viewCompositeGraphic = (ViewCompositeGraphic)this.getGraphParent();
            functBandPortGraphic = this;
            iViewGraph = viewCompositeGraphic.getParams().getParent();
        } else {
            viewCompositeGraphic2 = (ViewCompositeGraphic)this.getGraphParent();
            functBandPortGraphic2 = this;
            viewCompositeGraphic = (ViewCompositeGraphic)functBandDomainGrapher.getGraphChildren().get("FunctBandCardGrapher" + n);
            functBandPortGraphic = (ViewPortGraphic)viewCompositeGraphic.getGraphChildren().get("FunctBandPortGraphicCARD_PORT-BAND-1-RX");
            iViewGraph = viewCompositeGraphic2.getParams().getParent();
            ((ViewDomainGrapher)iViewGraph).getLayout().getNodeLayout().addConstraint((IlvHierarchicalConstraint)new IlvSameLevelConstraint((Object)functBandDomainGrapher, (Object)viewCompositeGraphic2));
        }
        if (functBandDomainGrapher.getEven() == 0) {
            ((ViewDomainGrapher)iViewGraph).getLayout().getNodeLayout().addConstraint((IlvHierarchicalConstraint)new IlvRelativePositionConstraint((Object)functBandDomainGrapher, (Object)viewCompositeGraphic2, 1.0f));
        } else {
            ((ViewDomainGrapher)iViewGraph).getLayout().getNodeLayout().addConstraint((IlvHierarchicalConstraint)new IlvRelativePositionConstraint((Object)viewCompositeGraphic2, (Object)functBandDomainGrapher, 1.0f));
        }
        IFvNodeModel iFvNodeModel = viewCompositeGraphic2.getNode();
        if (iFvNodeModel == null) {
            iFvNodeModel = viewCompositeGraphic.getNode();
        }
        if ((functViewPureGraphicalLink = FunctViewLinkHelper.createPortMpoLink((IViewGraph)viewCompositeGraphic2, (IViewGraph)functBandPortGraphic2, (IViewGraph)viewCompositeGraphic, (IViewGraph)functBandPortGraphic, this.getToolKit(), false, iFvNodeModel)) != null) {
            if (iViewGraph instanceof ViewDomainGrapher) {
                try {
                    ((ViewDomainGrapher)iViewGraph).connectPorts(viewCompositeGraphic2, (ViewPortGraphic)functBandPortGraphic2, viewCompositeGraphic, (ViewPortGraphic)functBandPortGraphic, (IViewLink)functViewPureGraphicalLink);
                }
                catch (FunctException functException) {
                    FunctDebug.printStackTrace((Throwable)functException);
                }
            }
            return functViewPureGraphicalLink;
        }
        return null;
    }

    public String getGraphKey() {
        return this.key;
    }

    public HashMap<String, IViewGraph> getGraphChildren() {
        return null;
    }

    public int compareTo(Object object) {
        return ((IViewGraph)object).getGraphKey().compareTo(this.getGraphKey());
    }

    public ViewSvgDecoderHelper.SvgTypeEnum getType() {
        return null;
    }

    public void setPos(Rectangle2D rectangle2D) {
    }

    public ViewSvgDecoderHelper.SvgTypeDirEnum getSvgDir() {
        if (this.getParams().getParamBag() instanceof IViewSvgParamInfo) {
            IViewSvgParamInfo iViewSvgParamInfo = (IViewSvgParamInfo)this.getParams().getParamBag();
            return iViewSvgParamInfo.getSvgDir();
        }
        return ViewSvgDecoderHelper.SvgTypeDirEnum.UNK;
    }

    public boolean hasIndex(int n) {
        Collection<IFvPortModel> collection = this.getPortModels();
        for (IFvPortModel iFvPortModel : collection) {
            if (iFvPortModel.getIndex() != n) continue;
            return true;
        }
        return false;
    }
}

