/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.functional;

import cerent.cms.fv.IFvAlarmStatus;
import cerent.cms.fv.IFvAlarmStore;
import cerent.cms.fv.IFvCardModel;
import cerent.cms.fv.IFvInterfaceModel;
import cerent.cms.fv.IFvNodeModel;
import cerent.cms.fv.IFvOpticsCardModel;
import cerent.cms.fv.IFvOpticsPortModel;
import cerent.cms.fv.IFvPortModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.functional.FunctBandDomainGrapher;
import cerent.cms.ui.functional.FunctBandPortGraphic;
import cerent.cms.ui.functional.FunctDomainGrapher;
import cerent.cms.ui.functional.FunctPSMCardGrapher;
import cerent.cms.ui.functional.FunctPortGraphic;
import cerent.cms.ui.functional.helper.MPOHelper;
import cerent.cms.ui.functional.helper.SvgFactoryDirector;
import cerent.util.gui.ActionOrganizer;
import cerent.util.gui.UPopupMenu;
import cerent.util.view.fv.GrapherViewCommand;
import cerent.util.view.fv.IFvOpenActions;
import cerent.util.view.fv.ISvgParams;
import cerent.util.view.fv.IViewGraph;
import cerent.util.view.fv.IViewShapeInfo;
import cerent.util.view.fv.IViewSvgParamInfo;
import cerent.util.view.fv.MouseViewCommand;
import cerent.util.view.fv.ViewAttribute;
import cerent.util.view.fv.ViewCardGrapher;
import cerent.util.view.fv.ViewCompositeGraphic;
import cerent.util.view.fv.ViewDwdmSide;
import cerent.util.view.fv.ViewGraphLabel;
import cerent.util.view.fv.ViewGraphic;
import cerent.util.view.fv.ViewGraphicSet;
import cerent.util.view.fv.ViewInternalLink;
import cerent.util.view.fv.ViewManager;
import cerent.util.view.fv.ViewManagerToolKit;
import cerent.util.view.fv.ViewPin;
import cerent.util.view.fv.ViewPortGraphic;
import cerent.util.view.fv.ViewShapeInfo;
import cerent.util.view.fv.ViewSvgDecoderHelper;
import cerent.util.view.fv.ViewZoomLabel;
import cerent.util.view.fv.helper.FunctDebug;
import cerent.util.view.fv.helper.IFunctGraphic;
import cerent.util.view.fv.helper.OpticalPatchCord;
import cerent.util.view.fv.helper.SvgColorHelper;
import cerent.util.view.fv.helper.SvgParams;
import cerent.util.view.fv.helper.SvgParamsHelper;
import cerent.util.view.fv.helper.ViewModelUpdateType;
import ilog.views.IlvGraphic;
import ilog.views.graphic.IlvGraphicSet;
import ilog.views.graphic.IlvZoomableLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctCardGrapher
extends ViewCardGrapher
implements ActionListener,
Observer {
    private String cardId = null;
    protected IFvAlarmStore alarmStore;
    protected int eqState;
    protected Color currentColor = Color.white;
    protected IFvAlarmStatus alarmStatus;
    private ActionOrganizer actOrg = null;
    protected int state;
    protected boolean DCUConnected = false;
    private List<ViewPortGraphic> paintedPorts;

    public FunctCardGrapher(SvgParams svgParams, ViewGraphicSet viewGraphicSet) {
        super((ISvgParams)svgParams, viewGraphicSet);
        IFvOpticsCardModel iFvOpticsCardModel;
        if (this.card instanceof IFvOpticsCardModel && (iFvOpticsCardModel = (IFvOpticsCardModel)this.card).isEvenWavelengthCard()) {
            this.getViewManager().setNodeEven(true);
        }
        try {
            this.initViewGraphic((IlvGraphicSet)viewGraphicSet);
            db = FunctDebug.instance().addChild("FunctCardGrapher", "Dump the info related to Domain Info");
            this.initialize();
        }
        catch (RuntimeException runtimeException) {
            FunctDebug.printStackTrace((Throwable)runtimeException);
        }
        this.paintedPorts = new ArrayList<ViewPortGraphic>();
    }

    private void initialize() {
        this.getCardModel().addObserver((Observer)this);
        IFvAlarmStore iFvAlarmStore = this.getViewManager().getNodeModel().getIFvAlarmStore();
        if (iFvAlarmStore != null) {
            this.alarmStore = iFvAlarmStore.getIFvCardAlarmStore(this.card.getShelfId(), this.card.getSlot());
            this.alarmStore.addAlarmStatusObserver((Observer)this);
            this.alarmStore.enablePortAlarmsStatus(this.card);
        } else {
            this.alarmStore = null;
        }
        this.initPortColor();
        this.setCardAlarmColor();
        this.initCardLabel();
    }

    private void initPortColor() {
        if (this.alarmStore != null) {
            Collection collection = this.getGraphChildren().values();
            for (IViewGraph iViewGraph : collection) {
                if (!(iViewGraph instanceof ViewPortGraphic)) continue;
                ViewPortGraphic viewPortGraphic = (ViewPortGraphic)iViewGraph;
                viewPortGraphic.initAlarm();
            }
        }
    }

    private void initCardLabel() {
        if (this.getCardModel().getEqType() == 134 || this.getCardModel().getEqType() == 135 || this.getCardModel().getEqType() == 136) {
            List list = this.card.getListOfPorts();
            for (IFvPortModel iFvPortModel : list) {
                if (!(iFvPortModel instanceof IFvOpticsPortModel)) continue;
                IFvInterfaceModel iFvInterfaceModel = iFvPortModel.getIFvInterfaceModel();
                try {
                    int n = iFvInterfaceModel.getExpectedWaveLength();
                    if (this.getObject(ViewSvgDecoderHelper.SvgTypeEnum.CARD_EXTRA_LABEL.toString()) == null) continue;
                    ViewZoomLabel viewZoomLabel = new ViewZoomLabel((Object)this.getObject(ViewSvgDecoderHelper.SvgTypeEnum.CARD_EXTRA_LABEL.toString()));
                    Attribute attribute = Wavelength.getWlAttribute(n);
                    String string = " (" + attribute + ")";
                    viewZoomLabel.setLabel(string);
                    this.setLabel(ViewSvgDecoderHelper.SvgTypeEnum.CARD_EXTRA_LABEL.toString(), string);
                    break;
                }
                catch (NoSuchInterface noSuchInterface) {
                    FunctDebug.printStackTrace((Throwable)noSuchInterface);
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    FunctDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
        }
    }

    private void updateCurrentColor() {
        block8: {
            try {
                if (this.getCardModel().getEqType() == 95) {
                    this.currentColor = SvgParamsHelper.getSvgColor((int)8);
                    return;
                }
                if (this.getCardModel().isInMT()) {
                    this.currentColor = SvgParamsHelper.getSvgColor((int)12);
                    return;
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block8;
                db.println("Caught " + exception + " in setCardColor");
            }
        }
        this.state = this.eqState;
        if (this.state == -1) {
            return;
        }
        try {
            this.currentColor = this.getCardModel().setStateColor(this.currentColor, this.state);
            if (this.state != 6) {
                IFvAlarmStatus iFvAlarmStatus = this.getAlarmStatus();
                this.currentColor = this.getCardModel().setAlarmColor(iFvAlarmStatus, this.currentColor, this.state);
            }
        }
        catch (Exception exception) {
            db.println("Caught " + exception + " in setCardColor");
            FunctDebug.printStackTrace((Throwable)exception);
        }
    }

    protected IFvAlarmStatus getAlarmStatus() {
        if (this.alarmStatus == null && this.alarmStore != null) {
            this.alarmStatus = this.alarmStore.getAlarmStatus();
        }
        return this.alarmStatus;
    }

    private synchronized void setState() {
        try {
            if (this.getCardModel() instanceof IFvCardModel) {
                this.eqState = this.getCardModel().getEqState();
            }
        }
        catch (Exception exception) {
            FunctDebug.printStackTrace((Throwable)exception);
        }
    }

    public boolean isDCUConnected() {
        return this.DCUConnected;
    }

    public int getEntityIndex() {
        return this.card.getIndex();
    }

    public int getNodeId() {
        return this.card.getIFVNodeModel().getNodeId();
    }

    public int getShelfId() {
        return this.card.getShelfId();
    }

    public int getShelfIdForOpenCard() {
        if (this.card.getIFVNodeModel().isMultishelf()) {
            return this.card.getShelfId();
        }
        return 0;
    }

    public int getSlotId() {
        return this.card.getSlot();
    }

    public IViewShapeInfo getInfo() {
        return this.info;
    }

    public String getGraphName() {
        return this.getcardName();
    }

    protected void createCardNameLabel(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
        ViewZoomLabel viewZoomLabel = (ViewZoomLabel)SvgFactoryDirector.getViewElem(SvgParamsHelper.getSvgZoomLabelParams((IFvNodeModel)this.getViewManager().getNode(), (IViewGraph)this, viewAttribute));
        this.setLabel(viewZoomLabel.getName(), this.getShortName());
    }

    protected void createCardExtraLabel(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
        ViewZoomLabel viewZoomLabel = (ViewZoomLabel)SvgFactoryDirector.getViewElem(SvgParamsHelper.getSvgZoomLabelParams((IFvNodeModel)this.getViewManager().getNode(), (IViewGraph)this, viewAttribute));
        this.setLabel(viewZoomLabel.getName(), this.getShortName());
    }

    protected ViewGraphLabel createCardLabel(ViewAttribute viewAttribute) throws Exception {
        return (ViewGraphLabel)SvgFactoryDirector.getViewElem(SvgParamsHelper.getSvgLabelParams((IFvNodeModel)this.getViewManager().getNode(), (IViewGraph)this, (ViewAttribute)viewAttribute));
    }

    protected void createExtraIcon(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
        this.extraIcon = new ViewGraphic(viewAttribute.getValue());
    }

    protected IViewGraph createBandPort(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
        IViewGraph iViewGraph = null;
        int n = ((IViewSvgParamInfo)viewAttribute.getKey()).getSvgNumId();
        boolean bl = false;
        switch (((IViewSvgParamInfo)viewAttribute.getKey()).getSvgDir()) {
            case TX: {
                bl = true;
                break;
            }
            case RX: {
                bl = false;
                break;
            }
        }
        viewAttribute.setBag(MPOHelper.getChanPortModels(n, bl, this.getCardModel(), true));
        iViewGraph = SvgFactoryDirector.getViewElem(SvgParamsHelper.getSvgBandPortParams((IViewGraph)this, (ViewManager)this.getViewManager(), viewAttribute, (IFvPortModel)SvgParamsHelper.getSvgPortModelFromBandId(viewAttribute, (int)n)));
        return iViewGraph;
    }

    protected IViewGraph createGenericPort(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
        return SvgFactoryDirector.getViewElem(SvgParamsHelper.getSvgGenericPortParams((IViewGraph)this, (ViewManager)this.getViewManager(), viewAttribute, (IFvPortModel)SvgParamsHelper.getSvgPortModel(viewAttribute)));
    }

    protected IViewGraph createMpoPort(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
        return SvgFactoryDirector.getViewElem(SvgParamsHelper.getSvgMPOPortParams((IViewGraph)this, (ViewManager)this.getViewManager(), viewAttribute, (IFvPortModel)SvgParamsHelper.getSvgPortModel(viewAttribute)));
    }

    protected void updateCardBckgInfo(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
        ViewShapeInfo viewShapeInfo = new ViewShapeInfo(this.getEntityIndex());
        if (this.getOwner() instanceof FunctDomainGrapher) {
            viewShapeInfo.setSide(((FunctDomainGrapher)this.getOwner()).getSideModel().getNameLabel());
        }
        this.info = viewShapeInfo;
    }

    protected HashMap<Integer, IFvPortModel> getModels() {
        return this.getPortModels();
    }

    protected HashMap<Integer, IFvPortModel> getPortModels() {
        HashMap<Integer, IFvPortModel> hashMap = new HashMap<Integer, IFvPortModel>();
        List list = this.card.getListOfPorts();
        for (IFvPortModel iFvPortModel : list) {
            hashMap.put(iFvPortModel.getPositionInParent(), iFvPortModel);
        }
        return hashMap;
    }

    public void onInitPopupMenu(UPopupMenu uPopupMenu) {
        this.actOrg = new ActionOrganizer(this);
        this.initPopupMenu(uPopupMenu);
        this.actOrg = null;
    }

    public void onInitPopupMenuDbg(UPopupMenu uPopupMenu) {
        this.actOrg = new ActionOrganizer(this);
        this.initPopupMenuDbg(uPopupMenu);
        this.actOrg = null;
    }

    protected void initPopupMenu(UPopupMenu uPopupMenu) {
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Open Card", 79);
    }

    protected void initPopupMenuDbg(UPopupMenu uPopupMenu) {
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Rotate Left", 76);
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Rotate Right", 82);
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Horizontal flip", 72);
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Vertical flip", 86);
    }

    public int getNumberOfPorts() {
        return this.getGraphChildren().size();
    }

    public String getId() {
        return this.cardId;
    }

    public String getType() {
        return "CARD";
    }

    public IFunctGraphic getGraphicParent() {
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Rotate Left") {
            this.doRotateL();
        } else if (string == "Rotate Right") {
            this.doRotateR();
        } else if (string == "Horizontal flip") {
            this.doFlipH();
        } else if (string == "Vertical flip") {
            this.doFlipV();
        } else if (string == "Delete") {
            this.doDelete();
        } else if (string == "Open Card") {
            this.openCard();
        }
    }

    private void doRotateL() {
        ((ViewShapeInfo)this.info).decAngle();
        this.doshapeRotate(new Double(-90.0));
    }

    private void doRotateR() {
        ((ViewShapeInfo)this.info).incAngle();
        this.doshapeRotate(new Double(90.0));
    }

    private void doDelete() {
        this.getTk().delCard((IViewGraph)this);
    }

    public void doMouseDoubleClick(MouseViewCommand mouseViewCommand) {
        if (db.on()) {
            db.println("doMouseDoubleClick");
        }
        this.openCard();
    }

    public void doMousePopup(MouseViewCommand mouseViewCommand) {
        UPopupMenu uPopupMenu = new UPopupMenu();
        this.onInitPopupMenu(uPopupMenu);
        if (mouseViewCommand.getKeyIntValue() == 8) {
            this.onInitPopupMenuDbg(uPopupMenu);
        }
        uPopupMenu.show((Component)mouseViewCommand.getViewManager().getViewTk(), mouseViewCommand.getEvent().getX(), mouseViewCommand.getEvent().getY());
    }

    public void doMouseUpdate(MouseViewCommand mouseViewCommand) {
    }

    public void doMouseClick(MouseViewCommand mouseViewCommand) {
        if (db.on()) {
            db.println("doMouseClick");
        }
    }

    public void doAdd(GrapherViewCommand grapherViewCommand) {
    }

    public void doDelete(GrapherViewCommand grapherViewCommand) {
    }

    public void doChange(GrapherViewCommand grapherViewCommand) {
    }

    public void dumpCardInfo() {
        if (this.info != null && db.on()) {
            db.println("card: " + this.getToolTipText() + " X=" + this.info.getX() + " Y=" + this.info.getY() + " angle=" + this.info.getAngle() + " CenterX=" + this.info.getCenterX() + " CenterY=" + this.info.getCenterY() + " getFlipH=" + this.info.getFlipH() + " getFlipV=" + this.info.getFlipV());
        }
    }

    public void doMouseDrag(MouseViewCommand mouseViewCommand) {
        this.info.setX(this.boundingBox().getX());
        this.info.setY(this.boundingBox().getY());
    }

    public ViewZoomLabel getlabel() {
        if (this.getParams().getOwner() != null && this.getParams().getOwner().getGraphChildren().containsKey(ViewManager.getCardLabelKey((ViewCompositeGraphic)this))) {
            return (ViewZoomLabel)this.getParams().getOwner().getGraphChildren().get(ViewManager.getCardLabelKey((ViewCompositeGraphic)this));
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        if (this.card != null) {
            this.card.deleteObserver((Observer)this);
        }
        if (this.alarmStore != null) {
            this.alarmStore.deleteAlarmStatusObserver((Observer)this);
        }
        this.alarmStore = null;
        this.currentColor = null;
        this.alarmStatus = null;
        this.eqState = 0;
        this.card = null;
        this.cardId = null;
        this.actOrg = null;
    }

    public int compareTo(Object object) {
        return ((IViewGraph)object).getGraphKey().compareTo(this.getGraphKey());
    }

    @Override
    public void update(Observable observable, Object object) {
        Integer n;
        if (object instanceof IFvAlarmStatus) {
            this.setCardAlarmColor();
        } else if (object instanceof Integer && (n = (Integer)object).equals(ViewModelUpdateType.DELETED)) {
            this.doDelete();
        }
    }

    public void setCardAlarmColor() {
        this.setState();
        this.updateCurrentColor();
        this.setAlarmColor(this.currentColor);
    }

    public void setDCUConnected() {
        this.DCUConnected = true;
    }

    protected void openCard() {
        IFvOpenActions iFvOpenActions = this.getViewManager().getFVActions();
        if (iFvOpenActions != null) {
            iFvOpenActions.openCard(new int[]{this.getNodeId(), this.getShelfIdForOpenCard(), this.getSlotId()});
        }
    }

    protected void addPinToGrapher(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute, ViewPin viewPin) {
        ViewManagerToolKit viewManagerToolKit = this.getViewManager().getViewTk();
        String string = ((IViewSvgParamInfo)viewAttribute.getKey()).getSvgPortTyp().toString() + "-" + ((IViewSvgParamInfo)viewAttribute.getKey()).getSvgNumId() + "-" + ((IViewSvgParamInfo)viewAttribute.getKey()).getSvgDir().toString();
        Collection collection = this.getGraphChildren().values();
        for (IViewGraph iViewGraph : collection) {
            int n;
            FunctBandPortGraphic functBandPortGraphic;
            if (!iViewGraph.getGraphName().contains(string)) continue;
            if (iViewGraph instanceof FunctBandPortGraphic) {
                functBandPortGraphic = (FunctBandPortGraphic)iViewGraph;
                n = ((IFvOpticsPortModel)functBandPortGraphic.getPortModel()).isOptPortTypeRX() ? 0 : 1;
                Collection<IFvPortModel> collection2 = functBandPortGraphic.getPortModels(n != 0);
                for (IFvPortModel iFvPortModel : collection2) {
                    viewManagerToolKit.addPin(iFvPortModel.getIndex(), viewPin);
                }
                continue;
            }
            if (this.getCardModel().isTxp()) {
                Object object;
                functBandPortGraphic = (ViewPortGraphic)iViewGraph;
                n = functBandPortGraphic.getPortModel().getIndex();
                int n2 = 0;
                try {
                    object = functBandPortGraphic.getPortModel().getCardModel().getAllOpticalPatchCords();
                    for (int i = 0; i < ((OpticalPatchCord[])object).length; ++i) {
                        IFvPortModel iFvPortModel;
                        IFvCardModel iFvCardModel = null;
                        if (object[i].from == n) {
                            iFvPortModel = functBandPortGraphic.getPortModel();
                            if (iFvPortModel.getIFVNextPorts(false).size() > 0) {
                                iFvCardModel = ((IFvPortModel)iFvPortModel.getIFVNextPorts(false).get(0)).getCardModel();
                            }
                            if (iFvCardModel != null) {
                                n2 = iFvCardModel.getSide();
                                continue;
                            }
                        }
                        if (((OpticalPatchCord)object[i]).to != n) continue;
                        iFvPortModel = functBandPortGraphic.getPortModel();
                        if (iFvPortModel.getIFVPrevPorts(false).size() > 0) {
                            iFvCardModel = ((IFvPortModel)iFvPortModel.getIFVPrevPorts(false).get(0)).getCardModel();
                        }
                        if (iFvCardModel == null) continue;
                        n2 = iFvCardModel.getSide();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
                catch (FeatureUnsupported featureUnsupported) {
                    featureUnsupported.printStackTrace();
                }
                catch (NoSuchInterface noSuchInterface) {
                    noSuchInterface.printStackTrace();
                }
                object = null;
                if (this.getGraphParent() instanceof FunctDomainGrapher) {
                    object = (FunctDomainGrapher)this.getGraphParent();
                } else if (this.getGraphParent() instanceof FunctBandDomainGrapher) {
                    object = (FunctDomainGrapher)this.getGraphParent().getGraphParent();
                }
                if (object == null || ((FunctDomainGrapher)object).getSideId() != n2) continue;
                viewManagerToolKit.addPin(n, viewPin);
                continue;
            }
            if (!(iViewGraph instanceof ViewPortGraphic)) continue;
            functBandPortGraphic = (ViewPortGraphic)iViewGraph;
            n = functBandPortGraphic.getPortModel().getIndex();
            viewManagerToolKit.addPin(n, viewPin);
        }
    }

    public void setCardinCircuit(boolean bl, int n) {
        if (!bl) {
            this.setState();
            this.updateCurrentColor();
            Iterator<ViewPortGraphic> iterator = this.paintedPorts.iterator();
            while (iterator.hasNext()) {
                iterator.next().repaint();
            }
            this.paintedPorts.clear();
        } else {
            Color color;
            if (n == -1) {
                color = SvgColorHelper.NEUTRAL_ALARM_COLOR;
            } else {
                switch (n) {
                    case 4: {
                        color = SvgParamsHelper.getSvgColor((int)9);
                        break;
                    }
                    case 3: {
                        color = SvgParamsHelper.getSvgColor((int)10);
                        break;
                    }
                    case 2: {
                        color = SvgParamsHelper.getSvgColor((int)11);
                        break;
                    }
                    default: {
                        color = SvgColorHelper.NEUTRAL_ALARM_COLOR;
                    }
                }
            }
            this.currentColor = color;
        }
        this.setAlarmColor(this.currentColor);
        if (bl && this.currentColor == SvgColorHelper.NEUTRAL_ALARM_COLOR) {
            this.paintAllPorts(this.currentColor);
        }
    }

    private void paintAllPorts(Color color) {
        Collection collection = this.getGraphChildren().values();
        for (IViewGraph iViewGraph : collection) {
            if (!(iViewGraph instanceof ViewPortGraphic)) continue;
            ViewPortGraphic viewPortGraphic = (ViewPortGraphic)iViewGraph;
            viewPortGraphic.setAlarmColor(color);
            this.paintedPorts.add(viewPortGraphic);
        }
    }

    protected void updateSideLabel(String string) {
        IlvGraphic ilvGraphic = this.getObject("SIDE_LABEL-1");
        if (ilvGraphic != null && ilvGraphic instanceof IlvZoomableLabel) {
            ((IlvZoomableLabel)ilvGraphic).setLabel(string);
        }
    }

    protected ViewInternalLink findOtherSideLink() {
        int n = 0;
        if (this.getObject("SIDE_LABEL-1") != null) {
            FunctPortGraphic functPortGraphic;
            for (Object object2 : this.getGraphChildren().values()) {
                if (!(object2 instanceof FunctPortGraphic) || (functPortGraphic = (FunctPortGraphic)((Object)object2)).hasLinks() != 0 || !functPortGraphic.isVisible()) continue;
                n = functPortGraphic.getPortModel().getIndex();
                break;
            }
            if (n != 0) {
                Object object;
                Object object2;
                if (this instanceof FunctPSMCardGrapher) {
                    this.getViewManager();
                    object = ViewManager.getPsmLinks((ArrayList)this.getViewManager().getNodeLinks());
                } else {
                    this.getViewManager();
                    object = ViewManager.getTxpLinks((ArrayList)this.getViewManager().getNodeLinks());
                }
                object2 = ((ArrayList)object).iterator();
                while (object2.hasNext()) {
                    functPortGraphic = (ViewInternalLink)object2.next();
                    if (functPortGraphic.getDwdmPort().getIndex() != n) continue;
                    return functPortGraphic;
                }
            }
        }
        return null;
    }

    public void refineTxpInit() {
        ViewInternalLink viewInternalLink = this.findOtherSideLink();
        if (viewInternalLink != null) {
            int n = viewInternalLink.getLinkSide();
            this.updateSideLabel("Peer Side " + ViewDwdmSide.getSideFromOffset((int)n));
        } else {
            this.updateSideLabel("Peer Side not connected");
        }
    }
}

