/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.functional;

import cerent.cms.fv.IFvCardModel;
import cerent.cms.fv.IFvNodeModel;
import cerent.cms.ui.functional.helper.SvgFactoryDirector;
import cerent.util.gui.ActionOrganizer;
import cerent.util.gui.UPopupMenu;
import cerent.util.view.fv.GrapherViewCommand;
import cerent.util.view.fv.ISvgParams;
import cerent.util.view.fv.IViewGraph;
import cerent.util.view.fv.IViewLink;
import cerent.util.view.fv.IViewSvg;
import cerent.util.view.fv.MouseViewCommand;
import cerent.util.view.fv.ViewAttribute;
import cerent.util.view.fv.ViewDomainGrapher;
import cerent.util.view.fv.ViewGraphLabel;
import cerent.util.view.fv.ViewGrapher;
import cerent.util.view.fv.ViewGraphicSet;
import cerent.util.view.fv.ViewInternalLink;
import cerent.util.view.fv.ViewPortGraphic;
import cerent.util.view.fv.ViewShapeInfo;
import cerent.util.view.fv.helper.FunctDebug;
import cerent.util.view.fv.helper.FunctException;
import cerent.util.view.fv.helper.SvgParams;
import cerent.util.view.fv.helper.SvgParamsHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctCliDomainGrapher
extends ViewDomainGrapher
implements ActionListener {
    private ViewGraphLabel label = null;
    private Integer bandid = 0;
    protected ActionOrganizer actOrg = null;
    private IFvCardModel model = null;

    public FunctCliDomainGrapher(SvgParams svgParams, ViewGraphicSet viewGraphicSet) {
        super((ISvgParams)svgParams);
        this.model = svgParams.getCardModel();
    }

    protected void init(SvgParams svgParams, Object object) {
        super.init();
        if (svgParams.getParamBag() instanceof Integer) {
            this.bandid = (Integer)svgParams.getParamBag();
        }
        this.initViewGraphic(object);
        this.initBandCards();
    }

    public void dispose() {
        this.model = null;
        this.label = null;
        this.actOrg = null;
        super.dispose();
    }

    private void initBandCards() {
        this.addBandGrapher(this.model, "todoxx");
    }

    private void addBandGrapher(IFvCardModel iFvCardModel, String string) {
        IViewGraph iViewGraph = null;
        try {
            SvgParams svgParams = new SvgParams(this.getViewManager().getNode(), this.getViewManager(), IViewSvg.SvgGenericShape.BAND_CARD_X.ordinal(), (IViewGraph)this, (Object)string, (Object)iFvCardModel, IViewGraph.Layers.Card);
            iViewGraph = SvgFactoryDirector.getDefaultViewElem(svgParams);
        }
        catch (FunctException functException) {
            FunctDebug.printStackTrace((Throwable)functException);
        }
        catch (SAXException sAXException) {
            FunctDebug.printStackTrace((Throwable)sAXException);
        }
        catch (IOException iOException) {
            FunctDebug.printStackTrace((Throwable)iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            FunctDebug.printStackTrace((Throwable)parserConfigurationException);
        }
        if (iViewGraph != null) {
            this.addGraphNode(iViewGraph, true, IViewGraph.Layers.Card);
        }
    }

    protected ViewGraphLabel createCardLabel(ViewAttribute viewAttribute) throws Exception {
        return (ViewGraphLabel)SvgFactoryDirector.getViewElem(SvgParamsHelper.getSvgLabelParams((IFvNodeModel)this.getViewManager().getNode(), (IViewGraph)this, (ViewAttribute)viewAttribute));
    }

    protected boolean isDomain() {
        return true;
    }

    protected void onInitPopupMenu(UPopupMenu uPopupMenu) {
        this.actOrg = new ActionOrganizer(this);
        this.initPopupMenu(uPopupMenu);
        this.actOrg = null;
    }

    protected void initPopupMenu(UPopupMenu uPopupMenu) {
        if (this.isCollapsed()) {
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Open Node", 68);
        } else {
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Close Node", 85);
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Rotate Left", 76);
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Rotate Right", 82);
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Horizontal flip", 72);
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Vertical flip", 86);
        }
    }

    public String getGraphName() {
        return "";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Close Node") {
            this.setViewCollapsed(!this.isCollapsed());
        } else if (string == "Open Node" || string == "Open Patch Panel") {
            this.setViewCollapsed(!this.isCollapsed());
        } else if (string == "Rotate Left") {
            this.doRotateL();
        } else if (string == "Rotate Right") {
            this.doRotateR();
        } else if (string == "Horizontal flip") {
            this.doFlipH();
        } else if (string == "Vertical flip") {
            this.doFlipV();
        }
        this.getTk().invalidateView();
        this.getTk().reDraw();
    }

    private void doRotateL() {
        this.doShapeRotate(new Double(-90.0));
    }

    private void doRotateR() {
        this.doShapeRotate(new Double(90.0));
    }

    public void doMouseDoubleClick(MouseViewCommand mouseViewCommand) {
    }

    public void doMousePopup(MouseViewCommand mouseViewCommand) {
    }

    public void doMouseClick(MouseViewCommand mouseViewCommand) {
    }

    public void doMouseUpdate(MouseViewCommand mouseViewCommand) {
    }

    public void doMouseDrag(MouseViewCommand mouseViewCommand) {
    }

    public void doAdd(GrapherViewCommand grapherViewCommand) {
    }

    public void doDelete(GrapherViewCommand grapherViewCommand) {
    }

    public void doChange(GrapherViewCommand grapherViewCommand) {
    }

    protected void initShapeinfo() {
        this.shape = new ViewShapeInfo((ViewGrapher)this, this.bandid.intValue());
    }

    public String getSideName() {
        return "CLI";
    }

    public void addLink(ViewPortGraphic viewPortGraphic, ViewPortGraphic viewPortGraphic2) {
    }

    public void delLink(IViewLink iViewLink) {
    }

    public void updateLinks(ArrayList<ViewInternalLink> arrayList) {
    }

    public ArrayList<ViewInternalLink> updateLinks(ArrayList<ViewInternalLink> arrayList, Integer n) {
        return new ArrayList<ViewInternalLink>();
    }

    public void fitToView() {
    }
}

