/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.functional;

import cerent.cms.fv.IFvPortModel;
import cerent.cms.fv.IFvSideModel;
import cerent.cms.ui.functional.FunctFiberPortGraphic;
import cerent.cms.ui.functional.MMUFunctCardGrapher;
import cerent.cms.ui.functional.helper.SvgFactoryDirector;
import cerent.util.gui.UPopupMenu;
import cerent.util.view.fv.IFvOpenActions;
import cerent.util.view.fv.ISvgParams;
import cerent.util.view.fv.IViewGraph;
import cerent.util.view.fv.IViewManagerDelegate;
import cerent.util.view.fv.IViewSvg;
import cerent.util.view.fv.IViewSvgParamInfo;
import cerent.util.view.fv.MouseViewCommand;
import cerent.util.view.fv.ViewAttribute;
import cerent.util.view.fv.ViewCardGrapher;
import cerent.util.view.fv.ViewFiberGrapher;
import cerent.util.view.fv.ViewGraphicSet;
import cerent.util.view.fv.ViewManager;
import cerent.util.view.fv.ViewPortGraphic;
import cerent.util.view.fv.ViewShapeInfo;
import cerent.util.view.fv.ViewSvgDecoderHelper;
import cerent.util.view.fv.ViewZoomLabel;
import cerent.util.view.fv.helper.SvgParams;
import cerent.util.view.fv.helper.SvgParamsHelper;
import ilog.views.graphic.IlvGraphicSet;
import ilog.views.graphic.IlvZoomableLabel;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctFiberGrapher
extends ViewFiberGrapher {
    IFvSideModel model = null;
    private static final int TX_DIR = 0;
    private static final int RX_DIR = 1;
    private String key = null;
    private static String[] ROLE_LABEL = new String[]{" ", "w", "p"};
    private HashMap<Integer, ViewPortGraphic> linePorts = new HashMap();
    private ViewCardGrapher linkedCard;

    public FunctFiberGrapher(SvgParams svgParams, ViewGraphicSet viewGraphicSet) {
        super((ISvgParams)svgParams, viewGraphicSet);
        this.model = (IFvSideModel)svgParams.getSvgValue();
        this.key = this.model.getName();
        this.initViewGraphic((IlvGraphicSet)viewGraphicSet);
        this.initDefaultPos();
        viewGraphicSet.setToolTipText("Connected to " + this.getNode().getConnectToName(this.sideModel));
        this.sideLabel = new ViewZoomLabel((Object)((IlvZoomableLabel)this.getObject("SIDE_LABEL")));
        if (ROLE_LABEL[this.sideModel.getRole()].equals(ROLE_LABEL[0])) {
            this.sideLabel.setLabel(this.sideModel.getNameLabel());
        } else {
            this.sideLabel.setLabel(this.sideModel.getNameLabel() + "(" + ROLE_LABEL[this.sideModel.getRole()] + ")");
        }
    }

    public void initDefaultPos() {
        this.setCoordinates(0.0, 860.0, 0.0, true);
        this.updateCoordinates();
    }

    protected IViewSvg.IViewSvgEnum getGeneralType() {
        return IViewSvg.SvgGenericShape.FIBER_SIDE;
    }

    protected IViewGraph createSidePort(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
        return SvgFactoryDirector.getViewElem(SvgParamsHelper.getSvgFiberPortParams((IViewGraph)this, (ViewManager)this.getViewManager(), viewAttribute, (IFvPortModel)SvgParamsHelper.getSvgPortModel(viewAttribute)));
    }

    protected void updateCardBckgInfo(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
        if (this.model != null) {
            this.info = new ViewShapeInfo(viewAttribute.getValue(), this.model.getId());
            this.info.setSide(this.model.getNameLabel());
        }
    }

    protected void onInitPopupMenu(UPopupMenu uPopupMenu) {
    }

    protected boolean addPort(IViewGraph iViewGraph, IViewSvgParamInfo iViewSvgParamInfo) {
        if (iViewGraph != null && !this.children.containsKey(iViewGraph.getGraphKey())) {
            this.children.put(iViewGraph.getGraphKey(), iViewGraph);
        }
        if (iViewGraph != null && iViewGraph instanceof ViewPortGraphic) {
            this.addGraphNode((IViewGraph)((ViewPortGraphic)iViewGraph), true, IViewGraph.Layers.Port);
        }
        if (iViewSvgParamInfo.getSvgDir() == ViewSvgDecoderHelper.SvgTypeDirEnum.RX) {
            this.linePorts.put(1, (ViewPortGraphic)iViewGraph);
        } else if (iViewSvgParamInfo.getSvgDir() == ViewSvgDecoderHelper.SvgTypeDirEnum.TX) {
            this.linePorts.put(0, (ViewPortGraphic)iViewGraph);
        }
        return true;
    }

    public FunctFiberPortGraphic getLineIn() {
        return (FunctFiberPortGraphic)this.linePorts.get(1);
    }

    public FunctFiberPortGraphic getLineOut() {
        return (FunctFiberPortGraphic)this.linePorts.get(0);
    }

    public void doMouseDrag(MouseViewCommand mouseViewCommand) {
        this.info.setX(this.boundingBox().getX());
        this.info.setY(this.boundingBox().getY());
    }

    public String getGraphKey() {
        return this.key;
    }

    public void setCoordinates(double d, double d2, double d3, boolean bl) {
        if (this.linkedCard instanceof MMUFunctCardGrapher) {
            Rectangle2D rectangle2D = this.linkedCard.getGraphBound();
            Rectangle2D rectangle2D2 = this.getGraphBound();
            d = rectangle2D.getX();
            d2 = rectangle2D.getMaxY() + rectangle2D2.getHeight() / 2.0;
            if (this.info.getAngle() == 0.0) {
                d3 = -90.0;
            }
        }
        super.setCoordinates(d, d2, d3, bl);
        this.updateCoordinates();
    }

    public void setLinkedCard(ViewCardGrapher viewCardGrapher) {
        this.linkedCard = viewCardGrapher;
    }

    public void doMouseDoubleClick(MouseViewCommand mouseViewCommand) {
        this.openFuncView();
        IFvOpenActions iFvOpenActions = this.getViewManager().getFVActions();
        iFvOpenActions.openNodeFV(this.getNode(), this.sideModel, (IViewManagerDelegate)this.getViewManager());
    }

    private void openFuncView() {
    }
}

