/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.functional;

import cerent.cms.fv.IFvCardModel;
import cerent.cms.fv.IFvEntityModel;
import cerent.cms.ui.functional.FunctNode;
import cerent.util.view.fv.GrapherViewCommand;
import cerent.util.view.fv.IViewCommand;
import cerent.util.view.fv.TreeViewCommand;
import cerent.util.view.fv.ViewCommand;
import cerent.util.view.fv.ViewManager;
import cerent.util.view.fv.helper.IFunctNode;

public class FunctNodeCardElem
extends FunctNode {
    private IFvCardModel card = null;
    private boolean visible = false;
    static final String SQUARE_BRACHET_OPEN = "[";
    static final String SQUARE_BRACHET_CLOSED = "] ";

    public FunctNodeCardElem(IFvCardModel iFvCardModel, IFunctNode iFunctNode) {
        super(FunctNodeCardElem.getNodeLabel((IFvEntityModel)iFvCardModel, false), iFunctNode);
        this.nodeTyp = 6;
        this.card = iFvCardModel;
    }

    public static String getNodeLabel(IFvEntityModel iFvEntityModel, boolean bl) {
        int n = iFvEntityModel.getSlot();
        String string = SQUARE_BRACHET_OPEN;
        if (n < 10) {
            string = string + "0";
        }
        string = string + n;
        string = bl ? string + "] Empty Slot" : string + SQUARE_BRACHET_CLOSED + iFvEntityModel.getEqLabel();
        return string;
    }

    public boolean isLeaf() {
        return true;
    }

    public IFvCardModel getCard() {
        return this.card;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public int getId() {
        return this.card.getEntityIndex();
    }

    public void nodeClicked(TreeViewCommand treeViewCommand) {
        ViewManager viewManager = treeViewCommand.getViewManager();
        IViewCommand iViewCommand = this.getDestGrapher(viewManager);
        if (viewManager.isCardAddable(this.getCard(), iViewCommand)) {
            GrapherViewCommand grapherViewCommand = new GrapherViewCommand(viewManager, iViewCommand, 1, (Object)this);
            viewManager.doCommand((ViewCommand)grapherViewCommand);
        }
    }
}

