/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.functional;

import cerent.cms.fv.IFvCardModel;
import cerent.cms.fv.IFvDwdmPortModel;
import cerent.cms.fv.IFvInterfaceModel;
import cerent.cms.fv.IFvNodeModel;
import cerent.cms.fv.IFvOpticsCardModel;
import cerent.cms.fv.IFvOpticsLineModel;
import cerent.cms.fv.IFvOpticsPortModel;
import cerent.cms.fv.IFvPortModel;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.WrongPortType;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.functional.FunctTrunkPortGraphic;
import cerent.cms.ui.functional.FunctViewPureGraphicalLink;
import cerent.util.view.fv.IViewGraph;
import cerent.util.view.fv.ViewLinkHelper;
import cerent.util.view.fv.ViewManagerToolKit;
import cerent.util.view.fv.ViewPortGraphic;
import cerent.util.view.fv.helper.FunctDebug;

public class FunctViewLinkHelper {
    private static FunctDebug db = null;

    public static FunctViewPureGraphicalLink createPortMpoLink(IViewGraph iViewGraph, IViewGraph iViewGraph2, IViewGraph iViewGraph3, IViewGraph iViewGraph4, ViewManagerToolKit viewManagerToolKit, boolean bl, IFvNodeModel iFvNodeModel) {
        FunctViewPureGraphicalLink functViewPureGraphicalLink = null;
        if (iViewGraph2 == null || iViewGraph4 == null) {
            return null;
        }
        Object object = ViewLinkHelper.getGraphOwner((IViewGraph)iViewGraph2, (IViewGraph)iViewGraph4);
        functViewPureGraphicalLink = new FunctViewPureGraphicalLink(object, viewManagerToolKit, iViewGraph, iViewGraph2, iViewGraph3, iViewGraph4, true, iFvNodeModel);
        if (functViewPureGraphicalLink != null) {
            functViewPureGraphicalLink.setLineWidth(2.0f);
            functViewPureGraphicalLink.setVisible(bl);
        }
        return functViewPureGraphicalLink;
    }

    public static String addUsedLambda(IViewGraph iViewGraph, IViewGraph iViewGraph2) {
        ViewPortGraphic viewPortGraphic = null;
        String string = null;
        if (iViewGraph2 instanceof FunctTrunkPortGraphic) {
            string = FunctViewLinkHelper.getLambdaTxp((ViewPortGraphic)iViewGraph2);
        } else {
            IFvPortModel iFvPortModel;
            if (iViewGraph instanceof ViewPortGraphic) {
                viewPortGraphic = (ViewPortGraphic)iViewGraph;
                if (viewPortGraphic.getPortModel() == null && iViewGraph2 instanceof ViewPortGraphic) {
                    viewPortGraphic = (ViewPortGraphic)iViewGraph2;
                }
                try {
                    iFvPortModel = viewPortGraphic.getPortModel();
                    if (iFvPortModel != null && iFvPortModel instanceof IFvOpticsPortModel && ((IFvOpticsPortModel)iFvPortModel).getOptPortTypeString().contains("OSC")) {
                        return "";
                    }
                }
                catch (NoSuchEquipment noSuchEquipment) {
                    noSuchEquipment.printStackTrace();
                }
                catch (WrongPortType wrongPortType) {
                    wrongPortType.printStackTrace();
                }
                string = FunctViewLinkHelper.getLambdaStr(viewPortGraphic);
            }
            if (string == null) {
                if (iViewGraph2 instanceof ViewPortGraphic && (viewPortGraphic = (ViewPortGraphic)iViewGraph2).getPortModel() == null && iViewGraph instanceof ViewPortGraphic) {
                    viewPortGraphic = (ViewPortGraphic)iViewGraph;
                }
                try {
                    iFvPortModel = viewPortGraphic.getPortModel();
                    if (iFvPortModel != null && iFvPortModel instanceof IFvOpticsPortModel && ((IFvOpticsPortModel)iFvPortModel).getOptPortTypeString().contains("OSC")) {
                        return "";
                    }
                }
                catch (NoSuchEquipment noSuchEquipment) {
                    noSuchEquipment.printStackTrace();
                }
                catch (WrongPortType wrongPortType) {
                    wrongPortType.printStackTrace();
                }
                string = FunctViewLinkHelper.getLambdaStr(viewPortGraphic);
            }
            if (string == null) {
                return "";
            }
        }
        return string;
    }

    private static String getLambdaTxp(ViewPortGraphic viewPortGraphic) {
        IFvInterfaceModel iFvInterfaceModel;
        String string = "";
        if (viewPortGraphic.getPortModel() instanceof IFvDwdmPortModel && (iFvInterfaceModel = viewPortGraphic.getPortModel().getIFvInterfaceModel()) != null) {
            try {
                int n = iFvInterfaceModel.getExpectedWaveLength();
                string = string + "<P><B>Used Lambda: </B></P>";
                string = string + Wavelength.getWavelengthStringFromWavelength(n) + "\n";
            }
            catch (NoSuchInterface noSuchInterface) {
                noSuchInterface.printStackTrace();
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                wrongInterfaceType.printStackTrace();
            }
        }
        return string;
    }

    private static String getLambdaStr(ViewPortGraphic viewPortGraphic) {
        String string = "";
        if (viewPortGraphic != null && viewPortGraphic.getPortModel() != null) {
            IFvCardModel iFvCardModel = viewPortGraphic.getPortModel().getCardModel();
            if (iFvCardModel instanceof IFvOpticsCardModel) {
                IFvOpticsLineModel[] iFvOpticsLineModelArray = ((IFvOpticsCardModel)iFvCardModel).getComTxLineModels();
                if (iFvOpticsLineModelArray.length > 0) {
                    String[] stringArray = iFvOpticsLineModelArray[0].getUsedWavelength(iFvOpticsLineModelArray, iFvCardModel);
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (i == 0) {
                            string = string + "<P><B>Used Lambda: </B></P>";
                        }
                        string = string + stringArray[i] + "\n";
                    }
                } else {
                    iFvOpticsLineModelArray = ((IFvOpticsCardModel)iFvCardModel).getOpticsAmplifiedLineModels();
                    if (iFvOpticsLineModelArray.length == 0) {
                        return null;
                    }
                    String[] stringArray = iFvOpticsLineModelArray[0].getUsedWavelength(iFvOpticsLineModelArray, iFvCardModel);
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (i == 0) {
                            string = string + "<P><B>Used Lambda: </B></P>";
                        }
                        string = string + stringArray[i] + "\n";
                    }
                }
            }
        } else {
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        return string;
    }
}

