/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.functional;

import cerent.cms.fv.IFvCardModel;
import cerent.cms.fv.IFvDwdmTrkLineModel;
import cerent.cms.fv.IFvEntityModel;
import cerent.cms.fv.IFvInterfaceModel;
import cerent.cms.fv.IFvNodeModel;
import cerent.cms.fv.IFvOptLinkModel;
import cerent.cms.fv.IFvOpticsCardModel;
import cerent.cms.fv.IFvOpticsLineModel;
import cerent.cms.fv.IFvOpticsPortModel;
import cerent.cms.fv.IFvPSMModuleModel;
import cerent.cms.fv.IFvPortModel;
import cerent.cms.fv.IFvSideModel;
import cerent.cms.fv.IFvViewCircuitPath;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.FVNodeModelDelegate;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.ISOchPath;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InterfaceModels;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OpticsChannelModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.SOchPath;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.WrongPortType;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.functional.FunctBandDomainGrapher;
import cerent.cms.ui.functional.FunctDomainGrapher;
import cerent.cms.ui.functional.FunctSidePortCircuitPathElement;
import cerent.cms.ui.functional.FunctSideViewLink;
import cerent.cms.ui.functional.FunctView;
import cerent.cms.ui.functional.FunctViewCircuitPathElement;
import cerent.cms.ui.functional.FunctViewDCULink;
import cerent.cms.ui.functional.FunctViewLink;
import cerent.cms.ui.functional.FunctViewPureGraphicalLink;
import cerent.cms.ui.functional.FunctViewWxcLink;
import cerent.cms.ui.functional.ViewManagerDelegate;
import cerent.util.SDebug;
import cerent.util.view.fv.IViewGraph;
import cerent.util.view.fv.IViewLink;
import cerent.util.view.fv.ViewCircuitPathElement;
import cerent.util.view.fv.ViewGrapher;
import cerent.util.view.fv.ViewManagerToolKit;
import cerent.util.view.fv.ViewPortGraphic;
import cerent.util.view.fv.ViewPureGraphicalLink;
import cerent.util.view.fv.helper.FunctDebug;
import cerent.util.view.fv.helper.FunctException;
import cerent.util.view.fv.helper.OpticalPatchCord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionalCircuitPath
implements IFvViewCircuitPath {
    private SOchPath ochList;
    private ViewManagerDelegate vm;
    private HashMap<Integer, ViewCircuitPathElement> circuitPathElement;
    private HashMap<Integer, ViewCircuitPathElement> currentCircuitPathElement;
    private ArrayList<PpMeshLink> ppMeshLink;
    private IFvSideModel sideModel;
    private int circuitType;
    private HashMap<Integer, IFvInterfaceModel> txpIndexes = null;
    private HashMap<Integer, IFvInterfaceModel> psmIndexes = null;
    private boolean evenCircuit;
    private IFvNodeModel nmd = null;
    private boolean findOneLink;
    private int oadmSide;
    private static Debug db;
    private int usedLambda;
    private boolean nodeIsInActivePath;
    private boolean psmChannelProtection;
    private int workingSide;

    public FunctionalCircuitPath(ViewManagerDelegate viewManagerDelegate, IFvSideModel iFvSideModel) {
        this.vm = viewManagerDelegate;
        this.sideModel = iFvSideModel;
        this.nmd = viewManagerDelegate.getNode();
        this.evenCircuit = false;
        this.circuitPathElement = new HashMap();
        this.ppMeshLink = new ArrayList();
        this.findOneLink = false;
        this.psmChannelProtection = false;
        if (db == null) {
            db = new Debug("FunctionalCircuitPath");
        }
        this.nodeIsInActivePath = true;
    }

    public void addPath(ISOchPath iSOchPath, int n, int n2) {
        this.ochList = (SOchPath)iSOchPath;
        this.evenCircuit = Wavelength.isEvenLambda(new Attribute("", n2));
        this.circuitType = n;
        this.usedLambda = n2;
        if (db.on()) {
            int n3;
            db.println("addPath for type: " + n + "; lamba: " + n2);
            db.print("ochList Uptrail: ");
            int[] nArray = iSOchPath.getUpTrail();
            for (n3 = 0; n3 < nArray.length; ++n3) {
                db.print("0x" + Integer.toHexString(nArray[n3]) + " - ");
            }
            db.print("ochList Downtrail: ");
            nArray = iSOchPath.getDownTrail();
            for (n3 = 0; n3 < nArray.length; ++n3) {
                db.print("0x" + Integer.toHexString(nArray[n3]) + " - ");
            }
        }
        this.collectLinks(this.sideModel);
    }

    public void paint() {
        if (this.circuitPathElement != null) {
            this.vm.getCircuitsPathManager().paint(this.circuitPathElement.values());
            this.currentCircuitPathElement = new HashMap<Integer, ViewCircuitPathElement>(this.circuitPathElement);
            this.circuitPathElement.clear();
            this.ppMeshLink.clear();
            if (this.txpIndexes != null) {
                this.txpIndexes.clear();
            }
            if (this.psmIndexes != null) {
                this.psmIndexes.clear();
            }
            this.workingSide = 0;
        }
    }

    private void collectLinks(IFvSideModel iFvSideModel) {
        IViewGraph iViewGraph = null;
        ViewManagerToolKit viewManagerToolKit = this.vm.getViewTk();
        if (iFvSideModel == null) {
            Collection<IViewLink> collection = viewManagerToolKit.getGraphLinks().values();
            if (collection.size() > 0) {
                this.findInternalLinks(collection);
            }
            Collection collection2 = viewManagerToolKit.getGraphChildren().values();
            Iterator iterator = collection2.iterator();
            while (iterator.hasNext()) {
                this.findOneLink = false;
                iViewGraph = (IViewGraph)iterator.next();
                if (!(iViewGraph instanceof ViewGrapher)) continue;
                this.findLinkInSide((ViewGrapher)iViewGraph);
            }
        } else {
            String string = "FunctDomainGrapher" + DwdmSide.getSideFromOffset(iFvSideModel.getId());
            iViewGraph = viewManagerToolKit.getSpecificGraphChildren(string);
            if (iViewGraph instanceof ViewGrapher) {
                this.findLinkInSide((ViewGrapher)iViewGraph);
            }
        }
        this.finalCheck(viewManagerToolKit);
        if (db.on()) {
            db.println("collectLinks(" + (iFvSideModel == null ? "-" : iFvSideModel.getName()) + ")");
            db.links();
        }
    }

    private void finalCheck(ViewManagerToolKit viewManagerToolKit) {
        block10: {
            try {
                this.adjustWxc();
            }
            catch (FunctException functException) {
                if (!db.on()) break block10;
                db.println("The WXC links are not found");
            }
        }
        if (this.circuitPathElement.size() == 0) {
            int[] nArray = this.ochList.getUpTrail();
            InterfaceModels interfaceModels = ((FVNodeModelDelegate)this.nmd).getDelegate().getIfModels();
            for (int i = 0; i < nArray.length; ++i) {
                try {
                    IViewGraph iViewGraph;
                    String string;
                    InterfaceModel interfaceModel = interfaceModels.getInterfaceModel(nArray[i]);
                    if (!(interfaceModel.getThePortModel() instanceof IFvOpticsPortModel)) continue;
                    IFvOpticsPortModel iFvOpticsPortModel = (IFvOpticsPortModel)interfaceModel.getThePortModel();
                    if (iFvOpticsPortModel.isLineOptPort()) {
                        string = "FunctDomainGrapher" + DwdmSide.getSideFromOffset(iFvOpticsPortModel.getSide());
                        iViewGraph = viewManagerToolKit.getSpecificGraphChildren(string);
                        this.takeExtraLine((ViewGrapher)iViewGraph);
                        continue;
                    }
                    if (!iFvOpticsPortModel.isDCPort()) continue;
                    string = "FunctDomainGrapher" + DwdmSide.getSideFromOffset(iFvOpticsPortModel.getSide());
                    iViewGraph = viewManagerToolKit.getSpecificGraphChildren(string);
                    this.takeExtraLine((ViewGrapher)iViewGraph);
                    continue;
                }
                catch (NoSuchInterface noSuchInterface) {
                    FunctDebug.instance();
                    FunctDebug.printStackTrace((Throwable)noSuchInterface);
                    continue;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    FunctDebug.instance();
                    FunctDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    continue;
                }
                catch (NoSuchEquipment noSuchEquipment) {
                    FunctDebug.instance();
                    FunctDebug.printStackTrace((Throwable)noSuchEquipment);
                    continue;
                }
                catch (WrongPortType wrongPortType) {
                    FunctDebug.instance();
                    FunctDebug.printStackTrace((Throwable)wrongPortType);
                }
            }
        }
    }

    private void findLinkInSide(ViewGrapher viewGrapher) {
        Collection<IViewLink> collection = viewGrapher.getGraphLinks().values();
        this.findInternalLinks(collection);
        this.findOneLink |= this.nmd.getNodeOpticalType() == 13 || this.nmd.getNodeOpticalType() == 14;
        if (this.nmd.getNodeOpticalType() == 4) {
            String string = "FunctDomainGrapher" + DwdmSide.getSideFromOffset(this.oadmSide);
            this.findOneLink |= string.equalsIgnoreCase(viewGrapher.getGraphKey());
        }
        this.workingSide = 0;
        if (viewGrapher instanceof FunctDomainGrapher) {
            this.workingSide = ((FunctDomainGrapher)viewGrapher).getSideId();
        }
        this.fromTransponder(viewGrapher);
        this.fromPSM(viewGrapher);
        if (this.findOneLink) {
            this.takeExtraLine(viewGrapher);
        }
    }

    private void fromPSM(ViewGrapher viewGrapher) {
        if (this.psmIndexes == null || this.psmIndexes.size() == 0) {
            return;
        }
        Collection collection = viewGrapher.getGraphChildren("FunctBandDomainGrapher").values();
        HashMap hashMap = viewGrapher.getMpoLinks();
        for (FunctBandDomainGrapher functBandDomainGrapher : collection) {
            Collection collection2 = functBandDomainGrapher.getGraphLinks().values();
            for (FunctViewLink functViewLink : collection2) {
                int n;
                IFvInterfaceModel iFvInterfaceModel;
                boolean bl;
                int n2;
                block19: {
                    Integer n3;
                    Integer n4;
                    Integer n5;
                    block18: {
                        n5 = functViewLink.getFromPort();
                        n4 = functViewLink.getToPort();
                        Integer n6 = n5;
                        n3 = n4;
                        IFvPortModel iFvPortModel = null;
                        IFvPortModel iFvPortModel2 = null;
                        try {
                            iFvPortModel = functViewLink.getLinkModel().getLink().getFromPortModel();
                            iFvPortModel2 = functViewLink.getLinkModel().getLink().getToPortModel();
                        }
                        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                            abstractCmsNoSuchEntityException.printStackTrace();
                        }
                        boolean bl2 = false;
                        n2 = 0;
                        bl = false;
                        iFvInterfaceModel = null;
                        n = 0;
                        if (iFvPortModel.getCardModel() instanceof DwdmModuleModel || iFvPortModel2.getCardModel() instanceof DwdmModuleModel) continue;
                        if (iFvPortModel.getCardModel() instanceof IFvPSMModuleModel) {
                            if (((InterfaceModel)iFvPortModel.getIFvInterfaceModel()).getHigherLayerIndexes_new().length != 0) {
                                n6 = ((InterfaceModel)iFvPortModel.getIFvInterfaceModel()).getHigherLayerIndexes_new()[0];
                            }
                            bl2 = iFvPortModel2.getCardModel().isPassiveModule();
                            n2 = FunctDomainGrapher.getBandfromPos(iFvPortModel2.getPositionInParent(), bl2);
                            n = n5 - 1;
                        } else if (iFvPortModel2.getCardModel() instanceof IFvPSMModuleModel) {
                            if (((InterfaceModel)iFvPortModel2.getIFvInterfaceModel()).getHigherLayerIndexes_new().length != 0) {
                                n3 = ((InterfaceModel)iFvPortModel2.getIFvInterfaceModel()).getHigherLayerIndexes_new()[0];
                            }
                            bl2 = iFvPortModel.getCardModel().isPassiveModule();
                            n2 = FunctDomainGrapher.getBandfromPos(iFvPortModel.getPositionInParent(), bl2);
                            n = n4 + 1;
                        }
                        if (this.psmIndexes.containsKey(n6)) {
                            try {
                                this.addLinkForCircuitPaint((IViewLink)functViewLink, n5, n4, this.psmIndexes.get(n6), null, this.nmd, false);
                                this.findOneLink = true;
                                bl = true;
                                iFvInterfaceModel = this.psmIndexes.get(n6);
                            }
                            catch (FunctException functException) {
                                if (!db.on()) break block18;
                                db.println("The link" + functViewLink.getName() + " is not found");
                            }
                        }
                    }
                    if (this.psmIndexes.containsKey(n3)) {
                        try {
                            this.addLinkForCircuitPaint((IViewLink)functViewLink, n5, n4, null, this.psmIndexes.get(n3), this.nmd, false);
                            this.findOneLink = true;
                            bl = true;
                            iFvInterfaceModel = this.psmIndexes.get(n3);
                        }
                        catch (FunctException functException) {
                            if (!db.on()) break block19;
                            db.println("The link" + functViewLink.getName() + " is not found");
                        }
                    }
                }
                if (!bl) continue;
                InterfaceModel interfaceModel = null;
                try {
                    interfaceModel = ((FVNodeModelDelegate)this.nmd).getDelegate().getIfModels().getInterfaceModel(n);
                }
                catch (NoSuchInterface noSuchInterface) {
                    noSuchInterface.printStackTrace();
                }
                this.addMPOLink(hashMap, n2, iFvInterfaceModel.getLowerLayerModels()[0]);
                if (interfaceModel == null) continue;
                this.addMPOLink(hashMap, n2, interfaceModel);
            }
        }
        this.psmChannelProtection = false;
    }

    private void fromTransponder(ViewGrapher viewGrapher) {
        if (this.txpIndexes == null || this.txpIndexes.size() == 0) {
            return;
        }
        Collection collection = viewGrapher.getGraphChildren("FunctBandDomainGrapher").values();
        if (collection.size() == 0) {
            this.fromAdCard(viewGrapher);
            return;
        }
        HashMap hashMap = viewGrapher.getMpoLinks();
        for (FunctBandDomainGrapher functBandDomainGrapher : collection) {
            Collection collection2 = functBandDomainGrapher.getGraphLinks().values();
            for (FunctViewLink functViewLink : collection2) {
                IFvInterfaceModel iFvInterfaceModel;
                boolean bl;
                int n;
                block17: {
                    Integer n2;
                    Integer n3;
                    Integer n4;
                    Integer n5;
                    block16: {
                        n5 = functViewLink.getFromPort();
                        n4 = functViewLink.getToPort();
                        n3 = n5;
                        n2 = n4;
                        IFvPortModel iFvPortModel = functViewLink.getLinkModel().getOptPort();
                        boolean bl2 = iFvPortModel.getCardModel().isPassiveModule();
                        n = FunctDomainGrapher.getBandfromPos(iFvPortModel.getPositionInParent(), bl2);
                        bl = false;
                        iFvInterfaceModel = null;
                        if (iFvPortModel.getIndex() == n5.intValue() && iFvPortModel.getCardModel() instanceof IFvPSMModuleModel && ((InterfaceModel)iFvPortModel.getIFvInterfaceModel()).getHigherLayerIndexes_new().length != 0) {
                            n3 = ((InterfaceModel)iFvPortModel.getIFvInterfaceModel()).getHigherLayerIndexes_new()[0];
                        }
                        if (iFvPortModel.getIndex() == n4.intValue() && iFvPortModel.getCardModel() instanceof IFvPSMModuleModel && ((InterfaceModel)iFvPortModel.getIFvInterfaceModel()).getHigherLayerIndexes_new().length != 0) {
                            n2 = ((InterfaceModel)iFvPortModel.getIFvInterfaceModel()).getHigherLayerIndexes_new()[0];
                        }
                        if (this.txpIndexes.containsKey(n3)) {
                            try {
                                if (this.circuitType != 9) {
                                    this.addLinkForCircuitPaint((IViewLink)functViewLink, n5, n4, this.txpIndexes.get(n3), null, this.nmd, false);
                                    this.findOneLink = true;
                                    bl = true;
                                    iFvInterfaceModel = this.txpIndexes.get(n3);
                                    if (n5 != n3 || n4 != n2) {
                                        this.psmChannelProtection = true;
                                    }
                                }
                            }
                            catch (FunctException functException) {
                                if (!db.on()) break block16;
                                db.println("The link" + functViewLink.getName() + " is not found");
                            }
                        }
                    }
                    if (this.txpIndexes.containsKey(n2)) {
                        try {
                            if (this.circuitType != 9) {
                                this.addLinkForCircuitPaint((IViewLink)functViewLink, n5, n4, null, this.txpIndexes.get(n2), this.nmd, false);
                                this.findOneLink = true;
                                bl = true;
                                iFvInterfaceModel = this.txpIndexes.get(n2);
                                if (n5 != n3 || n4 != n2) {
                                    this.psmChannelProtection = true;
                                }
                            }
                        }
                        catch (FunctException functException) {
                            if (!db.on()) break block17;
                            db.println("The link" + functViewLink.getName() + " is not found");
                        }
                    }
                }
                if (!bl || this.psmChannelProtection) continue;
                this.addMPOLink(hashMap, n, iFvInterfaceModel);
            }
        }
    }

    private void fromAdCard(ViewGrapher viewGrapher) {
        Collection collection = viewGrapher.getGraphLinks().values();
        for (IViewLink iViewLink : collection) {
            Integer n;
            Integer n2;
            block7: {
                n2 = iViewLink.getFromPort();
                n = iViewLink.getToPort();
                if (this.txpIndexes.containsKey(n2)) {
                    try {
                        if (this.circuitType != 9) {
                            this.addLinkForCircuitPaint(iViewLink, n2, n, this.txpIndexes.get(n2), null, this.nmd, false);
                            this.findOneLink = true;
                        }
                    }
                    catch (FunctException functException) {
                        if (!db.on()) break block7;
                        db.println("The link" + iViewLink.getName() + " is not found");
                    }
                }
            }
            if (!this.txpIndexes.containsKey(n)) continue;
            try {
                if (this.circuitType == 9) continue;
                this.addLinkForCircuitPaint(iViewLink, n2, n, null, this.txpIndexes.get(n), this.nmd, true);
                this.findOneLink = true;
            }
            catch (FunctException functException) {
                if (!db.on()) continue;
                db.println("The link" + iViewLink.getName() + " is not found");
            }
        }
    }

    private void addMPOLink(HashMap<Integer, IViewLink> hashMap, Integer n, IFvInterfaceModel iFvInterfaceModel) {
        block16: {
            Object object;
            Object object2;
            int n2 = 256;
            OpticalPatchCord opticalPatchCord = null;
            OpticalPatchCord opticalPatchCord2 = null;
            int n3 = 0;
            try {
                object2 = (IFvCardModel)iFvInterfaceModel.getModuleModel();
                object = object2.getAllOpticalPatchCords();
                int n4 = iFvInterfaceModel.getIndex();
                for (int i = 0; i < ((OpticalPatchCord[])object).length; ++i) {
                    if (object[i].from == n4) {
                        opticalPatchCord = object[i];
                    }
                    if (object[i].to != n4) continue;
                    opticalPatchCord2 = object[i];
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            catch (NumberFormatException numberFormatException) {
                SDebug.printStackTrace((Throwable)numberFormatException);
            }
            catch (FeatureUnsupported featureUnsupported) {
                SDebug.printStackTrace((Throwable)featureUnsupported);
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            try {
                n3 = iFvInterfaceModel instanceof IFvDwdmTrkLineModel ? ((IFvDwdmTrkLineModel)iFvInterfaceModel).getExpectedWaveLength() : ((AbstractOpticsLineModel)iFvInterfaceModel).getExpectedWaveLength();
                if (Wavelength.isEvenLambda(new Attribute("", n3))) {
                    n2 += 16;
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
            try {
                object2 = this.getLinkFromIndexMask(hashMap, n2 + n);
                if (opticalPatchCord2 != null) {
                    this.addLinkForCircuitPaint((IViewLink)object2, opticalPatchCord2.from, opticalPatchCord2.to, iFvInterfaceModel, null, this.nmd, false);
                    this.findOneLink = true;
                }
                n2 = 512;
                if (Wavelength.isEvenLambda(new Attribute("", n3))) {
                    n2 += 16;
                }
                object2 = this.getLinkFromIndexMask(hashMap, n2 + n);
                if (opticalPatchCord != null) {
                    this.addLinkForCircuitPaint((IViewLink)object2, opticalPatchCord.from, opticalPatchCord.to, null, iFvInterfaceModel, this.nmd, false);
                    this.findOneLink = true;
                }
            }
            catch (FunctException functException) {
                if (!db.on()) break block16;
                object = (FunctViewPureGraphicalLink)hashMap.get(n2 + n);
                db.println("The link" + object.getName() + "is not found do not add it");
            }
        }
    }

    private FunctViewPureGraphicalLink getLinkFromIndexMask(HashMap<Integer, IViewLink> hashMap, int n) {
        if (hashMap != null) {
            Iterator<Integer> iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                ViewPureGraphicalLink viewPureGraphicalLink = (ViewPureGraphicalLink)hashMap.get(iterator.next());
                if (viewPureGraphicalLink.getIndexMask() != n) continue;
                return (FunctViewPureGraphicalLink)viewPureGraphicalLink;
            }
        }
        return null;
    }

    private void findInternalLinks(Collection<IViewLink> collection) {
        ViewManagerToolKit viewManagerToolKit;
        Object object;
        if (db.on()) {
            db.println("Enter in findInternalLinks");
        }
        InterfaceModels interfaceModels = ((FVNodeModelDelegate)this.nmd).getDelegate().getIfModels();
        int[] nArray = this.ochList.getUpTrail();
        for (int i = 0; i < nArray.length; ++i) {
            try {
                InterfaceModel interfaceModel = interfaceModels.getInterfaceModel(nArray[i]);
                object = this.findLink(interfaceModel, collection);
                if (object != null) {
                    collection.remove(object);
                    this.findOneLink = true;
                    continue;
                }
                viewManagerToolKit = this.vm.getViewTk();
                try {
                    IFvOpticsPortModel iFvOpticsPortModel;
                    if (!(interfaceModel.getThePortModel() instanceof IFvOpticsPortModel) || !(iFvOpticsPortModel = (IFvOpticsPortModel)interfaceModel.getThePortModel()).isDCPort()) continue;
                    String string = "FunctDomainGrapher" + DwdmSide.getSideLabelFromOffset(iFvOpticsPortModel.getSide());
                    IViewGraph iViewGraph = viewManagerToolKit.getSpecificGraphChildren(string);
                    this.takeDCU((ViewGrapher)iViewGraph, iFvOpticsPortModel);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
                catch (NoSuchEquipment noSuchEquipment) {
                    SDebug.printStackTrace((Throwable)noSuchEquipment);
                }
                catch (WrongPortType wrongPortType) {
                    SDebug.printStackTrace((Throwable)wrongPortType);
                }
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (db.on()) {
                    db.println("Wrong interface id [" + Integer.toHexString(nArray[i]) + "] retrived by the upTrail");
                }
                FunctDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        if ((this.circuitType == 15 || this.circuitType == 14) && this.ochList.hasDownTrail()) {
            int[] nArray2 = this.ochList.getDownTrail();
            for (int i = 0; i < nArray2.length; ++i) {
                try {
                    object = interfaceModels.getInterfaceModel(nArray2[i]);
                    viewManagerToolKit = this.findLink((IFvInterfaceModel)object, collection);
                    if (viewManagerToolKit == null) continue;
                    collection.remove(viewManagerToolKit);
                    this.findOneLink = true;
                    continue;
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (db.on()) {
                        db.println("Wrong interface id [" + nArray[i] + "] retrived by the downTrail");
                    }
                    FunctDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
        }
    }

    private void takeExtraLine(ViewGrapher viewGrapher) {
        HashMap hashMap = viewGrapher.getSideGraphLinks();
        HashMap hashMap2 = viewGrapher.getMpoLinks();
        if (viewGrapher instanceof FunctDomainGrapher) {
            if (!((FunctView)this.vm.getViewTk()).isFromNtw()) {
                FunctDomainGrapher functDomainGrapher = (FunctDomainGrapher)viewGrapher;
                int n = 0;
                if (functDomainGrapher.hasProtection()) {
                    n = 1;
                }
                for (int i = 0; i <= n; ++i) {
                    try {
                        this.takeSideLine(hashMap, functDomainGrapher.getSideId(i));
                        continue;
                    }
                    catch (FunctException functException) {
                        if (!db.on()) continue;
                        db.println("The link for the side " + i + " is not found");
                    }
                }
                if (functDomainGrapher.hasMMU()) {
                    IFvSideModel iFvSideModel = functDomainGrapher.getSideModel(2);
                    InterfaceModels interfaceModels = ((FVNodeModelDelegate)this.nmd).getDelegate().getIfModels();
                    int[] nArray = this.ochList.getUpTrail();
                    for (int i = 0; i < nArray.length; ++i) {
                        try {
                            InterfaceModel interfaceModel = interfaceModels.getInterfaceModel(nArray[i]);
                            int n2 = interfaceModel.getThePortModel().getIndex();
                            int[] nArray2 = iFvSideModel.getLinesIn();
                            int[] nArray3 = iFvSideModel.getLinesOut();
                            boolean bl = false;
                            for (int n3 : nArray2) {
                                if (n3 != n2) continue;
                                bl = true;
                                break;
                            }
                            if (!bl) {
                                for (int n3 : nArray3) {
                                    if (n3 != n2) continue;
                                    bl = true;
                                    break;
                                }
                            }
                            if (!bl) continue;
                            try {
                                this.takeSideLine(hashMap, functDomainGrapher.getSideId(2));
                            }
                            catch (FunctException functException) {
                                if (!db.on()) continue;
                                db.println("The link for the MMUside " + functDomainGrapher.getSideId(2) + " is not found");
                            }
                            continue;
                        }
                        catch (NoSuchInterface noSuchInterface) {
                            SDebug.printStackTrace((Throwable)noSuchInterface);
                            continue;
                        }
                        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                        }
                    }
                }
            } else {
                this.takeSidePort((FunctDomainGrapher)viewGrapher);
            }
        }
    }

    private void takeDCU(ViewGrapher viewGrapher, IFvOpticsPortModel iFvOpticsPortModel) {
        HashMap hashMap = viewGrapher.getMpoLinks();
        IViewLink iViewLink = (IViewLink)hashMap.get(iFvOpticsPortModel.getEntityIndex());
        if (iViewLink instanceof FunctViewDCULink) {
            FunctViewDCULink functViewDCULink = (FunctViewDCULink)iViewLink;
            try {
                this.addLinkForCircuitPaint(iViewLink, functViewDCULink.getPortModelFrom().getIndex(), functViewDCULink.getPortModelTo().getIndex(), functViewDCULink.getPortModelFrom().getIFvInterfaceModel(), functViewDCULink.getPortModelTo().getIFvInterfaceModel(), this.nmd, false);
                this.findOneLink = true;
            }
            catch (FunctException functException) {
                SDebug.printStackTrace((Throwable)functException);
            }
        }
    }

    private void takeSidePort(FunctDomainGrapher functDomainGrapher) {
        int[] nArray;
        int[] nArray2 = nArray = functDomainGrapher.getSideModel().getLinesIn();
        int n = nArray2.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            ViewPortGraphic viewPortGraphic = this.vm.getViewTk().getConnectedPort(n2);
            if (viewPortGraphic == null) continue;
            this.insertElem(viewPortGraphic.getPortModel().getIndex(), new FunctSidePortCircuitPathElement(viewPortGraphic, this.usedLambda));
        }
        for (int n3 : nArray2 = functDomainGrapher.getSideModel().getLinesOut()) {
            ViewPortGraphic viewPortGraphic = this.vm.getViewTk().getConnectedPort(n3);
            if (viewPortGraphic == null) continue;
            this.insertElem(viewPortGraphic.getPortModel().getIndex(), new FunctSidePortCircuitPathElement(viewPortGraphic, this.usedLambda));
        }
    }

    private void takeSideLine(HashMap<Integer, IViewLink> hashMap, int n) throws FunctException {
        IViewLink iViewLink = hashMap.get(256 + n);
        if (iViewLink instanceof FunctSideViewLink) {
            this.addLinkForCircuitPaint(iViewLink, null, null, null, ((FunctSideViewLink)iViewLink).getInterfaceModel(), null, false);
        }
        if ((iViewLink = hashMap.get(512 + n)) instanceof FunctSideViewLink) {
            this.addLinkForCircuitPaint(iViewLink, null, null, ((FunctSideViewLink)iViewLink).getInterfaceModel(), null, null, false);
        }
    }

    private IViewLink findLink(IFvInterfaceModel iFvInterfaceModel, Collection<IViewLink> collection) {
        int n = 0;
        IFvInterfaceModel iFvInterfaceModel2 = null;
        int n2 = 0;
        try {
            n2 = iFvInterfaceModel.getModuleModel().getEqType();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            abstractCmsNoSuchEntityException.printStackTrace();
        }
        if (n2 == 286) {
            if (this.psmIndexes == null) {
                this.psmIndexes = new HashMap();
            }
            if (!this.psmIndexes.containsKey(iFvInterfaceModel.getIndex())) {
                this.psmIndexes.put(iFvInterfaceModel.getIndex(), iFvInterfaceModel);
            }
        }
        if (iFvInterfaceModel instanceof IFvDwdmTrkLineModel) {
            if (this.txpIndexes == null) {
                this.txpIndexes = new HashMap();
            }
            if (!this.txpIndexes.containsKey(iFvInterfaceModel.getIndex())) {
                this.txpIndexes.put(iFvInterfaceModel.getIndex(), iFvInterfaceModel);
            }
            return null;
        }
        if (!(iFvInterfaceModel instanceof OpticsChannelModel)) {
            iFvInterfaceModel2 = iFvInterfaceModel.getLowerLayerModels()[0];
            n = iFvInterfaceModel2.getIndex();
            if (this.nmd.getNodeOpticalType() == 4) {
                this.takeTheSide(iFvInterfaceModel2);
            }
        } else {
            n = iFvInterfaceModel.getIndex();
            iFvInterfaceModel2 = iFvInterfaceModel;
        }
        for (IViewLink iViewLink : collection) {
            block25: {
                IFvOptLinkModel iFvOptLinkModel = iViewLink.getLinkModel().getLink();
                int n3 = iFvOptLinkModel.getTo();
                int n4 = iFvOptLinkModel.getFrom();
                if (iViewLink instanceof FunctViewWxcLink) {
                    if (iFvInterfaceModel instanceof OpticsChannelModel) continue;
                    IFvEntityModel iFvEntityModel = null;
                    IFvPortModel iFvPortModel = null;
                    try {
                        IViewLink iViewLink2;
                        iFvPortModel = iFvInterfaceModel.getThePortModel();
                        iFvEntityModel = iFvInterfaceModel.getLowerLayerModels()[0].getModuleModel();
                        if (!this.needPPMeshLinkCheck((IFvCardModel)iFvEntityModel) || (iViewLink2 = this.isPPMeshLink(iFvEntityModel, (FunctViewWxcLink)iViewLink, iFvPortModel)) == null) continue;
                        return iViewLink2;
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                        continue;
                    }
                }
                boolean bl = true;
                if (n == n3) {
                    block24: {
                        if (this.vm.isNodeEven()) {
                            bl = this.addCorrectLink(n3, n4);
                        }
                        if (bl) {
                            try {
                                this.addLinkForCircuitPaint(iViewLink, n3, n4, iFvInterfaceModel2, null, this.nmd, false);
                            }
                            catch (FunctException functException) {
                                if (!db.on()) break block24;
                                db.println("The link" + iViewLink.getName() + "is not found do not add it");
                            }
                        }
                    }
                    return iViewLink;
                }
                if (n != n4) continue;
                if (this.vm.isNodeEven()) {
                    bl = this.addCorrectLink(n3, n4);
                }
                if (bl) {
                    try {
                        this.addLinkForCircuitPaint(iViewLink, n3, n4, null, iFvInterfaceModel2, this.nmd, false);
                    }
                    catch (FunctException functException) {
                        if (!db.on()) break block25;
                        db.println("The link" + iViewLink.getName() + "is not found do not add it");
                    }
                }
            }
            return iViewLink;
        }
        return null;
    }

    private boolean needPPMeshLinkCheck(IFvCardModel iFvCardModel) {
        int n = iFvCardModel.getEqType();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = bl2 = n == 266 || n == 270 || n == 297 || n == 295;
        if (!bl2 && iFvCardModel instanceof IFvOpticsCardModel) {
            bl = ((IFvOpticsCardModel)iFvCardModel).isAmplitWithPreRole();
        }
        return bl2 || bl;
    }

    private void takeTheSide(IFvInterfaceModel iFvInterfaceModel) {
        if (iFvInterfaceModel instanceof IFvOpticsLineModel) {
            try {
                this.oadmSide = ((IFvOpticsLineModel)iFvInterfaceModel).getSide();
            }
            catch (NoSuchInterface noSuchInterface) {
                this.oadmSide = 0;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                this.oadmSide = 0;
            }
            catch (InternalCommError internalCommError) {
                this.oadmSide = 0;
            }
        }
    }

    private boolean addCorrectLink(int n, int n2) {
        boolean bl = true;
        try {
            InterfaceModels interfaceModels = ((FVNodeModelDelegate)this.nmd).getDelegate().getIfModels();
            ModuleModel moduleModel = interfaceModels.getInterfaceModel(n).getModuleModel();
            int n3 = moduleModel.getEqType();
            if (n3 == 263 || n3 == 267 || n3 == 242 || n3 == 191) {
                OpticsModuleModel opticsModuleModel = (OpticsModuleModel)moduleModel;
                return opticsModuleModel.isEvenWavelengthCard() == this.evenCircuit;
            }
            moduleModel = interfaceModels.getInterfaceModel(n2).getModuleModel();
            n3 = moduleModel.getEqType();
            if (n3 == 263 || n3 == 267 || n3 == 242 || n3 == 191) {
                OpticsModuleModel opticsModuleModel = (OpticsModuleModel)moduleModel;
                return opticsModuleModel.isEvenWavelengthCard() == this.evenCircuit;
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        return bl;
    }

    private IViewLink isPPMeshLink(IFvEntityModel iFvEntityModel, FunctViewWxcLink functViewWxcLink, IFvPortModel iFvPortModel) {
        FunctViewWxcLink functViewWxcLink2 = null;
        int n = iFvPortModel.getEntityIndex();
        IFvOptLinkModel iFvOptLinkModel = functViewWxcLink.getLinkModel().getLink();
        int n2 = iFvOptLinkModel.getFrom();
        int n3 = iFvOptLinkModel.getTo();
        if (n == n2 || n == n3) {
            PpMeshLink ppMeshLink = new PpMeshLink(functViewWxcLink, iFvPortModel);
            this.ppMeshLink.add(ppMeshLink);
            functViewWxcLink2 = functViewWxcLink;
        } else if (iFvEntityModel.getEqType() == 295 && ((IFvOpticsPortModel)iFvPortModel).isOptPortTypeTX()) {
            if (n == n2 || n == n3) {
                PpMeshLink ppMeshLink = new PpMeshLink(functViewWxcLink, iFvPortModel);
                this.ppMeshLink.add(ppMeshLink);
                functViewWxcLink2 = functViewWxcLink;
            }
        } else {
            try {
                int n4 = ((IFvOpticsPortModel)iFvPortModel).getMPO();
                if (n4 != 0) {
                    int n5;
                    int n6 = 0;
                    int n7 = 0;
                    n6 = iFvOptLinkModel.getFromPortModel().getCardModel().getEntityIndex();
                    n7 = iFvOptLinkModel.getToPortModel().getCardModel().getEntityIndex();
                    if (iFvEntityModel.getEntityIndex() == n6) {
                        int n8 = ((IFvOpticsPortModel)iFvOptLinkModel.getFromPortModel()).getMPO();
                        if (n8 == n4) {
                            if (iFvEntityModel.getEqType() == 295 && ((IFvOpticsPortModel)functViewWxcLink.getLinkModel().getLink().getFromPortModel()).isOptPortTypeTX()) {
                                return functViewWxcLink2;
                            }
                            PpMeshLink ppMeshLink = new PpMeshLink(functViewWxcLink, iFvPortModel);
                            this.ppMeshLink.add(ppMeshLink);
                            functViewWxcLink2 = functViewWxcLink;
                        }
                    } else if (iFvEntityModel.getEntityIndex() == n7 && (n5 = ((IFvOpticsPortModel)iFvOptLinkModel.getToPortModel()).getMPO()) == n4) {
                        if (iFvEntityModel.getEqType() == 295 && ((IFvOpticsPortModel)functViewWxcLink.getLinkModel().getLink().getToPortModel()).isOptPortTypeTX()) {
                            return functViewWxcLink2;
                        }
                        PpMeshLink ppMeshLink = new PpMeshLink(functViewWxcLink, iFvPortModel);
                        this.ppMeshLink.add(ppMeshLink);
                        functViewWxcLink2 = functViewWxcLink;
                    }
                }
            }
            catch (NoSuchEquipment noSuchEquipment) {
                SDebug.printStackTrace((Throwable)noSuchEquipment);
            }
            catch (WrongPortType wrongPortType) {
                SDebug.printStackTrace((Throwable)wrongPortType);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return functViewWxcLink2;
    }

    private void adjustWxc() throws FunctException {
        for (PpMeshLink ppMeshLink : this.ppMeshLink) {
            FunctViewWxcLink functViewWxcLink = ppMeshLink.getLink();
            if (functViewWxcLink.getLinkDirection() == 0) {
                this.addLinkForCircuitPaint((IViewLink)functViewWxcLink, null, null, null, functViewWxcLink.getExpTxIModel(), this.nmd, false);
                this.findOneLink = true;
                continue;
            }
            if (functViewWxcLink.getLinkDirection() != 1) continue;
            this.addLinkForCircuitPaint((IViewLink)functViewWxcLink, null, null, functViewWxcLink.getExpRxIModel(ppMeshLink.getSideId()), null, this.nmd, false);
            this.findOneLink = true;
        }
    }

    private void addLinkForCircuitPaint(IViewLink iViewLink, Integer n, Integer n2, IFvInterfaceModel iFvInterfaceModel, IFvInterfaceModel iFvInterfaceModel2, IFvNodeModel iFvNodeModel, boolean bl) throws FunctException {
        FunctViewCircuitPathElement functViewCircuitPathElement = null;
        if (iViewLink == null) {
            throw new FunctException("link is Null");
        }
        functViewCircuitPathElement = !bl ? new FunctViewCircuitPathElement(iViewLink, n, n2, iFvInterfaceModel, iFvInterfaceModel2, iFvNodeModel, this.nodeIsInActivePath) : new FunctViewCircuitPathElement(iViewLink, iFvNodeModel, this.nodeIsInActivePath);
        if (functViewCircuitPathElement != null) {
            this.insertElem(iViewLink.getIndex(), functViewCircuitPathElement);
            functViewCircuitPathElement.setLambda(this.usedLambda);
        }
    }

    public void addCircuitPath(ISOchPath iSOchPath, int n, int n2, boolean bl) {
        this.nodeIsInActivePath = bl;
        this.addPath(iSOchPath, n, n2);
    }

    public HashMap<Integer, ViewCircuitPathElement> getCopyCircuitPathElement() {
        return (HashMap)this.currentCircuitPathElement.clone();
    }

    public int getUsedLambda() {
        return this.usedLambda;
    }

    private ViewCircuitPathElement insertElem(int n, ViewCircuitPathElement viewCircuitPathElement) {
        return this.circuitPathElement.put(n + this.workingSide * 0x1000000, viewCircuitPathElement);
    }

    public class Debug
    extends SDebug {
        public static final String Hlinks = "Print links currently in the circuit path";

        public Debug(String string) {
            super(string);
        }

        public final void links() {
            this.println("# links: " + FunctionalCircuitPath.this.circuitPathElement.size());
            for (ViewCircuitPathElement viewCircuitPathElement : FunctionalCircuitPath.this.circuitPathElement.values()) {
                this.println(viewCircuitPathElement.toString());
            }
        }
    }

    private class PpMeshLink {
        private FunctViewWxcLink link;
        int sideId;

        public FunctViewWxcLink getLink() {
            return this.link;
        }

        public int getSideId() {
            return this.sideId;
        }

        public void setSideId(int n) {
            this.sideId = n;
        }

        public PpMeshLink(FunctViewWxcLink functViewWxcLink, IFvPortModel iFvPortModel) {
            this.link = functViewWxcLink;
            IFvInterfaceModel[] iFvInterfaceModelArray = this.link.getExpRxIModels();
            this.setSideId(0);
            if (iFvInterfaceModelArray != null) {
                for (int i = 0; i < iFvInterfaceModelArray.length; ++i) {
                    IFvInterfaceModel iFvInterfaceModel = iFvInterfaceModelArray[i];
                    if (iFvPortModel.getIFvInterfaceModel() != iFvInterfaceModel) continue;
                    this.setSideId(i);
                }
            }
        }
    }
}

