/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.functional.helper;

import cerent.cms.ui.functional.FunctBandDomainGrapher;
import cerent.cms.ui.functional.SvgCardFactory;
import cerent.cms.ui.functional.SvgGeneralFactory;
import cerent.cms.ui.functional.SvgLabelFactory;
import cerent.cms.ui.functional.SvgPortFactory;
import cerent.util.view.fv.IViewGraph;
import cerent.util.view.fv.IViewNodeDef;
import cerent.util.view.fv.helper.FunctDebug;
import cerent.util.view.fv.helper.FunctException;
import cerent.util.view.fv.helper.SvgParams;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class SvgFactoryDirector
implements IViewNodeDef {
    private static SvgCardFactory cf;
    private static SvgGeneralFactory sgf;
    private static SvgPortFactory sgpf;
    private static SvgLabelFactory slf;

    private SvgFactoryDirector() {
    }

    public static IViewGraph getViewElem(SvgParams svgParams) throws Exception {
        IViewGraph iViewGraph = null;
        try {
            switch (svgParams.getSvgType()) {
                case 1: {
                    iViewGraph = SvgFactoryDirector.getSvgGeneralFactory(svgParams).getViewElem(svgParams);
                    break;
                }
                case 6: {
                    iViewGraph = SvgFactoryDirector.getSvgCardFactory(svgParams).getViewElem(svgParams);
                    break;
                }
                case 8: {
                    iViewGraph = SvgFactoryDirector.getSvgLabelFactory(svgParams).getViewElem(svgParams);
                    break;
                }
                case 9: {
                    iViewGraph = SvgFactoryDirector.getSvgLabelFactory(svgParams).getViewElem(svgParams);
                    break;
                }
                default: {
                    iViewGraph = SvgFactoryDirector.getSvgPortFactory(svgParams).getViewElem(svgParams);
                    break;
                }
            }
        }
        catch (FunctException functException) {
            FunctDebug.printStackTrace((Throwable)functException);
        }
        catch (SAXException sAXException) {
            throw new Exception(sAXException.toString());
        }
        catch (IOException iOException) {
            throw new Exception(iOException.toString());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new Exception(parserConfigurationException.toString());
        }
        return iViewGraph;
    }

    public static FunctBandDomainGrapher createBandDomanin(SvgParams svgParams, int n) throws SAXException, IOException, ParserConfigurationException {
        FunctBandDomainGrapher functBandDomainGrapher = null;
        try {
            svgParams.index = n;
            functBandDomainGrapher = (FunctBandDomainGrapher)SvgFactoryDirector.getDefaultViewElem(svgParams);
            functBandDomainGrapher.setEven(n);
        }
        catch (FunctException functException) {
            FunctDebug.printStackTrace((Throwable)functException);
        }
        return functBandDomainGrapher;
    }

    public static IViewGraph getDefaultViewElem(SvgParams svgParams) throws SAXException, IOException, ParserConfigurationException, FunctException {
        return SvgFactoryDirector.getSvgGeneralFactory(svgParams).getViewElem(svgParams);
    }

    private static SvgCardFactory getSvgCardFactory(SvgParams svgParams) {
        if (cf != null) {
            return cf;
        }
        cf = new SvgCardFactory(svgParams.getNodeModel());
        return cf;
    }

    private static SvgGeneralFactory getSvgGeneralFactory(SvgParams svgParams) {
        if (sgf != null) {
            return sgf;
        }
        sgf = new SvgGeneralFactory(svgParams.getNodeModel());
        return sgf;
    }

    private static SvgLabelFactory getSvgLabelFactory(SvgParams svgParams) {
        if (slf != null) {
            return slf;
        }
        slf = new SvgLabelFactory(svgParams.getNodeModel());
        return slf;
    }

    private static SvgPortFactory getSvgPortFactory(SvgParams svgParams) {
        if (sgpf != null) {
            return sgpf;
        }
        sgpf = new SvgPortFactory(svgParams.getNodeModel());
        return sgpf;
    }

    static {
        sgf = null;
        sgpf = null;
        slf = null;
    }
}

