/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.hdge;

import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.HdGeModuleModel;
import cerent.cms.model.IModel;
import cerent.cms.model.InvalidEtherTransponderProvisioning;
import cerent.cms.model.InvalidMaxFrameSize;
import cerent.cms.model.InvalidWaterMarkValue;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.TransponderInvalidWithCircuits;
import cerent.cms.model.Uni2PortAutonegProvError;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.hdge.HdGePortTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.FixedLengthField;
import cerent.util.gui.SoakTimeCellEditor;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class HdGePortProvPane
extends NodeProvPane
implements PropertyChangeListener,
TableModelListener {
    protected HdGePortTableModel dataModel = null;
    protected EtherLineModel[] lineModels = null;
    protected int numLines;
    private static final SDebug db = new SDebug("HdGePortProvPane");

    public HdGePortProvPane(String string, TabbedView tabbedView, EtherLineModel[] etherLineModelArray) {
        super(string, tabbedView);
        this.lineModels = etherLineModelArray;
        this.numLines = etherLineModelArray == null ? 0 : etherLineModelArray.length;
        this.setDataModel();
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.customizedProvPane();
        this.add((Component)uScrollPane);
    }

    public void enteringPage() throws Exception {
        this.registerWithModel();
        super.enteringPage();
        if (db.on()) {
            db.println("HdGePortProvPane::enteringPage!");
        }
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        this.unRegisterWithModel();
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (db.on()) {
            db.println("HdGePortLineProvPane::leavingPage!");
        }
        super.leavingPage();
    }

    protected void customizedProvPane() {
        TableColumn tableColumn = null;
        Attribute[] attributeArray = null;
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[0]);
        tableColumn.setCellEditor(new DefaultCellEditor(new JTextField()));
        tableColumn.setPreferredWidth(90);
        tableColumn.setCellRenderer(PORT_CELL_RENDERER);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[1]);
        tableColumn.setCellEditor(new DefaultCellEditor(new FixedLengthField(32)));
        tableColumn.setPreferredWidth(150);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[2]);
        boolean bl = AdminState.isANSI(this.getUiModel().getNodeModel().getTdmProtocolType());
        AdminState[] adminStateArray = AdminState.getDefaultAdminStates(bl);
        JComboBox<AdminState> jComboBox = new JComboBox<AdminState>(adminStateArray);
        jComboBox.setEditable(false);
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        tableColumn.sizeWidthToFit();
        tableColumn = this.table.getColumn(this.dataModel.columnNames[9]);
        attributeArray = this.getAttributeArray("G1000 Port Max Size");
        tableColumn.setCellEditor(new DefaultCellEditor((JComboBox<?>)this.getComboBoxFor(attributeArray)));
        tableColumn.sizeWidthToFit();
        if (!this.pci.is327()) {
            tableColumn = this.table.getColumn(this.dataModel.columnNames[11]);
            attributeArray = this.getAttributeArray("G1000 Transponder Port");
            tableColumn.setCellEditor(new DefaultCellEditor((JComboBox<?>)this.getTxpPortComboBox(attributeArray)));
            tableColumn.sizeWidthToFit();
            tableColumn = this.table.getColumn(this.dataModel.columnNames[12]);
            attributeArray = this.getAttributeArray("G1000 Transponder Mode");
            tableColumn.setCellEditor(new DefaultCellEditor((JComboBox<?>)this.getComboBoxFor(attributeArray)));
            tableColumn.sizeWidthToFit();
        } else {
            tableColumn = this.table.getColumn(this.dataModel.columnNames[11]);
            this.table.removeColumn(tableColumn);
            tableColumn = this.table.getColumn(this.dataModel.columnNames[12]);
            this.table.removeColumn(tableColumn);
        }
        SoakTimeCellEditor soakTimeCellEditor = new SoakTimeCellEditor(this);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[4]);
        tableColumn.setCellEditor(soakTimeCellEditor);
        tableColumn.setMinWidth(soakTimeCellEditor.getPreferredWidth() + 10);
        this.table.setRowHeight(soakTimeCellEditor.getPreferredHeight());
        tableColumn = this.table.getColumn(this.dataModel.columnNames[13]);
        attributeArray = this.getAttributeArray("G1000 Water Marks Setting");
        tableColumn.setCellEditor(new DefaultCellEditor((JComboBox<?>)this.getComboBoxFor(attributeArray)));
        tableColumn.sizeWidthToFit();
        tableColumn = this.table.getColumn(this.dataModel.columnNames[14]);
        tableColumn.setCellEditor(new DefaultCellEditor(new JTextField()));
        tableColumn.sizeWidthToFit();
        tableColumn = this.table.getColumn(this.dataModel.columnNames[15]);
        tableColumn.setCellEditor(new DefaultCellEditor(new JTextField()));
        tableColumn.sizeWidthToFit();
        tableColumn = this.table.getColumn(this.dataModel.columnNames[10]);
        attributeArray = this.getAttributeArray("G1000 Payload Type");
        tableColumn.setCellEditor(new DefaultCellEditor((JComboBox<?>)this.getComboBoxFor(attributeArray)));
        tableColumn.sizeWidthToFit();
        this.table.sizeColumnsToFit(-1);
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    private UComboBox getTxpPortComboBox(Attribute[] attributeArray) {
        int n = ((ModuleModel)this.getUiModel()).getPortModels().length;
        Object[] objectArray = new Attribute[n + 1];
        System.arraycopy(attributeArray, 0, objectArray, 0, objectArray.length);
        return new UComboBox(objectArray);
    }

    protected void setDataModel() {
        this.dataModel = new HdGePortTableModel((HdGeModuleModel)this.getUiModel(), this.lineModels);
        this.dataModel.addTableModelListener(this);
    }

    private UComboBox getComboBoxFor(Attribute[] attributeArray) {
        UComboBox uComboBox = new UComboBox((Object[])attributeArray);
        uComboBox.setEditable(false);
        return uComboBox;
    }

    protected AttributeMaps getAttributeMap() {
        IModel iModel = this.uiModel;
        return ElementDefaults.getAttributeMap(iModel);
    }

    protected Attribute[] getAttributeArray(String string) {
        return this.getAttributeMap().getAttributeArray(string);
    }

    protected void registerWithModel() {
        if (this.lineModels == null) {
            return;
        }
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].addObserver((Observer)((Object)this));
        }
    }

    protected void unRegisterWithModel() {
        if (this.lineModels == null) {
            return;
        }
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].deleteObserver((Observer)((Object)this));
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            this.requestRefresh(observable, this.getRefreshThread(observable));
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                HdGePortProvPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else if (db.on()) {
            db.println("In HdGePortProvPane change Message cannot find Model " + observable);
        }
    }

    public void destroy() {
        this.unRegisterWithModel();
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
            this.dataModel.destroy();
            this.dataModel = null;
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    protected boolean queryRemainDirty() {
        return true;
    }

    public void applyChangesToModel() throws Exception {
        if (!this.preApply()) {
            return;
        }
        try {
            Vector vector = this.dataModel.applyToModel();
            if (vector.size() > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                if (vector.size() > 1) {
                    for (int i = 0; i < vector.size(); ++i) {
                        stringBuffer.append(this.dataModel.getLineNumberFor((Integer)vector.get(i)));
                        if (i < vector.size() - 1) {
                            stringBuffer.append(", ");
                            continue;
                        }
                        stringBuffer.append(" ");
                    }
                } else {
                    stringBuffer.append(" " + this.dataModel.getLineNumberFor((Integer)vector.get(0)));
                }
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_PORT_CHANGE_DISALLOWED_PARAM_1, (Object)stringBuffer);
            }
        }
        catch (InvalidMaxFrameSize invalidMaxFrameSize) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_MAX_FRAME_SIZE);
        }
        catch (Uni2PortAutonegProvError uni2PortAutonegProvError) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_UNIDIR_2PORT_AUTONEG);
        }
        catch (TransponderInvalidWithCircuits transponderInvalidWithCircuits) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_TRANS_WITH_CKTS);
        }
        catch (InvalidEtherTransponderProvisioning invalidEtherTransponderProvisioning) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_TRANS);
        }
        catch (InvalidWaterMarkValue invalidWaterMarkValue) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_WATERMARK);
        }
        catch (EMCProvisionError eMCProvisionError) {
            ErrorMsg.displayError((Component)((Object)this), (EID)eMCProvisionError.getEID(), (Object[])eMCProvisionError.getEIDParams());
        }
        this.resetDirty();
    }

    private boolean preApply() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        if (AdminState.adminStateChangedToFormOfOOS(this.dataModel, this.lineModels)) {
            stringBuffer.append(AdminState.getBaseOosWarning(this.terms)).append('\n');
            bl2 = true;
        }
        if (AdminState.needRemoveLoopback(this.dataModel, this.lineModels)) {
            stringBuffer.append("Some lines will be removed from loopback since their new state does not allow loopback.").append('\n');
            bl = true;
        }
        if (bl || bl2) {
            if (bl2) {
                String string = AdminState.getSevWarningMsg(this.dataModel, this.lineModels, bl, true);
                stringBuffer.append(string).append("\n\n").append(this.getApplyString(false));
            } else {
                stringBuffer.append(this.getApplyString());
            }
            return CerentDialog.yesNoDialog((Component)((Object)this), (String)stringBuffer.toString(), (String)"Confirmation Dialog");
        }
        return true;
    }

    public boolean onValidate() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        stringBuffer.append("Ports cannot be provisioned in transponder mode when:\n");
        if (!this.dataModel.isTransponderValid()) {
            stringBuffer.append("- other ports are provisioned in normal mode (i.e., have circuits)\n");
            bl = true;
        }
        if (!this.dataModel.isAutonegotiationValid()) {
            stringBuffer.append("- autonegotiation is enabled (unidirectional transponding only)\n");
            bl = true;
        }
        if (bl) {
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_CHANGES, stringBuffer.toString());
            return false;
        }
        if (!this.dataModel.isWaterMarkValid()) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_WATERMARK_VALUE);
            return false;
        }
        return true;
    }

    public void refreshFromModel() throws Exception {
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    protected void setAttrCellEditor(int n, String string) {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.columnNames[n]);
        Attribute[] attributeArray = this.getAttributeArray(string);
        tableColumn.setCellEditor(new DefaultCellEditor((JComboBox<?>)this.getComboBoxFor(attributeArray)));
        tableColumn.sizeWidthToFit();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.HdGePortProvPane;
    }
}

