/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.intpatch;

import cerent.cms.idl.Common.eBandGridOpticalType;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Optics.eOpticalAmplifierRole;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmPortModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.ILmpDataLinkModel;
import cerent.cms.model.ILmpDataLinkModels;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOpticalPatchCordModel;
import cerent.cms.model.IOpticsChannelModel;
import cerent.cms.model.IOpticsPortModel;
import cerent.cms.model.IVirtualLinkModel;
import cerent.cms.model.IXPL2ModuleModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OchPortsHelper;
import cerent.cms.model.OpticalPortType;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.PassiveModuleModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmModuleModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.VirtualLinksManager;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.WrongPortType;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntPatchHelper {
    private static final SDebug db = new SDebug("IntPatchHelper");

    private IntPatchHelper() {
    }

    public static IEntityModel[] getOchTxpPorts(INodeModel iNodeModel, int n, StringBuffer stringBuffer) {
        IEntityModel[] iEntityModelArray = IntPatchHelper.getShelves(iNodeModel);
        ArrayList<IEntityModel> arrayList = new ArrayList<IEntityModel>();
        for (int i = 0; i < iEntityModelArray.length; ++i) {
            EntityModel entityModel = (EntityModel)iEntityModelArray[i];
            List list = entityModel.getChildrenOfType(eClass.BACKPLANE);
            List list2 = ((EntityModel)list.get(0)).getChildren();
            for (int j = 0; j < list2.size(); ++j) {
                PortModel[] portModelArray;
                Object e;
                EntityModel entityModel2 = (EntityModel)list2.get(j);
                List list3 = entityModel2.getChildren();
                if (list3.size() <= 0 || !((e = list3.get(0)) instanceof ModuleModel)) continue;
                ModuleModel moduleModel = (ModuleModel)e;
                int n2 = moduleModel.getEqType();
                if (moduleModel instanceof DwdmModuleModel) {
                    for (PortModel portModel : portModelArray = moduleModel.getPortModels()) {
                        if (portModel instanceof DwdmPortModel) {
                            IntPatchHelper.checkDwdmPort((DwdmPortModel)portModel, arrayList, n);
                            continue;
                        }
                        if (!(portModel instanceof TdmPortModel) || !db.isFinestEnabled()) continue;
                        db.println("Port " + portModel + " discarded as PPM port");
                    }
                    continue;
                }
                if (!IntPatchHelper.isITU_TCard(n2) || !IntPatchHelper.isColoredLinecard((ModuleModel)e, stringBuffer)) continue;
                for (PortModel portModel : portModelArray = moduleModel.getPortModels()) {
                    IntPatchHelper.checkTdmPort((TdmPortModel)portModel, arrayList, n);
                }
            }
        }
        return arrayList.toArray(new IEntityModel[0]);
    }

    public static IEntityModel[] getTrkL2Ports(INodeModel iNodeModel, IEntityModel iEntityModel) {
        IEntityModel[] iEntityModelArray = IntPatchHelper.getShelves(iNodeModel);
        ArrayList<IEntityModel> arrayList = new ArrayList<IEntityModel>();
        for (int i = 0; i < iEntityModelArray.length; ++i) {
            EntityModel entityModel = (EntityModel)iEntityModelArray[i];
            List list = entityModel.getChildrenOfType(eClass.BACKPLANE);
            List list2 = ((EntityModel)list.get(0)).getChildren();
            for (int j = 0; j < list2.size(); ++j) {
                PortModel[] portModelArray;
                ModuleModel moduleModel;
                Object e;
                EntityModel entityModel2 = (EntityModel)list2.get(j);
                List list3 = entityModel2.getChildren();
                if (list3.size() <= 0 || !((e = list3.get(0)) instanceof ModuleModel) || !IntPatchHelper.isL2Module(moduleModel = (ModuleModel)e)) continue;
                for (PortModel portModel : portModelArray = moduleModel.getPortModels()) {
                    if (!(portModel instanceof DwdmPortModel)) continue;
                    IntPatchHelper.checkL2DwdmPort((DwdmPortModel)portModel, arrayList, iEntityModel);
                }
            }
        }
        return arrayList.toArray(new IEntityModel[0]);
    }

    private static void checkDwdmPort(DwdmPortModel dwdmPortModel, ArrayList<IEntityModel> arrayList, int n) {
        block15: {
            if (!dwdmPortModel.isClientPort()) {
                try {
                    DwdmTrkLineModel dwdmTrkLineModel = (DwdmTrkLineModel)dwdmPortModel.getInterfaceModel();
                    if (dwdmTrkLineModel != null) {
                        if (!dwdmTrkLineModel.isInterlink()) {
                            int n2 = dwdmTrkLineModel.getWavelength();
                            if (n == n2 || n2 == 0) {
                                if (!IntPatchHelper.isPortAlreadyUsed(dwdmPortModel)) {
                                    arrayList.add(dwdmPortModel);
                                } else if (db.isFinestEnabled()) {
                                    db.println("Port " + dwdmPortModel + " discarded because already in use");
                                }
                            } else if (db.isFinestEnabled()) {
                                db.println("Port " + dwdmPortModel + " discarded because of unmatched wl (" + n2 + " != " + n + ")");
                            }
                        } else if (db.isFinestEnabled()) {
                            db.println("Port " + dwdmPortModel + " discarded because interlink");
                        }
                        break block15;
                    }
                    db.warning("Cannot get interface model for " + dwdmPortModel);
                }
                catch (Exception exception) {
                    db.warning("Cannot get wl for " + dwdmPortModel);
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    break block15;
                }
            }
            if (db.isFinestEnabled()) {
                db.println("Port " + dwdmPortModel + " discarded because client port");
            }
        }
    }

    private static void checkL2DwdmPort(DwdmPortModel dwdmPortModel, ArrayList<IEntityModel> arrayList, IEntityModel iEntityModel) {
        if (iEntityModel != null) {
            if (dwdmPortModel.getModuleModel() == iEntityModel.getModuleModel()) {
                return;
            }
            if (dwdmPortModel.getModuleModel().getEqType() != iEntityModel.getModuleModel().getEqType()) {
                return;
            }
        }
        if (!dwdmPortModel.isClientPort()) {
            if (!IntPatchHelper.isPortAlreadyUsed(dwdmPortModel) && !IntPatchHelper.isPortUsedByPPC(dwdmPortModel)) {
                arrayList.add(dwdmPortModel);
            } else if (db.isFinestEnabled()) {
                db.println("Port " + dwdmPortModel + " discarded because already in use");
            }
        } else if (db.isFinestEnabled()) {
            db.println("Port " + dwdmPortModel + " discarded because client port");
        }
    }

    private static boolean isPortUsedByPPC(DwdmPortModel dwdmPortModel) {
        NodeModelDelegate nodeModelDelegate = dwdmPortModel.getNodeModelDelegate();
        VirtualLinksManager virtualLinksManager = (VirtualLinksManager)nodeModelDelegate.getVirtualLinksManager();
        IVirtualLinkModel[] iVirtualLinkModelArray = virtualLinksManager.getVirtualLinks();
        if (iVirtualLinkModelArray != null && iVirtualLinkModelArray.length > 0) {
            for (int i = 0; i < iVirtualLinkModelArray.length; ++i) {
                InterfaceModel interfaceModel;
                IEntityModel iEntityModel = iVirtualLinkModelArray[i].getOrigEntity();
                if (iEntityModel == dwdmPortModel) {
                    return true;
                }
                InterfaceModel interfaceModel2 = (InterfaceModel)dwdmPortModel.getInterfaceModel();
                if (interfaceModel2 == null || (interfaceModel = interfaceModel2.getHigherLayerModels()[0]) == null) continue;
                try {
                    if (interfaceModel.getPortModel() == iEntityModel) {
                        return true;
                    }
                    continue;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        return false;
    }

    private static void checkTdmPort(TdmPortModel tdmPortModel, ArrayList<IEntityModel> arrayList, int n) {
        block14: {
            IModuleModel iModuleModel = tdmPortModel.getModuleModel();
            if (!iModuleModel.isPreProvisioned() || IntPatchHelper.isMrcCard(iModuleModel.getEqType())) {
                try {
                    TdmLineModel tdmLineModel = (TdmLineModel)tdmPortModel.getInterfaceModel();
                    if (tdmLineModel != null) {
                        int n2 = tdmLineModel.getExpectedWaveLength();
                        if (n == n2 || n2 == 0) {
                            if (!IntPatchHelper.isPortAlreadyUsed(tdmPortModel)) {
                                arrayList.add(tdmPortModel);
                            } else if (db.isFinestEnabled()) {
                                db.println("Port " + tdmPortModel + " discarded because already in use");
                            }
                        } else if (db.isFinestEnabled()) {
                            db.println("Port " + tdmPortModel + " discarded because of unmatched wl (" + n2 + " != " + n + ")");
                        }
                        break block14;
                    }
                    db.warning("Cannot get interface model for " + tdmPortModel);
                }
                catch (Exception exception) {
                    db.warning("Cannot get wl for " + tdmPortModel);
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    break block14;
                }
            }
            if (!IntPatchHelper.isPortAlreadyUsed(tdmPortModel)) {
                arrayList.add(tdmPortModel);
            } else if (db.isFinestEnabled()) {
                db.println("Port " + tdmPortModel + " discarded because already in use");
            }
        }
    }

    public static IModuleModel[] getOpticModules(INodeModel iNodeModel) {
        return IntPatchHelper.getOpticModules(IntPatchHelper.getShelves(iNodeModel));
    }

    private static ModuleModel[] getOpticModules(IEntityModel[] iEntityModelArray) {
        List list;
        EntityModel entityModel;
        int n;
        ArrayList<ModuleModel> arrayList = new ArrayList<ModuleModel>();
        for (n = 0; n < iEntityModelArray.length; ++n) {
            entityModel = (EntityModel)iEntityModelArray[n];
            list = entityModel.getChildrenOfType(eClass.BACKPLANE);
            List list2 = ((EntityModel)list.get(0)).getChildren();
            for (int i = 0; i < list2.size(); ++i) {
                IEntityModel iEntityModel;
                EntityModel entityModel2 = (EntityModel)list2.get(i);
                List list3 = entityModel2.getChildren();
                if (list3.size() <= 0 || !((iEntityModel = (IEntityModel)list3.get(0)) instanceof OpticsModuleModel)) continue;
                arrayList.add((ModuleModel)iEntityModel);
            }
        }
        for (n = 0; n < iEntityModelArray.length; ++n) {
            entityModel = (EntityModel)iEntityModelArray[n];
            list = entityModel.getChildrenOfType(eClass.E_MODULE);
            for (EntityModel entityModel3 : list) {
                if (!(entityModel3 instanceof PassiveModuleModel)) continue;
                arrayList.add((ModuleModel)entityModel3);
            }
        }
        return arrayList.toArray(new ModuleModel[0]);
    }

    private static boolean filterModule(IEntityModel iEntityModel, PortFilter portFilter) {
        boolean bl;
        if (portFilter.parent != null && portFilter.parent != iEntityModel) {
            if (db.isFinestEnabled()) {
                db.println("Parent filter <" + portFilter.parent + "> discars current module <" + iEntityModel + ">");
            }
            return false;
        }
        if (portFilter.notOfParent != null && portFilter.notOfParent == iEntityModel) {
            if (db.isFinestEnabled()) {
                db.println("Not Of Parent filter <" + portFilter.notOfParent + "> discars current module <" + iEntityModel + ">");
            }
            return false;
        }
        if (portFilter.parentClass != null && !portFilter.parentClass.isInstance(iEntityModel)) {
            if (db.isFinestEnabled()) {
                db.println("Parent class filter <" + portFilter.parentClass + "> discars current module <" + iEntityModel + ">");
            }
            return false;
        }
        if (portFilter.parentNotOfClass != null && portFilter.parentNotOfClass.isInstance(iEntityModel)) {
            if (db.isFinestEnabled()) {
                db.println("Parent not of class filter <" + portFilter.parentClass + "> discars current module <" + iEntityModel + ">");
            }
            return false;
        }
        if (portFilter.eqtype.size() > 0) {
            bl = false;
            for (eEqType eEqType2 : portFilter.eqtype) {
                if (iEntityModel.getEqType() != eEqType2.value()) continue;
                bl = true;
                break;
            }
            if (!bl) {
                if (db.isFinestEnabled()) {
                    db.println("Eqtype not found <" + portFilter.eqtype + "> discars current module <" + iEntityModel + ">");
                }
                return false;
            }
        }
        if (portFilter.notOfEqtype.size() > 0) {
            bl = false;
            for (eEqType eEqType2 : portFilter.notOfEqtype) {
                if (iEntityModel.getEqType() != eEqType2.value()) continue;
                bl = true;
                break;
            }
            if (bl) {
                if (db.isFinestEnabled()) {
                    db.println("NOT OF Eqtype found <" + portFilter.eqtype + "> discars current module <" + iEntityModel + ">");
                }
                return false;
            }
        }
        return true;
    }

    private static boolean isL2Module(ModuleModel moduleModel) {
        boolean bl = false;
        switch (moduleModel.getEqType()) {
            case 271: 
            case 272: {
                if (!(moduleModel instanceof IXPL2ModuleModel)) break;
                bl = ((IXPL2ModuleModel)moduleModel).isL2Switch();
                break;
            }
        }
        return bl;
    }

    public static boolean isColoredLinecard(ModuleModel moduleModel, StringBuffer stringBuffer) {
        boolean bl = false;
        if (IntPatchHelper.isMrcCard(moduleModel.getEqType())) {
            bl = true;
        } else if (!moduleModel.isPreProvisioned()) {
            TdmModuleModel tdmModuleModel = (TdmModuleModel)moduleModel;
            TdmLineModel[] tdmLineModelArray = tdmModuleModel.getTdmLineModels();
            for (int i = 0; !bl && i < tdmLineModelArray.length; ++i) {
                TdmLineModel tdmLineModel = tdmLineModelArray[i];
                try {
                    bl = tdmLineModel.isWavelengthSupported();
                    continue;
                }
                catch (Exception exception) {
                    db.warning("Cannot state if port " + tdmLineModel + " is colored: " + exception.getMessage());
                    if (!db.on()) continue;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        } else {
            if (stringBuffer != null) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("\n");
                }
                stringBuffer.append(moduleModel.getEqTypeName() + "/Slot " + moduleModel.getSlot());
            }
            bl = true;
        }
        return bl;
    }

    public static boolean isColoredLinecard(ModuleModel moduleModel) {
        return IntPatchHelper.isColoredLinecard(moduleModel, null);
    }

    private static boolean isITU_TCard(int n) {
        switch (n) {
            case 11: 
            case 60: {
                return true;
            }
        }
        return IntPatchHelper.isMrcCard(n);
    }

    public static boolean isMrcCard(int n) {
        switch (n) {
            case 219: 
            case 253: 
            case 254: {
                return true;
            }
        }
        return false;
    }

    public static PortFilter getFilter() {
        return IntPatchHelper.getFilter(true, 0);
    }

    public static PortFilter getFilter(boolean bl) {
        return IntPatchHelper.getFilter(bl, 0);
    }

    public static PortFilter getFilter(boolean bl, int n) {
        PortFilter portFilter = new PortFilter();
        portFilter.txonly = bl;
        portFilter.rxonly = !bl;
        portFilter.wavelength = n;
        return portFilter;
    }

    public static PortFilter getFilter(PortFilter portFilter) {
        PortFilter portFilter2 = new PortFilter();
        portFilter2.txonly = portFilter.txonly;
        portFilter2.rxonly = portFilter.rxonly;
        portFilter2.wavelength = portFilter.wavelength;
        portFilter2.onlyPassiveUnits = portFilter.onlyPassiveUnits;
        portFilter2.filterMPOOnly = portFilter.filterMPOOnly;
        portFilter2.grid = portFilter.grid;
        return portFilter2;
    }

    public static IEntityModel[] getOchPorts(INodeModel iNodeModel, PortFilter portFilter) {
        IEntityModel[] iEntityModelArray = IntPatchHelper.getShelves(iNodeModel);
        ModuleModel[] moduleModelArray = IntPatchHelper.getOpticModules(iEntityModelArray);
        ArrayList<IEntityModel> arrayList = IntPatchHelper.filterOCHPorts(moduleModelArray, portFilter);
        for (PortFilter portFilter2 : portFilter.or) {
            arrayList.addAll(IntPatchHelper.filterOCHPorts(moduleModelArray, portFilter2));
        }
        return arrayList.toArray(new IEntityModel[0]);
    }

    private static ArrayList<IEntityModel> filterOCHPorts(ModuleModel[] moduleModelArray, PortFilter portFilter) {
        ArrayList<IEntityModel> arrayList = new ArrayList<IEntityModel>();
        for (int i = 0; i < moduleModelArray.length; ++i) {
            if (!IntPatchHelper.filterModule(moduleModelArray[i], portFilter)) continue;
            PortModel[] portModelArray = moduleModelArray[i].getPortModels();
            for (int j = 0; j < portModelArray.length; ++j) {
                PortModel portModel = portModelArray[j];
                if (IntPatchHelper.isPortAlreadyUsed(portModel, portFilter.acceptRepetition, portFilter.originPort) || !IntPatchHelper.isPortOfSelectedDir(portModel, portFilter.rxonly, portFilter.txonly) || !IntPatchHelper.isPortofSelectedWL(portModel, portFilter.wavelength) || !IntPatchHelper.filterPortType(portModel, portFilter.porttype, portFilter.optype, portFilter.notOfOptype)) continue;
                arrayList.add(portModel);
            }
        }
        if (portFilter.filterMPOOnly) {
            arrayList = IntPatchHelper.filterMPOPorts(arrayList);
        }
        return arrayList;
    }

    public static IEntityModel[] getOtsPorts(INodeModel iNodeModel, PortFilter portFilter) {
        IEntityModel[] iEntityModelArray = IntPatchHelper.getShelves(iNodeModel);
        ModuleModel[] moduleModelArray = IntPatchHelper.getOpticModules(iEntityModelArray);
        ArrayList<IEntityModel> arrayList = IntPatchHelper.filterOTSPorts(moduleModelArray, portFilter);
        for (PortFilter portFilter2 : portFilter.or) {
            arrayList.addAll(IntPatchHelper.filterOTSPorts(moduleModelArray, portFilter2));
        }
        return arrayList.toArray(new IEntityModel[0]);
    }

    private static ArrayList<IEntityModel> filterOTSPorts(ModuleModel[] moduleModelArray, PortFilter portFilter) {
        ArrayList<IEntityModel> arrayList = new ArrayList<IEntityModel>();
        for (int i = 0; i < moduleModelArray.length; ++i) {
            if (!IntPatchHelper.filterModule(moduleModelArray[i], portFilter)) continue;
            PortModel[] portModelArray = moduleModelArray[i].getPortModels();
            for (int j = 0; j < portModelArray.length; ++j) {
                PortModel portModel = portModelArray[j];
                if (db.isFinestEnabled()) {
                    db.println("Port " + portModel.getPortNum() + portModel + portModel.getEqTypeName());
                }
                if (IntPatchHelper.isPortAlreadyUsed(portModel, portFilter.acceptRepetition, portFilter.originPort) || !IntPatchHelper.isPortElegibleOts(portModel) || !IntPatchHelper.isPortOfSelectedDir(portModel, portFilter.rxonly, portFilter.txonly) || !IntPatchHelper.isPortOfSelectedGrid(portModel, portFilter.grid) || !IntPatchHelper.filterPortType(portModel, portFilter.porttype, portFilter.optype, portFilter.notOfOptype)) continue;
                arrayList.add(portModel);
            }
        }
        if (portFilter.filterMPOOnly) {
            arrayList = IntPatchHelper.filterMPOPorts(arrayList);
        }
        return arrayList;
    }

    private static ArrayList<IEntityModel> filterMPOPorts(ArrayList<IEntityModel> arrayList) {
        ArrayList<IEntityModel> arrayList2 = new ArrayList<IEntityModel>();
        for (IEntityModel iEntityModel : arrayList) {
            if (!(iEntityModel instanceof IOpticsPortModel)) continue;
            try {
                if (((IOpticsPortModel)iEntityModel).getMPO() == 0 || ((IOpticsPortModel)iEntityModel).getPositionInMPO() != 1) continue;
                arrayList2.add(iEntityModel);
                if (!db.isFinestEnabled()) continue;
                db.println("MPO added " + ((IOpticsPortModel)iEntityModel).getMPO() + iEntityModel + iEntityModel.getEqTypeName());
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return arrayList2;
    }

    public static IEntityModel[] getOpticalPorts(INodeModel iNodeModel, PortFilter portFilter) {
        IEntityModel[] iEntityModelArray = IntPatchHelper.getShelves(iNodeModel);
        ModuleModel[] moduleModelArray = IntPatchHelper.getOpticModules(iEntityModelArray);
        List<IEntityModel> list = IntPatchHelper.filterOpticalPorts(moduleModelArray, portFilter);
        for (PortFilter portFilter2 : portFilter.or) {
            list.addAll(IntPatchHelper.filterOpticalPorts(moduleModelArray, portFilter2));
        }
        return list.toArray(new IEntityModel[0]);
    }

    private static List<IEntityModel> filterOpticalPorts(ModuleModel[] moduleModelArray, PortFilter portFilter) {
        ArrayList<IEntityModel> arrayList = new ArrayList<IEntityModel>();
        for (int i = 0; i < moduleModelArray.length; ++i) {
            if (!IntPatchHelper.filterModule(moduleModelArray[i], portFilter)) continue;
            PortModel[] portModelArray = moduleModelArray[i].getPortModels();
            for (int j = 0; j < portModelArray.length; ++j) {
                PortModel portModel = portModelArray[j];
                if (db.isFinestEnabled()) {
                    db.println("Port " + portModel.getPortNum() + portModel + portModel.getEqTypeName());
                }
                if (!IntPatchHelper.isPortOfSelectedDir(portModel, portFilter.rxonly, portFilter.txonly) || !IntPatchHelper.isPortOfSelectedGrid(portModel, portFilter.grid) || !IntPatchHelper.filterPortType(portModel, portFilter.porttype, portFilter.optype, portFilter.notOfOptype) || !IntPatchHelper.isPortSupportingFeatures(portModel, portFilter.features)) continue;
                arrayList.add(portModel);
            }
        }
        return arrayList;
    }

    private static boolean isPortOfSelectedDir(PortModel portModel, boolean bl, boolean bl2) {
        boolean bl3 = true;
        if (portModel instanceof IOpticsPortModel) {
            IOpticsPortModel iOpticsPortModel = (IOpticsPortModel)portModel;
            if (bl) {
                bl3 = iOpticsPortModel.isOptPortTypeRX();
            } else if (bl2) {
                bl3 = iOpticsPortModel.isOptPortTypeTX();
            }
        }
        if (bl3 && db.isFinestEnabled()) {
            db.println("Direction filter passed for " + portModel);
        }
        return bl3;
    }

    private static boolean isPortofSelectedWL(PortModel portModel, int n) {
        boolean bl;
        block3: {
            bl = false;
            try {
                int n2 = IntPatchHelper.getWlen(portModel);
                bl = n2 == n || n2 == 0;
            }
            catch (Exception exception) {
                db.warning("Cannot evaluate isPortofSelectedWL for " + portModel + ": " + exception.getMessage());
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (bl && db.isFinestEnabled()) {
            db.println("Wavelength [" + n + "] filter passed for " + portModel);
        }
        return bl;
    }

    private static boolean isPortOfSelectedGrid(PortModel portModel, eBandGridOpticalType eBandGridOpticalType2) {
        boolean bl;
        block9: {
            bl = false;
            if (portModel instanceof OpticsPortModel) {
                try {
                    eBandGridOpticalType eBandGridOpticalType3 = ((OpticsPortModel)portModel).getGrid();
                    switch (eBandGridOpticalType2.value()) {
                        case 0: {
                            bl = true;
                            break;
                        }
                        case 3: {
                            bl = eBandGridOpticalType3 == eBandGridOpticalType.GHz_50_GRID || eBandGridOpticalType3 == eBandGridOpticalType.GHz_100_ODD_GRID || eBandGridOpticalType3 == eBandGridOpticalType.GHz_100_EVEN_GRID;
                            break;
                        }
                        case 1: 
                        case 2: {
                            boolean bl2 = bl = eBandGridOpticalType3 == eBandGridOpticalType2;
                        }
                    }
                    if (bl && db.isFinestEnabled()) {
                        db.println("Grid " + eBandGridOpticalType3 + " filter passed for " + portModel);
                    }
                }
                catch (Exception exception) {
                    db.warning("Cannot evaluate isPortOfSelectedGrid for " + portModel + ": " + exception.getMessage());
                    if (!db.on()) break block9;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return bl;
    }

    private static boolean isPortSupportingFeatures(PortModel portModel, int n) {
        boolean bl;
        block4: {
            bl = true;
            if (n != 0 && portModel instanceof OpticsPortModel) {
                try {
                    int n2 = ((OpticsPortModel)portModel).getFeatures();
                    boolean bl2 = bl = (n2 & n) == n;
                    if (bl && db.isFinestEnabled()) {
                        db.println("Features [" + n + "] filter passed for " + portModel);
                    }
                }
                catch (Exception exception) {
                    db.warning("Cannot evaluate isPortOfSelectedGrid for " + portModel + ": " + exception.getMessage());
                    if (!db.on()) break block4;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return bl;
    }

    private static boolean filterPortType(PortModel portModel, List<eEqType> list, List<OpticalPortType> list2, List<OpticalPortType> list3) {
        block11: {
            if (list.size() > 0 && !list.contains(portModel.getEqTypeEnum())) {
                if (db.isFinestEnabled()) {
                    db.println("Port Type [" + list + "] filter NOT passed for port " + portModel);
                }
                return false;
            }
            if (portModel instanceof OpticsPortModel) {
                try {
                    OpticalPortType opticalPortType = ((OpticsPortModel)portModel).getOptPortType();
                    if (list2.size() > 0) {
                        for (OpticalPortType opticalPortType2 : list2) {
                            if (opticalPortType2 != opticalPortType) continue;
                            return true;
                        }
                        if (db.isFinestEnabled()) {
                            db.println("Type " + list2 + " filter NOT passed for port " + portModel + " type " + opticalPortType);
                        }
                        return false;
                    }
                    if (list3.size() > 0) {
                        for (OpticalPortType opticalPortType3 : list3) {
                            if (opticalPortType3 != opticalPortType) continue;
                            if (db.isFinestEnabled()) {
                                db.println("Not Of Type " + list3 + " filter NOT passed for port " + portModel + " type " + opticalPortType);
                            }
                            return false;
                        }
                    }
                }
                catch (Exception exception) {
                    db.warning("Cannot evaluate isOfPortType for " + portModel + ": " + exception.getMessage());
                    if (!db.on()) break block11;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return true;
    }

    private static boolean isPortElegibleOts(PortModel portModel) {
        if (OchPortsHelper.isOtsPort(portModel) || OchPortsHelper.isBandPort(portModel)) {
            OpticsPortModel opticsPortModel = (OpticsPortModel)portModel;
            return IntPatchHelper.isValidPortType(opticsPortModel);
        }
        if (db.isFinestEnabled()) {
            db.println("Port discarded" + portModel.getPortNum() + portModel);
        }
        return false;
    }

    private static boolean isValidPortType(OpticsPortModel opticsPortModel) {
        try {
            OpticalPortType opticalPortType = opticsPortModel.getOptPortType();
            switch (((IModuleModel)opticsPortModel.getParent()).getEqType()) {
                case 287: 
                case 321: {
                    return opticalPortType != OpticalPortType.IN_RAMAN && opticalPortType != OpticalPortType.OUT_RAMAN;
                }
                case 249: {
                    return opticalPortType != OpticalPortType.OUT_EXPRESS_A && opticalPortType != OpticalPortType.IN_EXPRESS_A;
                }
                case 128: {
                    return opticalPortType != OpticalPortType.OUT_OSC && opticalPortType != OpticalPortType.IN_OSC;
                }
                case 240: 
                case 277: 
                case 278: 
                case 281: {
                    if (((OpticsModuleModel)opticsPortModel.getParent()).getAmpliRole().equals(eOpticalAmplifierRole.PRE_AMPLI)) {
                        return opticalPortType != OpticalPortType.OUT_COM && opticalPortType != OpticalPortType.IN_LINE && opticalPortType != OpticalPortType.OUT_OSC && opticalPortType != OpticalPortType.IN_OSC;
                    }
                    return true;
                }
            }
            return true;
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return false;
        }
    }

    private static int getWlen(PortModel portModel) throws NoSuchInterface, WrongInterfaceType, WrongPortType {
        IOpticsChannelModel iOpticsChannelModel;
        int n = 174;
        if (portModel instanceof IOpticsPortModel) {
            n = ((IOpticsPortModel)portModel).getWaveLength();
        } else if (portModel instanceof IOpticsChannelModel && (iOpticsChannelModel = (IOpticsChannelModel)portModel.getInterfaceModel()).isWavelengthSupported()) {
            n = iOpticsChannelModel.getActualWaveLength();
            if (n == 0) {
                if (db.on()) {
                    db.println("Using expected wlen for local port");
                }
                n = iOpticsChannelModel.getExpectedWaveLength();
            } else if (db.on()) {
                db.println("Using actual wlen for local port");
            }
        }
        return n;
    }

    public static boolean isPortAlreadyUsed(IEntityModel iEntityModel) {
        return IntPatchHelper.isPortAlreadyUsed(iEntityModel, false, null);
    }

    private static boolean isPortAlreadyUsed(IEntityModel iEntityModel, boolean bl, IEntityModel iEntityModel2) {
        INodeModel iNodeModel = iEntityModel.getNodeModel();
        if (iEntityModel instanceof IOpticsPortModel && iNodeModel.getSideModels().getSideUsedByPort(iEntityModel) != null) {
            if (db.isFinestEnabled()) {
                db.println("Port is used by side");
            }
            return true;
        }
        if (bl && iEntityModel2 == null) {
            if (db.isFinestEnabled()) {
                db.println("Port is allowed by user to be reused");
            }
            return false;
        }
        int n = iEntityModel.getEntityIndex();
        IOpticalPatchCordModel iOpticalPatchCordModel = iNodeModel.getIOpticalPatchCordModel();
        try {
            ILmpDataLinkModels iLmpDataLinkModels = iOpticalPatchCordModel.getIOptLinkModels();
            if (!bl) {
                for (ILmpDataLinkModels iLmpDataLinkModels2 : iLmpDataLinkModels) {
                    if (iLmpDataLinkModels2.getFrom() != n && iLmpDataLinkModels2.getTo() != n) continue;
                    if (db.isFinestEnabled()) {
                        db.println("Port " + iEntityModel + " is already used by " + iLmpDataLinkModels2);
                    }
                    return true;
                }
            } else if (iEntityModel2 != null) {
                int n2 = iEntityModel2.getEntityIndex();
                for (ILmpDataLinkModels iLmpDataLinkModels3 : iLmpDataLinkModels) {
                    if (iLmpDataLinkModels3.getFrom() != n2 || iLmpDataLinkModels3.getTo() != n) continue;
                    if (db.isFinestEnabled()) {
                        db.println("Port " + iEntityModel + "has duplicated pcord " + iLmpDataLinkModels3);
                    }
                    return true;
                }
            }
        }
        catch (FeatureUnsupported featureUnsupported) {
            SDebug.printStackTrace((Throwable)featureUnsupported);
        }
        try {
            ILmpDataLinkModel[] iLmpDataLinkModelArray;
            ILmpDataLinkModels iLmpDataLinkModels = iNodeModel.getILmpDataLinkModels();
            for (ILmpDataLinkModel iLmpDataLinkModel : iLmpDataLinkModelArray = iLmpDataLinkModels.getIDataLinks()) {
                if (iLmpDataLinkModel.getLocalPortId() != n) continue;
                return true;
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return false;
    }

    private static IEntityModel[] getShelves(INodeModel iNodeModel) {
        IEntityModel[] iEntityModelArray = iNodeModel.getChassisModels();
        Arrays.sort(iEntityModelArray, new Comparator<IEntityModel>(){

            @Override
            public int compare(IEntityModel iEntityModel, IEntityModel iEntityModel2) {
                return iEntityModel.getShelfId() - iEntityModel2.getShelfId();
            }
        });
        return iEntityModelArray;
    }

    public static class PortFilter {
        public boolean rxonly;
        public boolean txonly;
        public int wavelength;
        public boolean onlyPassiveUnits = false;
        public boolean filterMPOOnly = false;
        public int features;
        public eBandGridOpticalType grid = eBandGridOpticalType.NO_GRID;
        public List<eEqType> porttype = new ArrayList<eEqType>();
        public List<OpticalPortType> optype = new ArrayList<OpticalPortType>();
        public List<OpticalPortType> notOfOptype = new ArrayList<OpticalPortType>();
        public boolean acceptRepetition = false;
        public IEntityModel originPort = null;
        public List<eEqType> eqtype = new ArrayList<eEqType>();
        public List<eEqType> notOfEqtype = new ArrayList<eEqType>();
        public IModuleModel parent = null;
        public IModuleModel notOfParent = null;
        public Class<?> parentClass = null;
        public Class<?> parentNotOfClass = null;
        public List<PortFilter> and = new ArrayList<PortFilter>();
        public List<PortFilter> or = new ArrayList<PortFilter>();
    }
}

