/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.intpatch;

import cerent.cms.model.EntityTableModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.IntPatchCreationDialog;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzDialog;
import cerent.cms.ui.intpatch.IntPatchCreationInfo;
import cerent.cms.ui.intpatch.IntPatchcdSourcePane;

public class IntPatchcdDestinationPane
extends IntPatchcdSourcePane {
    public IntPatchcdDestinationPane(WzDialog wzDialog, WzDiagDebug wzDiagDebug, String string) {
        super(wzDialog, wzDiagDebug, string);
    }

    protected boolean isSourcePane() {
        return false;
    }

    public void enteringPane() {
        super.enteringPane();
        if (this.info.isBidi()) {
            ((IntPatchCreationDialog)this.parent).setNextEnabled(true);
        } else {
            ((IntPatchCreationDialog)this.parent).setNextEnabled(false);
        }
    }

    protected String getNextPaneName() {
        return "Internal Patchcord Origination Reverse";
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.IntPatchcdDestinationPane;
    }

    public void validatePage() throws Exception {
        IntPatchCreationInfo.TermInfo termInfo = this.info.getActiveTerm();
        if (this.getPort() == null) {
            throw new Exception(this.portSelectorAttr.getPortLabel() + " must be selected.");
        }
        switch (this.info.getPatchType()) {
            case OCH2OCH: 
            case TRK2OCH: 
            case OTS2OTS: {
                termInfo.setDstPort(this.portSelectorAttr.getPort());
                termInfo.setAutoRevSrc(false);
                if (!this.info.isBidi()) break;
                NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.info.getNodeModel();
                EntityTableModel entityTableModel = nodeModelDelegate.getEntityTableModel();
                int[] nArray = nodeModelDelegate.getOpticalPatchCordModel().getReversePort(this.portSelectorAttr.getPort().getIndex());
                if (nArray.length != 1 || nArray[0] == 0) break;
                termInfo.setSecSrcPort(entityTableModel.getEntityModelByIndex(nArray[0]));
                termInfo.setAutoRevSrc(true);
                break;
            }
            case TRK2TRK: {
                termInfo.setDstPort(this.portSelectorAttr.getPort());
                termInfo.setSecSrcPort(this.portSelectorAttr.getPort());
                termInfo.setSecDstPort(termInfo.getSrcPort());
                termInfo.setAutoRevSrc(true);
                termInfo.setAutoRevDst(true);
            }
        }
    }
}

