/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.intpatch;

import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.IntPatchCreationDialog;
import cerent.cms.ui.WavelengthAttribute;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzDialog;
import cerent.cms.ui.WzPane;
import cerent.cms.ui.intpatch.IntPatchBidiAttr;
import cerent.cms.ui.intpatch.IntPatchCreationInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class IntPatchcdOCHAttrsPane
extends WzPane {
    private WavelengthAttribute waveAttr;
    private IntPatchBidiAttr bidiAttr;
    private JCheckBox protection;

    public IntPatchcdOCHAttrsPane(WzDialog wzDialog, WzDiagDebug wzDiagDebug, String string) {
        super(wzDialog, wzDiagDebug, string);
    }

    public void validatePage() throws Exception {
        IntPatchCreationInfo intPatchCreationInfo = ((IntPatchCreationDialog)this.parent).getInfo();
        intPatchCreationInfo.setWavelength(this.waveAttr.getChannel());
        if (this.isBidiSupported()) {
            intPatchCreationInfo.setBidi(this.bidiAttr.isBidirectional());
        }
        intPatchCreationInfo.setPsmProtection(this.protection.isSelected());
    }

    public void revalidateData() {
        if (this.isBidiSupported()) {
            this.bidiAttr.setSelected(this.protection.isSelected());
            this.bidiAttr.setEnabled(!this.protection.isSelected());
        } else {
            this.bidiAttr.setSelected(true);
            this.bidiAttr.setEnabled(false);
        }
    }

    private boolean isBidiSupported() {
        IntPatchCreationInfo intPatchCreationInfo = ((IntPatchCreationDialog)this.parent).getInfo();
        return intPatchCreationInfo.getPatchType() == IntPatchCreationInfo.eIntPatchCordType.OCH2OCH;
    }

    protected String getNextPaneName() {
        return "Internal Patchcord Origination";
    }

    protected void initPane() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        this.waveAttr = new WavelengthAttribute();
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.waveAttr.getUI(), gridBagConstraints);
        this.waveAttr.setEnabled(true);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.bidiAttr = new IntPatchBidiAttr();
        jPanel.add((Component)this.bidiAttr.getUI(), gridBagConstraints);
        this.bidiAttr.setEnabled(this.isBidiSupported());
        ++gridBagConstraints.gridx;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.protection = new JCheckBox("PSM Protection");
        this.protection.addActionListener(this);
        jPanel.add((Component)this.protection, gridBagConstraints);
        this.protection.setEnabled(true);
        if (this.isBidiSupported()) {
            this.bidiAttr.setSelected(this.protection.isSelected());
        }
        ++gridBagConstraints.gridx;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.IntPatchcdOCHAttrsPane;
    }

    public JComponent getStatusComponent() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        arrayList.add(new String[]{"Wavelength: ", this.waveAttr.getChannelString()});
        arrayList.add(new String[]{"Bidirectional: ", this.bidiAttr.toString()});
        if (this.protection.isSelected()) {
            arrayList.add(new String[]{"PSM Protection: ", "required"});
        }
        return IntPatchcdOCHAttrsPane.getGridPanel(arrayList);
    }

    protected String getStatusText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Wavelength: ").append(this.waveAttr.getChannelString());
        stringBuffer.append("\nBidirectional: ").append(this.bidiAttr.toString());
        if (this.protection.isSelected()) {
            stringBuffer.append("\nPSM Protection required.");
        }
        return stringBuffer.toString();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.protection && this.isBidiSupported()) {
            this.bidiAttr.setSelected(this.protection.isSelected());
            this.bidiAttr.setEnabled(!this.protection.isSelected());
        }
    }
}

