/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.intpatch;

import cerent.cms.idl.Common.eBandGridOpticalType;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.IntPatchCreationDialog;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzDialog;
import cerent.cms.ui.WzPane;
import cerent.cms.ui.intpatch.IntPatchBidiAttr;
import cerent.cms.ui.intpatch.IntPatchCreationInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class IntPatchcdOTSAttrsPane
extends WzPane {
    private IntPatchBidiAttr bidiAttr;
    private IntPatchGridAttr gridAttr;
    private IntPatchTypeAttr typeAttr;
    private CheckBoxAttr mpoConnAttr;
    private CheckBoxAttr reuseAttr;
    private HelpOnLine hol;

    public IntPatchcdOTSAttrsPane(WzDialog wzDialog, WzDiagDebug wzDiagDebug, String string) {
        super(wzDialog, wzDiagDebug, string);
    }

    public void validatePage() throws Exception {
        IntPatchCreationInfo intPatchCreationInfo = ((IntPatchCreationDialog)this.parent).getInfo();
        intPatchCreationInfo.setBidi(this.bidiAttr.isBidirectional());
        intPatchCreationInfo.setGrid(this.gridAttr.getGrid());
        intPatchCreationInfo.setPortTypeFilter(this.typeAttr.getOpType());
        intPatchCreationInfo.setMPOConnection(this.mpoConnAttr.isSelected());
        intPatchCreationInfo.setAcceptRepetition(!this.reuseAttr.isSelected());
    }

    protected String getNextPaneName() {
        return "Internal Patchcord Origination";
    }

    protected void initPane() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(15, 15, 0, 0);
        gridBagConstraints.anchor = 18;
        ++gridBagConstraints.gridy;
        this.bidiAttr = new IntPatchBidiAttr();
        jPanel.add((Component)this.bidiAttr.getUI(), gridBagConstraints);
        this.bidiAttr.setEnabled(true);
        this.bidiAttr.setSelected(false);
        this.bidiAttr.addActionListener(this);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.mpoConnAttr = new CheckBoxAttr("MPO Connection");
        jPanel.add((Component)this.mpoConnAttr.getUI(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.reuseAttr = new CheckBoxAttr("Exclude Used Port", true);
        jPanel.add((Component)this.reuseAttr.getUI(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.gridAttr = new IntPatchGridAttr();
        jPanel.add((Component)this.gridAttr.getUI(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.typeAttr = new IntPatchTypeAttr();
        jPanel.add((Component)this.typeAttr.getUI(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.hol = new HelpOnLine();
        jPanel.add((Component)this.hol.getUI(), gridBagConstraints);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.IntPatchcdOTSAttrsPane;
    }

    public JComponent getStatusComponent() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        arrayList.add(new String[]{"Bidirectional: ", this.bidiAttr.toString()});
        arrayList.add(new String[]{"Grid Filter: ", this.gridAttr.toString()});
        arrayList.add(new String[]{"Type Filter: ", this.typeAttr.toString()});
        if (this.mpoConnAttr.isSelected()) {
            arrayList.add(new String[]{"MPO Connection: ", "Enabled"});
        }
        arrayList.add(new String[]{"Exclude Used Port: ", this.reuseAttr.toString()});
        return IntPatchcdOTSAttrsPane.getGridPanel(arrayList);
    }

    protected String getStatusText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Bidirectional: ").append(this.bidiAttr.toString());
        stringBuffer.append("\bGrid Filter: ").append(this.gridAttr.toString());
        stringBuffer.append("\bType Filter: ").append(this.typeAttr.toString());
        if (this.mpoConnAttr.isSelected()) {
            stringBuffer.append("\nMPO Connection.");
        }
        stringBuffer.append("\bExclude Used Port: ").append(this.reuseAttr.toString());
        return stringBuffer.toString();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mpoConnAttr.getCB()) {
            if (this.mpoConnAttr.isSelected()) {
                this.bidiAttr.setSelected(false);
            }
        } else if (object == this.bidiAttr.getCB()) {
            if (this.bidiAttr.isBidirectional()) {
                this.mpoConnAttr.setSelected(false);
            }
        } else if (object == this.typeAttr.getCB() && this.typeAttr.getOpType() != IntPatchCreationInfo.eIntPatchPortType.OTS) {
            this.reuseAttr.setSelected(true);
            this.bidiAttr.setSelected(true);
        }
        this.bidiAttr.setEnabled(!this.mpoConnAttr.isSelected());
        this.mpoConnAttr.setEnabled(this.typeAttr.isOTS());
        this.reuseAttr.setEnabled(this.typeAttr.isOTS());
    }

    private abstract class AbstractComboBoxAttr {
        protected JComboBox cb;
        private DefaultComboBoxModel model;
        private JPanel p = WzPane.createHorizontalPanel(null);

        AbstractComboBoxAttr(String string, String[] stringArray) {
            this.p.setAlignmentX(0.0f);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(15, 15, 0, 0);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            this.p.add((Component)new JLabel(string), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            this.model = new DefaultComboBoxModel();
            for (String string2 : stringArray) {
                this.model.addElement(string2);
            }
            this.cb = new JComboBox(this.model){

                public Dimension getPreferredSize() {
                    Dimension dimension = super.getPreferredSize();
                    dimension.width = 180;
                    return dimension;
                }
            };
            this.cb.addActionListener(IntPatchcdOTSAttrsPane.this);
            this.p.add((Component)this.cb, gridBagConstraints);
            this.cb.setEnabled(true);
        }

        JPanel getUI() {
            return this.p;
        }

        JComboBox getCB() {
            return this.cb;
        }

        public String toString() {
            return (String)this.cb.getSelectedItem();
        }
    }

    private class CheckBoxAttr {
        private JCheckBox cb;
        private JPanel p = WzPane.createHorizontalPanel(null);

        CheckBoxAttr(String string) {
            this.p.setAlignmentX(0.0f);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(15, 15, 0, 0);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            this.cb = new JCheckBox(string);
            this.cb.addActionListener(IntPatchcdOTSAttrsPane.this);
            this.p.add((Component)this.cb, gridBagConstraints);
            this.cb.setEnabled(true);
        }

        CheckBoxAttr(String string, boolean bl) {
            this(string);
            this.setSelected(bl);
        }

        JPanel getUI() {
            return this.p;
        }

        JCheckBox getCB() {
            return this.cb;
        }

        boolean isSelected() {
            return this.cb.isSelected();
        }

        void setEnabled(boolean bl) {
            this.cb.setEnabled(bl);
        }

        void setSelected(boolean bl) {
            this.cb.setSelected(bl);
        }

        public String toString() {
            return this.cb.isSelected() ? "Enabled" : "Disabled";
        }
    }

    class HelpOnLine {
        private final JPanel p;
        private final JTextArea text;
        private final Font f = new Font("Arial", 1, 11);
        private static final String HELP = "Select the type of patch-cord you desire.\n-Bidirectional: create a bidirectional patchcord,\n-MPO Connection: create in one shot all the patchcords\n between 2 MPO connectors.\nUn-flag the 'exclude used port' check box if you want\nto create more than one patchcord starting from the same port\nThe Grid Filter Combo-Box filters the option on\n100 GHz ODD/EVEN or 50 Ghz band\nThe Port Filter Combo Box is used to filter the port type\nthat typically are connected together. (OSC / DCU or generic optical)";

        HelpOnLine() {
            this.p = new JPanel();
            this.text = new JTextArea();
            this.p.add(this.text);
            this.text.setEditable(false);
            this.text.setPreferredSize(new Dimension(390, 150));
            this.text.setBorder(BorderFactory.createEtchedBorder());
            this.text.setFont(this.f);
            this.updateHelp();
        }

        JPanel getUI() {
            return this.p;
        }

        void updateHelp() {
            this.text.setText(HELP);
        }
    }

    private class IntPatchGridAttr
    extends AbstractComboBoxAttr {
        IntPatchGridAttr() {
            super("Grid Filter:  ", new String[]{"<no grid>", "100 GHz Odd Grid", "100 GHz Even Grid", "50 GHz Grid"});
        }

        eBandGridOpticalType getGrid() {
            int n = this.cb.getSelectedIndex();
            return eBandGridOpticalType.from_int(n);
        }
    }

    private class IntPatchTypeAttr
    extends AbstractComboBoxAttr {
        private static final int OSC = 1;
        private static final int DC = 2;

        IntPatchTypeAttr() {
            super("Port Type:   ", new String[]{"<no OSC/DC selection>", "OSC Only", "DC Only"});
        }

        boolean isOTS() {
            return this.getOpType() == IntPatchCreationInfo.eIntPatchPortType.OTS;
        }

        IntPatchCreationInfo.eIntPatchPortType getOpType() {
            int n = this.cb.getSelectedIndex();
            if (n == 1) {
                return IntPatchCreationInfo.eIntPatchPortType.OSC;
            }
            if (n == 2) {
                return IntPatchCreationInfo.eIntPatchPortType.DC;
            }
            return IntPatchCreationInfo.eIntPatchPortType.OTS;
        }
    }
}

