/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.l2sc;

import cerent.cms.idl.EtherMedia.ePosFramingType;
import cerent.cms.idl.EtherMedia.sL2scPosPortInfo;
import cerent.cms.model.Attribute;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.L2scModuleModel;
import cerent.cms.model.L2scPortModel;
import cerent.cms.model.L2scPosLineModel;
import cerent.cms.model.L2scPosPortModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.enumeration.EtherEnumStrings;
import cerent.cms.ui.AbstractPane;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.SoakTimePropertyEditor;
import java.awt.Component;
import java.awt.Frame;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.table.AbstractTableModel;

public class L2scPosPortInfoTableModel
extends AbstractTableModel
implements Observer {
    private L2scModuleModel eqpmtModel = null;
    private L2scPortModel[] portModels = null;
    private EtherLineModel[] lineModels = null;
    private boolean[][] isDirty = null;
    private int numLines = 0;
    private int numPorts = 0;
    private sL2scPosPortInfo[] l2scPosPortInfo = null;
    private String[] portName = null;
    private Boolean[] suppress = null;
    private int[] soakTime;
    public String[] columnNames = new String[]{"Port", "Port Name", "Admin State", "PSAS", "Soak Time", "Link State", "MTU", "Framing Type"};
    public static String[] columnToolTips = new String[]{null, null, null, "Pre-Service Alarm Suppression", "Alarm Soak Time", null, null, null};
    public static final int PORT_NUMBER_INDEX = 0;
    public static final int PORT_NAME_INDEX = 1;
    public static final int ADMIN_STATE_INDEX = 2;
    public static final int PSAS_INDEX = 3;
    public static final int SOAK_TIME_INDEX = 4;
    public static final int LINK_STATE_INDEX = 5;
    public static final int MTU_INDEX = 6;
    public static final int FRAMING_TYPE_INDEX = 7;
    private static final String RPR_EAST = "RPR East";
    private static final String RPR_WEST = "RPR West";
    private static final int RPR_PORT_EAST = 0;
    private static final int RPR_PORT_WEST = 1;
    private static final SDebug db = new SDebug("L2scPosPortInfoTableModel");

    public L2scPosPortInfoTableModel(L2scModuleModel l2scModuleModel, L2scPortModel[] l2scPortModelArray, EtherLineModel[] etherLineModelArray) {
        this.portModels = l2scPortModelArray;
        this.lineModels = etherLineModelArray;
        this.numPorts = l2scPortModelArray == null ? 0 : l2scPortModelArray.length;
        this.numLines = etherLineModelArray == null ? 0 : etherLineModelArray.length;
        this.eqpmtModel = l2scModuleModel;
        this.isDirty = new boolean[this.numPorts][this.getColumnCount()];
        this.l2scPosPortInfo = new sL2scPosPortInfo[this.numPorts];
        this.portName = new String[this.numPorts];
        this.suppress = new Boolean[this.numPorts];
        this.soakTime = new int[this.numPorts];
        this.resetDirty();
        this.registerWithLineModels();
    }

    public boolean isCellEditable(int n, int n2) {
        boolean bl = false;
        if (n2 == 1 || n2 == 3 || n2 == 4) {
            bl = AbstractPane.isUserAuthorized(this.eqpmtModel, SecurityLevel.PROVISIONING);
        }
        return bl;
    }

    public boolean isCellDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    public sL2scPosPortInfo getL2scPosPortInfo(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError, ProvisionError {
        if (this.l2scPosPortInfo[n] == null && this.portModels[n] instanceof L2scPosPortModel) {
            L2scPosPortModel l2scPosPortModel = (L2scPosPortModel)this.portModels[n];
            this.l2scPosPortInfo[n] = l2scPosPortModel.getL2scPosPortInfo();
        }
        if (L2scPosPortInfoTableModel.db.on) {
            db.finest("\ngetL2scPosPortInfo(" + n + ") was called.");
            db.finest("   adminState:" + this.l2scPosPortInfo[n].adminState);
            db.finest("   linkProtocolState:" + this.l2scPosPortInfo[n].linkProtocolState);
            db.finest("   mtu:" + this.l2scPosPortInfo[n].mtu);
        }
        return this.l2scPosPortInfo[n];
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    private String getLineNumberFor(int n) {
        String string = null;
        try {
            L2scPortModel l2scPortModel = this.portModels[n];
            string = String.valueOf(l2scPortModel.getPort());
            return string;
        }
        catch (Exception exception) {
            if (L2scPosPortInfoTableModel.db.on) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return "unknown";
        }
    }

    public int getRowCount() {
        return this.numPorts;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 3: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    private String getPortName(int n) {
        String string = "";
        if (this.portName[n] == null) {
            if (null == this.lineModels[n]) {
                string = "lineModels is null";
            } else {
                try {
                    this.portName[n] = string = this.lineModels[n].getAlias();
                }
                catch (Exception exception) {
                    if (L2scPosPortInfoTableModel.db.on) {
                        db.println("Exception caught accessing port name: " + exception);
                    }
                    string = exception.toString();
                }
            }
        }
        return this.portName[n];
    }

    private void setPortName(int n, String string) {
        this.getPortName(n);
        try {
            if (null != this.lineModels[n] && null != string) {
                this.portName[n] = string;
                this.isDirty[n][1] = true;
            }
        }
        catch (Exception exception) {
            if (L2scPosPortInfoTableModel.db.on) {
                db.println("Exception caught setting port name: " + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    private String getAdminState(int n) {
        String string = "";
        try {
            this.getL2scPosPortInfo(n);
            boolean bl = this.l2scPosPortInfo[n].adminState;
            string = bl ? "Up" : "Down";
        }
        catch (Exception exception) {
            if (L2scPosPortInfoTableModel.db.on) {
                db.println("Exception caught accessing admin state: " + exception);
            }
            string = exception.toString();
        }
        return string;
    }

    private Boolean getPreServiceAlarmSuppress(int n) {
        block5: {
            this.suppress[n] = Boolean.valueOf("false");
            if (this.lineModels[n] instanceof L2scPosLineModel) {
                try {
                    this.suppress[n] = ((L2scPosLineModel)this.lineModels[n]).getPreServiceAlarmSuppress();
                    if (L2scPosPortInfoTableModel.db.on) {
                        db.println("getPSAS: row " + n + " suppress " + this.suppress[n]);
                    }
                }
                catch (EMCProvisionError eMCProvisionError) {
                    ErrorMsg.displayError((Component)this.getFrame(), (EID)eMCProvisionError.getEID());
                }
                catch (Exception exception) {
                    if (!L2scPosPortInfoTableModel.db.on) break block5;
                    db.println("Exception caught accessing PSAS: " + exception);
                }
            }
        }
        return this.suppress[n];
    }

    private void setPreServiceAlarmSuppress(int n, Boolean bl) {
        this.suppress[n] = bl;
        this.isDirty[n][3] = true;
        if (L2scPosPortInfoTableModel.db.on) {
            db.println("setPSAS, row " + n + " newSuppress " + bl);
        }
    }

    private String getSoakTimeAsHHMM(int n) throws NoSuchInterface {
        return SoakTimePropertyEditor.toStringHHMM(this.soakTime[n]);
    }

    private String getLinkState(int n) {
        String string = "";
        try {
            this.getL2scPosPortInfo(n);
            boolean bl = this.l2scPosPortInfo[n].linkProtocolState;
            string = bl ? "Up" : "Down";
        }
        catch (Exception exception) {
            if (L2scPosPortInfoTableModel.db.on) {
                db.println("Exception caught accessing link state: " + exception);
            }
            string = exception.toString();
        }
        return string;
    }

    private String getMTU(int n) {
        String string = "";
        try {
            this.getL2scPosPortInfo(n);
            string = new Integer(this.l2scPosPortInfo[n].mtu).toString();
        }
        catch (Exception exception) {
            if (L2scPosPortInfoTableModel.db.on) {
                db.println("Exception caught accessing mtu: " + exception);
            }
            string = exception.toString();
        }
        return string;
    }

    private Attribute getFramingType(int n) {
        Attribute attribute;
        block2: {
            attribute = null;
            try {
                this.getL2scPosPortInfo(n);
                ePosFramingType ePosFramingType2 = this.l2scPosPortInfo[n].framingType;
                attribute = EtherEnumStrings.get(ePosFramingType.class, ePosFramingType2.value());
            }
            catch (Exception exception) {
                if (!L2scPosPortInfoTableModel.db.on) break block2;
                db.println("Exception caught accessing framingType: " + exception);
            }
        }
        return attribute;
    }

    public Object getValueAt(int n, int n2) {
        String string;
        block12: {
            string = "";
            try {
                switch (n2) {
                    case 0: {
                        return this.getLineNumberFor(n);
                    }
                    case 1: {
                        return this.getPortName(n);
                    }
                    case 2: {
                        return this.getAdminState(n);
                    }
                    case 3: {
                        return this.suppress[n];
                    }
                    case 4: {
                        return this.getSoakTimeAsHHMM(n);
                    }
                    case 5: {
                        return this.getLinkState(n);
                    }
                    case 6: {
                        return this.getMTU(n);
                    }
                    case 7: {
                        return this.getFramingType(n);
                    }
                }
            }
            catch (Exception exception) {
                if (!L2scPosPortInfoTableModel.db.on) break block12;
                db.println("Error in getValueAt in L2scPosPortInfoTableModel " + exception + " rprMode: " + this.eqpmtModel.isRPRMode());
                SDebug.printStackTrace((Throwable)exception);
                string = exception.toString();
            }
        }
        return string;
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                return;
            }
            case 1: {
                if (!(object instanceof String)) break;
                String string = (String)object;
                this.setPortName(n, string);
                break;
            }
            case 3: {
                if (!(object instanceof Boolean)) break;
                Boolean bl = (Boolean)object;
                this.setPreServiceAlarmSuppress(n, bl);
                break;
            }
            case 4: {
                int n3 = this.soakTime[n];
                try {
                    n3 = SoakTimePropertyEditor.toIntValue((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    db.fine("Number Format Exception on " + (String)object);
                }
                if (this.soakTime[n] == n3) {
                    return;
                }
                this.soakTime[n] = n3;
                break;
            }
            default: {
                return;
            }
        }
        this.isDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                if (!this.isDirty[i][j]) continue;
                return true;
            }
        }
        return false;
    }

    public void resetDirty() {
        for (int i = 0; i < this.numPorts; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refreshLineFromModel(int n) {
        this.l2scPosPortInfo[n] = null;
        this.portName[n] = null;
        this.suppress[n] = this.getPreServiceAlarmSuppress(n);
        if (L2scPosPortInfoTableModel.db.on) {
            db.println("refreshLineFromModel: row " + n + " suppress " + this.suppress[n]);
        }
        try {
            this.soakTime[n] = this.lineModels[n].getSoakTime();
        }
        catch (NoSuchInterface noSuchInterface) {
            db.fine("No Such Interface: " + (Object)((Object)noSuchInterface));
        }
        this.fireTableRowsUpdated(n, n);
    }

    public void applyToModel() throws Exception {
        for (int i = 0; i < this.portModels.length; ++i) {
            if (this.isDirty[i][1]) {
                this.lineModels[i].setAlias(this.portName[i]);
            }
            if (this.isDirty[i][3]) {
                try {
                    if (this.lineModels[i] instanceof L2scPosLineModel) {
                        ((L2scPosLineModel)this.lineModels[i]).setPreServiceAlarmSuppress(this.suppress[i]);
                        if (db.on()) {
                            db.println("applyToModel: row " + i + " setting PSAS " + this.suppress[i]);
                        }
                    }
                }
                catch (EMCProvisionError eMCProvisionError) {
                    ErrorMsg.displayError((Component)this.getFrame(), (EID)eMCProvisionError.getEID());
                }
            }
            if (this.isDirty[i][4]) {
                if (db.on()) {
                    db.println("setting line soakTime " + this.soakTime[i]);
                }
                this.lineModels[i].setSoakTime(this.soakTime[i]);
            }
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refresh() {
        for (int i = 0; i < this.numLines; ++i) {
            this.refreshLineFromModel(i);
        }
    }

    public void destroy() {
        this.unRegisterWithLineModels();
        this.portModels = null;
        this.lineModels = null;
        this.eqpmtModel = null;
        this.resetDirty();
        for (int i = 0; i < this.l2scPosPortInfo.length; ++i) {
            this.l2scPosPortInfo[i] = null;
            this.portName[i] = null;
            this.suppress[i] = null;
        }
        this.l2scPosPortInfo = null;
        this.portName = null;
    }

    private void registerWithLineModels() {
        if (this.lineModels != null) {
            for (int i = 0; i < this.numLines; ++i) {
                this.lineModels[i].addObserver(this);
            }
        }
    }

    private void unRegisterWithLineModels() {
        for (int i = 0; i < this.lineModels.length; ++i) {
            this.lineModels[i].deleteObserver(this);
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            int n;
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            if ((n = Arrays.asList(this.lineModels).indexOf(observable)) != -1) {
                this.refreshLineFromModel(n);
            }
        }
    }

    protected Frame getFrame() {
        return this.eqpmtModel.getNodeModel().getUiToolkit().getApplicationFrame();
    }
}

