/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ml2;

import cerent.cms.idl.Circuits.eCircuitSize;
import cerent.cms.idl.EtherMedia.eConcatType;
import cerent.cms.idl.EtherMedia.eLcasType;
import cerent.cms.idl.EtherMedia.sEtherPosInfo;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.ML2EnhModuleModel;
import cerent.cms.model.ML2ModuleModel;
import cerent.cms.model.ML2PosPortModel;
import cerent.cms.model.enumeration.EtherEnumStrings;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.HoLoFactory;
import cerent.util.HoLoHelper;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import javax.swing.table.AbstractTableModel;

public class CEMRPosPortUsageTableModel
extends AbstractTableModel {
    public static final int PORT_INDEX = 0;
    public static final int ALLOCATION_INDEX = 1;
    public static final int STS_INDEX = 2;
    public static final int VT_INDEX = 3;
    private static final SDebug db = new SDebug("CEMRPosPortUsageTableModel");
    private String[] columnNames;
    private ML2ModuleModel eqpmtModel = null;
    private ML2PosPortModel[] portModels = null;
    private sEtherPosInfo[] infoList = null;
    private EntityCellRenderer myPortRenderer;

    public CEMRPosPortUsageTableModel(ML2ModuleModel mL2ModuleModel) {
        this.eqpmtModel = mL2ModuleModel;
        this.initColumnNames();
        this.portModels = mL2ModuleModel instanceof ML2EnhModuleModel ? ((ML2EnhModuleModel)this.eqpmtModel).getAllPortModels() : this.eqpmtModel.getPosPortModels();
        this.myPortRenderer = new EntityCellRenderer();
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        if (n >= 0 && n < this.columnNames.length) {
            return this.columnNames[n];
        }
        return null;
    }

    public int getRowCount() {
        return this.infoList == null ? 0 : this.infoList.length;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            default: 
        }
        return Object.class;
    }

    public Object getValueAt(int n, int n2) {
        block9: {
            try {
                switch (n2) {
                    case 0: {
                        return this.getPortDescription(this.infoList[n].port);
                    }
                    case 1: {
                        return this.getAllocationDescription(this.infoList[n]);
                    }
                    case 2: {
                        if (this.infoList[n].startingSts != 0) {
                            return this.getHoIndex(this.infoList[n].startingSts);
                        }
                    }
                    case 3: {
                        if (this.infoList[n].startingVt == 0) break;
                        return this.getLoIndex(this.infoList[n].startingVt, this.infoList[n].cktSize.value());
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block9;
                db.println("Error in getValueAt " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    private String getAllocationDescription(sEtherPosInfo sEtherPosInfo2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(EtherEnumStrings.get(eCircuitSize.class, sEtherPosInfo2.cktSize.value()));
        if (sEtherPosInfo2.concatType == eConcatType.CONCAT_VCAT) {
            stringBuffer.append("_");
            stringBuffer.append(String.valueOf(sEtherPosInfo2.numOfMembers));
            stringBuffer.append("v");
        }
        stringBuffer.append(" (");
        stringBuffer.append(EtherEnumStrings.get(eConcatType.class, sEtherPosInfo2.concatType.value()));
        if (sEtherPosInfo2.concatType == eConcatType.CONCAT_VCAT) {
            stringBuffer.append(",");
            stringBuffer.append(EtherEnumStrings.get(eLcasType.class, sEtherPosInfo2.lcasType.value()));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private String getPortDescription(int n) throws AbstractCmsNoSuchEntityException {
        String string = null;
        if (this.portModels.length < n) {
            if (--n == this.eqpmtModel.getRPREastPort()) {
                string = this.myPortRenderer.getPortString(this.portModels[((ML2EnhModuleModel)this.eqpmtModel).getNumberOfPosPorts()], false);
            }
            if (n == this.eqpmtModel.getRPRWestPort()) {
                string = this.myPortRenderer.getPortString(this.portModels[((ML2EnhModuleModel)this.eqpmtModel).getNumberOfPosPorts() + 1], false);
            }
        } else {
            string = this.myPortRenderer.getPortString(this.portModels[--n], false);
        }
        return string;
    }

    private String getHoIndex(int n) {
        int n2 = this.eqpmtModel.getNodeModel().getTdmProtocolType();
        if (db.on()) {
            db.println("PortUsage getHoIndex: sts=" + n + " framingType=" + n2);
        }
        IHoNum iHoNum = HoLoFactory.idlSts2HoNum(n2, n);
        if (db.on()) {
            db.println("PortUsage getHoIndex: hoNum=" + iHoNum);
        }
        return String.valueOf(iHoNum.getHoNum());
    }

    private String getLoIndex(int n, int n2) {
        int n3 = this.eqpmtModel.getNodeModel().getTdmProtocolType();
        if (db.on()) {
            db.println("PortUsage getLoIndex: vt=" + n + " framingType=" + n3);
        }
        ILoNum iLoNum = HoLoFactory.idlVt2LoNum(n3, n2, n);
        if (db.on()) {
            db.println("PortUsage getLoIndex: loNum=" + iLoNum);
        }
        return HoLoHelper.getDisplay(iLoNum, "/", true);
    }

    public void refreshFromModel() throws Exception {
        this.infoList = this.eqpmtModel.getEtherPosInfoList();
        if (db.on()) {
            if (this.infoList != null) {
                db.println("\ngetEtherPosInfoList: infoList.length=" + this.infoList.length);
                for (int i = 0; i < this.infoList.length; ++i) {
                    db.println(this.infoList[i].port + "  " + this.infoList[i].numOfMembers + "  " + this.infoList[i].concatType.value() + "  " + this.infoList[i].lcasType.value() + "  " + this.infoList[i].startingSts + "  " + this.infoList[i].startingVt);
                }
            } else {
                db.println("\ngetEtherPosInfoList: infoList is null");
            }
        }
        this.fireTableDataChanged();
    }

    private void initColumnNames() {
        TDMTerminology tDMTerminology = this.eqpmtModel.getNodeModel().getTDMTerminology();
        this.columnNames = new String[4];
        this.columnNames[0] = "Port";
        this.columnNames[1] = "Allocation";
        this.columnNames[2] = "First " + tDMTerminology.getGeneralTerms(0);
        this.columnNames[3] = "First " + tDMTerminology.getGeneralTerms(1);
    }
}

