/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ml2;

import cerent.cms.model.AdminState;
import cerent.cms.model.ML2EtherLineModel;
import cerent.cms.model.ML2EtherPortModel;
import cerent.cms.model.ML2ModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ml2.ML2LineMaintTableModel;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ML2LineMaintPane
extends NodeProvPane
implements TableModelListener {
    private ML2LineMaintTableModel dataModel = null;
    private ML2EtherLineModel[] lineModels = null;
    private static final SDebug db = new SDebug("ML2LineMaintPane");

    public ML2LineMaintPane(String string, TabbedView tabbedView, ML2ModuleModel mL2ModuleModel) {
        super(string, tabbedView);
        this.lineModels = mL2ModuleModel.getEtherLineModels();
        ML2EtherPortModel[] mL2EtherPortModelArray = mL2ModuleModel.getEtherPortModels();
        if (mL2ModuleModel == null || mL2EtherPortModelArray == null || this.lineModels == null || mL2EtherPortModelArray.length != this.lineModels.length) {
            if (db.on()) {
                db.println("Error during initialization");
                db.println("eqpmtModel=" + mL2ModuleModel + " portModels=" + mL2EtherPortModelArray + " lineModels=" + this.lineModels);
            }
            return;
        }
        this.dataModel = new ML2LineMaintTableModel(mL2ModuleModel, mL2EtherPortModelArray, this.lineModels);
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.customizedProvPane();
        this.add((Component)uScrollPane);
    }

    private void customizedProvPane() {
        TableColumn tableColumn = null;
        Object[] objectArray = null;
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(0));
        tableColumn.setCellEditor(new DefaultCellEditor(new JTextField()));
        tableColumn.setPreferredWidth(150);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(1));
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(this.dataModel.getAdminStateAttrs())));
        tableColumn.setPreferredWidth(100);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(2));
        tableColumn.setPreferredWidth(120);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(3));
        objectArray = this.dataModel.getLoopbackAttrs();
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(objectArray)));
        tableColumn.setPreferredWidth(200);
        this.table.sizeColumnsToFit(-1);
    }

    private JComboBox getComboBoxFor(Object[] objectArray) {
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    public void destroy() {
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
            this.dataModel.dispose();
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    protected boolean queryRemainDirty() {
        return true;
    }

    public void applyChangesToModel() throws Exception {
        if (this.preApply()) {
            this.dataModel.applyToModel();
            this.resetDirty();
        }
    }

    public void refreshFromModel() throws Exception {
        this.dataModel.refreshFromModel();
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    private boolean preApply() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        if (AdminState.adminStateChangedToFormOfOOS(this.dataModel, this.lineModels)) {
            stringBuffer.append(AdminState.getBaseOosWarning(this.terms)).append('\n');
            bl2 = true;
        }
        if (this.dataModel.changedToFormOfLoopback()) {
            stringBuffer.append("Some lines are being placed in Loopback.").append('\n');
            bl = true;
        }
        if (bl || bl2) {
            if (bl2) {
                String string = AdminState.getSevWarningMsg(this.dataModel, this.lineModels, bl, true);
                stringBuffer.append(string).append("\n\n").append(this.getApplyString(false));
            } else {
                stringBuffer.append(this.getApplyString());
            }
            return CerentDialog.yesNoDialog((Component)((Object)this), (String)stringBuffer.toString(), (String)"Confirmation Dialog");
        }
        return true;
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.ML2LineMaintPane;
    }
}

