/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ml2;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.EtherMedia.eEtherDuplex;
import cerent.cms.idl.EtherMedia.eEtherSpeed;
import cerent.cms.idl.EtherMedia.eFlowControlNegotiated;
import cerent.cms.idl.EtherMedia.sML2EtherLineInfo;
import cerent.cms.model.Attribute;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.ML2EtherLineModel;
import cerent.cms.model.ML2EtherPortModel;
import cerent.cms.model.ML2FastELineModel;
import cerent.cms.model.ML2ModuleModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.enumeration.ComEnumStrings;
import cerent.cms.model.enumeration.EtherEnumStrings;
import cerent.cms.ui.AbstractPane;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.SoakTimePropertyEditor;
import java.awt.Component;
import java.awt.Frame;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.table.AbstractTableModel;

public class ML2LxEtherPortTableModel
extends AbstractTableModel
implements Observer {
    public static final int PORT_NUMBER_INDEX = 0;
    public static final int PORT_NAME_INDEX = 1;
    public static final int ADMIN_STATE_INDEX = 2;
    public static final int PSAS_INDEX = 3;
    public static final int SOAK_TIME_INDEX = 4;
    public static final int LINK_STATE_INDEX = 5;
    public static final int OPERATING_SPEED_INDEX = 6;
    public static final int OPERATING_DUPLEX_INDEX = 7;
    public static final int FLOW_CTRL_INDEX = 8;
    public String[] columnNames = new String[]{"Port", "Port Name", "Admin State", "PSAS", "Soak Time", "Link State", "Operating Speed", "Operating Duplex", "Flow Control"};
    public static String[] columnToolTips = new String[]{null, null, null, "Pre-Service Alarm Suppression", "Alarm Soak Time for PSAS", null, null, null, null};
    private ML2ModuleModel eqpmtModel = null;
    private ML2EtherPortModel[] portModels = null;
    private ML2FastELineModel[] lineModels = null;
    private sML2EtherLineInfo[] etherLineInfo = null;
    private boolean[][] isDirty = null;
    private String[] portName = null;
    private Boolean[] suppress = null;
    private int[] soakTime;
    private int numLines = 0;
    private TDMTerminology term;
    private static final SDebug db = new SDebug("ML2LxEtherPortTableModel");

    public ML2LxEtherPortTableModel(ML2ModuleModel mL2ModuleModel, ML2EtherPortModel[] mL2EtherPortModelArray, ML2EtherLineModel[] mL2EtherLineModelArray) {
        if (mL2ModuleModel == null || mL2EtherPortModelArray == null || mL2EtherLineModelArray == null || mL2EtherPortModelArray.length != mL2EtherLineModelArray.length) {
            if (db.on()) {
                db.println("Error during initialization");
                db.println("eqpmtModel=" + mL2ModuleModel + " portModels=" + mL2EtherPortModelArray + " lineModels=" + mL2EtherLineModelArray);
            }
            return;
        }
        this.eqpmtModel = mL2ModuleModel;
        this.portModels = mL2EtherPortModelArray;
        this.lineModels = (ML2FastELineModel[])mL2EtherLineModelArray;
        this.numLines = mL2EtherLineModelArray.length;
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.etherLineInfo = new sML2EtherLineInfo[this.numLines];
        this.portName = new String[this.numLines];
        this.suppress = new Boolean[this.numLines];
        this.soakTime = new int[this.numLines];
        this.term = this.getTerm();
        this.resetDirty();
        this.registerWithLineModels();
    }

    public boolean isCellEditable(int n, int n2) {
        boolean bl = false;
        if (n2 == 1 || n2 == 3 || n2 == 4) {
            bl = AbstractPane.isUserAuthorized(this.eqpmtModel, SecurityLevel.PROVISIONING);
        }
        return bl;
    }

    public boolean isCellDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    public sML2EtherLineInfo getEtherLineInfoFromModel(int n) throws NoSuchInterface, WrongInterfaceType {
        sML2EtherLineInfo sML2EtherLineInfo2 = this.lineModels[n].getML2EtherLineInfo();
        if (ML2LxEtherPortTableModel.db.on) {
            db.finest("ML2EtherLineInfo: row=" + n);
            db.finest("   adminState:" + sML2EtherLineInfo2.adminState);
            db.finest("   linkUp:" + sML2EtherLineInfo2.linkUp);
            db.finest("   duplex:" + sML2EtherLineInfo2.duplex.value());
            db.finest("   flowControlNegotiated:" + sML2EtherLineInfo2.flowControlNegotiated.value());
        }
        return sML2EtherLineInfo2;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        if (n >= 0 && n < this.columnNames.length) {
            return this.columnNames[n];
        }
        return null;
    }

    private String getLineNumber(int n) {
        try {
            ML2EtherPortModel mL2EtherPortModel = this.portModels[n];
            return String.valueOf(mL2EtherPortModel.getPort());
        }
        catch (Exception exception) {
            if (ML2LxEtherPortTableModel.db.on) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return "unknown";
        }
    }

    public int getRowCount() {
        return this.numLines;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 1: {
                return String.class;
            }
            case 3: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    private String getPortNameFromModel(int n) {
        String string;
        block2: {
            string = "";
            try {
                string = this.lineModels[n].getAlias();
            }
            catch (Exception exception) {
                if (!ML2LxEtherPortTableModel.db.on) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }

    private String getLinkState(int n) {
        try {
            return this.etherLineInfo[n].linkUp ? "Up" : "Down";
        }
        catch (Exception exception) {
            if (ML2LxEtherPortTableModel.db.on) {
                db.println("Exception caught accessing link state: " + exception);
            }
            return exception.toString();
        }
    }

    public String getAdminState(int n) {
        return this.etherLineInfo[n].adminState == eAdminState.ADMIN_IS || this.etherLineInfo[n].adminState == eAdminState.ADMIN_IS_AINS ? "Up" : "Down";
    }

    private Boolean getPreServiceAlarmSuppress(int n) {
        block5: {
            if (this.lineModels[n] instanceof EtherLineModel) {
                try {
                    this.suppress[n] = this.lineModels[n].getPreServiceAlarmSuppress();
                    if (ML2LxEtherPortTableModel.db.on) {
                        db.println("getPSAS: row " + n + " suppress " + this.suppress[n]);
                    }
                }
                catch (EMCProvisionError eMCProvisionError) {
                    ErrorMsg.displayError((Component)this.getFrame(), (EID)eMCProvisionError.getEID());
                }
                catch (Exception exception) {
                    if (!ML2LxEtherPortTableModel.db.on) break block5;
                    db.println("Exception caught accessing PSAS: " + exception);
                }
            }
        }
        return this.suppress[n];
    }

    private void setPreServiceAlarmSuppress(int n, Boolean bl) {
        this.suppress[n] = bl;
        this.isDirty[n][3] = true;
        if (ML2LxEtherPortTableModel.db.on) {
            db.println("setPSAS, row " + n + " newSuppress " + bl);
        }
    }

    private int getSoakTime(int n) {
        try {
            this.soakTime[n] = this.lineModels[n].getSoakTime();
        }
        catch (NoSuchInterface noSuchInterface) {
            db.fine("No Such Interface: " + (Object)((Object)noSuchInterface));
        }
        return this.soakTime[n];
    }

    private String getSoakTimeAsHHMM(int n) throws NoSuchInterface {
        return SoakTimePropertyEditor.toStringHHMM(this.soakTime[n]);
    }

    public Attribute getOperatingEtherSpeed(int n) {
        return EtherEnumStrings.get(eEtherSpeed.class, this.etherLineInfo[n].speed.value());
    }

    public Attribute getOperatingEtherDuplex(int n) {
        return EtherEnumStrings.get(eEtherDuplex.class, this.etherLineInfo[n].duplex.value());
    }

    public Attribute getFlowControlStatus(int n) {
        return EtherEnumStrings.get(eFlowControlNegotiated.class, this.etherLineInfo[n].flowControlNegotiated.value());
    }

    public Object getValueAt(int n, int n2) {
        String string;
        block13: {
            string = "";
            try {
                switch (n2) {
                    case 0: {
                        return this.getLineNumber(n);
                    }
                    case 1: {
                        return this.portName[n];
                    }
                    case 2: {
                        return this.getAdminState(n);
                    }
                    case 3: {
                        return this.suppress[n];
                    }
                    case 4: {
                        return this.getSoakTimeAsHHMM(n);
                    }
                    case 5: {
                        return this.getLinkState(n);
                    }
                    case 6: {
                        return this.getOperatingEtherSpeed(n);
                    }
                    case 7: {
                        return this.getOperatingEtherDuplex(n);
                    }
                    case 8: {
                        return this.getFlowControlStatus(n);
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block13;
                db.println("Error in getValueAt " + exception);
                SDebug.printStackTrace((Throwable)exception);
                string = exception.toString();
            }
        }
        return string;
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                return;
            }
            case 1: {
                String string;
                if (!(object instanceof String) || (string = (String)object) == null) break;
                this.portName[n] = string;
                break;
            }
            case 2: {
                return;
            }
            case 3: {
                if (!(object instanceof Boolean)) break;
                Boolean bl = (Boolean)object;
                this.setPreServiceAlarmSuppress(n, bl);
                break;
            }
            case 4: {
                int n3 = this.soakTime[n];
                try {
                    n3 = SoakTimePropertyEditor.toIntValue((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    db.fine("Number Format Exception on " + (String)object);
                }
                if (this.soakTime[n] == n3) {
                    return;
                }
                this.soakTime[n] = n3;
                break;
            }
            case 5: {
                return;
            }
            case 6: {
                return;
            }
            case 7: {
                return;
            }
            case 8: {
                return;
            }
            default: {
                return;
            }
        }
        this.isDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                if (!this.isDirty[i][j]) continue;
                return true;
            }
        }
        return false;
    }

    public void resetDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void resetDirty(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    public void refreshLineFromModel(int n) {
        block2: {
            try {
                this.resetLineCache(n);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.fireTableRowsUpdated(n, n);
    }

    public void applyToModels() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            if (this.isDirty[i][1]) {
                try {
                    this.lineModels[i].setAlias(this.portName[i]);
                }
                catch (Exception exception) {
                    if (ML2LxEtherPortTableModel.db.on) {
                        db.println("Exception caught trying to set port name : " + exception);
                    }
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            if (this.isDirty[i][3]) {
                try {
                    if (this.lineModels[i] instanceof EtherLineModel) {
                        this.lineModels[i].setPreServiceAlarmSuppress(this.suppress[i]);
                        if (db.on()) {
                            db.println("applyToModel: row " + i + " setting PSAS " + this.suppress[i]);
                        }
                    }
                }
                catch (EMCProvisionError eMCProvisionError) {
                    ErrorMsg.displayError((Component)this.getFrame(), (EID)eMCProvisionError.getEID());
                }
            }
            if (!this.isDirty[i][4]) continue;
            if (db.on()) {
                db.println("setting line soakTime " + this.soakTime[i]);
            }
            this.lineModels[i].setSoakTime(this.soakTime[i]);
        }
        this.resetDirty();
    }

    public void refreshFromModel() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    private void resetLineCache(int n) throws Exception {
        this.etherLineInfo[n] = this.getEtherLineInfoFromModel(n);
        this.portName[n] = this.getPortNameFromModel(n);
        this.suppress[n] = this.getPreServiceAlarmSuppress(n);
        this.soakTime[n] = this.getSoakTime(n);
        this.resetDirty(n);
    }

    public Attribute[] getAdminStateAttrs() {
        return ComEnumStrings.get(eAdminState.class, ComEnumStrings.G1000_ADMIN_STATE);
    }

    public Attribute[] getFlowControlAttrs() {
        return EtherEnumStrings.get(eFlowControlNegotiated.class, EtherEnumStrings.ML2_FLOW_CONTROL);
    }

    private void registerWithLineModels() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].addObserver(this);
        }
    }

    private void unRegisterWithLineModels() {
        for (int i = 0; i < this.lineModels.length; ++i) {
            this.lineModels[i].deleteObserver(this);
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            int n;
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            if ((n = Arrays.asList(this.lineModels).indexOf(observable)) != -1) {
                this.refreshLineFromModel(n);
            }
        }
    }

    private TDMTerminology getTerm() {
        return this.eqpmtModel.getNodeModel().getTDMTerminology();
    }

    public void dispose() {
        this.unRegisterWithLineModels();
    }

    protected Frame getFrame() {
        return this.eqpmtModel.getNodeModel().getUiToolkit().getApplicationFrame();
    }
}

