/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ml2;

import cerent.cms.model.AdminState;
import cerent.cms.model.ML2EtherLineModel;
import cerent.cms.model.ML2EtherPortModel;
import cerent.cms.model.ML2ModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ml2.ML2CellEditor;
import cerent.cms.ui.ml2.ML2MapEtherPortTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.WID;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.FixedLengthField;
import cerent.util.gui.SoakTimeCellEditor;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ML2MapEtherPortProvPane
extends NodeProvPane
implements PropertyChangeListener,
TableModelListener {
    protected ML2MapEtherPortTableModel dataModel = null;
    protected ML2ModuleModel eqpmtModel = null;
    protected ML2EtherLineModel[] lineModels = null;
    protected ML2EtherPortModel[] portModels = null;
    private static final SDebug db = new SDebug("ML2MapEtherPortProvPane");

    public ML2MapEtherPortProvPane(String string, TabbedView tabbedView, ML2ModuleModel mL2ModuleModel) {
        super(string, tabbedView);
        this.portModels = mL2ModuleModel.getEtherPortModels();
        this.lineModels = mL2ModuleModel.getEtherLineModels();
        if (mL2ModuleModel == null || this.portModels == null || this.lineModels == null || this.portModels.length != this.lineModels.length) {
            if (db.on()) {
                db.println("Error during initialization");
                db.println("eqpmtModel=" + mL2ModuleModel + " portModels=" + this.portModels + " lineModels=" + this.lineModels);
            }
            return;
        }
        this.dataModel = new ML2MapEtherPortTableModel(mL2ModuleModel, this.portModels, this.lineModels);
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.customizedProvPane();
        this.add((Component)uScrollPane);
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        if (db.on()) {
            db.println("calling enteringPage");
        }
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (db.on()) {
            db.println("calling leavingPage");
        }
        super.leavingPage();
    }

    protected void customizedProvPane() {
        TableColumn tableColumn = null;
        Object[] objectArray = null;
        Vector vector = null;
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(0));
        tableColumn.setCellEditor(new DefaultCellEditor(new JTextField()));
        tableColumn.setPreferredWidth(50);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(1));
        tableColumn.setCellEditor(new DefaultCellEditor(new FixedLengthField(32)));
        tableColumn.setPreferredWidth(200);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(2));
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(this.dataModel.getAdminStateAttrs())));
        tableColumn.setPreferredWidth(75);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(3));
        tableColumn.setPreferredWidth(120);
        SoakTimeCellEditor soakTimeCellEditor = new SoakTimeCellEditor(this);
        tableColumn = this.table.getColumn(ML2MapEtherPortTableModel.columnNames[4]);
        tableColumn.setCellEditor(soakTimeCellEditor);
        tableColumn.setMinWidth(soakTimeCellEditor.getPreferredWidth() + 10);
        this.table.setRowHeight(soakTimeCellEditor.getPreferredHeight());
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(6));
        objectArray = this.dataModel.getEtherSpeedAttrs();
        tableColumn.setCellEditor(new ML2CellEditor(this.lineModels, this.getComboBoxFor(objectArray)));
        tableColumn.setPreferredWidth(105);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(7));
        tableColumn.setPreferredWidth(105);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(8));
        objectArray = this.dataModel.getEtherDuplexAttrs();
        tableColumn.setCellEditor(new ML2CellEditor(this.lineModels, this.getComboBoxFor(objectArray)));
        tableColumn.setPreferredWidth(105);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(9));
        tableColumn.setPreferredWidth(105);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(10));
        tableColumn.setPreferredWidth(150);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(11));
        tableColumn.setPreferredWidth(125);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(12));
        tableColumn.setPreferredWidth(100);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(13));
        vector = this.dataModel.getAvailableVlanCosValues();
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(vector)));
        tableColumn.setPreferredWidth(110);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(14));
        vector = this.dataModel.getAvailableIpTosValues();
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(vector)));
        tableColumn.setPreferredWidth(55);
        this.table.sizeColumnsToFit(-1);
    }

    private JComboBox getComboBoxFor(Object[] objectArray) {
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    private JComboBox getComboBoxFor(Vector vector) {
        JComboBox jComboBox = new JComboBox(vector);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    public void destroy() {
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
            this.dataModel.dispose();
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    protected boolean queryRemainDirty() {
        return true;
    }

    private boolean preApply() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        if (AdminState.adminStateChangedToFormOfOOS(this.dataModel, this.lineModels)) {
            stringBuffer.append(AdminState.getBaseOosWarning(this.terms)).append('\n');
            bl2 = true;
        }
        if (AdminState.needRemoveLoopback(this.dataModel, this.lineModels)) {
            stringBuffer.append("Some lines will be removed from loopback since their new state does not allow loopback.").append('\n');
            bl = true;
        }
        if (bl || bl2) {
            if (bl2) {
                String string = AdminState.getSevWarningMsg(this.dataModel, this.lineModels, bl, true);
                stringBuffer.append(string).append("\n\n").append(this.getApplyString(false));
            } else {
                stringBuffer.append(this.getApplyString());
            }
            return CerentDialog.yesNoDialog((Component)((Object)this), (String)stringBuffer.toString(), (String)"Confirmation Dialog");
        }
        return true;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
    }

    public void applyChangesToModel() throws Exception {
        if (!this.preApply()) {
            return;
        }
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        Boolean bl = this.dataModel.enableAutoNegotiationChanged();
        for (int i = 0; i < this.lineModels.length; ++i) {
            if (this.dataModel.validateChanges(i) && this.dataModel.validateEnableAutoNegotiation(i)) {
                this.dataModel.applyToModel(i);
                continue;
            }
            if (!this.dataModel.validateEnableAutoNegotiation(i)) {
                vector2.add(new Integer(this.portModels[i].getPort()));
                continue;
            }
            vector.add(new Integer(this.portModels[i].getPort()));
        }
        if (vector.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            if (vector.size() > 1) {
                for (int i = 0; i < vector.size(); ++i) {
                    stringBuffer.append((Integer)vector.get(i));
                    if (i < vector.size() - 1) {
                        stringBuffer.append(", ");
                        continue;
                    }
                    stringBuffer.append(" ");
                }
            } else {
                stringBuffer.append(" " + (Integer)vector.get(0));
            }
            ErrorMsg.displayError((Component)((Object)this), EMC.EID_ML2_PORT_CHANGE_DISALLOWED_PARAM_2, stringBuffer, this.terms.getTermForAdminState(0));
        } else if (vector2.size() > 0) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ML2_PORT_AUTO_NEGOTIATE);
        } else {
            if (this.dataModel.isSupportsOnlyCopperSFP() && bl.booleanValue()) {
                ErrorMsg.displayWarning((Component)((Object)this), (WID)EMC.WID_CHG_AUTO_NEGOTIATE);
            }
            this.resetDirty();
        }
    }

    public void refreshFromModel() throws Exception {
        this.dataModel.refreshFromModel();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.ML2MapEtherPortProvPane;
    }
}

