/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ml2;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.EtherMedia.eEtherDuplex;
import cerent.cms.idl.EtherMedia.eEtherSpeed;
import cerent.cms.idl.EtherMedia.eFlowControlNegotiated;
import cerent.cms.idl.EtherMedia.sML2EtherLineInfo;
import cerent.cms.idl.EtherMedia.sML2MapperEtherLineAdminInfo;
import cerent.cms.idl.If.eLoopback;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.IServiceState;
import cerent.cms.model.InvalidCardMode;
import cerent.cms.model.ML2EtherLineModel;
import cerent.cms.model.ML2EtherPortModel;
import cerent.cms.model.ML2FastELineModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.enumeration.EtherEnumStrings;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.IAdminTableAccess;
import cerent.util.EMC;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.SoakTimePropertyEditor;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class ML2MapEtherPortTableModel
extends AbstractTableModel
implements Observer,
IAdminTableAccess {
    public static final int LINENUMBER_INDEX = 0;
    public static final int PORTNAME_INDEX = 1;
    public static final int ADMIN_STATE_INDEX = 2;
    public static final int SERVICE_STATE_INDEX = 3;
    public static final int SOAK_TIME_INDEX = 4;
    public static final int LINK_STATE_INDEX = 5;
    public static final int EXPECTED_SPEED_INDEX = 6;
    public static final int OPERATING_SPEED_INDEX = 7;
    public static final int EXPECTED_DUPLEX_INDEX = 8;
    public static final int OPERATING_DUPLEX_INDEX = 9;
    public static final int ENABLE_AUTO_NEGOTIATION = 10;
    public static final int ENABLE_FLOW_CTRL_INDEX = 11;
    public static final int FLOW_CTRL_INDEX = 12;
    public static final int VLAN_COS_INDEX = 13;
    public static final int IP_TOS_INDEX = 14;
    public static final int LI_TIMER_INDEX = 15;
    public static final int LI_TIMER_DISABLE = 16;
    static final String[] columnNames = new String[]{"Port", "Port Name", "Admin State", "Service State", "AINS Soak", "Link State", "Expected Speed", "Operating Speed", "Expected Duplex", "Operating Duplex", "Enable Selective Auto Negotiation", "Enable Flow Control", "Flow Control", "802.1Q Vlan CoS", "IP ToS", "Link Integrity Timer", "Link Integrity Disable"};
    private ModuleModel eqpmtModel = null;
    private ML2EtherPortModel[] portModels = null;
    private ML2FastELineModel[] lineModels = null;
    private sML2MapperEtherLineAdminInfo[] etherLineAdminInfo = null;
    private sML2EtherLineInfo[] etherLineInfo = null;
    private int[] liTimer = null;
    private boolean[] liCheck = null;
    private boolean[][] isDirty = null;
    private int numLines = 0;
    private String[] portNames;
    private int[] soakTime;
    private AdminState[] adminState;
    protected IServiceState[] serviceState;
    private boolean isPortOOSServiceAffecting;
    private TDMTerminology term;
    private static final SDebug db = new SDebug("ML2MapEtherPortTableModel");

    public ML2MapEtherPortTableModel(ModuleModel moduleModel, ML2EtherPortModel[] mL2EtherPortModelArray, ML2EtherLineModel[] mL2EtherLineModelArray) {
        if (moduleModel == null || mL2EtherPortModelArray == null || mL2EtherLineModelArray == null || mL2EtherPortModelArray.length != mL2EtherLineModelArray.length) {
            if (db.on()) {
                db.println("Error during initialization");
                db.println("eqpmtModel=" + moduleModel + " portModels=" + mL2EtherPortModelArray + " lineModels=" + mL2EtherLineModelArray);
            }
            return;
        }
        this.eqpmtModel = moduleModel;
        this.portModels = mL2EtherPortModelArray;
        this.lineModels = (ML2FastELineModel[])mL2EtherLineModelArray;
        this.numLines = mL2EtherLineModelArray.length;
        this.etherLineAdminInfo = new sML2MapperEtherLineAdminInfo[this.numLines];
        this.etherLineInfo = new sML2EtherLineInfo[this.numLines];
        this.portNames = new String[this.numLines];
        this.adminState = new AdminState[this.numLines];
        this.serviceState = new IServiceState[this.numLines];
        this.soakTime = new int[this.numLines];
        this.liTimer = new int[this.numLines];
        this.liCheck = new boolean[this.numLines];
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.term = this.getTerm();
        this.resetDirty();
        this.registerWithLineModels();
        this.isPortOOSServiceAffecting = this.eqpmtModel.getNodeModelDelegate().getPlatform().isPortOOSserviceAfecting();
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.lineModels != null && this.numLines > 0 && AbstractPane.isUserAuthorized(this.lineModels[0], SecurityLevel.PROVISIONING)) {
            if (!this.liCheck[n] && n2 == 15) {
                return true;
            }
            return n2 == 1 || n2 == 2 || n2 == 11 || n2 == 4 || n2 == 6 || n2 == 8 || n2 == 13 || n2 == 14 || n2 == 10 || n2 == 16;
        }
        return false;
    }

    public boolean flowControlChanged() {
        for (int i = 0; i < this.numLines; ++i) {
            try {
                if (!this.isDirty[i][11] || !AdminState.isFormOfIS(this.getAdminStateAsEnum(i))) continue;
                return true;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!db.on()) continue;
                db.println("Error in getAdminState" + (Object)((Object)noSuchInterface));
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return false;
    }

    public boolean enableAutoNegotiationChanged() {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isDirty[i][10]) continue;
            return true;
        }
        return false;
    }

    private String getSoakTimeAsHHMM(int n) throws NoSuchInterface {
        return SoakTimePropertyEditor.toStringHHMM(this.soakTime[n]);
    }

    public boolean isCellDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    private sML2MapperEtherLineAdminInfo getEtherLineAdminInfoFromModel(int n) throws NoSuchInterface, WrongInterfaceType, InvalidCardMode {
        sML2MapperEtherLineAdminInfo sML2MapperEtherLineAdminInfo2 = this.lineModels[n].getML2MapperEtherLineAdminInfo();
        if (db.on()) {
            db.println("ML2MapperEtherLineAdminInfo: row=" + n);
            db.println("   loopback=" + sML2MapperEtherLineAdminInfo2.loopback.value());
            db.println("   flowControlEnabled=" + sML2MapperEtherLineAdminInfo2.flowControlEnabled);
            db.println("   speed=" + sML2MapperEtherLineAdminInfo2.linkSpeed.value());
            db.println("   duplex=" + sML2MapperEtherLineAdminInfo2.linkDuplex.value());
            db.println("   vlanCosThreshold=" + sML2MapperEtherLineAdminInfo2.vlanCosThreshold);
            db.println("   ipTosThreshold=" + sML2MapperEtherLineAdminInfo2.ipTosThreshold);
        }
        return sML2MapperEtherLineAdminInfo2;
    }

    private sML2EtherLineInfo getEtherLineInfoFromModel(int n) throws NoSuchInterface, WrongInterfaceType {
        sML2EtherLineInfo sML2EtherLineInfo2 = this.lineModels[n].getML2EtherLineInfo();
        if (ML2MapEtherPortTableModel.db.on) {
            db.finest("ML2EtherLineInfo: row=" + n);
            db.finest("   adminState=" + sML2EtherLineInfo2.adminState);
            db.finest("   linkUp=" + sML2EtherLineInfo2.linkUp);
            db.finest("   speed=" + sML2EtherLineInfo2.speed.value());
            db.finest("   duplex=" + sML2EtherLineInfo2.duplex.value());
            db.finest("   flowControlNegotiated=" + sML2EtherLineInfo2.flowControlNegotiated.value());
        }
        return sML2EtherLineInfo2;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public String getColumnName(int n) {
        if (n >= 0 && n < columnNames.length) {
            return columnNames[n];
        }
        return null;
    }

    private String getLineNumber(int n) {
        try {
            return String.valueOf(this.portModels[n].getPort());
        }
        catch (Exception exception) {
            if (ML2MapEtherPortTableModel.db.on) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return "unknown";
        }
    }

    public eAdminState getAdminStateAsEnum(int n) throws NoSuchInterface {
        return this.etherLineInfo[n].adminState;
    }

    private Boolean getFlowControlEnabled(int n) {
        return new Boolean(this.etherLineAdminInfo[n].flowControlEnabled);
    }

    private Boolean getAutoNegoEnabled(int n) {
        return new Boolean(this.etherLineAdminInfo[n].autoNegotiateEnabled);
    }

    private Attribute getExpectedEtherSpeed(int n) {
        return EtherEnumStrings.get(eEtherSpeed.class, this.etherLineAdminInfo[n].linkSpeed.value());
    }

    private Attribute getOperatingEtherSpeed(int n) {
        return EtherEnumStrings.get(eEtherSpeed.class, this.etherLineInfo[n].speed.value());
    }

    private String getLinkState(int n) {
        try {
            return this.etherLineInfo[n].linkUp ? "Up" : "Down";
        }
        catch (Exception exception) {
            if (ML2MapEtherPortTableModel.db.on) {
                db.println("Exception caught accessing link state: " + exception);
            }
            return exception.toString();
        }
    }

    private Attribute getExpectedEtherDuplex(int n) {
        return EtherEnumStrings.get(eEtherDuplex.class, this.etherLineAdminInfo[n].linkDuplex.value());
    }

    private Attribute getOperatingEtherDuplex(int n) {
        return EtherEnumStrings.get(eEtherDuplex.class, this.etherLineInfo[n].duplex.value());
    }

    public Attribute getFlowControlStatus(int n) {
        return EtherEnumStrings.get(eFlowControlNegotiated.class, this.etherLineInfo[n].flowControlNegotiated.value());
    }

    private String getPortNameFromModel(int n) {
        String string;
        block2: {
            string = "";
            try {
                string = this.lineModels[n].getAlias();
            }
            catch (Exception exception) {
                if (!ML2MapEtherPortTableModel.db.on) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }

    public int getRowCount() {
        return this.numLines;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 10: 
            case 11: {
                return Boolean.class;
            }
            case 15: {
                return Integer.class;
            }
            case 16: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    public Object getValueAt(int n, int n2) {
        block22: {
            try {
                switch (n2) {
                    case 0: {
                        return this.getLineNumber(n);
                    }
                    case 1: {
                        return this.portNames[n];
                    }
                    case 2: {
                        return this.adminState[n].toString(this.term);
                    }
                    case 4: {
                        return this.getSoakTimeAsHHMM(n);
                    }
                    case 3: {
                        return this.serviceState[n].toString(this.term);
                    }
                    case 5: {
                        return this.getLinkState(n);
                    }
                    case 6: {
                        return this.getExpectedEtherSpeed(n);
                    }
                    case 7: {
                        return this.getOperatingEtherSpeed(n);
                    }
                    case 8: {
                        return this.getExpectedEtherDuplex(n);
                    }
                    case 9: {
                        return this.getOperatingEtherDuplex(n);
                    }
                    case 11: {
                        return this.getFlowControlEnabled(n);
                    }
                    case 12: {
                        return this.getFlowControlStatus(n);
                    }
                    case 13: {
                        return new Integer(this.etherLineAdminInfo[n].vlanCosThreshold);
                    }
                    case 14: {
                        return new Integer(this.etherLineAdminInfo[n].ipTosThreshold);
                    }
                    case 10: {
                        return this.getAutoNegoEnabled(n);
                    }
                    case 15: {
                        if (this.liCheck[n]) {
                            return null;
                        }
                        return this.liTimer[n];
                    }
                    case 16: {
                        return this.liCheck[n];
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block22;
                db.println("Error in getValueAt in ML2MapEtherPortTableModel " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                return;
            }
            case 1: {
                if (this.portNames[n] == (String)object) {
                    return;
                }
                this.portNames[n] = (String)object;
                break;
            }
            case 2: {
                if (this.adminState[n] == (AdminState)object) {
                    return;
                }
                this.adminState[n] = (AdminState)object;
                break;
            }
            case 4: {
                int n3 = this.soakTime[n];
                try {
                    n3 = SoakTimePropertyEditor.toIntValue((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    db.fine("Number Format Exception on " + (String)object);
                }
                if (this.soakTime[n] == n3) {
                    return;
                }
                this.soakTime[n] = n3;
                break;
            }
            case 6: {
                if (this.etherLineAdminInfo[n].linkSpeed == eEtherSpeed.from_int(((Attribute)object).getIntValue())) {
                    return;
                }
                this.etherLineAdminInfo[n].linkSpeed = eEtherSpeed.from_int(((Attribute)object).getIntValue());
                break;
            }
            case 8: {
                if (this.etherLineAdminInfo[n].linkDuplex == eEtherDuplex.from_int(((Attribute)object).getIntValue())) {
                    return;
                }
                this.etherLineAdminInfo[n].linkDuplex = eEtherDuplex.from_int(((Attribute)object).getIntValue());
                break;
            }
            case 11: {
                if (!(object instanceof Boolean)) break;
                if (this.etherLineAdminInfo[n].flowControlEnabled == (Boolean)object) {
                    return;
                }
                this.etherLineAdminInfo[n].flowControlEnabled = (Boolean)object;
                break;
            }
            case 13: {
                if (!(object instanceof Integer)) break;
                if (this.etherLineAdminInfo[n].vlanCosThreshold == ((Integer)object).shortValue()) {
                    return;
                }
                this.etherLineAdminInfo[n].vlanCosThreshold = ((Integer)object).shortValue();
                break;
            }
            case 14: {
                if (!(object instanceof Integer)) break;
                if (this.etherLineAdminInfo[n].ipTosThreshold == ((Integer)object).shortValue()) {
                    return;
                }
                this.etherLineAdminInfo[n].ipTosThreshold = ((Integer)object).shortValue();
                break;
            }
            case 10: {
                if (!(object instanceof Boolean)) break;
                if (this.etherLineAdminInfo[n].autoNegotiateEnabled == (Boolean)object) {
                    return;
                }
                this.etherLineAdminInfo[n].autoNegotiateEnabled = (Boolean)object;
                break;
            }
            case 15: {
                if (this.liTimer[n] == (Integer)object) {
                    return;
                }
                this.liTimer[n] = (Integer)object;
                break;
            }
            case 16: {
                Boolean bl = (Boolean)object;
                if (this.liCheck[n] == bl) {
                    return;
                }
                this.liCheck[n] = bl;
                if (!bl.booleanValue()) {
                    this.liTimer[n] = 200;
                    break;
                }
                this.liTimer[n] = 0;
                break;
            }
            default: {
                return;
            }
        }
        this.isDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                if (!this.isDirty[i][j]) continue;
                return true;
            }
        }
        return false;
    }

    public void resetDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refreshLineFromModel(int n) {
        block2: {
            try {
                this.resetLineCache(n);
                this.fireTableRowsUpdated(n, n);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private boolean needRemoveLoopback(int n) {
        block3: {
            try {
                if (this.isDirty[n][2] && (this.etherLineAdminInfo[n].loopback == eLoopback.LINE_LOOPBACK || this.etherLineAdminInfo[n].loopback == eLoopback.INWARD_LOOPBACK) && !AdminState.admitsLoopback(this.getNewAdminState(n))) {
                    return true;
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return false;
    }

    public sML2MapperEtherLineAdminInfo getEtherAdminInfo(int n) {
        return this.etherLineAdminInfo[n];
    }

    public boolean validateChanges(int n) throws Exception {
        sML2MapperEtherLineAdminInfo sML2MapperEtherLineAdminInfo2 = this.getEtherLineAdminInfoFromModel(n);
        sML2MapperEtherLineAdminInfo sML2MapperEtherLineAdminInfo3 = this.etherLineAdminInfo[n];
        return this.getAdminStateFromModel(n) != eAdminState.ADMIN_IS || sML2MapperEtherLineAdminInfo2.linkSpeed == sML2MapperEtherLineAdminInfo3.linkSpeed && sML2MapperEtherLineAdminInfo2.linkDuplex == sML2MapperEtherLineAdminInfo3.linkDuplex && sML2MapperEtherLineAdminInfo2.flowControlEnabled == sML2MapperEtherLineAdminInfo3.flowControlEnabled && sML2MapperEtherLineAdminInfo2.vlanCosThreshold == sML2MapperEtherLineAdminInfo3.vlanCosThreshold && sML2MapperEtherLineAdminInfo2.ipTosThreshold == sML2MapperEtherLineAdminInfo3.ipTosThreshold && sML2MapperEtherLineAdminInfo2.autoNegotiateEnabled == sML2MapperEtherLineAdminInfo3.autoNegotiateEnabled;
    }

    public boolean validateEnableAutoNegotiation(int n) throws Exception {
        sML2MapperEtherLineAdminInfo sML2MapperEtherLineAdminInfo2 = this.etherLineAdminInfo[n];
        return sML2MapperEtherLineAdminInfo2.linkDuplex.value() != 2 && sML2MapperEtherLineAdminInfo2.linkSpeed.value() != 3 || sML2MapperEtherLineAdminInfo2.autoNegotiateEnabled != Boolean.TRUE;
    }

    public void applyToModel(int n) throws Exception {
        if (this.isDirty[n][1]) {
            this.lineModels[n].setAlias(this.portNames[n]);
        }
        boolean bl = this.needRemoveLoopback(n);
        if (this.isDirty[n][11] || this.isDirty[n][6] || this.isDirty[n][8] || this.isDirty[n][13] || this.isDirty[n][14] || this.isDirty[n][10] || bl) {
            if (bl) {
                this.etherLineAdminInfo[n].loopback = eLoopback.NO_LOOPBACK;
            }
            this.lineModels[n].setML2MapperEtherLineAdminInfo(this.etherLineAdminInfo[n]);
        }
        if (this.isDirty[n][4]) {
            if (db.on()) {
                db.println("setting line soakTime " + this.soakTime[n]);
            }
            this.lineModels[n].setSoakTime(this.soakTime[n]);
        }
        if (!this.liCheck[n] && this.liTimer[n] == 0) {
            throw new ProvisionError(EMC.EID_WRONG_INPUT, null);
        }
        boolean bl2 = false;
        if (this.isDirty[n][15]) {
            this.etherLineAdminInfo[n].liTimer = this.liTimer[n];
            this.lineModels[n].setML2MapperEtherLineAdminInfo(this.etherLineAdminInfo[n]);
            bl2 = true;
        }
        if (this.isDirty[n][16] && !bl2) {
            this.etherLineAdminInfo[n].liTimer = this.liTimer[n];
            this.lineModels[n].setML2MapperEtherLineAdminInfo(this.etherLineAdminInfo[n]);
            bl2 = true;
        }
        if (this.isDirty[n][2]) {
            this.lineModels[n].setAdminState(this.getNewAdminState(n));
        }
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    public void refreshFromModel() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    protected void resetLineCache(int n) throws Exception {
        this.etherLineAdminInfo[n] = this.getEtherLineAdminInfoFromModel(n);
        this.etherLineInfo[n] = this.getEtherLineInfoFromModel(n);
        this.portNames[n] = this.getPortNameFromModel(n);
        this.adminState[n] = AdminState.enumToAdminState(this.getAdminStateFromModel(n));
        sServiceState sServiceState2 = this.lineModels[n].getServiceState();
        this.serviceState[n] = ServiceStateFactory.getServiceState(sServiceState2);
        this.soakTime[n] = this.lineModels[n].getSoakTime();
        this.liTimer[n] = this.etherLineAdminInfo[n].liTimer;
        this.liCheck[n] = this.liTimer[n] == 0;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    private eAdminState getNewAdminState(int n) throws NoSuchInterface {
        return this.adminState[n].getAdminStateEnum();
    }

    public AdminState getAdminState(int n) throws NoSuchInterface {
        return this.adminState[n];
    }

    public boolean isAdminStateDirty(int n) {
        return this.isDirty[n][2];
    }

    protected eAdminState getAdminStateFromModel(int n) throws NoSuchInterface {
        return this.lineModels[n].getAdminStateEnum();
    }

    public Vector getAvailableVlanCosValues() {
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i <= 7; ++i) {
            vector.add(new Integer(i));
        }
        return vector;
    }

    public Vector getAvailableIpTosValues() {
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i <= 255; ++i) {
            vector.add(new Integer(i));
        }
        return vector;
    }

    public AdminState[] getAdminStateAttrs() {
        boolean bl = AdminState.isANSI(this.eqpmtModel.getNodeModel().getTdmProtocolType());
        return AdminState.getDefaultAdminStates(bl);
    }

    public Attribute[] getFlowControlAttrs() {
        return EtherEnumStrings.get(eFlowControlNegotiated.class, EtherEnumStrings.ML2_FLOW_CONTROL);
    }

    public Attribute[] getEtherSpeedAttrs() {
        if (this.eqpmtModel.getEqType() == 283 || this.eqpmtModel.getEqType() == 284) {
            return EtherEnumStrings.get(eEtherSpeed.class, EtherEnumStrings.ONE_GIG_ETHER_SPEED);
        }
        return EtherEnumStrings.get(eEtherSpeed.class, EtherEnumStrings.ML2_ETHER_SPEED);
    }

    public boolean isSupportsOnlyCopperSFP() {
        int n = this.eqpmtModel.getEqType();
        return n == 283 || n == 284;
    }

    public Attribute[] getEtherDuplexAttrs() {
        return EtherEnumStrings.get(eEtherDuplex.class);
    }

    private void registerWithLineModels() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].addObserver(this);
        }
    }

    private void unRegisterWithLineModels() {
        for (int i = 0; i < this.lineModels.length; ++i) {
            this.lineModels[i].deleteObserver(this);
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            int n;
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            if ((n = Arrays.asList(this.lineModels).indexOf(observable)) != -1) {
                this.refreshLineFromModel(n);
            }
        }
    }

    public void dispose() {
        this.unRegisterWithLineModels();
    }

    private TDMTerminology getTerm() {
        return this.eqpmtModel.getNodeModel().getTDMTerminology();
    }
}

