/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ml2;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.EtherMedia.eFlowControlNegotiated;
import cerent.cms.idl.EtherMedia.sCE1000EtherLineAdminInfo;
import cerent.cms.idl.EtherMedia.sCE1000EtherLineInfo;
import cerent.cms.idl.If.eLoopback;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.InvalidCardMode;
import cerent.cms.model.ML2EtherLineModel;
import cerent.cms.model.ML2EtherPortModel;
import cerent.cms.model.ML2GigELineModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.enumeration.EtherEnumStrings;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.IAdminTableAccess;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.WID;
import cerent.util.gui.SoakTimePropertyEditor;
import java.awt.Component;
import java.awt.Frame;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.table.AbstractTableModel;

public class ML2MapGigEPortTableModel
extends AbstractTableModel
implements Observer,
IAdminTableAccess {
    public static final int LINENUMBER_INDEX = 0;
    public static final int PORTNAME_INDEX = 1;
    public static final int ADMIN_STATE_INDEX = 2;
    public static final int SERVICE_STATE_INDEX = 3;
    public static final int SOAK_TIME_INDEX = 4;
    public static final int LINK_STATE_INDEX = 5;
    public static final int FLOW_CTRL_INDEX = 6;
    public static final int AUTO_NEGOTIATION_INDEX = 7;
    public static final int FLOW_CTRL_STATUS_INDEX = 8;
    public static final int MTU_INDEX = 9;
    public static final int WATER_MARKS_INDEX = 10;
    public static final int FLOW_CTRL_LO_INDEX = 11;
    public static final int FLOW_CTRL_HI_INDEX = 12;
    public static final int LI_TIMER_INDEX = 14;
    public static final int LI_CHECK = 13;
    static final String[] columnNames = new String[]{"Port", "Port Name", "Admin State", "Service State", "AINS Soak", "Link State", "Flow Control", "Auto Negotiation", "Flow Control Status", "MTU", "Water Marks", "Flow Ctrl Lo", "Flow Ctrl Hi", "Link Integrity Disable", "Link Integrity Timer"};
    private ModuleModel eqpmtModel = null;
    private ML2EtherPortModel[] portModels = null;
    private ML2GigELineModel[] lineModels = null;
    private sCE1000EtherLineAdminInfo[] etherLineAdminInfo = null;
    private sCE1000EtherLineInfo[] etherLineInfo = null;
    private boolean[][] isDirty = null;
    private int numLines = 0;
    private String[] portNames;
    private int[] soakTime;
    private int[] liTimer;
    private boolean[] liCheck;
    private AdminState[] adminState;
    protected IServiceState[] serviceState;
    private Attribute[] waterMarks = null;
    private boolean isPortOOSServiceAffecting;
    private TDMTerminology term;
    private static final SDebug db = new SDebug("ML2MapGigEPortTableModel");

    public ML2MapGigEPortTableModel(ModuleModel moduleModel, ML2EtherPortModel[] mL2EtherPortModelArray, ML2EtherLineModel[] mL2EtherLineModelArray) {
        if (moduleModel == null || mL2EtherPortModelArray == null || mL2EtherLineModelArray == null || mL2EtherPortModelArray.length != mL2EtherLineModelArray.length) {
            if (db.on()) {
                db.println("Error during initialization");
                db.println("eqpmtModel=" + moduleModel + " portModels=" + mL2EtherPortModelArray + " lineModels=" + mL2EtherLineModelArray);
            }
            return;
        }
        this.eqpmtModel = moduleModel;
        this.portModels = mL2EtherPortModelArray;
        this.lineModels = (ML2GigELineModel[])mL2EtherLineModelArray;
        this.numLines = mL2EtherLineModelArray.length;
        this.etherLineAdminInfo = new sCE1000EtherLineAdminInfo[this.numLines];
        this.etherLineInfo = new sCE1000EtherLineInfo[this.numLines];
        this.portNames = new String[this.numLines];
        this.adminState = new AdminState[this.numLines];
        this.serviceState = new IServiceState[this.numLines];
        this.waterMarks = new Attribute[this.numLines];
        this.soakTime = new int[this.numLines];
        this.liTimer = new int[this.numLines];
        this.liCheck = new boolean[this.numLines];
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.term = this.getTerm();
        this.resetDirty();
        this.registerWithLineModels();
        this.isPortOOSServiceAffecting = this.eqpmtModel.getNodeModelDelegate().getPlatform().isPortOOSserviceAfecting();
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.lineModels != null && this.numLines > 0 && AbstractPane.isUserAuthorized(this.lineModels[0], SecurityLevel.PROVISIONING)) {
            boolean bl = false;
            if (n2 == 11 || n2 == 12) {
                boolean bl2 = bl = this.getWaterMarkSetting(n).getIntValue() == 2;
            }
            if (!this.liCheck[n] && n2 == 14) {
                return true;
            }
            return n2 == 1 || n2 == 2 || n2 == 6 || n2 == 4 || n2 == 7 || n2 == 9 || n2 == 10 || bl || n2 == 13;
        }
        return false;
    }

    public boolean flowControlChanged() {
        for (int i = 0; i < this.numLines; ++i) {
            try {
                if (!this.isDirty[i][6] || !AdminState.isFormOfIS(this.getAdminStateAsEnum(i))) continue;
                return true;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!db.on()) continue;
                db.println("Error in getAdminState" + (Object)((Object)noSuchInterface));
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return false;
    }

    private String getSoakTimeAsHHMM(int n) throws NoSuchInterface {
        return SoakTimePropertyEditor.toStringHHMM(this.soakTime[n]);
    }

    private String getLinkState(int n) {
        try {
            return this.etherLineInfo[n].linkUp ? "Up" : "Down";
        }
        catch (Exception exception) {
            if (ML2MapGigEPortTableModel.db.on) {
                db.println("Exception caught accessing link state: " + exception);
            }
            return exception.toString();
        }
    }

    private Boolean getAutoNegotiationEnabledFor(int n) {
        return new Boolean(this.etherLineAdminInfo[n].negotiation);
    }

    private Attribute getPortMaxSizeFor(int n) {
        return this.getAttributeFor("CE1000 Port Max Size", this.etherLineAdminInfo[n].maxFrameSize);
    }

    public Attribute getWaterMarkSetting(int n) {
        if (this.waterMarks[n] == null) {
            short s = this.getFlowControlLowWaterMark(n);
            short s2 = this.getFlowControlHighWaterMark(n);
            this.waterMarks[n] = s == 25 && s2 == 485 ? this.getAttributeFor("G1000 Water Marks Setting", 0) : (s == 5 && s2 == 10 ? this.getAttributeFor("G1000 Water Marks Setting", 1) : this.getAttributeFor("G1000 Water Marks Setting", 2));
        }
        return this.waterMarks[n];
    }

    public Short getFlowControlLowWaterMark(int n) {
        return new Short(this.etherLineAdminInfo[n].lowWaterMark);
    }

    public Short getFlowControlHighWaterMark(int n) {
        return new Short(this.etherLineAdminInfo[n].highWaterMark);
    }

    public boolean isCellDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    private sCE1000EtherLineAdminInfo getEtherLineAdminInfoFromModel(int n) throws NoSuchInterface, WrongInterfaceType, InvalidCardMode {
        sCE1000EtherLineAdminInfo sCE1000EtherLineAdminInfo2 = this.lineModels[n].getGigELineAdminInfo();
        if (db.on()) {
            db.println("CE1000EtherLineAdminInfo: row=" + n);
            db.println("   flowControl=" + sCE1000EtherLineAdminInfo2.flowControl.value());
            db.println("   negotiation=" + sCE1000EtherLineAdminInfo2.negotiation);
            db.println("   maxFrameSize=" + sCE1000EtherLineAdminInfo2.maxFrameSize);
            db.println("   highWaterMark=" + sCE1000EtherLineAdminInfo2.highWaterMark);
            db.println("   lowWaterMark=" + sCE1000EtherLineAdminInfo2.lowWaterMark);
            db.println("   loopback=" + sCE1000EtherLineAdminInfo2.loopback.value());
        }
        return sCE1000EtherLineAdminInfo2;
    }

    private sCE1000EtherLineInfo getEtherLineInfoFromModel(int n) throws NoSuchInterface, WrongInterfaceType {
        sCE1000EtherLineInfo sCE1000EtherLineInfo2 = this.lineModels[n].getGigELineInfo();
        if (ML2MapGigEPortTableModel.db.on) {
            db.println("CE1000EtherLineInfo: row=" + n);
            db.println("   adminState=" + sCE1000EtherLineInfo2.adminState);
            db.println("   linkUp=" + sCE1000EtherLineInfo2.linkUp);
            db.println("   flowControlStatus=" + sCE1000EtherLineInfo2.flowControlStatus.value());
            db.println("   optics=" + sCE1000EtherLineInfo2.opticsType.value());
        }
        return sCE1000EtherLineInfo2;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public String getColumnName(int n) {
        if (n >= 0 && n < columnNames.length) {
            return columnNames[n];
        }
        return null;
    }

    private String getLineNumber(int n) {
        try {
            return String.valueOf(this.portModels[n].getPort());
        }
        catch (Exception exception) {
            if (ML2MapGigEPortTableModel.db.on) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return "unknown";
        }
    }

    public eAdminState getAdminStateAsEnum(int n) throws NoSuchInterface {
        return this.etherLineInfo[n].adminState;
    }

    private Attribute getFlowControl(int n) {
        return EtherEnumStrings.get(eFlowControlNegotiated.class, this.etherLineAdminInfo[n].flowControl.value());
    }

    public Attribute getFlowControlStatus(int n) {
        return EtherEnumStrings.get(eFlowControlNegotiated.class, this.etherLineInfo[n].flowControlStatus.value());
    }

    private String getPortNameFromModel(int n) {
        String string;
        block2: {
            string = "";
            try {
                string = this.lineModels[n].getAlias();
            }
            catch (Exception exception) {
                if (!ML2MapGigEPortTableModel.db.on) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }

    public int getRowCount() {
        return this.numLines;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 7: {
                return Boolean.class;
            }
            case 14: {
                return Integer.class;
            }
            case 13: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    public Object getValueAt(int n, int n2) {
        block20: {
            try {
                switch (n2) {
                    case 0: {
                        return this.getLineNumber(n);
                    }
                    case 1: {
                        return this.portNames[n];
                    }
                    case 2: {
                        return this.adminState[n].toString(this.term);
                    }
                    case 4: {
                        return this.getSoakTimeAsHHMM(n);
                    }
                    case 5: {
                        return this.getLinkState(n);
                    }
                    case 3: {
                        return this.serviceState[n].toString(this.term);
                    }
                    case 6: {
                        return this.getFlowControl(n);
                    }
                    case 7: {
                        return this.getAutoNegotiationEnabledFor(n);
                    }
                    case 8: {
                        return this.getFlowControlStatus(n);
                    }
                    case 9: {
                        return this.getPortMaxSizeFor(n);
                    }
                    case 10: {
                        return this.getWaterMarkSetting(n);
                    }
                    case 11: {
                        return this.getFlowControlLowWaterMark(n);
                    }
                    case 12: {
                        return this.getFlowControlHighWaterMark(n);
                    }
                    case 14: {
                        if (this.liCheck[n]) {
                            return null;
                        }
                        return this.liTimer[n];
                    }
                    case 13: {
                        return this.liCheck[n];
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block20;
                db.println("Error in getValueAt in ML2MapGigEPortTableModel " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                return;
            }
            case 1: {
                if (this.portNames[n] == (String)object) {
                    return;
                }
                this.portNames[n] = (String)object;
                break;
            }
            case 2: {
                if (this.adminState[n] == (AdminState)object) {
                    return;
                }
                this.adminState[n] = (AdminState)object;
                break;
            }
            case 4: {
                int n3 = this.soakTime[n];
                try {
                    n3 = SoakTimePropertyEditor.toIntValue((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    db.fine("Number Format Exception on " + (String)object);
                }
                if (this.soakTime[n] == n3) {
                    return;
                }
                this.soakTime[n] = n3;
                break;
            }
            case 6: {
                if (!(object instanceof Attribute)) break;
                if (this.etherLineAdminInfo[n].flowControl == eFlowControlNegotiated.from_int(((Attribute)object).getIntValue())) {
                    return;
                }
                this.etherLineAdminInfo[n].flowControl = eFlowControlNegotiated.from_int(((Attribute)object).getIntValue());
                break;
            }
            case 7: {
                if (!(object instanceof Boolean)) break;
                if (this.etherLineAdminInfo[n].negotiation == (Boolean)object) {
                    return;
                }
                this.etherLineAdminInfo[n].negotiation = (Boolean)object;
                break;
            }
            case 9: {
                if (!(object instanceof Attribute)) break;
                if (this.etherLineAdminInfo[n].maxFrameSize == ((Attribute)object).getIntValue()) {
                    return;
                }
                this.etherLineAdminInfo[n].maxFrameSize = ((Attribute)object).getIntValue();
                break;
            }
            case 10: {
                Attribute attribute = (Attribute)object;
                if (this.waterMarks[n] == attribute) {
                    return;
                }
                this.waterMarks[n] = attribute;
                if (attribute.getIntValue() == 0) {
                    this.setWaterMark(11, n, String.valueOf(25));
                    this.setWaterMark(12, n, String.valueOf(485));
                } else if (attribute.getIntValue() == 1) {
                    this.setWaterMark(11, n, String.valueOf(5));
                    this.setWaterMark(12, n, String.valueOf(10));
                }
                this.isDirty[n][10] = true;
                break;
            }
            case 11: {
                this.setWaterMark(11, n, (String)object);
                break;
            }
            case 12: {
                this.setWaterMark(12, n, (String)object);
                break;
            }
            case 14: {
                if (this.liTimer[n] == (Integer)object) {
                    return;
                }
                this.liTimer[n] = (Integer)object;
                break;
            }
            case 13: {
                Boolean bl = (Boolean)object;
                if (this.liCheck[n] == bl) {
                    return;
                }
                this.liCheck[n] = bl;
                if (!bl.booleanValue()) {
                    this.liTimer[n] = 200;
                    break;
                }
                this.liTimer[n] = 0;
                break;
            }
            default: {
                return;
            }
        }
        this.isDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
    }

    private void setWaterMark(int n, int n2, String string) {
        short s = 1;
        try {
            s = Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            SDebug.printStackTrace((Throwable)numberFormatException);
            return;
        }
        if (s < 1 || s > 511) {
            ErrorMsg.displayError(null, EMC.EID_WATERMARK_LIMITS_PARAM_2, Integer.toString(1), Integer.toString(511));
            return;
        }
        switch (n) {
            case 11: {
                this.etherLineAdminInfo[n2].lowWaterMark = s;
                this.isDirty[n2][11] = true;
                this.fireTableCellUpdated(n2, 11);
                break;
            }
            case 12: {
                this.etherLineAdminInfo[n2].highWaterMark = s;
                this.isDirty[n2][12] = true;
                this.fireTableCellUpdated(n2, 12);
            }
        }
    }

    public boolean isWaterMarkValid() {
        boolean bl = true;
        for (int i = 0; i < this.numLines && bl; ++i) {
            bl = this.etherLineAdminInfo[i].lowWaterMark < this.etherLineAdminInfo[i].highWaterMark;
        }
        return bl;
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                if (!this.isDirty[i][j]) continue;
                return true;
            }
        }
        return false;
    }

    public void resetDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refreshLineFromModel(int n) {
        block2: {
            try {
                this.resetLineCache(n);
                this.fireTableRowsUpdated(n, n);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private boolean needRemoveLoopback(int n) {
        block3: {
            try {
                if (this.isDirty[n][2] && (this.etherLineAdminInfo[n].loopback == eLoopback.LINE_LOOPBACK || this.etherLineAdminInfo[n].loopback == eLoopback.INWARD_LOOPBACK) && !AdminState.admitsLoopback(this.getNewAdminState(n))) {
                    return true;
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return false;
    }

    public boolean validateChanges(int n) throws Exception {
        sCE1000EtherLineAdminInfo sCE1000EtherLineAdminInfo2 = this.getEtherLineAdminInfoFromModel(n);
        sCE1000EtherLineAdminInfo sCE1000EtherLineAdminInfo3 = this.etherLineAdminInfo[n];
        return this.getAdminStateFromModel(n) != eAdminState.ADMIN_IS || sCE1000EtherLineAdminInfo2.flowControl == sCE1000EtherLineAdminInfo3.flowControl && sCE1000EtherLineAdminInfo2.negotiation == sCE1000EtherLineAdminInfo3.negotiation && sCE1000EtherLineAdminInfo2.maxFrameSize == sCE1000EtherLineAdminInfo3.maxFrameSize && sCE1000EtherLineAdminInfo2.lowWaterMark == sCE1000EtherLineAdminInfo3.lowWaterMark && sCE1000EtherLineAdminInfo2.highWaterMark == sCE1000EtherLineAdminInfo3.highWaterMark;
    }

    public void applyToModel(int n) throws Exception {
        int n2;
        short s;
        if (this.isDirty[n][1]) {
            this.lineModels[n].setAlias(this.portNames[n]);
        }
        boolean bl = this.needRemoveLoopback(n);
        if (this.isDirty[n][6] || this.isDirty[n][7] || this.isDirty[n][9] || this.isDirty[n][11] || this.isDirty[n][12] || bl) {
            if (bl) {
                this.etherLineAdminInfo[n].loopback = eLoopback.NO_LOOPBACK;
            }
            this.lineModels[n].setGigELineAdminInfo(this.etherLineAdminInfo[n]);
        }
        if (this.isDirty[n][4]) {
            if (db.on()) {
                db.println("setting line soakTime " + this.soakTime[n]);
            }
            this.lineModels[n].setSoakTime(this.soakTime[n]);
        }
        if (this.isDirty[n][2]) {
            this.lineModels[n].setAdminState(this.getNewAdminState(n));
        }
        if (this.isDirty[n][10] && this.waterMarks[n].getIntValue() == 2) {
            s = this.getFlowControlLowWaterMark(n);
            n2 = this.getFlowControlHighWaterMark(n).shortValue();
            if (s == 25 && n2 == 485) {
                ErrorMsg.displayWarning((Component)this.getFrame(), (WID)EMC.WID_CUSTOM_WATER_MARKS, (Object)"Default");
                this.refreshLineFromModel(n);
            } else if (s == 5 && n2 == 10) {
                ErrorMsg.displayWarning((Component)this.getFrame(), (WID)EMC.WID_CUSTOM_WATER_MARKS, (Object)"Low Latency");
                this.refreshLineFromModel(n);
            }
        }
        if (!this.liCheck[n] && this.liTimer[n] == 0) {
            throw new ProvisionError(EMC.EID_WRONG_INPUT, null);
        }
        s = 0;
        if (this.isDirty[n][14]) {
            this.etherLineAdminInfo[n].liTimer = this.liTimer[n];
            this.lineModels[n].setGigELineAdminInfo(this.etherLineAdminInfo[n]);
            s = 1;
        }
        if (this.isDirty[n][13] && s == 0) {
            this.etherLineAdminInfo[n].liTimer = this.liTimer[n];
            this.lineModels[n].setGigELineAdminInfo(this.etherLineAdminInfo[n]);
        }
        for (n2 = 0; n2 < this.getColumnCount(); ++n2) {
            this.isDirty[n][n2] = false;
        }
    }

    public void refreshFromModel() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    protected void resetLineCache(int n) throws Exception {
        this.etherLineAdminInfo[n] = this.getEtherLineAdminInfoFromModel(n);
        this.etherLineInfo[n] = this.getEtherLineInfoFromModel(n);
        this.portNames[n] = this.getPortNameFromModel(n);
        this.adminState[n] = AdminState.enumToAdminState(this.getAdminStateFromModel(n));
        sServiceState sServiceState2 = this.lineModels[n].getServiceState();
        this.serviceState[n] = ServiceStateFactory.getServiceState(sServiceState2);
        this.waterMarks[n] = null;
        this.soakTime[n] = this.lineModels[n].getSoakTime();
        this.liTimer[n] = this.etherLineAdminInfo[n].liTimer;
        this.liCheck[n] = this.liTimer[n] == 0;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    private eAdminState getNewAdminState(int n) throws NoSuchInterface {
        return this.adminState[n].getAdminStateEnum();
    }

    public AdminState getAdminState(int n) throws NoSuchInterface {
        return this.adminState[n];
    }

    public boolean isAdminStateDirty(int n) {
        return this.isDirty[n][2];
    }

    protected eAdminState getAdminStateFromModel(int n) throws NoSuchInterface {
        return this.lineModels[n].getAdminStateEnum();
    }

    public AdminState[] getAdminStateAttrs() {
        boolean bl = AdminState.isANSI(this.eqpmtModel.getNodeModel().getTdmProtocolType());
        return AdminState.getDefaultAdminStates(bl);
    }

    public Attribute[] getMaxSizeAttrs() {
        return this.getAttributeArray("CE1000 Port Max Size");
    }

    public Attribute[] getWaterMarksAttrs() {
        return this.getAttributeArray("G1000 Water Marks Setting");
    }

    public Attribute[] getFlowControlAttrs() {
        return EtherEnumStrings.get(eFlowControlNegotiated.class, EtherEnumStrings.ML2_GIGE_FLOW_CONTROL);
    }

    protected AttributeMaps getAttributeMap() {
        return ElementDefaults.getAttributeMap(this.eqpmtModel);
    }

    protected Attribute[] getAttributeArray(String string) {
        return this.getAttributeMap().getAttributeArray(string);
    }

    protected Attribute getAttributeFor(String string, int n) {
        INodeModel iNodeModel = this.eqpmtModel.getNodeModel();
        return ElementDefaults.getAttributeMap((IModel)iNodeModel).getAttributeForVal(string, n);
    }

    private void registerWithLineModels() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].addObserver(this);
        }
    }

    private void unRegisterWithLineModels() {
        for (int i = 0; i < this.lineModels.length; ++i) {
            this.lineModels[i].deleteObserver(this);
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            int n;
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            if ((n = Arrays.asList(this.lineModels).indexOf(observable)) != -1) {
                this.refreshLineFromModel(n);
            }
        }
    }

    public void dispose() {
        this.unRegisterWithLineModels();
    }

    private TDMTerminology getTerm() {
        return this.eqpmtModel.getNodeModel().getTDMTerminology();
    }

    private Frame getFrame() {
        return this.eqpmtModel.getNodeModel().getUiToolkit().getApplicationFrame();
    }
}

