/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ml2;

import cerent.cms.idl.Epos.eCppFailAction;
import cerent.cms.idl.Epos.eCppProtState;
import cerent.cms.idl.Epos.sCppGrpAttributes;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.ML2ModuleModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.enumeration.EtherEnumStrings;
import cerent.util.SDebug;
import javax.swing.table.AbstractTableModel;

public class ML2ProtectionGroupTableModel
extends AbstractTableModel {
    public static final int GROUP_NUMBER_INDEX = 0;
    public static final int PROTECTION_STATE_INDEX = 1;
    public static final int FAIL_ACTION = 2;
    public static final int PEER_SLOT = 3;
    private String[] columnNames = new String[]{"Protection Group Number", "Protection State", "Fail Action", "Peer Slot"};
    private ML2ModuleModel moduleModel = null;
    private sCppGrpAttributes[] cppAttributes;
    private sCppGrpAttributes[] cppAttributesLen;
    private int numLines;
    private static final SDebug db = new SDebug("ML2ProtectionGroupTableModel");

    public ML2ProtectionGroupTableModel(ML2ModuleModel mL2ModuleModel) {
        this.moduleModel = mL2ModuleModel;
        try {
            int n = 0;
            this.cppAttributesLen = this.moduleModel.getCPPGrpAttributesList();
            for (int i = 0; i < this.cppAttributesLen.length; ++i) {
                if (!this.cppAttributesLen[i].isGrpValid) continue;
                ++n;
            }
            this.numLines = n;
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        if (n >= 0 && n < this.columnNames.length) {
            return this.columnNames[n];
        }
        return null;
    }

    public int getRowCount() {
        return this.numLines;
    }

    public Class getColumnClass(int n) {
        return Object.class;
    }

    public Object getValueAt(int n, int n2) {
        String string = "";
        Object var4_4 = null;
        switch (n2) {
            case 0: {
                if (this.cppAttributes[n] != null) {
                    return this.cppAttributes[n].groupNum;
                }
            }
            case 1: {
                if (this.cppAttributes[n] != null) {
                    string = this.getProtState(this.cppAttributes[n].grpProtState);
                    return string;
                }
            }
            case 2: {
                if (this.cppAttributes[n] != null) {
                    return this.getFailAction(this.cppAttributes[n].failAction);
                }
            }
            case 3: {
                if (this.cppAttributes[n] == null) break;
                if (this.cppAttributes[n].peerSlot > 0) {
                    return this.cppAttributes[n].peerSlot;
                }
                return "NOT CONFIGURED";
            }
        }
        return string;
    }

    public void refreshFromModel() throws ProvisionError {
        int n;
        this.cppAttributesLen = this.moduleModel.getCPPGrpAttributesList();
        int n2 = 0;
        for (n = 0; n < this.cppAttributesLen.length; ++n) {
            if (!this.cppAttributesLen[n].isGrpValid) continue;
            ++n2;
        }
        this.numLines = n2;
        this.cppAttributes = new sCppGrpAttributes[this.numLines];
        n2 = 0;
        for (n = 0; n < this.cppAttributesLen.length; ++n) {
            if (!this.cppAttributesLen[n].isGrpValid) continue;
            this.cppAttributes[n2] = this.cppAttributesLen[n];
            ++n2;
        }
        this.fireTableDataChanged();
    }

    private String getPortNumber(int n) {
        try {
            IEntityModel iEntityModel = this.moduleModel.getNodeModelDelegate().getEntityTableModel().getEntityModelByIndex(n);
            return String.valueOf(iEntityModel.getPort());
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            return "";
        }
    }

    public String getProtState(eCppProtState eCppProtState2) {
        return EtherEnumStrings.getString(eCppProtState.class, eCppProtState2.value());
    }

    public String getFailAction(eCppFailAction eCppFailAction2) {
        return EtherEnumStrings.getString(eCppFailAction.class, eCppFailAction2.value());
    }
}

