/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ml2;

import cerent.cms.model.Attribute;
import cerent.cms.model.ML2ModuleModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ml2.ML2ProtectionGroupTableModel;
import cerent.cms.ui.ml2.ML2ProtectionPortTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ML2ProtectionPane
extends AbstractPane
implements ActionListener {
    private static final String RETRIEVE_STRING = "Retrieve";
    private JButton refreshButton = new JButton("Retrieve");
    private JLabel refreshLabel = new JLabel("");
    private JLabel peerLabel;
    private ML2ProtectionPortTableModel dataModel;
    private ML2ProtectionGroupTableModel protModel;
    private ML2ModuleModel moduleModel;
    private UTable table;
    private UTable tableProt;
    private static final SDebug db = new SDebug("ML2ProtectionPane");

    public ML2ProtectionPane(String string, TabbedView tabbedView, ML2ModuleModel mL2ModuleModel) {
        super(string, tabbedView);
        this.moduleModel = mL2ModuleModel;
        this.setDefaultPrivilegeLevel(SecurityLevel.RETRIEVE);
        this.setLayout(new BorderLayout());
        this.add(this.createDualPanels(), "Center");
        this.add(this.createButtonPanel(), "South");
    }

    private JPanel createDualPanels() {
        JPanel jPanel = ML2ProtectionPane.createHorizontalPanel("");
        JPanel jPanel2 = ML2ProtectionPane.createVerticalPanel("Protection Group");
        JPanel jPanel3 = ML2ProtectionPane.createVerticalPanel("Port");
        this.dataModel = new ML2ProtectionPortTableModel(this.moduleModel);
        this.protModel = new ML2ProtectionGroupTableModel(this.moduleModel);
        this.table = new UTable((TableModel)this.dataModel);
        jPanel3.add((Component)new UScrollPane((Component)this.table));
        this.tableProt = new UTable((TableModel)this.protModel);
        jPanel2.add((Component)new UScrollPane((Component)this.tableProt));
        jPanel.add(jPanel3);
        jPanel.add(jPanel2);
        this.customizedPortPane();
        return jPanel;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 5, 5));
        this.refreshButton.addActionListener(this);
        jPanel2.add(this.refreshButton);
        jPanel3.add(this.refreshLabel);
        jPanel3.add(new CSHelpButton(CSHelpConst.ML2ProtectionPane));
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "East");
        return jPanel;
    }

    private void customizedPortPane() {
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        TableColumn tableColumn = this.table.getColumn((Object)this.dataModel.getColumnName(1));
        tableColumn.setPreferredWidth(100);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.refreshButton) {
            try {
                this.refresh();
            }
            catch (ProvisionError provisionError) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_GENERIC_PROV_ERROR, (Object[])provisionError.getEIDParams());
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void enteringPage() throws Exception {
        this.refresh();
    }

    public void leavingPage() throws Exception {
    }

    public void refresh() throws Exception {
        this.dataModel.refreshFromModel();
        this.protModel.refreshFromModel();
        this.refreshLabel.setText("Refreshed: " + ML2ProtectionPane.getFormattedDateTime());
    }

    private JComboBox getComboBoxFor(Attribute[] attributeArray) {
        JComboBox<Attribute> jComboBox = new JComboBox<Attribute>(attributeArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    public void destroy() {
        this.dataModel = null;
        super.destroy();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.ML2ProtectionPane;
    }
}

