/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ms;

import cerent.cms.model.IChassisModel;
import cerent.cms.model.IShelfViewModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.event.AlarmStatus;
import cerent.cms.model.event.IAlarmStore;
import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.ms.BayViewPanel;
import cerent.cms.ui.ms.IMsShelfLayout;
import cerent.cms.ui.ms.MsCardGraphic;
import cerent.cms.ui.ms.MsCardPanel;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;

public abstract class AbstractMsShelfLayout
extends AbstractShelfLayout
implements IMsShelfLayout,
Observer {
    protected static final Border UNSELECTED_BORDER = BorderFactory.createLineBorder(Color.black, 1);
    private IAlarmStore shelfAlarmStore;

    public AbstractMsShelfLayout(IShelfViewModel iShelfViewModel, AbstractViewController abstractViewController, BayViewPanel bayViewPanel) {
        super(iShelfViewModel, abstractViewController, bayViewPanel);
        this.chassis.addObserver(this);
        if (this.chassis instanceof IChassisModel) {
            this.shelfAlarmStore = ((IChassisModel)this.chassis).getShelfAlarmStore();
            if (this.shelfAlarmStore != null) {
                this.shelfAlarmStore.addAlarmStatusObserver((Observer)this);
            }
        }
        this.setBorder(UNSELECTED_BORDER);
    }

    public void destroy() {
        this.chassis.deleteObserver(this);
        if (this.chassis instanceof IChassisModel && this.shelfAlarmStore != null) {
            this.shelfAlarmStore.deleteAlarmStatusObserver((Observer)this);
        }
        super.destroy();
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer) {
            if (((Integer)object).equals(ModelUpdateType.CHANGED) || ((Integer)object).equals(ModelUpdateType.STRUCTURE_CHANGED)) {
                if (db.on()) {
                    db.println("Received Shelf change message");
                }
                this.refreshShelfLayout();
                this.refreshShelfColor();
            }
        } else if (object instanceof AlarmStatus) {
            this.refreshShelfColor();
        }
    }

    protected void refreshShelfColor() {
        this.setShelfColor(this.getState());
        if (this.labelsPanel != null) {
            this.labelsPanel.setBackground(this.currShelfColor);
        } else {
            this.slotsPanel.setBackground(this.currShelfColor);
        }
    }

    protected void refreshShelfLayout() {
    }

    public BayViewPanel getBayViewPanel() {
        return this.bvp;
    }

    protected MouseInputAdapter getMouseClickProcessor() {
        return new MouseClickProcessor();
    }

    protected void addLabels() {
        if (this.labelsPanel != null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            ((GridBagLayout)this.getLayout()).setConstraints(this.labelsPanel, gridBagConstraints);
            this.add(this.labelsPanel);
        }
    }

    protected void removeLabels() {
        this.remove(this.labelsPanel);
    }

    protected void addPanels() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        ((GridBagLayout)this.getLayout()).setConstraints(this.slotsPanel, gridBagConstraints);
        this.add(this.slotsPanel);
    }

    private class MouseClickProcessor
    extends MouseInputAdapter {
        private MouseEvent firstMouseEvent = null;

        private MouseClickProcessor() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.firstMouseEvent = mouseEvent;
            mouseEvent.consume();
            AbstractMsShelfLayout.this.highLighter.cancel();
            AbstractMsShelfLayout.this.bvp.getRVP().getMVP().setSelectedShelf(AbstractMsShelfLayout.this);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.firstMouseEvent != null) {
                JComponent jComponent;
                TransferHandler transferHandler;
                mouseEvent.consume();
                int n = 2;
                int n2 = Math.abs(mouseEvent.getX() - this.firstMouseEvent.getX());
                int n3 = Math.abs(mouseEvent.getY() - this.firstMouseEvent.getY());
                if ((n2 > 5 || n3 > 5) && (transferHandler = (jComponent = (JComponent)mouseEvent.getSource()).getTransferHandler()) != null) {
                    transferHandler.exportAsDrag(jComponent, this.firstMouseEvent, n);
                    this.firstMouseEvent = null;
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.firstMouseEvent = null;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object instanceof MsCardPanel) {
                Icon icon = ((MsCardPanel)object).getIcon();
                if ((mouseEvent.getModifiers() & 4) != 0) {
                    if (icon instanceof CardGraphic) {
                        ((CardGraphic)icon).rightMouseClicked(mouseEvent.getPoint(), (MsCardPanel)object);
                    }
                } else if ((mouseEvent.getModifiers() & 0x10) != 0 && mouseEvent.getClickCount() == 2 && icon instanceof MsCardGraphic) {
                    ((MsCardGraphic)icon).openShelf();
                }
            }
        }
    }
}

