/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ms;

import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.ms.BayViewPanel;
import cerent.cms.ui.ms.MultishelfViewPanel;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import cerent.util.gui.ActionOrganizer;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;

public class RackViewPanel
extends JPanel
implements ActionListener,
IObserver {
    private MultishelfViewPanel parent;
    private short rackNumber;
    private final BayViewPanel[] bayMap;
    private JPopupMenu popup;
    private ActionOrganizer actOrg;
    private static final String CMD_REM_RACK = "Delete Rack";
    private static final int BORDER_SPACE = 5;
    private static Border RACK_IN_BORDER = BorderFactory.createEmptyBorder(5, 5, 5, 5);
    private static Border RACK_OUT_BORDER = BorderFactory.createLineBorder(Color.black, 1);
    protected static final SDebug db = new SDebug("RackViewPanel");

    public RackViewPanel(MultishelfViewPanel multishelfViewPanel, boolean bl, short s) {
        db.fine("<init>");
        this.rackNumber = s;
        this.parent = multishelfViewPanel;
        this.bayMap = new BayViewPanel[49];
        this.setBorder(BorderFactory.createCompoundBorder(RACK_OUT_BORDER, RACK_IN_BORDER));
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(Color.gray);
        JPanel jPanel = new JPanel(new FlowLayout(1));
        JLabel jLabel = new JLabel("Rack " + s);
        jPanel.add(jLabel);
        this.add(jPanel);
        this.add(Box.createVerticalGlue());
        this.add(Box.createVerticalStrut(5));
        this.add(Box.createVerticalGlue());
        for (int n = 0; n < this.bayMap.length; n = (int)((short)(n + 1))) {
            this.bayMap[n] = new BayViewPanel(this, (short)(n + 1));
            this.add(this.bayMap[n]);
        }
        this.popup = new JPopupMenu();
        this.actOrg = new ActionOrganizer(this);
        this.actOrg.addMenuItem((JComponent)this.popup, null, CMD_REM_RACK, 68);
        PopupListener popupListener = new PopupListener();
        this.addMouseListener(popupListener);
    }

    public short getRackNum() {
        return this.rackNumber;
    }

    public NodeModelDelegate getNodeModel() {
        return this.parent.getNodeModel();
    }

    protected AbstractViewController getViewController() {
        return this.parent.getViewController();
    }

    public IUiToolkit getUiToolkit() {
        return this.parent.getUiToolkit();
    }

    public BayViewPanel getBay(int n) {
        return this.bayMap[n - 1];
    }

    public int getMaxBays() {
        return this.bayMap.length;
    }

    public void setBayOccupied(int n, boolean bl) {
        int n2 = n + this.getBay(n).getBayOccupied() - 1;
        while (n < n2) {
            this.getBay(++n).showHideBay(bl);
        }
    }

    public short getBayFreeCount(int n) {
        short s = 0;
        while (n <= this.bayMap.length && this.getBay(n++).isEmpty()) {
            s = (short)(s + 1);
        }
        return s;
    }

    public void update(IObservable iObservable, Object object) {
        db.fine("update(" + iObservable + ", " + (object == ModelUpdateType.DELETED ? "DELETED" : (object == ModelUpdateType.ADDED ? "ADDED" : object.toString())) + ")");
        this.actOrg.getMenuItem(CMD_REM_RACK).setEnabled(true);
        for (int i = 0; i < this.bayMap.length; ++i) {
            BayViewPanel bayViewPanel = this.bayMap[i];
            if (bayViewPanel.isEmpty()) continue;
            this.actOrg.getMenuItem(CMD_REM_RACK).setEnabled(false);
            break;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == CMD_REM_RACK) {
            for (int i = 0; i < this.bayMap.length; ++i) {
                this.bayMap[i] = null;
            }
            this.parent.removeRack(this);
        }
    }

    public MultishelfViewPanel getMVP() {
        return this.parent;
    }

    public String toString() {
        return "rack " + this.rackNumber + ", " + super.toString();
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                RackViewPanel.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

