/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ms;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.ChassisModels;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IShelfViewModel;
import cerent.cms.model.InvalidData;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NotSupportedOnEquipment;
import cerent.cms.model.PassiveChassisModel;
import cerent.cms.model.PassiveModuleModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;

public class ShelfBehavior {
    public static final String DELETE_SHELF = "Delete Shelf";
    public static final String DELETE_UNIT = "Delete Unit";
    public static final String OPEN_SHELF = "Open Shelf";
    public static final String ADD_SHELF = "Add Shelf";
    public static final String ADD_UNIT = "Add Unit";
    public static final String UNDELETE_SHELF = "Undelete Shelf";
    private NodeModelDelegate nmd;
    protected SDebug db;

    public ShelfBehavior(NodeModelDelegate nodeModelDelegate, SDebug sDebug) {
        this.nmd = nodeModelDelegate;
        this.db = sDebug;
    }

    public eEqType[] getProvisionableShelves() {
        if (this.nmd.isSdh()) {
            return new eEqType[]{eEqType.CHASSIS_454SDH, eEqType.PASSIVE_CHASSIS};
        }
        return new eEqType[]{eEqType.CHASSIS_454, eEqType.PASSIVE_CHASSIS};
    }

    public eEqType[] getProvisionableUnitsOnShelf(eEqType eEqType2) {
        if (eEqType2.equals(eEqType.PASSIVE_CHASSIS)) {
            return PassiveModuleModel.getPassiveNoInnersEqTypeArray();
        }
        return null;
    }

    public String getShelfName(eEqType eEqType2) {
        return EntityModel.eqType2Name(this.nmd.getTDMTerminology(), eEqType2);
    }

    public Integer[] getAvailableShelfIds(String string) {
        return this.nmd.getChassisModelsInstance().getAvailableShelfIds(EntityModel.name2EqType(this.nmd, string));
    }

    public Integer[] getAvailableSlots(String string) {
        int n;
        eEqType eEqType2 = EntityModel.name2EqType(this.nmd, string);
        if (PassiveModuleModel.isEqTypeSupported(eEqType2) && (n = PassiveChassisModel.getNumberOfSlots(eEqType2)) > 1) {
            Integer[] integerArray = new Integer[n];
            for (int i = 0; i < n; ++i) {
                integerArray[i] = new Integer(i + 1);
            }
            return integerArray;
        }
        return new Integer[0];
    }

    public Integer[] getShelfSizes(String string, short s) {
        short s2;
        eEqType eEqType2 = EntityModel.name2EqType(this.nmd, string);
        short s3 = ChassisModels.getChassisHeight(eEqType2);
        if (s3 != (s2 = ChassisModels.getMaxRUOccupied(eEqType2)) && s2 <= s) {
            return new Integer[]{s3, s2};
        }
        return new Integer[]{s3};
    }

    public void addShelf(final Component component, final short s, final short s2, final short s3, final short s4, final short s5, String string) {
        final eEqType eEqType2 = EntityModel.name2EqType(this.nmd, string);
        new Thread("Shelf Provisioner"){

            public void run() {
                try {
                    ShelfBehavior.this.nmd.getChassisModelsInstance().provisionShelf(s, s2, s3, s4, s5, (short)1, eEqType2);
                }
                catch (InvalidData invalidData) {
                    if (ShelfBehavior.this.db.on()) {
                        SDebug.printStackTrace((Throwable)invalidData);
                    }
                    ErrorMsg.displayError((Component)component, (EID)EMC.EID_FAIL_SHELF_ADD_PARAM_1, (Object)("shelf ID " + s + " is invalid."));
                }
                catch (ProvisionError provisionError) {
                    if (ShelfBehavior.this.db.on()) {
                        SDebug.printStackTrace((Throwable)provisionError);
                    }
                    ErrorMsg.displayError((Component)component, (EID)provisionError.getEID(), (Object[])provisionError.getEIDParams());
                }
                catch (NotSupportedOnEquipment notSupportedOnEquipment) {
                    if (ShelfBehavior.this.db.on()) {
                        SDebug.printStackTrace((Throwable)notSupportedOnEquipment);
                    }
                    ErrorMsg.displayError((Component)component, (EID)EMC.EID_FAIL_SHELF_ADD_PARAM_1, (Object)"the equipment does not support multishelf.");
                }
                catch (ResourceInUse resourceInUse) {
                    if (ShelfBehavior.this.db.on()) {
                        SDebug.printStackTrace((Throwable)resourceInUse);
                    }
                    ErrorMsg.displayError((Component)component, (EID)EMC.EID_FAIL_SHELF_ADD_PARAM_1, (Object)"the resource is in use.");
                }
            }
        }.start();
    }

    public void unDeleteShelf(Component component, IShelfViewModel iShelfViewModel) {
        this.addShelf(component, (short)iShelfViewModel.getShelfId(), iShelfViewModel.getRackNumber(), iShelfViewModel.getRackPosition(), iShelfViewModel.getRUOccupied(), (short)0, iShelfViewModel.getShelfTypeName());
    }

    public boolean deleteShelf(Component component, IShelfViewModel iShelfViewModel) {
        boolean bl = false;
        if (iShelfViewModel.getShelfId() == 1) {
            bl = false;
            ErrorMsg.displayError((Component)component, (EID)EMC.NOT_DELETE_NC);
            return bl;
        }
        if (CerentDialog.yesNoDialog((Component)component, (String)"Are you sure?", (String)"Deleting Shelf")) {
            try {
                bl = false;
                iShelfViewModel.unprovision();
                bl = true;
            }
            catch (ResourceInUse resourceInUse) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("it is in use.");
                ErrorMsg.displayError((Component)component, (EID)EMC.EID_FAIL_SHELF_DELETE_PARAM_1, (Object)stringBuffer.toString());
            }
            catch (ProvisionError provisionError) {
                ErrorMsg.displayError((Component)component, (EID)EMC.EID_FAIL_SHELF_DELETE_PARAM_1, (Object)"provision error");
            }
        }
        return bl;
    }

    public void addUnit(Component component, short s, short s2, short s3, String string) {
        this.addShelf(component, (short)0, s, s2, (short)0, s3, string);
    }
}

