/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ms;

import cerent.cms.model.ChassisModels;
import cerent.cms.model.IShelfViewModel;
import cerent.cms.model.InvalidData;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ProvisionError;
import cerent.cms.ui.ms.BayViewPanel;
import cerent.cms.ui.ms.IMsShelfLayout;
import cerent.cms.ui.ms.MsCardPanel;
import cerent.cms.ui.ms.MultishelfViewPanel;
import cerent.util.IObservable;
import cerent.util.SDebug;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class ShelfTransferHandler
extends TransferHandler {
    private DataFlavor shelfIdFlavor = DataFlavor.stringFlavor;
    private BayViewPanel source = null;
    private final ChassisModels cms;
    private final MultishelfViewPanel mvp;
    private static final SDebug db = new SDebug("ShelfTransferHandler");

    public ShelfTransferHandler(ChassisModels chassisModels, MultishelfViewPanel multishelfViewPanel) {
        this.cms = chassisModels;
        this.mvp = multishelfViewPanel;
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        block13: {
            if (this.canImport(jComponent, transferable.getTransferDataFlavors())) {
                BayViewPanel bayViewPanel = this.getBVPForComponent(jComponent);
                if (this.source == bayViewPanel) {
                    return true;
                }
                try {
                    int n = Integer.parseInt((String)transferable.getTransferData(this.shelfIdFlavor));
                    IShelfViewModel iShelfViewModel = this.cms.getShelfViewByShelfId(n);
                    IShelfViewModel iShelfViewModel2 = bayViewPanel.getChassis();
                    this.source = this.mvp.getRack(iShelfViewModel.getRackNumber()).getBay(iShelfViewModel.getRackPosition());
                    if (!this.cms.swapChassisPositions(iShelfViewModel, bayViewPanel.getRVP().getRackNum(), bayViewPanel.getBayNum())) {
                        db.fine("No space to swap " + iShelfViewModel + " with " + iShelfViewModel2);
                        return false;
                    }
                    if (iShelfViewModel2 != null && this.source != null) {
                        this.source.update((IObservable)iShelfViewModel2, ModelUpdateType.ADDED);
                        this.source.alertUserToChange();
                    } else {
                        this.source.update((IObservable)iShelfViewModel, ModelUpdateType.DELETED);
                    }
                    bayViewPanel = this.mvp.getRack(iShelfViewModel.getRackNumber()).getBay(iShelfViewModel.getRackPosition());
                    bayViewPanel.update((IObservable)iShelfViewModel, ModelUpdateType.ADDED);
                    bayViewPanel.alertUserToChange();
                    return true;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    db.fine("Caught " + unsupportedFlavorException + " in importData");
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)unsupportedFlavorException);
                    }
                }
                catch (IOException iOException) {
                    db.fine("Caught " + iOException + " in importData");
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)iOException);
                    }
                }
                catch (InvalidData invalidData) {
                    db.fine("Caught " + (Object)((Object)invalidData) + " in importData");
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)invalidData);
                    }
                }
                catch (ProvisionError provisionError) {
                    db.fine("Caught " + (Object)((Object)provisionError) + " in importData");
                    if (!db.on()) break block13;
                    SDebug.printStackTrace((Throwable)provisionError);
                }
            }
        }
        return false;
    }

    protected Transferable createTransferable(JComponent jComponent) {
        this.source = this.getBVPForComponent(jComponent);
        return new ShelfTransferable(this.source.getChassis().getShelfId());
    }

    public int getSourceActions(JComponent jComponent) {
        return 2;
    }

    private BayViewPanel getBVPForComponent(JComponent jComponent) {
        BayViewPanel bayViewPanel = null;
        if (jComponent instanceof BayViewPanel) {
            bayViewPanel = (BayViewPanel)jComponent;
        } else if (jComponent instanceof IMsShelfLayout) {
            IMsShelfLayout iMsShelfLayout = (IMsShelfLayout)((Object)jComponent);
            bayViewPanel = iMsShelfLayout.getBayViewPanel();
        } else if (jComponent instanceof MsCardPanel) {
            MsCardPanel msCardPanel = (MsCardPanel)jComponent;
            IMsShelfLayout iMsShelfLayout = (IMsShelfLayout)((Object)msCardPanel.getShelfLayout());
            bayViewPanel = iMsShelfLayout.getBayViewPanel();
        }
        return bayViewPanel;
    }

    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        this.source = null;
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!this.shelfIdFlavor.equals(dataFlavorArray[i])) continue;
            return true;
        }
        return false;
    }

    class ShelfTransferable
    implements Transferable {
        private final String shelfId;

        ShelfTransferable(int n) {
            this.shelfId = Integer.toString(n);
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.shelfId;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{ShelfTransferHandler.this.shelfIdFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return ShelfTransferHandler.this.shelfIdFlavor.equals(dataFlavor);
        }
    }
}

