/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nedefaults;

import cerent.cms.model.Attribute;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.nedefaults.IDefaultsElement;
import cerent.cms.ui.nedefaults.DefaultsController;
import cerent.cms.ui.nedefaults.DefaultsDataSource;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.Map;
import javax.swing.JTable;

public class DefaultsTableModel
extends SortableRowTableModel {
    private DefaultsDataSource dds;
    private DefaultsController dfc;
    int pos = 0;
    private static final String fieldString = "\nCorrect the value in the dependent field before pressing apply.";

    public DefaultsTableModel(DefaultsController defaultsController, DefaultsDataSource defaultsDataSource) {
        super((RowDataSource)defaultsDataSource, defaultsDataSource.getRenderers(), defaultsDataSource.getRowObjectClass());
        this.dds = defaultsDataSource;
        this.dfc = defaultsController;
    }

    public boolean findDefault(String string) {
        boolean bl = false;
        if (string.startsWith("\"") && string.endsWith("\"")) {
            bl = true;
            string = string.substring(1, string.length() - 1);
        }
        return this.findNEDefault(string, 0, bl);
    }

    public boolean findNEDefault(String string, int n, boolean bl) {
        for (int i = n; i < this.dds.getRowCount(); ++i) {
            String string2;
            DefaultsDataSource.DefaultsInfo defaultsInfo = (DefaultsDataSource.DefaultsInfo)this.getValueAt(i, 0);
            if (bl) {
                string2 = defaultsInfo.getModel().getFullName();
            } else {
                string2 = defaultsInfo.getModel().getFullName().toUpperCase();
                string = string.toUpperCase();
            }
            if (!string2.contains(string)) continue;
            this.table.getSelectionModel().setSelectionInterval(i, i);
            Rectangle rectangle = this.table.getCellRect(i, 0, true);
            this.table.scrollRectToVisible(rectangle);
            this.pos = i + 1;
            return true;
        }
        return false;
    }

    public boolean enableNext() {
        return this.pos != 0;
    }

    public boolean findNextDefault(String string) {
        boolean bl = false;
        if (string.startsWith("\"") && string.endsWith("\"")) {
            bl = true;
            string = string.substring(1, string.length() - 1);
        }
        return this.findNEDefault(string, this.pos, bl);
    }

    public void initTable(JTable jTable) {
        super.initTable(jTable);
        int[] nArray = new int[]{0};
        boolean[] blArray = new boolean[]{false};
        String[] stringArray = new String[]{"Default Domain", "Side Effects"};
        this.setDefaultColSetting(nArray, blArray, stringArray);
    }

    public int getRowCount() {
        return this.dds.getRowCount();
    }

    private IDefaultsElement getElementAtRow(int n) {
        return ((DefaultsDataSource.DefaultsInfo)this.getValueAt(n, 0)).getModel();
    }

    public void setValueAt(Object object, int n, int n2) {
        IDefaultsElement iDefaultsElement = this.getElementAtRow(n);
        try {
            if (object instanceof String) {
                String string = (String)object;
                String string2 = iDefaultsElement.getValue();
                iDefaultsElement.setValue(string);
                if (iDefaultsElement.isDirty() && iDefaultsElement.getName().equals("EnableShellPassword") && string.equals("FALSE")) {
                    Object object2 = CerentDialog.inputPasswordDialog((Component)this.dfc.getParentComponent(), (String)"Turn off enforce shell password, please enter the current shell password.", (String)"Disable Shell Password");
                    if (object2 != null) {
                        this.dfc.setShellPassword((String)object2);
                    } else {
                        iDefaultsElement.setValue(string2);
                        iDefaultsElement.makeClean();
                    }
                }
            } else if (object instanceof Attribute) {
                iDefaultsElement.setValue(object.toString());
            }
            if (iDefaultsElement.isDirty()) {
                this.dfc.setDirty(iDefaultsElement);
                this.fireTableRowsUpdated(n, n);
            }
        }
        catch (ProvisionError provisionError) {
            ErrorMsg.displayDetailed(this.dfc.getParentComponent(), EMC.EID_PROVISIONING_PARAM_1, iDefaultsElement.getName(), "\nCorrect the value in the dependent field before pressing apply.\n" + provisionError.getMessage());
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMsg.displayDetailed(this.dfc.getParentComponent(), EMC.EID_PROVISIONING_PARAM_1, iDefaultsElement.getName(), "\nCorrect the value in the dependent field before pressing apply.\n" + numberFormatException.getMessage());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            ErrorMsg.displayDetailed(this.dfc.getParentComponent(), EMC.EID_GENERIC_PROV_ERROR, arrayIndexOutOfBoundsException.getMessage());
        }
    }

    public void setScope(SortableRowTableModel sortableRowTableModel, Map map) {
        this.dds.refreshFromModel(sortableRowTableModel, map.values());
    }

    public boolean isCellEditable(int n, int n2) {
        boolean bl = false;
        if (this.dfc.isAuthorized()) {
            IDefaultsElement iDefaultsElement = this.getElementAtRow(n);
            String string = iDefaultsElement.getName();
            bl = string.equals("SecureModeLocked") ? iDefaultsElement.getValue().equals("FALSE") : (iDefaultsElement.neverEditable() ? false : n2 == 1);
        }
        return bl;
    }
}

