/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.nodesetup.AbstractNodeSetupDialog;
import cerent.cms.ui.nodesetup.NodeSetupWizard;
import cerent.cms.ui.nodesetup.NsdAnpPane;
import cerent.cms.ui.nodesetup.NsdAnsPane;
import cerent.cms.ui.nodesetup.NsdParamsPane;
import cerent.cms.ui.nodesetup.NsdPassiveUnitsPane;
import cerent.cms.ui.nodesetup.NsdPatchcordsPane;
import cerent.cms.ui.nodesetup.NsdPpmPane;
import cerent.cms.ui.nodesetup.NsdSidesPane;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.cms.ui.nodesetup.WzNsdPane;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.PrintStream;

public class NodeSetupDialog
extends AbstractNodeSetupDialog {
    private static final SDebug db = new SDebug("NodeSetupDialog");
    private NodeModelDelegate nmd;
    private String currentPane;
    private String firstPane;
    private String latestPane;

    public NodeSetupDialog(NodeSetupWizard nodeSetupWizard, NsdWizardInfo nsdWizardInfo, Frame frame, boolean bl) {
        super(frame, "Node Setup for " + nsdWizardInfo.getNodeName(), new WzDiagDebug("NodeSetupDialog"), bl, true);
        this.wizard = nodeSetupWizard;
        this.wizardInfo = nsdWizardInfo;
        this.nmd = nsdWizardInfo.getNmd();
        int n = 950;
        int n2 = 450;
        this.setSize(new Dimension(n, n2));
        this.statusPanel.removeMouseListener(this.statusPanel);
        this.splitter.setDividerLocation(160);
        this.applyButton.setVisible(true);
        this.createPanesAndSetCurrent();
        this.setLocationRelativeTo(frame);
    }

    private void addPane(String string, WzNsdPane wzNsdPane) {
        this.addPane(string, string, wzNsdPane);
    }

    private void addPane(String string, String string2, WzNsdPane wzNsdPane) {
        this.wzPaneMap.put(string, wzNsdPane);
        if (this.currentPane == null) {
            this.currentPane = string;
        }
        if (this.firstPane == null) {
            this.firstPane = string2;
        }
        this.latestPane = string2;
    }

    protected void createPanesAndSetCurrent() {
        String string = null;
        String string2 = "";
        if (this.wizardInfo.isAnpSelected()) {
            for (int i = 0; i < this.wizardInfo.getAnp().size(); ++i) {
                string = "Shelf" + i;
                string2 = this.nmd.isMultishelf() ? "Shelf # " + this.wizardInfo.getAnp().elementAt((int)i).shelf : "Node Layout";
                this.addPane(string, string2, new NsdAnpPane(this, this.makeChildDebug("Anp"), this.wizardInfo, i, string2));
            }
        }
        if (this.wizardInfo.isPassiveUnitsSelected()) {
            NsdPassiveUnitsPane nsdPassiveUnitsPane = new NsdPassiveUnitsPane(this, this.makeChildDebug("PassiveUnits"), this.wizardInfo, "Passive Units");
            this.addPane("Passive Units", nsdPassiveUnitsPane);
        }
        if (this.wizardInfo.isParamSelected()) {
            NsdParamsPane nsdParamsPane = new NsdParamsPane(this, this.makeChildDebug("Params"), this.wizardInfo, "Card Parameters");
            this.addPane("Card Parameters", nsdParamsPane);
        }
        if (this.wizardInfo.isPpmSelected()) {
            NsdPpmPane nsdPpmPane = new NsdPpmPane(this, this.makeChildDebug("Ppm"), this.wizardInfo, "Pluggable Port Modules");
            this.addPane("Pluggable Port Modules", nsdPpmPane);
        }
        if (this.wizardInfo.isPatchcordsSelected()) {
            NsdPatchcordsPane nsdPatchcordsPane = new NsdPatchcordsPane(this, this.makeChildDebug("Patchcords"), this.wizardInfo, "Internal Patchcords");
            this.addPane("Internal Patchcords", nsdPatchcordsPane);
        }
        if (this.wizardInfo.isSidesSelected()) {
            NsdSidesPane nsdSidesPane = new NsdSidesPane(this, this.makeChildDebug("Sides"), this.wizardInfo, "Optical Sides");
            this.addPane("Optical Sides", nsdSidesPane);
        }
        if (this.wizardInfo.isAnsSelected()) {
            NsdAnsPane nsdAnsPane = new NsdAnsPane(this, this.makeChildDebug("Ans"), this.wizardInfo, "ANS Parameters");
            this.addPane("ANS Parameters", nsdAnsPane);
        }
        this.wizardInfo.setFirstPane(this.firstPane);
        this.wizardInfo.setLastPane(this.latestPane);
        this.setCurrentPane(this.currentPane);
    }

    protected void backFromEmptyStack() throws Exception {
        if (this.wizard != null) {
            this.close();
            this.dispose();
            this.wizard.setVisible(true);
        } else {
            super.backFromEmptyStack();
        }
    }

    protected void localValidation() {
    }

    protected void handleCancel() {
        if (NodeSetupDialog.db.on) {
            db.println("handleCancel: cleaning up");
        }
        this.close();
    }

    protected String getCancelMessage() {
        return "Canceling will not undo any provisioning already done.\nIs it OK to cancel " + this.getTitle() + "?";
    }

    private void close() {
    }

    private void terminate() {
        this.cancel(false);
        if (this.wizardInfo.getErrCnt() > 0) {
            CerentDialog.warningDialog((Component)this, (String)"The wizard completed import with some error!\nCheck log for details.", (String)"Wizard End");
        } else {
            CerentDialog.infoDialog((Component)this, (String)"The wizard successfully completed the import.", (String)"Wizard End");
        }
        PrintStream printStream = this.wizardInfo.getLogPs();
        printStream.close();
    }

    public void finish() {
        this.terminate();
    }

    public void apply() {
    }

    protected void handleFinish() {
        super.handleFinish();
    }
}

