/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.nodesetup.NodeSetupDialog;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.cms.ui.nodesetup.PassiveUnitsManager;
import cerent.cms.ui.nodesetup.WzNsdPane;
import java.util.Vector;

public class NsdPassiveUnitsPane
extends WzNsdPane {
    public NsdPassiveUnitsPane(NodeSetupDialog nodeSetupDialog, WzDiagDebug wzDiagDebug, NsdWizardInfo nsdWizardInfo, String string) {
        super(nodeSetupDialog, wzDiagDebug, string, nsdWizardInfo, new PassiveUnitsManager(nsdWizardInfo, nsdWizardInfo.getNmd()));
    }

    protected String getNextPaneName() {
        if (this.wizInfo.isPpmSelected()) {
            return "Pluggable Port Modules";
        }
        if (this.wizInfo.isParamSelected()) {
            return "Card Parameters";
        }
        if (this.wizInfo.isPatchcordsSelected()) {
            return "Internal Patchcords";
        }
        if (this.wizInfo.isSidesSelected()) {
            return "Optical Sides";
        }
        if (this.wizInfo.isAnsSelected()) {
            return "ANS Parameters";
        }
        return null;
    }

    protected void createColumns() {
        this.columnNames = new String[]{"Unit", "Equipment Type", "Description", "Position"};
    }

    protected void createData() {
        Vector<NsdWizardInfo.PUnitStructure> vector = this.wizInfo.getPassiveUnits();
        this.dataValues = new String[vector.size()][4];
        for (int i = 0; i < vector.size(); ++i) {
            this.dataValues[i][0] = vector.elementAt((int)i).unitNumber;
            this.dataValues[i][1] = vector.elementAt((int)i).eqType;
            this.dataValues[i][2] = vector.elementAt((int)i).description;
            this.dataValues[i][3] = this.getPositionStr(vector.elementAt(i));
        }
    }

    private String getPositionStr(NsdWizardInfo.PUnitStructure pUnitStructure) {
        if (pUnitStructure.RUPos != null) {
            return "r " + pUnitStructure.rackNum + ", p " + pUnitStructure.RUPos + "(" + pUnitStructure.rackPos + "), s " + pUnitStructure.slotPos;
        }
        return "r " + pUnitStructure.rackNum + ", p " + pUnitStructure.rackPos + ", s " + pUnitStructure.slotPos;
    }
}

